      include 'copyrght.def'
C
C-----------------------------------------------------------------------
	integer function psl_tblload(ilogic, isubfile)
C Read subfile ISUBFILE from the misc bitmaps, using logic type ILOGIC
C returns the number of hits or a negative number for an error
C-----------------------------------------------------------------------
	implicit none
!MS$ATTRIBUTES C, REFERENCE :: psl_tblload
	integer*4 ilogic, isubfile
C-----------------------------------------------------------------------
C ilogic is a number between 0 and 6
C	0	 Match with table
C	1	 Add to table
C	2	 Remove from table
C	3	 Subfile without current table
C	4	 Replace table with subfile
C	5	 Clear all entries from table
C	6	 Set table with all entries
C isubfile is a number between 1 and ?: see PSL_TBLLIST
C-----------------------------------------------------------------------
	include 'bitops.def'
	include 'pdfread.def'

	include 'pdfdefs.par'

	include 'pdf.cmn'
	include 'pdfdefs.cmn'
	include 'logic.cmn'

	include 'pdfdefs.dat'

	CHARACTER*(*) subrnm
	PARAMETER (subrnm='psl_tblload')

	integer   i,ln,lench
	integer*4 irec

	if (ilogic .eq. 5) then
C clear all
	  cnum = 1
	  context(1) = 'Cleared all entries from table'
	  psl_tblload = tblclr(table,N_cards) 
	elseif (ilogic .eq. 6) then
C set all
	  cnum = 1
	  context(1) = 'Set table to have all entries'
	  psl_tblload = tblset(table,N_cards)
C --------- test before loading the subfile
	elseif (isubfile .le. 0 .or. isubfile .gt. max_sub) then
	   call errmsg(subrnm,'isubfile is out of range')
	   psl_tblload = -1
	ELSEIF (SUBREC(isubfile) .le. 0) THEN
	   call errmsg(subrnm,
	1	'isubfile points to an undefined subfile')
	   psl_tblload = -2
	ELSE
C ------- load the subfile
	   call ps_openmisc(i)
	   if (i .ne. 0) then
	      call errmsg(subrnm,
	1	   'opening misc Subfile bitmap')
	      psl_tblload = -3
	      RETURN
	   ENDIF
	   irec = SUBREC(isubfile)
	   i = ps_readbitlib(irec, TABLE1, N_cards)
	   if (i .ne. 0) then
	      call errmsg(subrnm,
	1	   'reading from misc Subfile bitmap')
	      psl_tblload = -3
	      return
	   ENDIF
	   call ps_closebitlib
C ------ process the subfile according to the chosen logic
	   ln = lench(SUBLBL(isubfile))
	   IF (ilogic .eq. 0) THEN
C  Match with table
	      CALL TBLAND(TABLE1,TABLE,TABLE,N_Cards)
	      cnum = cnum + 1
	      context(cnum) = 'Match entries from "' //
	1	   SUBLBL(isubfile)(:ln) // '" against table'
C   Add to table
	   ELSEIF (ilogic .eq. 1) THEN
	      CALL TBLOR(TABLE1,TABLE,TABLE,N_Cards)
	      cnum = cnum + 1
	      context(cnum) = 'Add entries from "' //
	1	   SUBLBL(isubfile)(:ln) // '" to table'
C   Remove from table
	   ELSEIF (ilogic .eq. 2) THEN
	      CALL TBLnot(TABLE1,TABLE1,N_cards)
	      CALL TBLAND(TABLE1,TABLE,TABLE,N_cards)
	      cnum = cnum + 1
	      context(cnum) = 'Remove entries in "' //
	1	   SUBLBL(isubfile)(:ln) // '" from table'
C   Subfile without current table
	   ELSEIF (ilogic .eq. 3) THEN
	      CALL TBLnot(TABLE,TABLE,N_cards)
	      CALL TBLAND(TABLE1,TABLE,TABLE,N_cards)
	      cnum = cnum + 1
	      context(cnum) = 'Remove entries in table from "' 
	1	   // SUBLBL(isubfile)(:ln) // '"'
C   Replace table with subfile
	   ELSEIF (ilogic .eq. 4) THEN
	      CALL TBLCOPY(TABLE1,TABLE,N_cards)
	      ln = lench(SUBLBL(isubfile))
	      cnum = 1
	      context(1) = 'Set table to "' //
	1	   SUBLBL(isubfile)(:ln) // '"'
	   ENDIF
	   psl_tblload = TBLCOUNT(TABLE,N_cards)
	ENDIF
	return
	end
	
