	SUBROUTINE PHSTD(STRING,STDFLD,SIZE,NFLDS)
C
C	   Routine to convert any codes in the Internal/External
C	   standard field (CARDF(50:55)) to the appropriate form
C	   for photocomposition.
C
C	   STRING - the text ready to be added to the comments box
C	            as created by this routine
C	   STDFLD - the 6 character field for filter/mono. from the
C	            Card F.
C	   SIZE   - length of the text in STRING.
C	   NFLDS  - the number of codes found in the STDFLD field.
C	            Used to determine whether or not the word "standard"
C	            should be plural.
C
C
C	   By: Mark Holomany, JCPDS     Date: 25-May-1984
C
C	   Revised:
C	      8-Aug-84 MAH--Capitalize only the first expanded text string
C	                    if more than one exists.  Return the number of
C	                    standard codes found in NFLDS.
C
C
	IMPLICIT INTEGER (A-Z)

!	INCLUDE  'pdfdata.cmn'
	INCLUDE  'ioret.cmn'

	CHARACTER STRING*(*)
	CHARACTER STDFLD*6,TOKEN*6

!	PARAMETER (MAXCOD = 30, MAXEXP = 450)
!	COMMON /STDCDS/ NCODES,LENEXP(MAXCOD),BEGEXP(MAXCOD),
!	1  CODE(MAXCOD),EXPAND
!	CHARACTER CODE*6, EXPAND*(MAXEXP)
!	INTEGER   LENEXP, NCODES,  BEGEXP
	CHARACTER CODE1*6, EXPAND1*73

C
C	... Initialize the scanner program; a blank will be the delimiter.
	CALL SCANIN(STDFLD, ' ')
C
C	... Check for codes to be expanded

	IS = 0
	NFLDS = 0
C
C	... Get next token (field)
100	CALL SCANER(TOKEN, LEN)
	IF(LEN .LT. 0) GO TO 999
	IF(LEN .EQ. 0) GO TO 100
	NFLDS = NFLDS + 1

	IF(NFLDS .GT. 1) THEN
	   STRING(IS+1:IS+2) = ', '
	   IS = IS + 2
	ENDIF

!	DO 4001 N=1,NCODES
!	IF(TOKEN .EQ. CODE(N)) THEN
!	   STRING(IS+1:IS+LENEXP(N)) =
!	1    EXPAND(BEGEXP(N):BEGEXP(N)+LENEXP(N)-1)
!	   IF(NFLDS .EQ. 1) CALL UPPER( STRING(IS+1:IS+1) )
!	   IS = IS + LENEXP(N)
!	   GO TO 100
!	ENDIF
!4001	CONTINUE

C read the standards codes from file
	REWIND(UNIT=NMINRL)
	do I=1,99999
	   read(NMINRL,'(a6,1x,a)',end=2) CODE1,expand1
	   IF(TOKEN .EQ. CODE1) THEN
C       find the end of the string
	      do J=73,1,-1
		 if (expand1(j:j) .ne. ' ') then
		    ln = j
		    goto 1
		 endif
	      enddo
 1	      STRING(IS+1:) = expand1(:ln)
	      IF(NFLDS .EQ. 1) CALL UPPER( STRING(IS+1:IS+1) )
	      IS = IS + LN
	      GO TO 100
	   ENDIF
	enddo

C
C	... If the CODE is not found, just copy the CODE to the output
C	... string as is.
 2	STRING(IS+1:IS+LEN) = TOKEN(1:LEN)
	IS = IS + LEN
	GO TO 100
C
C	... All done.  Return the length of the string.
999	CONTINUE
	IF(IS .GE. 1) THEN
	   SIZE = LENGTH(STRING(1:IS))
	ELSE
	   SIZE = 0
	ENDIF
	RETURN
	END
