#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "logiclib.h"

/*  Program hit2seq

    This program converts a hit # in a table of entries to a sequence # in the PDF

  Command syntax:
    hit2seq <file> <hits>  returns the sequence # of the first <n> hits in <file>
    hit2seq <file> <start> <end>  returns the sequence # of the hits between <start> and <end> in <file>
*/

int main (int argc, char *argv[])
{
  int error = 0;
  int first, last;
  if (PSL_INIT() != 0) 
    {
      fprintf(stderr,"error initializing the ICDD database\n");
      return 1;
    }

  if (argc == 3) {
    first = 1;
    last = strtol(argv[2], NULL, 10);
    if (last < 1) {
      fprintf(stderr,"error: invalid hit number %s\n", argv[2]);
      error = 1;
    }
  } else if (argc == 4) {
    first = strtol(argv[2], NULL, 10);
    if (first < 1) {
      fprintf(stderr,"error: invalid hit number %s\n", argv[2]);
      error = 1;
    }
    last = strtol(argv[3], NULL, 10);
    if (last < 1) {
      fprintf(stderr,"error: invalid hit number %s\n", argv[3]);
      error = 1;
    }
  } else {
    error = 1;
  }
  
  if (!error) {
      /*  Load the file argument */
      INTEGER4 ilogic, error;
      ilogic = 4;     /* Replace bitmap */
      error = PSL_READBITMAP(argv[1],&ilogic);
      if (error) 
	{      
	  fprintf(stderr, "error reading subfile %s\n",argv[1]);
	  return 1;
	}
      else {
	INTEGER4 j = 0;
	INTEGER4 tmp_dir = 0;
	INTEGER4 iseq = 0;
	INTEGER4 hitnum = 0;
	if (last <= PSL_REPHITS(&j) ) {
	  /*  get seq # for 1st hit */
	  while (hitnum < last) {
	    j = PSL_NEXTHIT(&iseq, &hitnum, &tmp_dir);
/*  	    printf("iseq=%d hitnum=%d nexthit=%d\n",iseq, hitnum, j); */
	    if (hitnum >= first) printf("%d ",j);
	    iseq = j;
	  }
	  printf("\n");
	  return 0;
	} else {
	  fprintf(stderr, "error: invalid hit-number %d\n",last);
	  error = 1;
	}
      }
    }
  fprintf(stderr, "\nusage:\n");
  fprintf(stderr, "\t hit2seq <file> <hits>\n(or)\t hit2seq <file> <start> <end>\n");
  return 1;
}
