/* pdfwrite.c
// functions to write PDF1 files from FORTRAN code
*/
#include <stdio.h>
#include <string.h>
#include "copyrght.h"
#include "logicmap.h"

/* pointers for pdf1 files */
FILE * findex;                    /* index */                    
FILE * fnamlib;                   /* name library */
FILE * fdilib;                    /* di library */
FILE * freflib;                   /* ref library */
FILE * fbitmap;                   /* selected bitmap library */

/* Open the pdf1 index file (jcpds.ind) */
INTEGER4 MSFLAG PS_CREATEINDEX(
		   const CHAR * diskpath
#ifdef _MSC_VER
		   , int FORlen /* dummy FORTRAN string length */
#endif
		   )  /* location of disk files */
{
	char tempname[128];

	/* open the file on disk */
	strcpy(tempname,diskpath);
	strcat(tempname, "jcpds.ind");
	findex = fopen(tempname, "wb");
	if (findex != NULL)  return 0;
	return -1;
}

/* Open the pdf1 library file (name.lib) */
INTEGER4 MSFLAG PS_CREATENAMLIB(
		   const CHAR * diskpath
#ifdef _MSC_VER
		   , int FORlen /* dummy FORTRAN string length */
#endif
		   )  /* location of disk files */
{
	char tempname[128];

	/* open the file on disk */
	strcpy(tempname,diskpath);
	strcat(tempname, "name.lib");
	fnamlib = fopen(tempname, "wb");
	if (fnamlib != NULL)  return 0;
	return -1;
}

/* Open the pdf1 library file (di.lib) */
INTEGER4 MSFLAG PS_CREATEDILIB(
		   const CHAR * diskpath
#ifdef _MSC_VER
		      , int FORlen /* dummy FORTRAN string length */
#endif
		   )  /* location of disk files */
{
	char tempname[128];

	/* open the file on disk */
	strcpy(tempname,diskpath);
	strcat(tempname, "di.lib");
	fdilib = fopen(tempname, "wb");
	if (fdilib != NULL)  return 0;
	return -1;
}

/* Open the pdf1 library file (ref.lib) */
INTEGER4 MSFLAG PS_CREATEREFLIB(
		   const CHAR * diskpath
#ifdef _MSC_VER
		   , int FORlen /* dummy FORTRAN string length */
#endif
		   )  /* location of disk files */
{
	char tempname[128];

	/* open the file on disk */
	strcpy(tempname,diskpath);
	strcat(tempname, "ref.lib");
	freflib = fopen(tempname, "wb");
	if (freflib != NULL)  return 0;
	return -1;
}


/* Open a bitmap library (.bit) file */
INTEGER4 MSFLAG PS_CREATEBITLIB(
		   const CHAR * filename,  /* name of file */
#ifdef _MSC_VER
		   int FORlen1, /* dummy FORTRAN string length */
#endif
		   const CHAR * diskpath
#ifdef _MSC_VER
		   , int FORlen2 /* dummy FORTRAN string length */
#endif
		   )  /* location of disk files */
{
	char tempname[128];

	/* first try to open the file on disk */
	strcpy(tempname,diskpath);
	strcat(tempname,filename);
	fbitmap = fopen(tempname, "wb");
	if (fbitmap != NULL)  return 0;
	return -1;
}
/* Close the bitmap library file */
void MSFLAG PS_CLOSEBIT(void)
{
  fclose(fbitmap); 
  fbitmap = NULL;
}			


/* Write a record to the pdf1 index file */
INTEGER4 MSFLAG PS_WRITEINDEX(
		  INTEGER4 *cardnum,    /* JCPDS-ICDD set/card # */
		  INTEGER4 *namept,	    /* pointer to name record */
		  INTEGER4 *dipt,	    /* pointer to d/i record */
		  INTEGER4 *refpt,	    /* pointer to reference record */
		  INTEGER4 * cdpt)	    /* pointer to PDF2 record */
{
  int i2;
  INTEGER4 words[5];

  words[0] = *cardnum;
  words[1] = *namept;
  words[2] = *dipt;
  words[3] = *refpt;
  words[4] = *cdpt;

  i2 = fwrite(words, 1, 20, findex);
  if (i2<20) return -1L;
  return 0L;
}

/* Write a record to the pdf1 name library file */
INTEGER4 MSFLAG PS_WRITENAMLIB(
		      INTEGER4 * bytepointer,  /* byte offset */
		      unsigned INTEGER1 * l1,
		      unsigned INTEGER1 * l2,
		      unsigned INTEGER1 * l3,
		      unsigned INTEGER1 * l4,
		      CHAR * line1,
#ifdef _MSC_VER
		     int FORlen1, /* dummy FORTRAN string length */
#endif
		      CHAR * line2,
#ifdef _MSC_VER
		      int FORlen2, /* dummy FORTRAN string length */
#endif
		      CHAR * line3,
#ifdef _MSC_VER
		      int FORlen3, /* dummy FORTRAN string length */
#endif
		      CHAR * line4
#ifdef _MSC_VER
		   , int FORlen4 /* dummy FORTRAN string length */
#endif
			  )
{
  size_t i;
  unsigned INTEGER1 lngths[4];

  lngths[0] = *l1;
  lngths[1] = *l2;
  lngths[2] = *l3;
  lngths[3] = *l4;

  *bytepointer += fwrite(lngths, 1, 4, fnamlib);
  i = lngths[0];
  if (i >0) *bytepointer += fwrite(line1, 1, i, fnamlib);
  i = lngths[1];
  if (i >0) *bytepointer += fwrite(line2, 1, i, fnamlib);
  i = lngths[2];
  if (i >0) *bytepointer += fwrite(line3, 1, i, fnamlib);
  i = lngths[3];
  if (i >0) *bytepointer += fwrite(line4, 1, i, fnamlib);

  return 0L;
}


/* Write a record to the pdf1 ref library file */
INTEGER4 MSFLAG PS_WRITEREFLIB(
		      INTEGER4 * bytepointer,  /* byte offset */
		      INTEGER1 * year, 
		      unsigned INTEGER1 * l1,
		      CHAR * coden,  
#ifdef _MSC_VER
		      int FORlen1, /* dummy FORTRAN string length */
#endif
		      unsigned INTEGER1 * l2,
		      CHAR * volume, 
#ifdef _MSC_VER
		      int FORlen2, /* dummy FORTRAN string length */
#endif
		      unsigned INTEGER1 * l3,
		      CHAR * page, 
#ifdef _MSC_VER
		      int FORlen3, /* dummy FORTRAN string length */
#endif
		      unsigned INTEGER1 * l4,
		      CHAR * authors
#ifdef _MSC_VER
		   , int FORlen4 /* dummy FORTRAN string length */
#endif
			  )
{
  size_t i;
  unsigned INTEGER1 lngths[5];

  lngths[0] = *l1;
  lngths[1] = *l2;
  lngths[2] = *l3;
  lngths[3] = *l4;
  lngths[4] = *year;

  *bytepointer += fwrite(lngths, 1, 5, freflib);
  i = lngths[0];
  if (i >0) *bytepointer += fwrite(coden, 1, i, freflib);
  i = lngths[1];
  if (i >0) *bytepointer += fwrite(volume, 1, i, freflib);
  i = lngths[2];
  if (i >0) *bytepointer += fwrite(page, 1, i, freflib);
  i = lngths[3];
  if (i >0) *bytepointer += fwrite(authors, 1, i, freflib);

  return 0L;
}

/* Write a record to the pdf1 di library file */
INTEGER4 MSFLAG PS_WRITEDILIB(
		      INTEGER4 * bytepointer,  /* byte offset */
		      INTEGER2 *pdfdsp,  
		      unsigned INTEGER1 *inten, 
		      unsigned INTEGER1 * ndsp )
{
  size_t i;
  *bytepointer += fwrite(ndsp, 1, 1, fdilib);
  i = 2*(*ndsp);
  if (i > 0)
    {
      *bytepointer += fwrite(pdfdsp, 1, i, fdilib);
      i = *ndsp;
      *bytepointer += fwrite(inten, 1, i, fdilib);
    }
  return 0L;
}

/* write a record to a bitmap library file */
INTEGER4 MSFLAG PS_WRITEBITLIB(
		  INTEGER4 *recpointer, /* sequence # to be written */
		  INTEGER4 *table,      /* bitmap array */
		  INTEGER4 *nentries)   /* number of entries in database */
{
  int i2;
  long bytepointer;
  size_t nwords; 
  
  nwords = (31+*nentries)/32;
  bytepointer = 4 * nwords * (-1 + *recpointer); /* (4*nwords bytes/record) */

  i2 = fseek(fbitmap, bytepointer, SEEK_SET);
  if (i2<0) return -1L;

  i2 = fwrite(table, 4, nwords, fbitmap);
  if (i2<nwords) return -1L;
  return 0L;
}
