#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "logiclib.h"

/*  Program element

    This program locates the entries that have a specified set of 
    elements. These entries are applied to the current table in
    a boolean operation.

  Command syntax:
    element <file>
            [ -oneof <e_list> | -allof <e_list> ] 
            [ -alloptional | -optional <e_list> ]
	    [ -or | -and | -remove | -not ]
    Where -e_list is a list of elements by number {<int> <int>...}
    The list may be null, but the brackets or quotes must be present.
    Elements are defined as the integers from 1 to 103, and integers 
    from 104-121 represent groups of elements:
  1a	104              2a	105              3a	106           
  4a	107              5a	108              6a	109
  7a	110              8a	111              1b	112
  2b	113              3b	114              4b	115
  5b	116              6b	117              7b	118
  8b	119              LN	120              AD	121

*/

int main (int argc, char *argv[])
{
  INTEGER4 j;
  INTEGER4 error;
  INTEGER4 ilogic,reqval,optval;
  INTEGER4 reqelem[103],optelem[103];
  INTEGER4 reqgrp[18],optgrp[18];

  error = 0;
  reqval = -1;
  optval = -1;
  /*  Check the arguments */
  if (argc < 6 || argc > 7) 
    {
      fprintf(stderr,"error: wrong number of arguments\n");
      error = 1;
    }

  if (PSL_INIT() != 0) 
    {
      fprintf(stderr,"error initializing the ICDD database\n");
      return 1;
    }

  /*  Load the starting file */
  if (!error) {
    ilogic = 4;     /* Replace bitmap */
    error = PSL_READBITMAP(argv[1],&ilogic);
    if (error) 
      {      
	fprintf(stderr, "error reading subfile %s\n",argv[1]);
	return 1;
      }
  }
  
  ilogic = -1;
  for (j=0; j<18; j++) reqgrp[j] = optgrp[j] = 0;
  for (j=0; j<103; j++) reqelem[j] = optelem[j] = 0;
  j = 2;
  while (j < argc && !error) {
    if (!strcmp(argv[j],"-allof") || !strcmp(argv[j],"-oneof")) {
      if (reqval != -1) {
	fprintf(stderr,"error: option -allof or -oneof repeated\n");
	error = 1;
      }
      if (!strcmp(argv[j],"-allof"))
	reqval = 0;
      else
	reqval = 1;
      /*  Now process the list of elements */
      j++;
      error = ParseElementList(argv[j], reqelem, reqgrp);
    } else if (!strcmp(argv[j],"-optional")|| !strcmp(argv[j],"-alloptional")){
      if (optval != -1) {
	error = 1;
	fprintf(stderr,"error: option -alloptional or -optional repeated\n");
      }
      if (!strcmp(argv[j],"-alloptional"))
	optval = 0;
      else {
	optval = 1;
	j++;
	error = ParseElementList(argv[j], optelem, optgrp);
      }
    } else if (!strcmp(argv[j],"-or") || !strcmp(argv[j],"-and") ||
	       !strcmp(argv[j],"-remove") || !strcmp(argv[j],"-not") ||
	       !strcmp(argv[j],"-replace")) {
      if (ilogic != -1) {
	fprintf(stderr,"error: option -or -and -remove -not or -replace repeated\n");
	error = 1;
      }
      if (!strcmp(argv[j],"-and"))
	ilogic = 0;
      else if (!strcmp(argv[j],"-or"))
	ilogic = 1;
      else if (!strcmp(argv[j],"-remove"))
	ilogic = 2;
      else if (!strcmp(argv[j],"-not"))
	ilogic = 3;
      else if (!strcmp(argv[j],"-replace"))
	ilogic = 4;
    } else {
      fprintf(stderr,"error: unknown option: %s\n",argv[j]);
      error = 1;
      j = argc;
    }
    j++;
  }
  if (ilogic < 0 || reqval < 0 || optval <0 ) error = 1;

  if (!error) {
/*       printf("elemsub ilogic = %d, reqval = %d, optval = %d\n", */
/*  	     ilogic, reqval, optval); */
/*       printf("required elements: "); */
/*       for (j=0; j<103; j++) if (reqelem[j]) printf("%d, ",j+1); */
/*       printf("\nrequired groups: "); */
/*       for (j=0; j<18; j++) if (reqgrp[j]) printf("%d, ",j+1); */
/*       printf("\noptional elements: "); */
/*       for (j=0; j<103; j++) if (optelem[j]) printf("%d, ",j+1); */
/*       printf("\noptional groups: "); */
/*       for (j=0; j<18; j++) if (optgrp[j]) printf("%d, ",j+1); */
/*       printf("\n"); */

    j = PSL_ELEMSUB(&ilogic, &reqval, &optval,
		    reqelem, reqgrp, optelem, optgrp);
    if (j < 0) {
      fprintf(stderr,"error processing request\n");
      error = 1;
    } else {
      error = PSL_SAVEBITMAP(argv[1]);
      if (error) {      
	fprintf(stderr, "error writing subfile %s\n",argv[1]);
      }
    }
  }
  if (error) {
    fprintf(stderr, "\nusage:\n");
    fprintf(stderr, "element\t<file>\t[ -oneof e_list | -allof e_list ]\n");
    fprintf(stderr, "\t\t[ -alloptional | -optional e_list]\n");
    fprintf(stderr, "\t\t[ -or | -and | -remove | -not ]\n");
    return 1;
  } else {
    printf("%d\n", j);
  }
  return 0;
}
