#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "logiclib.h"

/*  Program elemcount

    This program locates the entries that have a specified range of
    unique elements. These entries are applied to the specified bitmap 
    table using the selected boolean operation.

  Command syntax:
        elemcount <file> 
	          -count "<int>, <int> ..." [ -or | -and | -remove | -not ]

*/
int main (int argc, char *argv[]) {
  int error = 0;			/* error flag */
  INTEGER4 j;
  INTEGER4 ilogic;
  INTEGER4 *count_arg = NULL;
  INTEGER4 count_arr[10];
  int count;
  int i,listlen;

  ilogic = count = -1;
  for (i=0; i< 10; i++) count_arr[i] = 0;

  j = 2;
  while (j < argc && !error) {
    if (!strcmp(argv[j],"-count")) {
      if (count != -1) {
	fprintf(stderr,"error: -count repeated\n");
	error = 1;
      }
      count = 1;
      j++;
      listlen = ParseIntegerList(argv[j], &count_arg);
      for (i=0; i< listlen; i++) {
	if (count_arg[i] >= 0 && count_arg[i] < 10) 
	  count_arr[count_arg[i]] = 1;
	else {
	  fprintf(stderr,"invalid count value: %d/n",count_arg[i]);
	  error = 1;
	}
      }
      if (count_arg != NULL) free(count_arg);
    } else if (!strcmp(argv[j],"-or"))
      ilogic = 1;
    else if (!strcmp(argv[j],"-and"))
      ilogic = 0;
    else if (!strcmp(argv[j],"-remove"))
      ilogic = 2;
    else if (!strcmp(argv[j],"-not"))
      ilogic = 3;
    else {
      fprintf(stderr,"unknown option: %s\n",argv[j]);
      error = 1;
    }
    j++;
  }
  if (count < 0 || ilogic < 0) {
    fprintf(stderr,"required option missing\n");
    error = 1;
  }

  if (PSL_INIT() != 0) {
    fprintf(stderr,"error initializing the ICDD database\n");
    return 1;
  }

  /*  Load the starting file */
  if (!error) {
    INTEGER4 il;
    il = 4;     /* Replace bitmap */
    error = PSL_READBITMAP(argv[1],&il);
    if (error) 
      {      
	fprintf(stderr, "error reading subfile %s\n",argv[1]);
	return 1;
      }
  }

  if (!error) {
    PSL_ELEMCOUNT(&ilogic, count_arr);
    error = PSL_SAVEBITMAP(argv[1]);
    if (error) {      
      fprintf(stderr, "error writing subfile %s\n",argv[1]);
    }
  }

  if (error) {
    fprintf(stderr, "\nusage:\n");
    fprintf(stderr,
	    "\t elemcount <file> -count {<int> <int> ...");
    fprintf(stderr,
	    " [ -or | -and | -remove | -not ]\n");
    return 1;
  }
  return 0;
}
