      include 'copyrght.def'
C
C-----------------------------------------------------------------------
	integer*4 function psl_elemcount(ilogic, count)
C locate entries based on number of unique elements in chemical composition 
C-----------------------------------------------------------------------
	implicit none
!MS$ATTRIBUTES C, REFERENCE :: psl_elemcount
	INTEGER*4 ilogic, count(10)
C-----------------------------------------------------------------------
C count(i) is 1 if element with (i-1) elements are to be considered
C
C ilogic determines the logic to be applied to the tables
C	0	 Match with table
C	1	 Add to table
C	2	 Remove new table from old table
C	3	 Remove old table from new table
C-----------------------------------------------------------------------
	include 'bitops.def'
	include 'pdfread.def'

	include 'pdfdefs.par'

	include 'pdf.cmn'
	include 'logic.cmn'

	CHARACTER*(*) subrnm
	PARAMETER (subrnm='psl_elemcount')

	integer*4 I,J,K
	CHARACTER*100 TRACE
        integer lench
        integer ln

C========================================================================
C now perform the search
C========================================================================
      CALL ps_openelemcnt(i)
      IF (i .ne. 0) THEN
	 call errmsg(subrnm,'Unable to open element bitmap file')
	 psl_ELEMcount = -1
	 RETURN
      ENDIF
C 
      nph1 = TBLCLR(TABLE1,N_Cards)
      DO J=1,min(10,N_ELEMC)
         if (count(j) .ne. 0) then
            k = ps_readbitlib(j, table2, N_cards)
            IF (k .ne. 0) THEN
               call errmsg(subrnm,
     $              'reading Element Count bitmap file')
               psl_ELEMCOUNT = -1
               RETURN
            ENDIF
            CALL TBLOR(TABLE1,TABLE2,TABLE1,N_Cards)
         endif
      ENDDO
      call ps_closebitlib()
C========================================================================
C now setup the history entry
C========================================================================
      trace = 'Element Count ='
      DO J=1,min(10,N_ELEMC)
         if (count(j) .ne. 0) then
            ln = lench(trace)
            write(trace(ln+1:),'(i2,a)') j-1,','
         endif
      enddo
C remove final comma
      ln = lench(trace)
      trace(ln:ln) = ' '
!! debug
!	call tblcount(table,N_Cards,I)
!	write (99,'(A,i6)') 'TABLE = ',I
!	call tblcount(table1,N_Cards,I)
!	write (99,'(A,i6)') 'TABLE1 = ',I

	CALL TBLLOGIC(ilogic, trace)

!! debug
!	write (99,'(2A)') 'after TBLLOGIC, trace=',trace
!	call tblcount(table,N_Cards,I)
!	write (99,'(A,i6)') 'TABLE = ',I
!	close(99)
	psl_elemcount = NPHASE
	RETURN
	END







