	include 'copyrght.def'
C subroutines for conversions -- some of the following subroutines 
C have machine-specific functions. Subroutine get_byte_order
C attempts to set the byte ordering
C
	integer function get_byte_order()
	integer*4 word
	INTEGER*1 wordarray(4)
	equivalence (word,wordarray)
	word = 1
	if (wordarray(1) .eq. 1) then
	   get_byte_order = 0 ! bigendian (80486)
	elseif (wordarray(4) .eq. 1) then
	   get_byte_order = 1 ! littleendian (most RISC)
	else
	   stop 'Error in get_byte_order'
	endif
C	write (*,*) 'byte order=',get_byte_order
	return
	end
C--------------------------------------------------------------------
	INTEGER*1 function long2byte(word)
C Convert a long integer (32 bits) to an unsigned 8 bit byte
C by dropping all but 8 bits
	INTEGER*1 word(4)
C--------------------------------------------------------------------
C  correct for machine-dependent implementation
	integer get_byte_order
	integer byteorder/-1/
	save byteorder
	if (byteorder .lt. 0) byteorder = get_byte_order()
C--------------------------------------------------------------------
	if (byteorder .eq. 0) then
	   long2byte = word(1)
	else
	   long2byte = word(4)
	endif
	return
	end
C--------------------------------------------------------------------
	INTEGER*2 function long2short(word)
C Convert a long integer (32 bits) to a signed 16 bit short integer
C by dropping all but 16 bits
	INTEGER*2 word(2)
C--------------------------------------------------------------------
C  correct for machine-dependent implementation
	integer get_byte_order
	integer byteorder/-1/
	save byteorder
	if (byteorder .lt. 0) byteorder = get_byte_order()
C--------------------------------------------------------------------
	if (byteorder .eq. 0) then
	   long2short = word(1)
	else
	   long2short = word(2)
	endif
	return
	end
C--------------------------------------------------------------------
	subroutine byte2long(byte,word)
C Convert a long integer (32 bits) from an unsigned 8 bit byte
C by zeroing all but 8 bits
	INTEGER*1 byte
	INTEGER*1 word(4)
C--------------------------------------------------------------------
C  correct for machine-dependent implementation
	integer get_byte_order
	integer byteorder/-1/
	save byteorder
	if (byteorder .lt. 0) byteorder = get_byte_order()
C--------------------------------------------------------------------
	if (byteorder .eq. 0) then
	   word(1) = byte
	   do i=2,4
	      word(i) = 0
	   enddo
	else
	   word(4) = byte
	   do i=1,3
	      word(i) = 0
	   enddo
	endif
	return
	end
C--------------------------------------------------------------------
	subroutine short2long(short,word)
C Convert a long integer (32 bits) from a signed 16 bit byte
C by zeroing all but 16 bits
	INTEGER*1 short(2)
	INTEGER*1 word(4)
C--------------------------------------------------------------------
C  correct for machine-dependent implementation
	integer get_byte_order
	integer byteorder/-1/
	save byteorder
	if (byteorder .lt. 0) byteorder = get_byte_order()
C--------------------------------------------------------------------
	if (byteorder .eq. 0) then
	   word(1) = short(1)
	   word(2) = short(2)
	   if (short(2) .gt. 127 .or. short(2) .lt. 0) then
!	   if (short(2) .gt. 127) then
	      word(3) = -1
	      word(4) = -1
	   else
	      word(3) = 0
	      word(4) = 0
	   endif
	else
	   word(3) = short(1)
	   word(4) = short(2)
	   if (short(1) .gt. 127 .or. short(1) .lt. 0) then
!	   if (short(1) .gt. 127) then
	      word(1) = -1
	      word(2) = -1
	   else
	      word(1) = 0
	      word(2) = 0
	   endif
	endif
	return
	end
CC========================================================================CC
C the following conversion are probably not machine-dependent, but this    C
C should be verified                                                       C
CC========================================================================CC
C---------------------------------------------------------------------------
	LOGICAL FUNCTION DTOTT(DSPACE,TWOTHETA,WAVE)
C--
C  Converts a D space to a 2Theta value
C	the function returns .TRUE. if the conversion was successful
C--
C	DSPACE    is the D value 
C	TWOTHETA  is the (returned) TWOTHETA value
C	WAVE	  is the wavelength for 2Theta's
C
	REAL DSPACE,TWOTHETA,WAVE

	REAL X
	
	DTOTT = .false.

	IF (DSPACE .LE. 0.0 .or. WAVE .le. 0.0) RETURN

	X = 0.5 * WAVE / DSPACE
C	Is the position within the Ewald sphere?
	IF (X .LE. 1.0) THEN
	  twotheta = 360.0 * ASIN(X) / 3.14159265
	  DTOTT = .true.
	ENDIF
	RETURN
	END
C---------------------------------------------------------------------------
	LOGICAL FUNCTION TTTOD(DSPACE,TWOTHETA,WAVE)
C--
C  Converts a 2Theta value to a D space
C	the function returns .TRUE. if the conversion was successful
C--
C	DSPACE    is the (returned ) D value 
C	TWOTHETA  is the TWOTHETA value
C	WAVE	  is the wavelength for 2Theta's
C
	REAL DSPACE,TWOTHETA,WAVE

	REAL X

	TTTOD = .false.

	IF (WAVE .le. 0.0) RETURN

	IF (twotheta .le. 0.0 .or. twotheta .gt. 180.) RETURN
C convert to theta (radians) 
	x = 3.14159265 * twotheta / 360.0 
	X = SIN(X)
	IF (X .le. 0) RETURN
	DSPACE = 0.5 * WAVE / X
	TTTOD = .true.
	RETURN
	END
C---------------------------------------------------------------------------
	LOGICAL FUNCTION PDFTOD(PDF2T,DSPACE)
C--
C  Converts a PDF (D/I) encoding to a D space
C	the function returns .TRUE. if the conversion was successful
C--
C	DSPACE    is the (returned) D value 
C	PDF2T     is the encoded 2Theta value

C
	REAL DSPACE
	INTEGER PDF2T
	REAL X

C     WAVE2	  is the wavelength/2 (1.540598A)
	REAL WAVE2
	PARAMETER (WAVE2 = 0.770299)

	PDFTOD = .false.

C    convert PDF2T to theta (in radians) at 1.540598A 
	X = 0.25*(0.0001*PDF2T + 3.14159265)
	IF (X .le. 0) RETURN
C    convert to D space 
	DSPACE = WAVE2/SIN(X)
	PDFTOD = .true.
	RETURN
	END
C---------------------------------------------------------------------------
	LOGICAL FUNCTION DTOPDF(PDF2T,DSPACE)
C--
C  Converts a D space to a PDF (D/I) encoded value
C	the function returns .TRUE. if the conversion was successful
C--
C	DSPACE    is the D value 
C	PDF2T     is the (returned) encoded 2Theta value

	REAL     DSPACE
	INTEGER  PDF2T

C     WAVE2	  is the wavelength/2 (1.540598A)
	REAL WAVE2
	PARAMETER (WAVE2 = 0.770299)

	REAL X

	DTOPDF = .false.

	IF (DSPACE .LE. 0.0) RETURN
C    convert D to theta (in radians) at 1.540598A 
	X = WAVE2 / DSPACE
C	Is the position within the Ewald sphere?
	IF (X .LE. 1.0) THEN
	  X = ASIN(X)
	  X = 10000.*(4.0*X - 3.14159265)
C   now round to nearest integer 
	  IF (X .lt. 0) THEN
	    PDF2T = X - 0.5
	  ELSE
	    PDF2T = X + 0.5
	  ENDIF
	  DTOPDF = .true.
	ENDIF
	RETURN
	END
C---------------------------------------------------------------------------
	LOGICAL FUNCTION DTOIND(DSPACE,INDEX,NREGIONS)
C--
C  Converts a D space to an INDEX number for the ``D-space Indices''
C	the function returns .TRUE. if the conversion was successful
C
C  this approach is a little more complex than desired, but it is completely
C  compatible with the computation in Harlow's PDFENCODE program (subroutine
C  ENDSPINT) 12/87 BHT
C--
C	DSPACE    is the D value 
C	INDEX     is the (returned) record number 1<=INDEX<=NREGIONS
C	NREGIONS  is the number of records on the files

	REAL DSPACE
	INTEGER*4 NREGIONS,INDEX

C     WAVE2	  is the wavelength/2 (1.540598A)
	REAL WAVE2
	PARAMETER (WAVE2 = 0.770299)
	INTEGER   PDF2T

	REAL X

	DTOIND = .false.
	INDEX = NREGIONS

	IF (DSPACE .LE. 0.0) RETURN
C    convert D to theta (in radians) at 1.540598A 
	X = WAVE2 / DSPACE
C	Is the position within the Ewald sphere?
	IF (X .GT. 1.0) THEN
	  INDEX = NREGIONS
	ELSE
	  X = ASIN(X)
	  X = 10000.*(4.0*X - 3.14159265)
C   now round to nearest integer 
	  IF (X .lt. 0) THEN
	    PDF2T = X - 0.5
	  ELSE
	    PDF2T = X + 0.5
	  ENDIF
C subtract offset
	  INDEX = PDF2T/100. + 314.0 + 1.
	  IF (INDEX .GE. 1 .and. INDEX .LE. NREGIONS) DTOIND = .true.
	ENDIF
	INDEX = MAX(1,INDEX)
	INDEX = MIN(NREGIONS,INDEX)
	RETURN
	END
C---------------------------------------------------------------------------
	LOGICAL FUNCTION INDTOD(INDEX1,INDEX2,DMAX,DMIN,NREGIONS)
C--
C  Converts a range of INDEX numbers to the MIN and MAX d-space covered 
C  in the ``D-space Indices.''
C  The d-space range minimum d-space covered in INDEX1 to the maximum
C  in INDEX2 (or reverse, if INDEX2 < INDEX1). Values outside the legal 
C  range (1...NREGIONS) are set to the appropriate value
C	The function returns .TRUE. if the INDEX values are legal
C--
C  this approach is a little more complex than desired, but it is completely
C  compatible with the computation in Harlow's PDFENCODE program (subroutine
C  ENDSPINT) 12/87 BHT
C	INDEX1    is a record number
C	INDEX2    is a record number 
C	DMAX      is the maximum D value 
C	DMIN      is the minimum D value 

	REAL DMAX,DMIN
	INTEGER*4 INDEX1,INDEX2,NREGIONS

C     WAVE2	  is the wavelength/2 (1.540598A)
	REAL WAVE2
	PARAMETER (WAVE2 = 0.770299)
	INTEGER*4 Ilow,Ihigh

	REAL X,X1

	INDTOD = .true.
	Ilow = MIN(INDEX1,INDEX2)
	Ihigh = MAX(INDEX1,INDEX2)
	IF (Ilow .lt. 1) then 
	  ILOW = 1
	  INDTOD = .false.
	ENDIF
	IF (Ihigh .gt. NREGIONS) then 
	  Ihigh = NREGIONS
	  INDTOD = .false.
	ENDIF

	x = 100.*(Ilow-1.0049999999) - 31400
	x1 = 100.*(Ihigh-0.0049999999) - 31400
	x = (X/10000. + 3.14159265)/4.0
	x1 = (X1/10000. + 3.14159265)/4.0
	DMAX = WAVE2 / sin(x)
	DMIN = WAVE2 / sin(x1)
	RETURN
	END

