      PROGRAM INTERPOLATE
        INTEGER IN,OUT,LI,LO
        COMMON/IO/IN,OUT,LI,LO
!        DIMENSION X(100000),A(100000),ESD(100000)
        INTEGER*4 INPSIZ, OUTSIZ
!        PARAMETER (INPSIZ=100000)
        INTEGER*4 p_X, p_A, p_ESD
!        DIMENSION XB(1000000),B(1000000),BESD(1000000)
!        PARAMETER (OUTSIZ=1000000)
        INTEGER*4 p_XB, B, BESD
      EXTERNAL MALLOC

      IN=5
      OUT=2
      LI=5
      LO=6

C OPEN .INPUT FILE
 
        OPEN(UNIT=IN,FILE='interp.inp',STATUS='OLD',ERR=1)
        GO TO 3

1       WRITE(LO,*)'ERROR OPENING .ASCII FILE = interp.inp'
        CLOSE(UNIT=IN)
        STOP
 
3       READ (IN,*) INPSIZ
        READ (IN,*) OUTSIZ

        IERR = MALLOC(p_X, 4* (INPSIZ+1))
        IF (IERR .NE. 0) STOP 'Cannot allocate memory'
        IERR = MALLOC(p_A, 4*(INPSIZ+1))
        IF (IERR .NE. 0) STOP 'Cannot allocate memory'
        IERR = MALLOC(p_ESD, 4*(INPSIZ+1))
        IF (IERR .NE. 0) STOP 'Cannot allocate memory'
        IERR = MALLOC(p_XB, 4*(OUTSIZ+1))
        IF (IERR .NE. 0) STOP 'Cannot allocate memory'
        IERR = MALLOC(p_B, 4*(OUTSIZ+1))
        IF (IERR .NE. 0) STOP 'Cannot allocate memory'
        IERR = MALLOC(p_BESD, 4*(OUTSIZ+1))
        IF (IERR .NE. 0) STOP 'Cannot allocate memory'
        CALL INTERPLT(%val(p_X), %val(p_A), %val(p_ESD), %val(p_XB),
     $       %val(p_B), %val(p_BESD),inpsiz,outsiz)
      
      END
      SUBROUTINE INTERPLT(X,A,ESD,XB,B,BESD,iinp,iout)


C
C       Change step size by interpolating values and combining files
C       into one file with fixed step size
C
 
        INTEGER IN,OUT,LI,LO
        COMMON/IO/IN,OUT,LI,LO
        DIMENSION X(*),A(*),ESD(*)
        DIMENSION XB(*),B(*),BESD(*)
        REAL*4 XA(25),YA(25),DELY(25)
        REAL*4 AX(27),BX(27),CX(27),DX(27)
        REAL*4 TEMP(216)
 
        READ (IN,*) TTMIN,TTMAX,DLT
        ifile = 0

C       Make two-theta range and step size consistent in case they're not
C       and fix DLT at some reasonable integer in case it is not.

        IDLT=NINT(10000.0*DLT)
        DLT=0.0001*FLOAT(IDLT)
        NP=NINT((TTMAX-TTMIN)/DLT)+1
        ! make sure we do not overflow
        NP = MIN(NP,iout)
5       TTMAXT=TTMIN+(NP-1)*DLT
        IF (TTMAXT.GT.TTMAX) THEN
           NP=NP-1
           GO TO 5
        ENDIF
        TTMAX=TTMAXT

C       Generate the new two-theta array 

        DO J=1,NP
           XB(J)=TTMIN+(J-1)*DLT
           B(J)=0.0
           BESD(J)=0.0
        ENDDO

C       Read the method of extrapolation to use

        READ (IN,*) INTERP
        iline = 4

        IF (INTERP.EQ.1) THEN
           READ (IN,*) NS,S
           IF(NS.LT.5) NS=5
           IF(NS.GT.25) NS=25
C       Make sure that NS is odd
           MPT=NS/2
           NS=2*MPT+1
        ENDIF

C       Read data from one file -- throw away any points outside of 
C       TTMIN to TTMAX range
      
 7      I=1
        ifile = ifile + 1
 8      READ (IN,*,END=100) X(I),A(I),ESD(I)
        iline = iline + 1
        IF (X(I).LT. -180.0) GO TO 10
        IF (X(I).LT.TTMIN.OR.X(I).GT.TTMAX) GO TO 8
C        IF (ESD(I).LE. 0.0) GO TO 8
        ! make sure we do not overflow
        if (I .LE. iinp) I=I+1
        GO TO 8

 10     NPTS=I-1

C were there any points in range? If not skip this file
        IF (NPTS .LT. 2) GOTO 7

C       The present file will contribute data from J1 to J2 and will fill 
C       in the two dangling end points

        !print *,'read file ',ifile,' from x=',x(1),X(NPTS),NPTS,iline
         
           J1=IFIX((X(1)-TTMIN)/DLT)+2
           J2=IFIX((X(NPTS)-TTMIN)/DLT)+1

C         Start entering data in the new array by simply transfering the data 
C         closest to the two end points

           S2=1.0/ESD(1)**2
           B(J1-1)=B(J1-1)+A(1)*S2
           BESD(J1-1)=BESD(J1-1)+S2

           S2=1.0/ESD(NPTS)**2
           B(J2+1)=B(J2+1)+A(NPTS)*S2
           BESD(J2+1)=BESD(J2+1)+S2

C        Now finish with interpolation of points in between

C**************************************************************************
C        Linear interpolation
C**************************************************************************
         IF (INTERP.EQ.0) THEN         
         I=1
         DO 20 J=J1,J2

C        Be sure that one point in X(I) is above XB(J) and one is below

 15         BELOW=X(I)-XB(J)
            ABOVE=X(I+1)-XB(J)
            IF (BELOW.LE.0.0 .AND. ABOVE.GE.0.0) THEN
               DIFF=X(I+1)-X(I)
               RATIO=ABS(BELOW)/DIFF
               FINTERP=A(I)+(A(I+1)-A(I))*RATIO
C are points valid?
               if (ESD(I+1) .GT. 0 .AND. ESD(I) .GT. 0) THEN
                  SIGINTERP=ESD(I)+(ESD(I+1)-ESD(I))*RATIO
                  S2=1.0/SIGINTERP**2
                  B(J)=B(J)+FINTERP*S2
                  BESD(J)=BESD(J)+S2
               ENDIF
               GO TO 20
            ELSE
               I=I+1
               GO TO 15
            ENDIF
 20     CONTINUE

        GO TO 7
        ENDIF
C**************************************************************************
C Spline interpolation
C**************************************************************************
        IF (INTERP.EQ.1) THEN

           ISAVE=-1

           DO 88 J=J1,J2

C       "XB(J)" IS TWO-THETA VALUE OF THE POINT WE NEED AN INTENSITY FOR.
C       NEXT, GET THE CLOSEST "X(I)" VALUE IN THE INPUT DATA -- THE
C       INPUT X VALUES NEED NOT BE OF EQUAL STEPS BUT THE OUTPUT XB VALUES
C       WILL BE.

             DO 82 I=1,NPTS
                 IF (XB(J).GT.X(I)) GO TO 82
                 IF (XB(J).EQ.X(I)) GO TO 84
                 IF ((X(I)-XB(J)).GT.(XB(J)-X(I-1))) THEN
                 GO TO 83
                 ELSE
                 GO TO 84
                 ENDIF
82            CONTINUE
83            I=I-1

C       THE "I"TH DATA POINT IN THE INPUT IS THE CLOSEST TO "TT"
C       NOW GET THE RANGE OF POINTS TO BE INCLUDED IN THE SPLINE

C       NEW I IS THE SAME AS THE LAST I, NO NEED TO CALCULATE A NEW SPLINE
84            IF (I.EQ.ISAVE) GO TO 86

              I1=I-MPT
              I2=I+MPT
              IF (I1.LT.1) THEN
                 I2=I2-I1+1
                 I1=1
              ENDIF
              IF (I2.GT.NPTS) THEN
                 I1=I1-(I2-NPTS)
                 I2=NPTS
              ENDIF

              ISAVE=I

              WRITE (LO,655) ISAVE,I1,I2
 655          FORMAT (' ISAVE,I1,I2 = ',3I10)

              N=0
              DO 85 I=I1,I2
                 N=N+1
                 XA(N)=X(I)

C     Intensities or esd's are too large for synchrotron data and the
C     spline subroutines end up in infinite loops so I cut them both
C     by 100.

                 YA(N)=0.01*A(I)
C     skip invalid points
                 IF (ESD(I) .LE. 0) GOTO 85
                 DELY(N)=0.01*ESD(I)
 85           CONTINUE

c     NS and N should be the same at this point except at ends.

              CALL SMOSP1(XA,YA,DELY,N,S,AX,BX,CX,DX,TEMP)

              WRITE (LO,334) XB(J),B(J)
 334          FORMAT (' TT, INT = ',F10.4)

86            CALL SMOSP2(XA,AX,BX,CX,DX,N,XB(J),YVAL,FDRVAL,D2)
              S2=1.0/ESD(ISAVE)**2
              B(J)=B(J)+(100.0*YVAL)*S2
              BESD(J)=BESD(J)+S2
88         CONTINUE
        GO TO 7
        ENDIF
C**************************************************************************
C       Binning operation
C**************************************************************************
        IF (INTERP.EQ.2) THEN
           DO 30 I=2,NPTS-1
              J=NINT((X(I)-TTMIN)/DLT)+1
              if (ESD(I) .GT. 0) THEN
                 S2=1.0/ESD(I)**2
                 B(J)=B(J)+A(I)*S2
                 BESD(J)=BESD(J)+S2
              ENDIF
 30        CONTINUE
        GO TO 7
        ENDIF
C**************************************************************************
    
 100    CLOSE(UNIT=IN)

        OPEN(UNIT=OUT,FILE='interp.out',STATUS='UNKNOWN')
 
        WRITE (OUT,*) 'set newx {'
        DO J=1,NP
           WRITE (OUT,*) XB(J)
        ENDDO
        WRITE (OUT,*) '}'
        WRITE (OUT,*) 'set newy {'
        DO J=1,NP
           IF (BESD(J).GT.0.0) THEN
              B(J)=B(J)/BESD(J)
           ELSE
              B(J)=0.0
           ENDIF
           WRITE (OUT,*) B(J)
        ENDDO
        WRITE (OUT,*) '}'
        WRITE (OUT,*) 'set newesd {'
        DO J=1,NP
           IF (BESD(J).GT.0.0) THEN
              BESD(J)=SQRT(1.0/BESD(J))
           ELSE
              BESD(J)=0.0
           ENDIF
           WRITE (OUT,*) BESD(J)
        ENDDO
        WRITE (OUT,*) '}'
        CLOSE (UNIT=OUT)

C       OPEN(UNIT=OUT,FILE='linterp.txt',STATUS='UNKNOWN')
C       DO J=1,NP
C       WRITE (OUT,*) XB(J),B(J),BESD(J)
C       ENDDO

        STOP
        END
 
C******************************************************************
C******************************************************************

       SUBROUTINE SMOSP1(X,Y,DELY,N,S,A,B,C,D,TEMP)
       REAL*4 X(N),Y(N),DELY(N),A(N+2),B(N+2),C(N+2),D(N+2),
     1 TEMP(8*(N+2))
        INTEGER IN,OUT,LI,LO
        COMMON/IO/ IN,OUT,LI,LO
C
C       TEMP ASSUMED TO BE AT LEAST  8*(N+2)
C
        write(LO,232) N,S
 232    format (' N and S = ',I10,F10.5)

       DO 10 I = 2,N
       IF( X(I) .GE. X(I-1) ) GO TO 10
       WRITE (LO,5) I,X(I-1),X(I)
5      FORMAT('0SMOSP1 CALLED WITH X IN NON-ASCENDING ORDER',I3,2E16.8)
       RETURN
10     CONTINUE
       DO 20 I = 1,(N+2)
        A(I)=0.0
        B(I)=0.0
        C(I)=0.0
        D(I)=0.0
C       K = (I-1)*N + 2*I-1
C       KK = K + N + 1
C        TEMP(K ) = 0
C        TEMP(KK) = 0
20     CONTINUE
        DO 22 I=1,(8*(N+2))
22      TEMP(I)=0.0
       CALL SM1SP1(X,Y,DELY,N,S,A,B,C,D,TEMP(1),TEMP(N+3),TEMP(2*N+5),
     1 TEMP(3*N+7),TEMP(4*N+9),TEMP( 5*N+11),TEMP(6*N+13),TEMP(7*N+15))
       RETURN
       END

C******************************************************************
       SUBROUTINE SM1SP1(X,Y,DYT,NOBS,S,A,B,C,D,DY,R,R1,R2,T,T1,U,V)
       REAL*4 X(NOBS),Y(NOBS),DYT(NOBS),A(NOBS+2),B(NOBS+2),
     1 C(NOBS+2),D(NOBS+2),DY(NOBS+2),R(NOBS+2),R1(NOBS+2),
     2 R2(NOBS+2),T(NOBS+2),T1(NOBS+2),U(NOBS+2),V(NOBS+2)
        REAL*4 P,E,F,G,H
c        CALL ERRSET(74,.TRUE.,.TRUE.,.FALSE.,.FALSE.,15)
       NN = NOBS
C
C       X    AND Y ARE  U AND V  ARRAYS UNTIL STATEMENT 100
C
      DO 50 I = 1,NN
      U(I+1) = X(I)
      V(I+1) = Y(I)
      DY(I+1) = DYT(I)
50    CONTINUE
      U(1) = 0
      U(NN+2) = 0
      V(1) = 0
      V(NN+2) = 0
      DY(1) = 0
      DY(NN+2) = 0
C
      N1 = 2
      N2=NOBS+1
      NM1=N1-1
      M2 = N2 - 1
      M1 = N1 + 1
      R(NM1)=0.
      R(N1) = 0.
      R1(N2) = 0.
      R2(N2) = 0.
      R2(M2) = 0.
C THE FOLLOWING STATEMENT IS NOT IN ORIGINAL CODE -- EDITING ERROR?
C      R2(N2+1) = 0.
      P = 0.
      H = U(M1) - U(N1)
      F = ( V(M1) - V(N1))/H
      DO 100 I = M1,M2
      G = H
      H = U(I+1) - U(I)
      E = F
      F = (V(I+1) - V(I))/H
      A(I) = F - E
      T(I) = 2. * (G + H) / 3.
      T1(I) = H / 3.
      R2(I) = DY(I-1) / G
      R(I) = DY(I+1) / H
 100  R1(I) = - DY(I) / G - DY(I) / H
      U(NM1)=0.
      U(N1) = 0.
      U(N2) = 0.
      U(M2) = 0.
      DO 110 I = M1,M2
      B(I) = R(I) * R(I) + R1(I) * R1(I) + R2(I) * R2(I)
      C(I) = R(I) * R1(I+1) + R1(I) * R2(I+1)
 110  D(I) = R(I) * R2(I+2)
      F2 = - S
C     ** NEXT ITERATION
 115  CONTINUE
      DO 120 I = M1,M2
      R1(I-1) = F * R(I-1)
      R2(I-2) = G * R(I-2)
      R(I) = 1. / (P*B(I) + T(I) - F* R1(I-1) - G* R2(I-2))
      U(I) = A(I) - R1(I-1) * U(I-1) -R2(I-2) * U(I-2)
      F = P * C(I) + T1(I) - H*R1(I-1)
      G = H
 120  H = D(I) * P
      DO 130 I = M2,M1,-1
      U(I) = R(I) * U(I) - R1(I) * U(I+1) - R2(I) * U(I+2)
  130 CONTINUE
      E = 0.
      H=0.
      DO 140 I = N1,M2
      G = H
      H = (U(I+1) - U(I)) / (X(I) - X(I-1))
      V(I) = (H - G) * DY(I) * DY(I)
 140  E = E + V(I) * (H - G)
      G = - H * DY(N2) * DY(N2)
      V(N2) = G
      E = E - G * H
      G = F2
      F2 = E * P * P
C       WRITE (6,999) S,F2,E,P,G
C999    FORMAT (' S,F2,E,P,G = '5F15.4)
      IF(F2 .GE. S .OR. F2 .LE. G) GO TO 160
      F = 0.
      H = (V(M1) - V(N1)) / (X(2) - X(1))
      DO 150 I = M1,M2
      G = H
      H = (V(I+1) - V(I)) / (X(I) - X(I-1))
      G = H - G - R1(I-1) * R(I-1) - R2(I-2) * R(I-2)
      F = F + G * R(I) * G
 150  R(I) = G
      H = E - P * F
      IF(H .LE. 0.) GO TO 160
C
C       someone suggest the folowing changes to be sure that the square root
C       is valid.
      if (E .le. 1.0e-36) go to 160
      if (H .le. 1.0e-36) go to 160
      if (E .le. 1.0e-15 .and. H .le. 1.0e-15) go to 160

      P = P + (S - F2) / ((SQRT(S/E) + P) * H)
      GO TO 115
C     ** FIN
 160  DO 170 I = N1,N2
      A(I) = Y(I-1) - P*V(I)
 170  C(I) = U(I)
      DO 180 I = N1,M2
      H = X(I) - X(I-1)
      D(I) = (C(I+1) - C(I)) / (3. * H)
 180  B(I) = (A(I+1) - A(I)) / H - (H * D(I) + C(I)) * H
C
c        CALL ERRSET(74,.TRUE.,.TRUE.,.FALSE.,.TRUE.,15)
      RETURN
      END

C*******************************************************************

       SUBROUTINE SMOSP2(X,A,B,C,D,N,XEVAL,YVAL,FDRVAL,SDRVAL)
       REAL*4 X(N),A(N+2),B(N+2),C(N+2),D(N+2)
       I = 1
       IF ( XEVAL  .LT. X(1)) GO TO 100
       I = N -1
       IF( XEVAL  .GE.  X(N-1)) GO TO 100
       I = 1
 40    IF(XEVAL  .GE.X(I)   .AND.  XEVAL.LE. X(I+1)) GO TO 100
       I = I+1
       GO TO 40
 100   H = XEVAL - X(I)
       I = I+1
       YVAL=((D(I)*H +C(I))*H +B(I))*H+A(I)
       FDRVAL=(3.*D(I)*H +2.*C(I))*H + B(I)
       SDRVAL= 6.*D(I)*H +2.*C(I)
       RETURN
       END
