      SUBROUTINE REDLIN(PRNTMR,PRNTLN,INDAT,INTENS,TOLKEP)
C  READS SECOND PARAMETER CARD AND THE LINE CARDS.
C-----------------------------------------------------------------------
C  .... CHANGED:  090585  13.00H      ADDED SUMMARY OUTPUT.
C  .... changed:  260493  NCRT, output.
C  .... changed:  071193  delete NCRT, output.
C  Last changed:  061293  introduction nmax, max number of lines used.
C-----------------------------------------------------------------------
      DIMENSION QIN(200),NR(5)
      LOGICAL SELF,ENL,TEST,ZERREF,REPEAT
      CHARACTER NAME*80,CARD*80,INTSY*2,INTENS*1,IBLA*1,SNAME*70
      CHARACTER IIN(200)*2,INTY(8)*2,BLANK*2,INVAL(3)*9
      COMMON /LINES / IDOC,INP,IOUT,NCRT,MAX,OBS(40),CEL(10)
      COMMON /CHARCM/ NAME,CARD,INTSY(50)
      COMMON /PARMS / TOL2,TOL3,WAVEL,FMINEQ,FMINIM,SELF,ENL,TEST,LIST,
     *                NSYST(3),OBSMT(40),OBSPT(40),TWTHET(40),TOLG
      COMMON /CONSTS/ NSUMM,RAD,TWORAD,RRAD,HLFLAM,WAVSQR,STORE(200,9)
      COMMON /HISYM / ZERREF,ISOL,SYMCON(12,6),NMATCH(45)
      DATA IBLA/' '/,BLANK/'  '/,INVAL/'D-VALUES ','Q-VALUES ',
     * 'TWOTHETAS'/
      INPFIX=INP
      SNAME=NAME
      WRITE(NSUMM,9980) SNAME
      REPEAT=.FALSE.
      ZERREF=.TRUE.
      DO 6 I=1,8
      CEL(I)=0.
    6 INTY(I)=BLANK
      DO 7 I=1,200
    7 IIN(I)=BLANK
C
C  READ SECOND PARAMETER CARD. IF NOT PRESENT,REPAIR SITUATION.
C
      CALL ECHO
      READ(CARD,9903)  ZERCOR,PRNTMR,PRNTLN, (CEL(J),J=4,8)
      L=0
      NMAX=32
      IF (ZERCOR .LT. 3.0) GO TO 9
C  MAKES REPAIRS IF THE  NEW SECOND PARAMETER CARD WAS NOT INSERTED.
      CEL(3)=PRNTLN
      CEL(2)=PRNTMR
      CEL(1)=ZERCOR
      ZERCOR=0.
      PRNTMR=4.0
      PRNTLN=14.
      ZERREF=.TRUE.
      WRITE(IOUT,9960)
      GO TO 14
C  SECOND PARAMETER CARD WAS PRESENT.
    9 IF ( PRNTMR .LT. 0.1) PRNTMR=4.0
      IF ( PRNTLN .LT. 0.1) PRNTLN=14.
      IF ( CEL(4) .GT. 0.1 ) ZERREF=.FALSE.
      IF ( CEL(5) .GT. 1.0 ) NMAX=NINT( CEL(5) )
      IF (NMAX .GT. 40) NMAX=40
C        THE ARRAYS CAN ONLY HOLD 40 LINES.
      IF (INDAT .NE. INP) INP=INDAT
C  NOTE THAT INPFIX=INP IN THE FIRST STATEMENT OF THIS ROUTINE
C  AND THAT  INP=INPFIX IN THE LAST STATEMENT.
C  INDAT IS THUS ONLY VALID  WITHIN THIS SUBROUTINE.
   10 CONTINUE
      CALL ECHO
      IF (INTENS .EQ. IBLA) THEN
         READ(CARD,9903)  (CEL(J),J=1,8)
      ELSE
         READ(CARD,9912)  (CEL(J),INTY(J),J=1,8)
      END IF
   14 U=0.0
      DO 15 I=1,8
   15 U=U+ABS(CEL(I) )
C  IT IS POSSIBLE TO GET RID OF A LINE BY SIMPLY PUNCHING A MINUS  SIGN
C  IN FRONT OF THE VALUE(PROVIDED THERE WAS ENOUGH SPACE IN THE FORMAT).
C  THIS TRICK NOW ALSO WORKS WITH ONLY ONE LINE PER CARD.
      IF (U .LT. 0.1) GO TO 30
      DO  20 I=1,8
      IF (CEL(I) .LT. 0.1) GO TO 20
      L=L+1
      QIN(L)  =CEL(I)
      IIN(L)=INTY(I)
   20 CONTINUE
      IF (L .GT. 190) L=190
C  PREVENTS OVERFLOW OF THE INPUT  ARRAYS.  NOW THERE IS NO LIMIT ON
C  THE NUMBER OF LINES THAN CAN BE READ.
      GO TO 10
C-----------------------------------------------------------------------
C--END OF READING LINES CARDS
C-----------------------------------------------------------------------
   30 L=L+1
      DO 40 I=1,8
      MAX=L-I
      IF (QIN(MAX) .GT. 0.1) GO TO 60
   40 CONTINUE
   60 WRITE(IOUT,9911)  WAVEL
      WRITE(IOUT, 9918)  MAX
      WRITE(IOUT, 9915) ( QIN(M),IIN(M) ,M=1,MAX)
      B=1.0E+4/WAVSQR
      WRITE(NSUMM,9911)  WAVEL
      WRITE(NSUMM, 9918)  MAX
      N=MAX/5
      KK=MAX-5*N
      DO 70 I=1,5
         IF (I .GT. KK) THEN
            NR(I)=KK
         ELSE
            NR(I)=I-1
         END IF
   70 CONTINUE
      DO 100 J=1,N
      WRITE(NSUMM, 9985) ( QIN(J+(I-1)*N+NR(I)),IIN(J+(I-1)*N+NR(I)),
     *  I=1,5)
  100 CONTINUE
      IF (KK .GT. 0) WRITE(NSUMM,9985) (QIN(I*N+1+NR(I)),
     *  IIN(1+I*N+NR(I) ), I=1,KK )
C-----------------------------------------------------------------------
C--WE NOW KNOW THE NUMBER OF LINES. NEXT WE TRY TO FIND OUT,
C--WHAT KIND OF VALUES WE HAVE  AND PRINT THEM OUT.
C-----------------------------------------------------------------------
      IF (MAX .GT. NMAX) MAX=NMAX
      DO 140 M=1,MAX
      OBS(M)=QIN(M)
      INTSY(M)=IIN(M)
  140 CONTINUE
      DO 160 M=1,5
      IF(OBS(M+1) .LT. OBS(M)) GO TO 195
  160 CONTINUE
C-----------------------------------------------------------------------
C--IF INPUT IS IN DESCENDING ORDER, WE HAVE  D-VALUES
C-----------------------------------------------------------------------
      ISTYG=1
      CALL SRTLIN(ISTYG)
      IF(OBS(MAX) .GE. 180.0) GO TO 190
C-----------------------------------------------------------------------
C--IF THE LAST INPUT VALUE IS GREATER THAN 180 WE DO NOT HAVE TWOTHETAS.
C-----------------------------------------------------------------------
      WRITE(IOUT,9905) INVAL(3)
      write(ncrt,9905) inval(3)
      DO 180 M=1,MAX
      W=OBS(M)+ZERCOR
      TWTHET(M)=W
      D=SIN(0.5*RRAD*W)
      OBS(M)=B*D*D
  180 CONTINUE
      WRITE(IOUT,9911)  WAVEL
      GO TO 220
  190 CONTINUE
C  INPUT IS  Q-VALUES
      WRITE(IOUT,9921)  MAX
      WRITE(IOUT,9905) INVAL(2)
      write(ncrt,9905) inval(2)
      DO 192 M=1,MAX
      TWTHET(M)=TWORAD*TETCAL(OBS(M))+ZERCOR
      IF (ABS(ZERCOR) .LT. 1.E-8) GO TO 192
      D=SIN(0.5*RRAD*TWTHET(M))
      OBS(M)=B*D*D
  192 CONTINUE
      GO TO 230
C  INPUT IS D-VALUES.
  195 ISTYG=0
      CALL SRTLIN(ISTYG)
      WRITE(IOUT,9905) INVAL(1)
      write(ncrt,9905) inval(1)
      DO 210 M=1,MAX
      SIT=0.5*WAVEL/OBS(M)
      TWTHET(M)=TWORAD*ASIN(SIT)+ZERCOR
      D=SIN(0.5*RRAD*TWTHET(M))
      OBS(M)=B*D*D
  210 CONTINUE
  220 WRITE(IOUT,9921)  MAX
C     WRITE(NCRT,9921)  MAX
      IF (ABS(ZERCOR) .GT. 1.0E-4) WRITE(IOUT,9945) ZERCOR
      WRITE(IOUT,9910)
C     WRITE(NCRT,9910)
  230 WRITE(IOUT,9916)  ( OBS(M),INTSY(M) ,M=1,MAX)
C     WRITE(NCRT,9917)  ( OBS(M),INTSY(M) ,M=1,MAX)
C---------------------------------------------------------------------
C--IF THE NUMBER OF LINES IS SMALL, A WARNING IS ISSUED.
C---------------------------------------------------------------------
      IF (MAX .GE. 30 ) THEN
         GO TO 240
      ELSE IF (MAX .LT. 20) THEN
         WRITE(IOUT, 9930) MAX
         WRITE(NCRT, 9932) MAX
         WRITE(NSUMM, 9932) MAX
         MAX=10
         GO TO 9990
      ELSE
         WRITE(IOUT,9934) MAX
         WRITE(IOUT,9931)
         GO TO 240
      END IF
  240 CONTINUE
C-----------------------------------------------------------------------
C--THE ARRAY OF Q-VALUES HAS NOW BEEN ESTABLISHED.
C-----------------------------------------------------------------------
      IF (ABS(ZERCOR) .LT. 1.E-4) GO TO 265
      IF (.NOT. TEST) GO TO 265
      WRITE(IOUT,9946) ZERCOR, (TWTHET(M),M=1,MAX), (OBS(M),M=1,MAX)
  265 CONTINUE
      IF (TEST) WRITE(IOUT,9936)
      U=0.
      DO 270 M=1,MAX
      SIT=SIN(0.5*RRAD*(TWTHET(M)+TOLG) )
      W=SIT/HLFLAM
      OBSPT(M)=W*W
      OBSMT(M)=2.*OBS(M)-OBSPT(M)
      IF (M .LE. 20) U=U+OBSPT(M)-OBSMT(M)
      IF (TEST) WRITE(IOUT,9937) OBS(M),OBSMT(M),OBSPT(M)
  270 CONTINUE
C--THE RANGE FOR MATCHING Q-VALUES HAS BEEN SET
      U=U/40.
      IF (TEST) WRITE(IOUT,9938) TOLG,U
      IF (REPEAT) GO TO 280
      Q20=OBS(20)
      N20=50
      M20=10
      DELQMX=Q20/FLOAT(2*N20*M20)
C-----------------------------------------------------------------------
C  DELQMAX IS THE MAXIMUM VALUE OF THE MEAN DELTA Q THAT IS
C  STILL CONSISTENT WITH AN ELEMENTARY CELL THAT HAS A
C  FIGURE OF MERIT THAT IS GREATER THAN 10.
C    THE MEAN TOLERATED DELTA Q IS U, CORRESPONDING TO A
C  MEAN DELTA TWO THETA OF *TOLG*
C  THE MAXIMUM TOLERABLE TOLG IS THUS (DELQMX/ U )*TOLG
C--------------------------------------------------------------------
      TOLMAX=TOLG*DELQMX/U
      WRITE(IOUT,9964)
      WRITE(IOUT,9965) TOLMAX
      IF ( ABS(TOLG-TOLKEP) .LT. 1.E-4) GO TO 280
C  IF A TOLERANCE WAS GIVEN ORIGINALLY, TOLG=TOLKEP.
C  IN THAT CASE, EVERYTHING REMAINS AS IT WAS.
C  IF NO TOLERANCE WAS GIVEN, WE SET IT AT 2*TOLMAX.
      TOLG=2.*TOLMAX
      IF (TOLG .GT. 0.06) TOLG=0.06
      TOLKEP=TOLG
      REPEAT=.TRUE.
      GO TO 265
  280 FMINEQ=OBS(20)*5.0E-4
      WRITE(NSUMM,9986) TOLG
      IF (FMINEQ .LT. 0.8)  FMINEQ=0.8
      A=8.0 *FMINEQ
      C=1.6*FMINEQ
      DO 290 M=2,MAX
      B=OBS(M)-OBS(M-1)
      IF  (B .GT. A) GO TO 290
      A=B
      IF ( B .GE. C) GO TO 290
      I=M-1
      D=RAD*WAVEL*B/( 200.0*SQRT(OBS(M)))
      WRITE(IOUT,9914) I,B,D
  290 CONTINUE
      FMINEQ=0.125*A
      IF (FMINEQ .LT. 0.5)  FMINEQ=0.5
      WRITE(IOUT,9926) FMINEQ
      FMINIM=OBS(1)/17.
      A=100./SQRT(FMINIM)
      WRITE (IOUT,9925) FMINIM,A
      IF (FMINIM  .LE. 2.0) WRITE(IOUT,9929)
 9990 INP=INPFIX
      RETURN
 9903 FORMAT( 8F10.5 )
 9905 FORMAT(/ ' THE INPUT CONSISTED OF ',A9)
 9906 FORMAT(23H THE INPUT CONSISTED OF   )
 9910 FORMAT(45H THE INPUT LEADS TO THE FOLLOWING Q-VALUES   )
 9911 FORMAT(20H THE WAVELENGTH IS  , F8.4)
 9912 FORMAT( 8(F7.3,A2,1X) )
 9914 FORMAT(40H XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX      /
     * 41H THE DIFFERENCE IN Q-VALUES BETWEEN LINE ,  I3,
     * 22H AND THE NEXT IS ONLY  , F6.2 /
     * 14H THIS IS ONLY  ,F5.2,  18H DEGREES TWO THETA     /
     * 40H            PLEASE  CHECK  YOUR  INPUT     /
     * 56H THE PROGRAM WILL CONTINUE, BUT MAY NOT GIVE THE CORRECT,
     * 59H ANSWERS SINCE THE LIMIT FOR  *EQUAL* VALUES CAN BE TOO LOW /
     * 40H XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX      )
 9915 FORMAT( 10(1X,F8.3,1X,A2,1X )  )
 9916 FORMAT( 10(1X,F7.1,2X,A2,1X )  )
 9917 FORMAT(  5(1X,F7.1,2X,A2,1X )  )
 9918 FORMAT(37H THE INPUT CONSISTED OF THE FOLLOWING,I4,7H LINES   )
 9921 FORMAT(41H THE NUMBER OF LINES THAT WILL BE USED IS ,I4)
 9925 FORMAT(44H THE LOWER LIMIT FOR THE VALUES OF A,B,C IS ,  F8.2/
     * 40H THE MAXIMUM EDGE OF THE UNIT CELL IS    ,F6.1,10H ANGSTROM )
 9926 FORMAT(67H Q-VALUES WILL BE CONSIDERED TO BE EQUAL WHEN THEY DIFFE
     *R LESS THAN , F4.1 )
 9929 FORMAT(50H FROM YOUR DATA ONE EXPECTS A VERY LARGE UNIT CELL,
     1       50H.  THIS REQUIRES AN ACCURACY THAT IS BETTER THAN  /
     2       50H 0.005 DEGREES TWO THETA IN YOUR OBSERVATIONS.    /
     4       50H     READ THE PAPER BY P.E.WERNER IN J.APPL.CRYST.,
     5       50H(1976) 9, P.216.                                  /
     6       50H THE PROGRAM CANNOT HANDLE THIS CASE WITHOUT SOME ,
     7       50HMODIFICATION. THIS PROBLEM IS SKIPPED.            )
 9930 FORMAT(32H THE NUMBER OF USEFUL LINES  IS ,I4 /
     *60H SINCE THIS IS LESS THAN THE MINIMUM NUMBER OF LINES THAT TH ,
     *60HE PROGRAM NEEDS (20),YOU CANNOT EXPECT RELIABLE  RESULTS.   /
     *24H THIS PROBLEM IS SKIPPED  //
     4 ' IF THIS IS REALLY THE MAXIMUM NUMBER OF LINES THAT CAN' ,
     5 ' BE MEASURED,' / ' THE PROBLEM CAN ONLY BE SOLVED WHEN THE ',
     6 'LATTICE HAS AT LEAST ORTHORHOMBIC SYMMETRY.' /
     7 ' THERE ARE MANY PROGRAMS THAT ARE MUCH BETTER SUITED TO THOSE',
     8 ' SYMMETRIES.'  )
 9931 FORMAT('   THE NUMBER OF LINES ENTERED FOR THIS PROBLEM IS RATHER
     1SMALL.'/' WITH ONLY 20 LINES YOUR CHANCES ARE 50:50 THAT YOU ',
     2 'WILL FIND A SUBLATTICE' /' OR A DERIVED LATTICE.  WITH 40 LINES
     3 YOUR CHANCES OF FINDING THE CORRECT' / ' LATTICE IMMEDIATELY',
     4 ' ARE MUCH BETTER.  PLEASE ENTER MORE LINES IF POSSIBLE.' /
     5 ' READ THE PAPER BY A.D. MIGHELL AND J.K. STALICK ON: ',
     6 'THE RELIABILITY OF POWDER INDEXING PROCEDURES,'/
     7 ' PAG. 393-403 IN: ACCURACY IN POWDER DIFFRACTION,(1979)',
     8 ' SEE BIBLIOGRAPHY.' )
 9932 FORMAT(// ' THE NUMBER OF LINES IS ONLY ',I3,//
     * ' THIS PROBLEM IS SKIPPED' /  7('**********') )
 9934 FORMAT(1H ,41X,8(1H*)/41X,10(1H*) /
     * 40X,'****    ****'   ,/ 39X,'***  THE   ***'/,38X,'***  ',
     1 'NUMBER',2X,3(1H*)/37X,'***  OF LINES  ***',/ 36X,
     2 '***  ENTERED IS  ***'/35X,'***    ONLY ',I2,'     ***'/
     3 34X,'***  THIS MEANS THAT ***'/33X,'***  YOU MAY FIND A    ***'/
     4 32X,'***  LATTICE THAT IS A   ***'/
     5 31X,'***  SUBLATTICE OR SOME    ***'/
     6 30X,'***  SUPERLATTICE OR OTHER   ***'/
     7 29X,'***    DERIVATIVE LATTICE.     ***'/ 28X,36(1H*)/
     8 27X, 38(1H*)/ 26X,40(1H*)  )
 9936 FORMAT(63H THE Q-VALUES WITH THEIR LIMITS OF ERROR,Q +/- TOLERANCE
     1 (TOLG)/ 32H       Q        Q-TOL     Q+TOL    )
 9937 FORMAT(1H ,3F10.1)
 9938 FORMAT(20H WITH A TOLERANCE OF, F6.3,18H DEGREES TWOTHETA,   ,
     2 25H THE MEAN DELTA Q BECOMES, F7.2)
 9945 FORMAT(21H A ZERO CORRECTION OF   , F6.3,
     1       44H  DEGREES TWOTHETA WAS APPLIED TO ALL LINES   )
 9946 FORMAT(56H TWOTHETAS AND Q S AFTER APPLYING A ZERO CORRECTION OF
     2  , F10.4/ 4(1H ,10F12.2/)  // 4(1H ,10F12.1/)  )
C9950 FORMAT(   ///80(1H*)/2H *,78X,1H*/2H *,5X,16HTHE MAXIMUM MEAN
C    2 22H ERROR IN YOUR DATA IS, F6.3,18H DEGREES TWO THETA, 11X,
C    3 1H*/2H *,78X,1H*/1H ,80(1H*) )
 9960 FORMAT(50H *************************************************/
     2       50H *    YOU FORGOT TO INSERT THE 2ND PARAMETER CARD*/
     3       50H *THE PROGRAM TOOK DEFAULT VALUES FOR  ZERCOR    */
     4       50H * AND PRNTMR     AND  CONTINUES.......          */
     5       50H *************************************************)
 9964 FORMAT(48H THIS PROGRAM CALCULATES A NUMBER OF UNIT CELLS.
     1 /     51H THESE CELLS ARE ALL TESTED BY DE WOLFF'S CRITERION,
     2        8H (READ:   /
     3       50H A SIMPLIFIED CRITERION FOR THE RELIABILITY OF A  ,
     4       50HPOWDER PATTERN INDEXING, BY P.M. DE WOLFF ,       /
     5       50H JOURNAL APPLIED CRYSTALLOGRAPHY (1968) 1, 108  )./
     6       50H IN ORDER THAT THE UNIT CELL BE ABLE TO PASS THE  ,
     7       50HTEST (M20 .GT. 10), AND ASSUMING THAT YOU DID NOT /
     8       50H MISS TOO MANY LINES (N20=50), THE CRITERION DEMAN,
     9       50HDS THAT THE MEAN ERROR IN YOUR DATA IS            )
 9965 FORMAT(1H ,20X,50(1H*)/1H ,20X,14H*   LESS THAN , F8.3,5X,
     1       17HDEGREES TWO THETA,5X,1H* / 1H ,20X,50(1H*) )
 9980 FORMAT(/' PROGRAM TO FIND THE UNIT CELL OF' //1H , A70//
     1       ' VERSION 15 '/ )
 9985 FORMAT( 5(1X,F8.3,1X,A2,1X) )
 9986 FORMAT(' TOLG, THE TOLERANCE ON TWOTHETA IS', F6.3)
      END
      SUBROUTINE REFINE(IREFCY,ALL,DRUK,PRIN,LIST2)
C-----------------------------------------------------------------------
C
C  CHANGED TO CONFORM WITH FORTRAN 77.  SEPT. 83
C
C  CHANGED TO REFINE DELTA THETA  INSTEAD OF DELTA Q.SEPT. 83
C
C  REFINES CELL CONSTANTS + ZERO SHIFT.  OCT.  83
C  CHOICE POSSIBLE TO REFINE WITH/WITHOUT ZERO SHIFT (JULY 87)
C-----------------------------------------------------------------------
C  CHANGED:  140585,  CHANGED /HISYM / FOR OUTPUT SUMMARY.
C  CHANGED:  151085,  CHANGED FORMATS  FOR OUTPUT SUMMARY.
C  CHANGED:  200787,  REFINE WITH/WITHOUT ZERO SHIFT.
C  CHANGED:  110593,  ADDED NCRT + OUTPUT, ZERREF
C  CHANGED:  071193,  DELETED NCRT - OUTPUT
C-----------------------------------------------------------------------
C
C--REFPAR REFINES  THE PARAMETERS, PRINTS OUT THE LATTICE IF PRIN=.TRUE.
C--AND PRINTS OUT A LIST OF   TWOTHETA,D,Q,H,K,L.
C  IN THE FIRST CALLS OF REFINE, ALL PARAMETERS ARE .FALSE.
C  THE CELL CONSTANTS ARE THEN 'SILENTLY' REFINED.
C  AT THE END, THE BRAVAIS TYPE IS ESTABLISHED.
C  IN THE FOLLOWING CALLS, THE BOOLEANS DO THE FOLLOWING
C  PRIN  COMMANDS THE PRINTING OF A Q-SCHEME
C  DRUK  PRINTS THE TWOTHETA-HKL-Q LISTS
C  LIST2 PRINTS A LIST OF THE OBSERVED AND ALL CALCULATED LINES
C  ALL  TRIES TO INDEX ALL GIVEN LINES(<41).
C-----------------------------------------------------------------------
      DIMENSION HULP(8),VAR(8),FYN(8),WE(10),WAR(8),
     1 MATR1(8),MATR2(8),REF(8,8)
      DIMENSION KSTOR(40,5),LSTOR(40,5),QSTOR(40,5),IBR(41,5)
      INTEGER HSTOR(40,5)
      INTEGER P,  H,H1,HS,HMIN,HMAX,HMAX1,COUNT,ORDE,ORP1
      LOGICAL SELF,ENL,TEST,ALL,DUBL,ZERREF
      LOGICAL HEVEN,KEVEN,LEVEN,MIS,DRUK,PRIN,LIST2
      CHARACTER NAME*80,CARD*80,INTSY*2
      COMMON /LINES / IDOC,INP,IOUT,NCRT,MAX,OBS(40),CEL(10)
      COMMON /CHARCM/ NAME,CARD,INTSY(50)
      COMMON /PARMS / TOL2,TOL3,WAVEL,FMINEQ,FMINIM,SELF,ENL,TEST,LIST,
     *                NSYST(3),OBSMT(40),OBSPT(40),TWTHET(40),TOLG
      COMMON /LINSTR/ NMAX,NCALC,N20,NOTIND,INSTOR(200,3),QQSTOR(200)
      COMMON /CONSTS/ NSUMM,RAD,TWORAD,RRAD,HLFLAM,WAVSQR,STORE(200,9)
      COMMON /THETAS/ ZERTOT,OBSTET(40),SHFTET(40),TETPT(40),TETMT(40)
      COMMON /HISYM / ZERREF,ISOL,SYMCON(12,6),NMATCH(45)
      EQUIVALENCE (INSTOR(1,1),HSTOR(1,1)),(INSTOR(1,2),KSTOR(1,1)),
     1  (INSTOR(1,3),LSTOR(1,1)),(QQSTOR(1),QSTOR(1,1) )
C-----------------------------------------------------------------------
      DO 20 M=1,MAX
   20 SHFTET(M)=OBSTET(M)-ZERTOT
      IF (TEST) WRITE(IOUT,9904) CEL
C     WRITE(NCRT,9905) CEL
      IBRAV=NINT( CEL(9) )
      NMAX=20
      IF (ALL)  NMAX=MAX
      J20=20
      Q20=OBSPT(20)
      QMAX=OBSPT(NMAX)+1.
      IF (TEST) WRITE(IOUT,9923)
C  BEGIN OF  THE REFINEMENT CYCLES.
C
      DO 1250 NREFCY=1,IREFCY
C  FIRST, WE DETERMINE THE NUMBER OF PARAMETERS TO BE REFINED (ORDE),
C  ORDE IS THE ORDER OF THE MATRIX.
      ORDE=3
      DO 110 J=4,6
      IF (ABS(CEL(J)) .GT. FMINEQ) THEN
         ORDE=ORDE+1
      ELSE
         CEL(J)=.0
      END IF
  110 CONTINUE
      ORP1=ORDE+1
C  SET THE BRAVAIS-ARRAY TO ZERO
      DO 211 I=1,41
      DO 210 J=1,5
  210 IBR(I,J)=0
      IF (.NOT. LIST2) NMATCH(I)=0
  211 CONTINUE
C  SET UP THE (ENLARGED) TOLERANCES
      TOLRAD=0.5*TOLG*RRAD
      TOL=(IREFCY-NREFCY+1)*TOLRAD
      DO 220 I=1,NMAX
      TETPT(I)=SHFTET(I)+TOL
      TETMT(I)=SHFTET(I)-TOL
  220 CONTINUE
C
C                 START GENERATING  Q-VALUES
C
      NCALC=0
      N20=0
      ISPAT=1
C  THE ZERO CORRECTION DEPENDS ON 'ZERREF'
      IF ( .NOT. ZERREF ) ORP1=ORDE
      HMAX=INT(SQRT(QMAX/CEL(1)))+1
      KMAX=INT(SQRT(QMAX/CEL(2)))+1
      LMAX=INT(SQRT(QMAX/CEL(3)))+1
      KEVEN=.FALSE.
      LMIN=-LMAX
      IF(ORDE .EQ. 3) LMIN=0
      HMIN=0
      IF(ORDE .GE. 5) HMIN=-HMAX
      IF (PRIN) WRITE(IOUT,9917)
      KMAX1=KMAX+1
C  K-LOOP STARTS HERE
      DO 1050 K1=1,KMAX1
      K=K1-1
      RK=K
      IF(PRIN) THEN
         WRITE(IOUT,9918)  K
         ISPAT=1
      END IF
      C1=RK*RK*CEL(2)
      C2=RK*CEL(4)
      C3=RK*CEL(6)
      KEVEN=.NOT. KEVEN
      HS=HMIN
      IF(K .EQ.  0) HS=0
      HEVEN=.TRUE.
      IF(2*(HS/2) .EQ. HS) HEVEN=.FALSE.
      HMAX1=HMAX-HS+1
C  H-LOOP STARTS HERE
      DO 1040 H1=1,HMAX1
      H=H1+HS-1
      RH=H
      C4=C1+RH*(C3+RH*CEL(1))
      C5=C2+RH*CEL(5)
      IF (PRIN) THEN
         WRITE(IOUT,9923)
         ISPAT=1
         IF((K+IABS(H)) .EQ. 0 .AND. ORDE .GT. 4) ISPAT=ISPAT+LMAX
         IF(ORDE .EQ. 4 . AND. H .EQ. 0) ISPAT=ISPAT+LMAX
      END IF
      HEVEN=.NOT. HEVEN
      LB=LMIN
      IF (H .EQ. 0) THEN
         IF(K .EQ. 0.OR. ORDE .EQ. 4) LB=0
      END IF
      LEVEN=.TRUE.
      IF(2*(LB/2) .EQ. LB) LEVEN=.FALSE.
      LMAX1=LMAX+1-LB
C  L-LOOP STARTS HERE
      DO 1030 L1=1,LMAX1
      L=L1-1+LB
      LEVEN=.NOT. LEVEN
      Q=C4+FLOAT(L)*(C5+FLOAT(L)*CEL(3))
      IF (Q .LT. 1.0) THEN
         IF (PRIN) CALL WRISP(ISPAT,0. ,0)
         GO TO 1020
      END IF
      IF(Q .GE. QMAX) GO TO 1020
      THET=TETCAL(Q)+ZERTOT
      Q=SIN(THET)/HLFLAM
      Q=Q*Q
      IF (CEL(7) .LT. 1.) GO TO 700
      GO TO (640,650,660,670,680,700,950),IBRAV
C REPRESENTING A, B , C , I , F , P    LATTICES
  640 IF(KEVEN .EQV. LEVEN) GO TO 700
      GO TO 1020
  650 IF(HEVEN .EQV. LEVEN) GO TO 700
      GO TO 1020
  660 IF(HEVEN .EQV. KEVEN) GO TO 700
      GO TO 1020
  670 IF (2*((H+K+L)/2) .EQ. H+K+L) GO TO 700
      GO TO 1020
  680 IF ((HEVEN .EQV. KEVEN) .AND. (KEVEN .EQV. LEVEN)) GO TO 700
      GO TO 1020
  700 IF (Q .LT. Q20) N20=N20+1
      NCALC=NCALC+1
      IF (LIST2) THEN
         INSTOR(NCALC,1)=H
         INSTOR(NCALC,2)=K
         INSTOR(NCALC,3)=L
         QQSTOR(NCALC)=Q
         GO TO 1030
      END IF
      IF (PRIN) CALL WRISP(ISPAT,Q,0)
      THET=TETCAL(Q)
      MIS=.TRUE.
      NRINDX=0
      DO 800 J=1,NMAX
      IF (TETPT(J) .LT. THET ) GO TO 800
      IF (TETMT(J) .GT. THET ) GO TO 950
      NRINDX=NRINDX+1
C  COUNTS THE NUMBER OF TIMES THAT ONE H,K,L-COMBINATION IS USED.
      P=J
      IF (PRIN) THEN
         CALL WRISP(ISPAT,Q,1)
         MIS=.FALSE.
      END IF
      IF (CEL(7) .GT. .9) GO TO 780
      IF (KEVEN .EQV. LEVEN) IBR(P,1)=IBR(P,1)+1
      IF (HEVEN .EQV. LEVEN) IBR(P,2)=IBR(P,2)+1
      IF (HEVEN .EQV. KEVEN) IBR(P,3)=IBR(P,3)+1
      IF (2*((H+K+L)/2) .EQ. H+K+L) IBR(P,4)=IBR(P,4)+1
      IF ((HEVEN.EQV.KEVEN).AND.(KEVEN.EQV.LEVEN)) IBR(P,5)=IBR(P,5)+1
C     PRINT *, H,K,L,Q, TWORAD*THET, (IBR(P,I),I=1,5)
  780 I=NMATCH(P)+1
      IF (I .GT.  5) GO TO 800
      NMATCH(P)=I
      IF (NRINDX .GE. 2) L=L+1000
C  IF A SET OFH,K,L'S IS USED MORE THAN ONCE, IT IS MARKED.
      HSTOR(P,I)=H
      KSTOR(P,I)=K
      LSTOR(P,I)=L
      QSTOR(P,I)=Q
  800 CONTINUE
  950 CONTINUE
 1020 IF (PRIN) ISPAT=ISPAT+1
C  END OF K,H,L-LOOP ON 1050,1040,1030 RESPECTIVELY
 1030 CONTINUE
      IF (PRIN) CALL WRISP(ISPAT,Q,2)
 1040 CONTINUE
 1050 CONTINUE
C
C             END GENERATING Q
C
      IF (LIST2) THEN
         CALL LISTM
         RETURN
      END IF
      DO 1110 H=1,8
      DO 1105 K=1,8
 1105 REF(H,K)=0.0
 1110 CONTINUE
      DO 1120 H=1,8
      FYN(H)=0.0
      WAR(H)=0.0
 1120 CONTINUE
      T=0.0
      RMS=0.0
      SUMEPS=1.E-3
C  WHEN THE NUMBER OF LINES INDEXED  EQUALS THE NUMBER OF PARAMETERS,
C  SUMEPS WILL REMAIN AT ITS STARTING VALUE.  THE VALUE *ZERO*
C  CAUSES ACCIDENTS.
      COUNT=0
      IF (DRUK)  WRITE(IOUT,9910)
      DO 1180 P=1,NMAX
      NR=NMATCH(P)
      W=SIN(SHFTET(P))/HLFLAM
      QOBS=W*W
      IF (DRUK) THEN
         D=100./W
         U=TWORAD*SHFTET(P)
         IF (NR .EQ. 0) THEN
            WRITE(IOUT,9911) U,D,QOBS,INTSY(P)
         ELSE
            WRITE(IOUT,9912) U,D,QOBS,INTSY(P)
         END IF
      END IF
      IF (NR .EQ. 0) GO TO 1180
      EPS=1000.0
      SUMW=0.0
      DO 1130 N=1,NR
         D=ABS(QOBS-QSTOR(P,N))
         IF(D .LT. EPS)EPS=D
         IF (D .GT. 9.0) D=9.0
C--NECESSARY TO PREVENT UNDERFLOW ON  PDP-10 (AND UNIVAC?)
         W=EXP(-D*D)
         WE(N)=W
         SUMW=SUMW+W
 1130 CONTINUE
      IF (P .LE. J20) SUMEPS=SUMEPS+EPS
      DO 1170 N=1,NR
         DUBL=.FALSE.
         H=HSTOR(P,N)
         K=KSTOR(P,N)
         L=LSTOR(P,N)
         Q=QSTOR(P,N)
         TETC=TETCAL(Q)
         IF (L .GT. 900) THEN
            L=L-1000
            DUBL=.TRUE.
         END IF
C  FLAG DOUBLE USAGE OF 1 SET OF HKL
         IF (DRUK) THEN
            D=100./SQRT(Q)
            U=TWORAD*TETC
            IF (DUBL) THEN
               WRITE(IOUT,9914) U,D,Q,H,K,L
            ELSE
               WRITE(IOUT,9915) U,D,Q,H,K,L
            END IF
         END IF
         DIF=SHFTET(P)-TETC
         COUNT=COUNT+1
         W=WE(N)/SUMW
         RMS=RMS+W*DIF*DIF
         T=T+W
         C=WAVSQR/SIN(2.*TETC)
         VAR(1)=H*H*C
         VAR(2)=K*K*C
         VAR(3)=L*L*C
         VAR(4)=H*L*C
         VAR(5)=K*L*C
         VAR(6)=H*K*C
         IF ( ZERREF )  VAR(ORP1)=1.
         DO 1150 J=1,ORP1
            HULP(J)=W*VAR(J)
            WAR(J)=WAR(J)+W*DIF*VAR(J)
 1150    CONTINUE
         DO 1160 J=1,ORP1
            DO 1155 I=1,ORP1
 1155       REF(I,J)=REF(I,J)+VAR(I)*HULP(J)
 1160    CONTINUE
 1170 CONTINUE
 1180 CONTINUE
      CALL ARRAY(2,ORP1,ORP1,8,8,REF,REF)
      CALL MINV(REF,ORP1,DETER,MATR1,MATR2)
      CALL ARRAY(1,ORP1,ORP1,8,8,REF,REF)
      IF (ABS(DETER) .LT. 1.E-30) THEN
         IF (TEST) WRITE(IOUT,9931)
         GO TO 1250
      END IF
      IF (T .GT. FLOAT(ORP1+1)) RMS=RMS/(T-FLOAT(ORP1))
      DO 1195 I=1,ORP1
         DO 1190 J=1,ORP1
 1190    FYN(I)=FYN(I)+REF(I,J)*WAR(J)
 1195 CONTINUE
      DO 1200 N=1,ORDE
 1200 FYN(N)=1.E+4*FYN(N)
      DO 1210 N=1,3
 1210 CEL(N)=CEL(N)+FYN(N)
      IF (ORDE .GT. 3) CEL(5)=CEL(5)+FYN(4)
      IF (ORDE .GT. 4) CEL(4)=CEL(4)+FYN(5)
      IF (ORDE .GT. 5) CEL(6)=CEL(6)+FYN(6)
      IF ( ZERREF ) THEN
         ZERSHF=FYN(ORP1)
         ZERTOT=ZERTOT+ZERSHF
         IF (TEST) WRITE(IOUT,9925) TWORAD*ZERSHF,CEL
      END IF
      DO 1240 M=1,MAX
 1240 SHFTET(M)=SHFTET(M)-ZERSHF
C
C
 1250 CONTINUE
      IF (DRUK  .AND. ZERREF) THEN
         WRITE(IOUT ,9927) -TWORAD*ZERTOT
         WRITE(NSUMM,9927) -TWORAD*ZERTOT
C        WRITE(NCRT ,9925) -TWORAD*ZERTOT, CEL
      END IF
C  END OF REFINEMENT CYCLE
C-----------------------------------------------------------------------
C
C  NOW DETERMINE BRAVAIS TYPE AND FIGURE OF MERIT
C
      N=0
      DO 1215 I=1,NMAX
      IF (NMATCH(I) .GE. 1) N=N+1
      J20=I
      IF (N .EQ. 20) GO TO 1220
 1215 CONTINUE
C  N=NUMBER OF INDEXED LINES,  J20 IS THE NUMBER OF EXAMINED LINES,
C  IN ORDER TO FIND 20 INDEXED LINES.
 1220 NOTIND=J20-N
      INDEXD=N
C  DETERMINE THE BRAVAIS TYPE ONLY AT THE FIRST CALL OF REFPAR
      IF (CEL(7) .GT. 0.9) GO TO 1350
C
      DO 1320 J=1,5
      N=0
      DO 1310 M=1,20
 1310 IF (IBR(M,J) .GT. 0 ) N=N+1
      IBR(21,J)=N
 1320 CONTINUE
      IBRAV=6
      DO 1330 J=1,5
      IF ( IBR(21,J) .GE. INDEXD) IBRAV=J
 1330 CONTINUE
      CEL(9)=IBRAV
C-----------------------------------------------------------------------
C
 1350 CEL(7)=INDEXD
      CEL(8)=FLOAT(INDEXD)*OBS(J20)/(FLOAT(2*N20)*SUMEPS)
      IF (TEST) WRITE(IOUT,9926) CEL
C     WRITE(NCRT,9925)  -TWORAD*ZERTOT,CEL
      RETURN
 9904 FORMAT(2X/' AT ENTERING REFINE, CEL= ',6F10.3,4F8.2 )
 9905 FORMAT(/' AT ENTERING REFINE, CEL= ',/ 6F8.1,4F5.0 )
 9910 FORMAT(2X/41H TWOTHETA     D       Q       H    K    L)
 9911 FORMAT(2X/1H , F8.2, F8.3, F9.1, 18H    *OBSERVED**    ,A2,
     *       '  NOT INDEXED' )
 9912 FORMAT(2X/1H , F8.2, F8.3, F9.1, 18H    *OBSERVED**    ,A2)
 9914 FORMAT(1H ,F8.2,F8.3,F9.1, 3I5,
     *      '   HKL-COMBINATION WAS USED BEFORE' )
 9915 FORMAT(1H ,F8.2,F8.3,F9.1, 3I5)
 9917 FORMAT(36H LATTICE PRINTED OUT FOR INSPECTION //
     1 56H DISPLAYED IN LAYERS UP --K-- ,    --L-- ACROSS THE PAGE,
     2 22H --H-- DOWN THE PAGE.   //)
 9918 FORMAT( 8H ***  H ,I2,8H  L  ***   // )
 9923 FORMAT(2X / 2X)
 9925 FORMAT(1H ,'ZEROSHIFT IS',F10.4,' CELL IS NOW:'/ 6F9.2,4F5.0)
 9926 FORMAT(1H ,' AT END OF SUBROUTINE REFINE, CEL =  '/
     *           6F9.2, F9.0,F9.1, 2F9.0 )
 9927 FORMAT(2X/' ZEROSHIFT IS ',F10.4,'  DEGREES TWOTHETA')
 9931 FORMAT(1H ,14X,19HMATRIX IS SINGULAR )
      END
      SUBROUTINE REFPAR(NSOL,ALL)
C  REFPAR TAKES CARE THAT THE CELL PARAMETERS ARE REFINED.
C  THE COMPUTING PART IS DONE IN *REFINE*, BUT THE
C  STEERING PARAMETERS ARE ESTABLISHED HERE.
C---------------------------------------------------------------
C  CHANGED:  250386  ADDED NSUMM, OUTPUT 9942
C  CHANGED:  080486  ADDED NSUMM, OUTPUT 9910 + 9912
C  CHANGED:  260493  ADDED NCRT + OUTPUT
C  CHANGED:  071193  DELETED NCRT - OUTPUT.
C---------------------------------------------------------------
      LOGICAL SELF,ENL,TEST,ALL,DRUK,PRIN,LIST2,ZERREF
      CHARACTER NAME*80,CARD*80,INTSY*2
      COMMON /LINES / IDOC,INP,IOUT,NCRT,MAX,OBS(40),CEL(10)
      COMMON /CHARCM/ NAME,CARD,INTSY(50)
      COMMON /CONSTS/ NSUMM,RAD,TWORAD,RRAD,HLFLAM,WAVSQR,STORE(200,9)
      COMMON /PARMS / TOL2,TOL3,WAVEL,FMINEQ,FMINIM,SELF,ENL,TEST,LIST,
     *                NSYST(3),OBSMT(40),OBSPT(40),TWTHET(40),TOLG
      COMMON /LINSTR/ NMAX,NCALC,N20,NOTIND,INSTOR(200,3),QQSTOR(200)
      COMMON /HISYM / ZERREF,ISOL,SYMCON(12,6),NMATCH(45)
C-----------------------------------------------------------------------
      DRUK =.FALSE.
      PRIN =.FALSE.
      LIST2=.FALSE.
C  THE THREE PLACES IN THE MAIN PROGRAM WHERE REFPAR IS CALLED
C  CAN BE DISTINGUISHED BY THE BEHAVIOUR OF CEL(7) AND  ALL.
C  THE FIRST TIME,  CEL(7)=0., ALL=.FALSE.
C  THE SECOND TIME, CEL(7)>0 AND  ALL=.FALSE.  THE LAST TIME ALL=.TRUE.
C
      IF (CEL(7) .GT. 1.0) GO TO 1000
      IREFCY=5
      CALL REFINE(IREFCY,ALL,DRUK,PRIN,LIST2)
      RETURN
C
C
 1000 IF (ALL) GO TO 2000
      IREFCY=2
      CALL REFINE(IREFCY,ALL,DRUK,PRIN,LIST2)
      IF (TEST) PRIN=.TRUE.
      DRUK=.TRUE.
      WRITE(IOUT,9916) NAME,NSOL
      WRITE(IOUT,9926) CEL
      CALL REFINE(IREFCY,ALL,DRUK,PRIN,LIST2)
      WRITE(IOUT,9941) CEL,NAME,NSOL
      IF (NSOL .GT. LIST) GO TO 1100
      IF (N20 .GT. 100) THEN
         WRITE(IOUT,9942) N20
         WRITE(NSUMM,9942) N20
         GO TO 1100
      END IF
      LIST2=.TRUE.
      PRIN=.FALSE.
      CALL REFINE(IREFCY,ALL,DRUK,PRIN,LIST2)
      WRITE(IOUT,9941) CEL,NAME,NSOL
 1100 RETURN
C
C
 2000 WRITE(IOUT,9902) NAME
      IREFCY=3
      CALL REFINE(IREFCY,ALL,DRUK,PRIN,LIST2)
      WRITE(IOUT,9943) CEL(8),NOTIND,N20,NCALC
      DRUK=.TRUE.
      IF (NCALC .LE. 4*NMAX) THEN
         LIST2=.TRUE.
      ELSE
         WRITE(NSUMM,9910) NCALC
      END IF
      CALL REFINE(IREFCY,ALL,DRUK,PRIN,LIST2)
      WRITE(NSUMM,9912) NOTIND
      RETURN
 9902 FORMAT(///,20X,A80 / 40(3H---)/
     *       50H THE BEST SOLUTION IS NOW USED TO TRY AND INDEX AL,
     *        9HL LINES.  )
 9910 FORMAT(/,' THE NUMBER OF CALCULATED LINES IS ',I3 /
     *  ' NO LISTING IS PRINTED IF THIS NUMBER IS GREATER THAN'/
     *  ' 4 * THE NUMBER OF OBSERVED LINES. ')
 9912 FORMAT(/,' THERE ARE ',I2,' UNINDEXED LINES AMONGST THE',
     *  ' FIRST 20 INDEXED LINES. ')
 9916 FORMAT(///,10X,A80,20X,'SOLUTION NR',I3/ 40(3H---) )
 9926 FORMAT(1H ,6F9.2, F9.0,F9.1, 2F9.0 )
 9941 FORMAT(   //46H RECIPROCAL LATTICE CONSTANTS AFTER REFINEMENT/
     1 1H ,6F9.2/14H LINES INDEXED,F4.0,18H   FIGURE OF MERIT,F5.1,
     2 16H    LATTICE TYPE,F4.0, 12H    PEDIGREE,F5.0 /
     3 1H ,A80,14H   SOLUTION NR, I3)
 9942 FORMAT(/ ' THE NUMBER OF CALCULATED LINES (N20) IS ',I4,/
     *   ' NO LISTING IS PRINTED WHEN N20 IS MORE THAN 100 ' )
 9943 FORMAT(50H TWO CYCLES OF REFINEMENT WITH ALL LINES HAVE BEEN,
     1       50H CARRIED OUT.                                     /
     2       25H THE FIGURE OF MERIT IS  , F7.1 /
     3       50H THE NUMBER OF UNINDEXED LINES AMONG THE FIRST 20 ,
     4       18H INDEXED LINES IS ,I3,4H=X20  /
     5       50H THE NUMBER OF LINES CALCULATED UP TO THE 20ST. IN,
     6       15HDEXED LINE IS  , I3 ,4H=N20  /
     7       42H THE TOTAL NUMBER OF LINES CALCULATED IS  , I4   )
      END
      SUBROUTINE REFSYM
C-----------------------------------------------------------------------
C  REFINES THE PARAMETERS (QX,QZ) BY LEAST-SQUARES,
C-----------------------------------------------------------------------
C          .... CHANGED:  210585  OUTPUT FOR NSUMM
C          .... CHANGED:  151085  REFINEMENT OF CUBIC,HEX,TETR.
C          LAST CHANGED:  071193  NCRT-OUTPUT DELETED.
C-----------------------------------------------------------------------
      DIMENSION REF(4,4),VAR(6),FYN(4),DIFR(4),MATR1(4),MATR2(4),TEMP(4)
      INTEGER  H,HG, ORDE,ORP1
      LOGICAL SELF,ENL,TEST,TYP,ZERREF
      CHARACTER NAME*80,CARD*80,INTSY*2
      COMMON /LINES / IDOC,INP,IOUT,NCRT,MAX,OBS(40),CEL(10)
      COMMON /CHARCM/ NAME,CARD,INTSY(50)
      COMMON /PARMS / TOL2,TOL3,WAVEL,FMINEQ,FMINIM,SELF,ENL,TEST,LIST,
     *                NSYST(3),OBSMT(40),OBSPT(40),TWTHET(40),TOLG
      COMMON /TEMRES/ LINCO,NQ2,NINDEX,INDEX(40),ROSTER(150,12)
      COMMON /LINSTR/ NMAX,NCALC,N20,NOTIND,INSTOR(200,3),QSTOR(200)
      COMMON /CONSTS/ NSUMM,RAD,TWORAD,RRAD,HLFLAM,WAVSQR,STORE(200,9)
      COMMON /THETAS/ ZERTOT,OBSTET(40),SHFTET(40),TETPT(40),TETMT(40)
      COMMON /HISYM / ZERREF,ISOL,SYMCON(12,6),NMATCH(45)
      TYP=.FALSE.
      NMAX=MAX
      QMAX=OBSPT(MAX)+10.
      QX=SYMCON(ISOL,1)
      QZ=SYMCON(ISOL,2)
      NSYM=NINT( SYMCON(ISOL,3) )
      ZERTOT=0.0
      IF (ZERREF) ZERTOT=ROSTER(ISOL,11)
C
C  LATTICE IS:  CUBIC  TETRAGONAL RHOMBOHEDRAL  HEXAGONAL
C  NSYM =         3         4          5            6
C
      HG=NINT( SQRT(QMAX/QX) )
      IF (NSYM .EQ. 3) THEN
         LG=HG
         QZ=QX
      ELSE
         LG=NINT( SQRT(QMAX/QZ) )
      END IF
      LMAX=LG
      LSTEP=1
      IF (NSYM .EQ. 5) THEN
         LMAX=(LG+2)/3
         LMAX=3*LMAX
         LSTEP=3
      END IF
      ZERSHF=0.0
      TOLR=0.5*RRAD*TOLG
C  THE THETA- VALUES ARE STORED AS THETA AND IN RADIANS.
      DO 1000 NCYCLE=1,5
      NCALC=0
      DO 20 H=1,4
         FYN(H)=0.
         DIFR(H)=0.
         DO 10 K=1,4
   10       REF(H,K)=0.
   20 CONTINUE
      DO 30 J=1,40
         NMATCH(J)=0
   30 INDEX(J)=0
      F=1.+(5-NCYCLE)/2.0
      TOL=F*TOLR
      DO 40 M=1,MAX
         SHFTET(M)=OBSTET(M)-ZERTOT
         TETPT(M)=SHFTET(M)+TOL
         TETMT(M)=SHFTET(M)-TOL
   40 CONTINUE
      ORDE=2
      IF (NSYM .EQ. 3) ORDE=1
      ORP1=ORDE+1
      IF ( .NOT. ZERREF ) ORP1=ORDE
      KHMIX=1
      IF (NSYM .LT. 5) KHMIX=0
C-----------------------------------------------------------------------
      DO 80 H=0,HG
         DO 70 K=H,HG
            NN=H*H+K*K+H*K*KHMIX
            A=NN*QX
            IF (A .GT.QMAX) GO TO 80
            IF (NSYM .EQ. 3) THEN
               LMIN=K
            ELSE IF (NSYM .EQ. 5) THEN
               M=MOD(K-H,3)
               IF (M .EQ. 0) THEN
                  LMIN=0
               ELSE
                  LMIN=-M-LMAX
               END IF
            ELSE
               LMIN=0
            END IF
            DO 60 L=LMIN,LMAX,LSTEP
               Q=A+L*L*QZ
               IF (Q .LT. 1.0 ) GO TO 60
               IF (Q .GT. QMAX) GO TO 60
               NCALC=NCALC+1
               IF (NCALC .GT. 200) THEN
                  TYP=.TRUE.
                  GO TO 90
               END IF
               INSTOR(NCALC,1)=H
               INSTOR(NCALC,2)=K
               INSTOR(NCALC,3)=L
               QSTOR(NCALC)=Q
               Z=TETCAL(Q)
               DO 50 M=1,MAX
                  IF (TETPT(M) .LT. Z) GO TO 50
                  IF (TETMT(M) .GT. Z) GO TO 55
C           THERE IS A FITTING LINE. USE IT FOR THE REFINEMENT.
C                 PRINT *,' A FITTING LINE IS NR ',M,TWORAD*OBSTET(M)
                  I=NMATCH(M)+1
                  NMATCH(M)=I
C                 WRITE(IOUT,360) H,K,L,Q,TWORAD*Z,M
C 360 FORMAT(1X,3I4,F10.2,F10.3,'  LINE NR ', I2 ,'  FITS' )
                  CONS=WAVSQR/SIN(2.*Z)
                  W=1.
                  DIF=SHFTET(M)-Z
                  VAR(1)=NN*CONS
                  VAR(2)=L*L*CONS
                  IF (NSYM .EQ. 3) VAR(1)=VAR(1)+VAR(2)
                  IF ( ZERREF ) VAR(ORP1)=1.0
                  DO 42 J=1,ORP1
                     TEMP(J)=W*VAR(J)
                     DIFR(J)=DIFR(J)+W*DIF*VAR(J)
   42             CONTINUE
                  DO 48 J=1,ORP1
                     DO 45 I=1,ORP1
   45                REF(I,J)=REF(I,J)+VAR(I)*TEMP(J)
   48             CONTINUE
   50       CONTINUE
C  50       IS THE END OF THE LOOP ON THE SEARCH FOR A FITTING  Q
   55       CONTINUE
C  55       WRITE(IOUT,365) H,K,L,Q,TWORAD*Z
C 365       FORMAT(1X,3I4,F10.2,F10.3,'  NO FIT ' )
   60    CONTINUE
C  60    IS THE END OF THE LOOP ON L
   70 CONTINUE
C  END OF LOOP ON K
   80 CONTINUE
C  80 IS END OF LOOP ON H
C-----------------------------------------------------------------------
   90 CALL ARRAY(2,ORP1,ORP1,4,4,REF,REF)
      CALL MINV(REF,ORP1,DETER,MATR1,MATR2)
      CALL ARRAY(1,ORP1,ORP1,4,4,REF,REF)
      IF (ABS(DETER) .LT. 1.0E-30) THEN
         WRITE(IOUT,'(A38)' ) ' NOT REFINED, DETER LESS THAN 1.0E-30 '
         GO TO 200
      END IF
      NINDEX=0
      DO 120 I=1,MAX
         IF (NMATCH(I) .GT. 0) NINDEX=NINDEX+1
  120 CONTINUE
      SYMCON(ISOL,4)=NINDEX
      DO 170 I=1,ORP1
         DO 160 J=1,ORP1
  160    FYN(I)=FYN(I)+REF(I,J)*DIFR(J)
  170 CONTINUE
      IF ( ZERREF) THEN
         ZERSHF=FYN(ORP1)
         ZERTOT=ZERTOT+ZERSHF
      END IF
C  QX AND QZ ARE Q-VALUES,THAT WERE MULTIPLIED BY 1.E+4
      QX=QX+FYN(1)*1.E+4
      IF (ORDE .GT. 1) THEN
         QZ=QZ+FYN(2)*1.E+4
      ELSE
         QZ=QX
      END IF
C     IF (TEST) WRITE(IOUT,4) ISOL,QX,QZ,ZERSHF*TWORAD
  200 CONTINUE
 1000 CONTINUE
      IF (TYP) WRITE(IOUT,7)
      IF (NSYM .LT. 5) THEN
         VOL=1.E+6 / SQRT(QX*QX*QZ)
      ELSE
         VOL=2.E+6 / SQRT(3.*QX*QX*QZ)
      END IF
      IF (NSYM .EQ. 5 ) THEN
         WRITE(IOUT ,5) QX,QZ,NINDEX,MAX,ZERTOT*TWORAD,VOL
         WRITE(NSUMM,5) QX,QZ,NINDEX,MAX,ZERTOT*TWORAD,VOL
C        WRITE(NCRT ,5) QX,QZ,NINDEX,MAX,ZERTOT*TWORAD,VOL
      ELSE
         WRITE(IOUT ,6) QX,QZ,NINDEX,MAX,ZERTOT*TWORAD,VOL
         WRITE(NSUMM,6) QX,QZ,NINDEX,MAX,ZERTOT*TWORAD,VOL
C        WRITE(NCRT ,6) QX,QZ,NINDEX,MAX,ZERTOT*TWORAD,VOL
      END IF
      SYMCON(ISOL,1)=QX
      SYMCON(ISOL,2)=QZ
      SYMCON(ISOL,5)=ZERTOT*TWORAD
      SYMCON(ISOL,6)=VOL
      RETURN
C   4 FORMAT(' LATTICE ',I3,18H AFTER REFINEMENT , 2F10.3,
C    1 '    ZERO SHIFT=',F8.3,' DEGREES TWOTHETA ,  TOTAL:', F8.3)
    5 FORMAT(' THE RHOMBOHEDRAL LATTICE WITH THE (HEXAGONAL) CONSTANTS'
     1 /1X,2F12.3,'  CAN INDEX',I3,' FROM THE',I3,' LINES ' /
     2 ' ZEROSHIFT= ',F7.3,'  VOLUME=',F10.2 //)
    6 FORMAT(' THE SYMMETRICAL LATTICE WITH THE  CONSTANTS'
     1 /1X,2F12.3,'  CAN INDEX',I3,' FROM THE',I3,' LINES ' /
     2 ' ZEROSHIFT= ',F7.3,'  VOLUME=',F10.2 //)
    7 FORMAT(// 1X,30(2HYY)/ ' SUBR. REFSYM.  ARRAY INSTORE WAS FULL' /
     1  ' GENERATION OF Q-VALUES WAS DISCONTINUED.'//
     2  ' THIS MAKES IT RATHER IMPROBABLE THAT THE HIGH-SYMMETRY ',
     3  'LATTICE IS CORRECT. '/ 1X,30(2HYY) // )
      END
