      SUBROUTINE INDEXREF
C 
C     SUBROUTINE TO GENERATE MILLER INDICES ACCORDING TO THE SPECIFIC 
C     LAUE GROUP WITHOUT REDUNDANCIES 
C 
C     THE CODE WORD, LAUE, FOUND ON THE POWDER DATA CONTROL CARD HAS THE
C     FOLLOWING INTERPRETATION
C         LAUE = 1   LAUE GROUP -1
C         LAUE = 2   LAUE GROUP 2/M (Y AXIS UNIQUE) 
C         LAUE = 3   LAUE GROUP 2/M (Z AXIS UNIQUE) 
C         LAUE = 4   LAUE GROUP MMM 
C         LAUE = 5   LAUE GROUP 4/M 
C         LAUE = 6   LAUE GROUP 4/MMM 
C         LAUE = 7   LAUE GROUP M3
C         LAUE = 8   LAUE GROUP M3M 
C         LAUE = 9   LAUE GROUP -3     RHOMBOHEDRAL AXES
C         LAUE =10   LAUE GROUP -3M    RHOMBOHEDRAL AXES
C         LAUE =11   LAUE GROUP -3     HEXAGONAL AXES 
C         LAUE =12   LAUE GROUP -3M    HEXAGONAL AXES 
C         LAUE =13   LAUE GROUP 6/M 
C         LAUE =14   LAUE GROUP 6/MMM 
C         LAUE =15   LAUE GROUP -3M    ROTATED
C 
      COMMON/GENL/XLAMDA,DMIN,TITLE(18),NIN,NOUT,NPUNCH,JJ,IA,ISH,ISK,IS
     *L 
      COMMON /DATA/D(3001),IH(3001),IK(3001),IL(3001) 
      COMMON /EXTNS/RECD,LAUE,IEXT(13),NEX,NH,NK,NL,JNUM
      COMMON /CELLS/A,B,C,AL,BE,GA,RCV,RCP(6),VOL,PRCP(6) 
      DIMENSION HH(100),HK(100),HL(100) 
      DO 100  I=1,100 
      HH(I)=0.0 
      HK(I)=0.0 
  100 HL(I)=0.0 
      DO 110  I=1,1000
      D(I)=0.0
      IH(I)=0 
      IK(I)=0 
  110 IL(I)=0 
      DO 120  I=1,13
  120 IEXT(I)=IEXT(I)+1 
      JNUM=3000 
C 
C     DETERMINE MAXIMUM INDICES 
C 
C     SET UP RANGE OF MILLER INDICES
C 
      HLMAX=C/DMIN
      LMAX=min(99.,HLMAX+1.0)
      DO 130  K=1,LMAX
  130 HL(K+1)=HL(K)+1.0 
C  
      HKMAX=B/DMIN
      KMAX=min(99.,HKMAX+1.0)
      IF (LAUE.EQ.1) GO TO 150
      DO 140  J=1,KMAX
  140 HK(J+1)=HK(J)+1.0 
      GO TO 170 
  150 KMAX=min(99,2*KMAX-1)
      N=HKMAX 
      HK(1)=N 
      DO 160  J=1,KMAX
  160 HK(J+1)=HK(J)-1.0 
C 
  170 HHMAX=A/DMIN
      IMAX=min(99.,HHMAX+1.0)
      IF (LAUE.LE.3) GO TO 190
      DO 180  I=1,IMAX
  180 HH(I+1)=HH(I)+1.0 
      GO TO 210 
  190 IMAX=min(99,2*IMAX-1)
      M=HHMAX 
      HH(1)=M 
      DO 200  I=1,IMAX
  200 HH(I+1)=HH(I)-1.0 
C 
  210 JJ=0
      GO TO (220,260,310,350,350,820,460,460,460,460,820,820,820,820,820
     1), LAUE 
C 
C     TRICLINIC SYSTEM - LAUE GROUP -1
C 
C     GENERATE MILLER INDICES (H00) 
C 
  220 NK=0
      NL=0
      DO 250  I=1,M 
      NH=HH(I)
      CALL EXTN 
      IF (NEX) 210,230,250
  230 RECD=HH(I)*RCP(1) 
      IF (RECD.EQ.0) GO TO 240
      D(JJ)=1.0/RECD
      IF (D(JJ).GE.DMIN) GO TO 250
  240 JJ=JJ-1 
  250 CONTINUE
C 
C     GENERATE MILLER INDICES (HK0) (K NOT ZERO)
C 
      JQ=N
      IQ=IMAX 
      ASSIGN 400 TO NINDX 
      GO TO 270 
C 
C     MONOCLINIC SYSTEM (Y UNIQUE)
C 
  260 JQ=KMAX 
      IQ=M+1
      ASSIGN 410 TO NINDX 
      NL=0
C 
C     GENERATE MILLER INDICES (HK0) 
C 
  270 DO 300  J=1,JQ
      DO 300  I=1,IQ
      NH=HH(I)
      NK=HK(J)
      CALL EXTN 
      IF (NEX) 210,280,300
  280 RECD=0.0
      IF (LAUE.EQ.1) RECD=HH(I)*HK(J)*PRCP(4)*2.0 
      RECD=2.0*SQRT(HH(I)**2*PRCP(1)+HK(J)**2*PRCP(2)+RECD) 
      IF (RECD.EQ.0) GO TO 290
      D(JJ)=1.0/RECD
      IF (D(JJ).GE.DMIN) GO TO 300
  290 JJ=JJ-1 
  300 CONTINUE
C 
C     GENERATE MILLER INDICES (HKL) (L NOT ZERO)
C 
      JQ=1
      KQ=2
      GO TO 370 
C 
C     MONOCLINIC SYSTEM (Z UNIQUE)
C 
  310 MN=M+1
      NK=0
C 
C     GENERATE MILLER INDICES (H0L) 
C 
      DO 340  K=1,LMAX
      DO 340  I=1,MN
      NH=HH(I)
      NL=HL(K)
      CALL EXTN 
      IF (NEX) 210,320,340
  320 RECD=2.0*SQRT(HH(I)**2*PRCP(1)+HL(K)**2*PRCP(3))
      IF (RECD.EQ.0) GO TO 330
      D(JJ)=1.0/RECD
      IF (D(JJ).GE.DMIN) GO TO 340
  330 JJ=JJ-1 
  340 CONTINUE
C 
C     GENERATE MILLER INDICES (HKL) (K NOT ZERO)
C 
      JQ=2
      ASSIGN 420 TO NINDX 
      GO TO 360 
C 
C     ORTHORHOMBIC SYSTEM 
C 
C     TETRAGONAL SYSTEM - 4/M 
C 
C 
C     GENERATE MILLER INDICES (HKL) 
C 
  350 ASSIGN 430 TO NINDX 
      JQ=1
  360 KQ=1
  370 DO 450  K=KQ,LMAX 
      DO 450  J=JQ,KMAX 
      DO 450  I=1,IMAX
      IF (LAUE.NE.5) GO TO 380
      IF (HH(I).EQ.0.AND.HK(J).NE.0.0) GO TO 450
  380 NH=HH(I)
      NK=HK(J)
      NL=HL(K)
      CALL EXTN 
      IF (NEX) 210,390,450
  390 RECD=HH(I)**2*PRCP(1)+HK(J)**2*PRCP(2)+HL(K)**2*PRCP(3) 
      GO TO NINDX, (400,410,420,430)
  400 RECD=RECD+2.0*(HH(I)*HK(J)*PRCP(4)+HH(I)*HL(K)*PRCP(5)+HK(J)*HL(K)
     1*PRCP(6)) 
      GO TO 430 
  410 RECD=RECD+2.0*HH(I)*HL(K)*PRCP(5) 
      GO TO 430 
  420 RECD=RECD+2.0*HH(I)*HK(J)*PRCP(4) 
  430 RECD=2.0*SQRT(RECD) 
      IF (RECD.EQ.0) GO TO 440
      D(JJ)=1.0/RECD
      IF (D(JJ).GE.DMIN) GO TO 450
  440 JJ=JJ-1 
  450 CONTINUE
      GO TO 1100
C 
C     RHOMBOHEDRAL SYSTEM 
C     RHOMBOHEDRAL LAUE GROUPS WITH RHOMBOHEDRAL LATTICE
C 
C     CUBIC SYSTEM
C 
C 
C     LAUE GROUPS -3 AND -3M            3M AND M3M
C 
C 
C      GENERATE MILLER INDICES (HKL) (H GREATER OR EQUAL K GREATER OR 
C     EQUAL +L) 
C 
  460 DO 490  K=1,IMAX
      DO 490  J=K,IMAX
      DO 490  I=J,IMAX
      NH=HH(I)
      NK=HK(J)
      NL=HL(K)
      CALL EXTN 
      IF (NEX) 210,470,490
  470 RECD=0.0
      IF (LAUE.GE.9) RECD=2.0*RCP(4)*(HH(I)*HK(J)+HH(I)*HL(K)+HK(J)*HL(K
     1))
      RECD=2.0*SQRT((HH(I)**2+HK(J)**2+HL(K)**2+RECD)*PRCP(1))
      IF (RECD.EQ.0) GO TO 480
      D(JJ)=1.0/RECD
      IF (D(JJ).GE.DMIN) GO TO 490
  480 JJ=JJ-1 
  490 CONTINUE
      IF (LAUE-8) 630,1100,500
C 
C     GENERATE MILLER INDICES (HKL) (-H GREATER OR EQUAL K GREATER OR 
C     EQUAL L, K NOT ZERO)
C 
  500 DO 540  K=1,IMAX
      DO 540  J=K,IMAX
      IF (HK(J).EQ.0) GO TO 540 
      DO 530  I=J,IMAX
      NH=-HH(I) 
      NK=HK(J)
      NL=HL(K)
      CALL EXTN 
      IF (NEX) 210,510,530
  510 RECD=2.0*SQRT((HH(I)**2+HK(J)**2+HL(K)**2+2.0*RCP(4)*(-HH(I)*HK(J)
     1-HH(I)*HL(K)+HK(J)*HL(K)))*PRCP(1)) 
      IF (RECD.EQ.0) GO TO 520
      D(JJ)=1.0/RECD
      IF (D(JJ).GE.DMIN) GO TO 530
  520 JJ=JJ-1 
      GO TO 540 
  530 CONTINUE
  540 CONTINUE
C 
C     GENERATE MILLER INDICES (HKL) (H GREATER OR EQUAL K GREATER OR
C     EQUAL -L, L NOT ZERO) 
C 
      DO 570  K=2,IMAX
      DO 570  J=K,IMAX
      DO 570  I=J,IMAX
      IF (HH(I).EQ.HL(K)) GO TO 570 
      NH=HH(I)
      NK=HK(J)
      NL=-HL(K) 
      CALL EXTN 
      IF (NEX) 210,550,570
  550 RECD=2.0*SQRT((HH(I)**2+HK(J)**2+HL(K)**2+2.0*RCP(4)*(HH(I)*HK(J)-
     1HH(I)*HL(K)-HK(J)*HL(K)))*PRCP(1))
      IF (RECD.EQ.0) GO TO 560
      D(JJ)=1.0/RECD
      IF (D(JJ).GE.DMIN) GO TO 570
  560 JJ=JJ-1 
  570 CONTINUE
C 
C     GENERATE MILLER INDICES (HKL) (H GREATER THAN -K GREATER THAN L)
C 
      DO 620  K=2,IMAX
      KK=K+1
      IF (KK.GT.IMAX) GO TO 620 
      DO 610  J=KK,IMAX 
      JJJ=J+1 
      IF (JJJ.GT.IMAX) GO TO 610
      DO 600  I=JJJ,IMAX
      NH=HH(I)
      NK=-HK(J) 
      NL=HL(K)
      CALL EXTN 
      IF (NEX) 210,580,600
  580 RECD=2.0*SQRT((HH(I)**2+HK(J)**2+HL(K)**2+2.0*RCP(4)*(-HH(I)*HK(J)
     1+HH(I)*HL(K)-HK(J)*HL(K)))*PRCP(1)) 
      IF (RECD.EQ.0) GO TO 590
      D(JJ)=1.0/RECD
      IF (D(JJ).GE.DMIN) GO TO 600
  590 JJ=JJ-1 
  600 CONTINUE
  610 CONTINUE
  620 CONTINUE
      IF (LAUE.NE.9) GO TO 1100 
C 
C     GENERATE MILLER INDICES (HKL) (H LESS THAN K LESS THAN L) 
C 
  630 DO 680  I=1,IMAX
      II=I+1
      IF (II.GT.IMAX) GO TO 680 
      DO 670  J=II,IMAX 
      JJJ=J+1 
      IF (JJJ.GT.IMAX) GO TO 670
      DO 660  K=JJJ,IMAX
      NH=HH(I)
      NK=HK(J)
      NL=HL(K)
      CALL EXTN 
      IF (NEX) 210,640,660
  640 RECD=0.0
      IF (LAUE.NE.7) RECD=2.0*RCP(4)*(HH(I)*HH(J)+HH(I)*HL(K)+HK(J)*HL(K
     1))
      RECD=2.0*SQRT((HH(I)**2+HK(J)**2+HL(K)**2+RECD)*PRCP(1))
      IF (RECD.EQ.0) GO TO 650
      D(JJ)=1.0/RECD
      IF (D(JJ).GE.DMIN) GO TO 660
  650 JJ=JJ-1 
  660 CONTINUE
  670 CONTINUE
  680 CONTINUE
      IF (LAUE.EQ.7) GO TO 1100 
C 
C     GENERATE MILLER INDICES (HKL) (H LESS THAN -K LESS THAN L)
C 
      DO 730  I=1,IMAX
      II=I+1
      IF (II.GT.IMAX) GO TO 730 
      DO 720  J=II,IMAX 
      JJJ=J+1 
      IF (JJJ.GT.IMAX) GO TO 720
      DO 710  K=JJJ,IMAX
      NH=HH(I)
      NK=-HK(J) 
      NL=HL(K)
      CALL EXTN 
      IF (NEX) 210,690,710
  690 RECD=2.0*SQRT((HH(I)**2+HK(J)**2+HL(K)**2+2.0*RCP(4)*(-HH(I)*HK(J)
     1+HH(I)*HL(K)-HK(J)*HL(K)))*PRCP(1)) 
      IF (RECD.EQ.0.0) GO TO 700
      D(JJ)=1.0/RECD
      IF (D(JJ).GE.DMIN) GO TO 710
  700 JJ=JJ-1 
  710 CONTINUE
  720 CONTINUE
  730 CONTINUE
C 
C     GENERATE MILLER INDICES (HKL) (-H LESS OR EQUAL K LESS THAN L,
C     H NOT ZERO) 
C 
      DO 770  I=2,IMAX
      DO 770  J=I,IMAX
      JJJ=J+1 
      IF (JJJ.GT.IMAX) GO TO 770
      DO 760  K=JJJ,IMAX
      NH=-HH(I) 
      NK=HK(J)
      NL=HL(K)
      CALL EXTN 
      IF (NEX) 210,740,760
  740 RECD=2.0*SQRT((HH(I)**2+HK(J)**2+HL(K)**2+2.0*RCP(4)*(-HH(I)*HK(J)
     1-HH(I)*HL(K)+HK(J)*HL(K)))*PRCP(1)) 
      IF (RECD.EQ.0.0) GO TO 750
      D(JJ)=1.0/RECD
      IF (D(JJ).GE.DMIN) GO TO 760
  750 JJ=JJ-1 
  760 CONTINUE
  770 CONTINUE
C 
C     GENERATE MILLER INDICES (HKL) (H LESS THAN K LESS OR EQUAL -L,
C     H NOT ZERO
C 
      DO 810  I=2,IMAX
      II=I+1
      IF (II.GT.IMAX) GO TO 810 
      DO 800  J=II,IMAX 
      DO 800  K=J,IMAX
      NH=HH(I)
      NK=HK(J)
      NL=-HL(K) 
      CALL EXTN 
      IF (NEX) 210,780,800
  780 RECD=2.0*SQRT((HH(I)**2+HK(J)**2+HL(K)**2+2.0*RCP(4)*(HH(I)*HK(J)-
     1HH(I)*HL(K)-HK(J)*HL(K)))*PRCP(1))
      IF (RECD.EQ.0.0) GO TO 790
      D(JJ)=1.0/RECD
      IF (D(JJ).GE.DMIN) GO TO 800
  790 JJ=JJ-1 
  800 CONTINUE
  810 CONTINUE
      GO TO 1100
C 
C     HEXAGONAL SYSTEM
C 
C     TETRAGONAL SYSTEM 
C 
C     LAUE GROUPS -3, -3M, 6/M, AND 6/MMM        4/MMM
C 
C     GENERATE MILLER INDICES FOR (HKL) (H GREATER OR EQUAL K ALL +L) 
C 
  820 DO 850  J=1,IMAX
      DO 850  I=J,IMAX
      DO 850  K=1,LMAX
      NH=HH(I)
      NK=HK(J)
      NL=HL(K)
      CALL EXTN 
      IF (NEX) 210,830,850
  830 RECD=0.0
      IF (LAUE.NE.6) RECD=HH(I)*HK(J) 
      RECD=2.0*SQRT((HH(I)**2+HK(J)**2+RECD)*PRCP(1)+HL(K)**2*PRCP(3))
      IF (RECD.EQ.0.0) GO TO 840
      D(JJ)=1.0/RECD
      IF (D(JJ).GE.DMIN) GO TO 850
  840 JJ=JJ-1 
  850 CONTINUE
      IF (LAUE.EQ.6) GO TO 1100 
      IF (LAUE-13) 910,860,970
C 
C     LAUE GROUP 6/M
C 
C     GENERATE MILLER INDICES (HKL) (H LESS THAN K ALL +L, H NOT ZERO)
C 
  860 DO 900  I=2,IMAX
      II=I+1
      IF (II.GT.IMAX) GO TO 900 
      DO 890  J=II,IMAX 
      DO 890  K=1,LMAX
      NH=HH(I)
      NK=HK(J)
      NL=HL(K)
      CALL EXTN 
      IF (NEX) 210,870,890
  870 RECD=2.0*SQRT((HH(I)**2+HK(J)**2+HH(I)*HK(J))*PRCP(1)+HL(K)**2*PRC
     1P(3)) 
      IF (RECD.EQ.0.0) GO TO 880
      D(JJ)=1.0/RECD
      IF (D(JJ).GE.DMIN) GO TO 890
  880 JJ=JJ-1 
  890 CONTINUE
  900 CONTINUE
C 
C     LAUE GROUP -3M
C 
C     GENERATE MILLER INDICES (HKL) (H LESS THAN K, L NOT ZERO) 
C 
  910 IF (LAUE-12) 1010,920,1100
  920 DO 960  I=1,IMAX
      II=I+1
      IF (II.GT.IMAX) GO TO 960 
      DO 950  J=II,IMAX 
      DO 950  K=2,LMAX
      NH=HH(I)
      NK=HK(J)
      NL=HL(K)
      CALL EXTN 
      IF (NEX) 210,930,950
  930 RECD=2.0*SQRT((HH(I)**2+HK(J)**2+HH(I)*HK(J))*PRCP(1)+HL(K)**2*PRC
     1P(3)) 
      IF (RECD.EQ.0.0) GO TO 940
      D(JJ)=1.0/RECD
      IF (D(JJ).GE.DMIN) GO TO 950
  940 JJ=JJ-1 
  950 CONTINUE
  960 CONTINUE
      GO TO 1100
C 
C     LAUE GROUP -3M ROTATED
C 
C     GENERATE MILLER INDICES (HKL)  (H GREATER OR EQUAL K, K NOT EQUAL 
C     ZERO, ALL +L) 
C 
  970 IF (LAUE.NE.15) GO TO 1100
      DO 1000  J=2,IMAX 
      DO 1000  I=J,IMAX 
      DO 1000  K=2,LMAX 
      NH=-HH(I) 
      NK=-HK(J) 
      NL=HL(K)
      CALL EXTN 
      IF (NEX) 210,980,1000 
  980 RECD=2.0*SQRT((HH(I)**2+HK(J)**2-HH(I)*(-HK(J)))*PRCP(1)+HL(K)**2*
     1PRCP(3))
      IF (RECD.EQ.0.0) GO TO 990
      D(JJ)=1.0/RECD
      IF (D(JJ).GE.DMIN) GO TO 1000 
  990 JJ=JJ-1 
 1000 CONTINUE
      GO TO 1100
C 
C     LAUE GROUP -3 
C 
C     GENERATE MILLER INDICES (HKL) (H LESS THAN K, ALL +L) 
C 
 1010 DO 1060  I=1,IMAX 
      II=I+1
      IF (II.GT.IMAX) GO TO 1060
      DO 1050  J=II,IMAX
      DO 1050  K=1,LMAX 
      IF (HL(K).NE.0) GO TO 1020
      IF (HH(I).EQ.0) GO TO 1050
 1020 NH=HH(I)
      NK=HK(J)
      NL=HL(K)
      CALL EXTN 
      IF (NEX) 210,1030,1050
 1030 RECD=2.0*SQRT((HH(I)**2+HK(J)**2+HH(I)*HK(J))*PRCP(1)+HL(K)**2*PRC
     1P(3)) 
      IF (RECD.EQ.0.0) GO TO 1040 
      D(JJ)=1.0/RECD
      IF (D(JJ).GE.DMIN) GO TO 1050 
 1040 JJ=JJ-1 
 1050 CONTINUE
 1060 CONTINUE
C 
C     GENERATE MILLER INDICES (HKL) (H AND K NOT ZERO, ALL -L)
C 
      DO 1090  I=2,IMAX 
      DO 1090  J=2,IMAX 
      DO 1090  K=2,LMAX 
      NH=HH(I)
      NK=HK(J)
      NL=-HL(K) 
      CALL EXTN 
      IF (NEX) 210,1070,1090
 1070 RECD=2.0*SQRT((HH(I)**2+HK(J)**2+HH(I)*HK(J))*PRCP(1)+HL(K)**2*PRC
     1P(3)) 
      IF (RECD.EQ.0.0) GO TO 1080 
      D(JJ)=1.0/RECD
      IF (D(JJ).GE.DMIN) GO TO 1090 
 1080 JJ=JJ-1 
 1090 CONTINUE
 1100 RETURN
      END 
