C 
C     GENERAL PURPOSE LEAST SQUARES PROGRAM 
C     MODIFIED VERSION OF MOWLS  D. E. COX OCTOBER 1981 
C     FORMAT FOLLOWS THAT OF HAMILTON IN STATISTICS IN PHYSICAL SCIENCES
C     DIMENSIONED FOR MXD OBSERVATIONS AND nparam PARAMETERS
C
C Original Version keeps entire observation matrix of
C    Ndata by Nparams in memory.  Converted to build normal
c    equations matrix one observation at a time.
C    Modifications 1-Oct-1992 by Larry W. Finger
C 
	PARAMETER (MXD=1000,Neta=4,nparam=40)
      real*4 fobs(mxd),sigf(mxd),fcalc(mxd),
     1 pvalue(nparam),pnew(nparam),sigp(nparam),
     2  adjust(nparam),x(nparam)
	CHARACTER*72 title
      real*8 amat(nparam,nparam),bmat(nparam),dsave(nparam)
      real*4 deriv(nparam)
C input parameters are:
      common /a/astart,astep,aend,dis,det,iasymm,np,no
	REAL*4 astart,astep,aend,dis,det
	INTEGER*4 iasymm,np,no
      character*36 what(nparam)
	INTEGER*4 isel(nparam)
	common /b/isel
	REAL WAVE1,WAVE2,RATIO21	   
	common /c/ WAVE1,WAVE2,RATIO21
	WAVE1 = 0.0
	WAVE2 = 0.0
	RATIO21 = 0.5
C
C OPEN INPUT AND OUTPUT FILES
C
!      OPEN(UNIT=2,FILE='GPLS.INP;1',STATUS='OLD',READONLY)
      OPEN(UNIT=2,FILE='GPLS.INP',STATUS='OLD')
      OPEN(UNIT=3,FILE='GPLS.PRM',STATUS='UNKNOWN')
C 
C     READ IN TITLE CARD
C 
      READ(2,'(a)') TITLE
C 
C     READ IN NO. OF OBSERVATIONS, CYCLES AND PARAMETERS
C     ASTART AND AEND ARE START AND FINISH POINTS, ASTEP IS INTERVAL 
C     Iasymm is Non-zero for asymmetric peaks - Van Laar and Yelon (JAC
C	17,47,1984).  SAM is effective illumination half width of sample,
C	DET is half width of detector slit, DIS is distance from sample to
C	detector.  All distances in mm.
C 
!      READ(2,'(5i3,3f11.5,2i1,3f6.1)')NPTS,NEX,NO,ICYC,NP,ASTART
!     1  ,ASTEP,AEND,nsigma,IASYMM,DIS,DET
      READ(2,*) NPTS,ICYC,NP,ASTART,ASTEP,AEND,IASYMM,DIS,XFR
!      READ(2,*) NPTS,ICYC,NP,ASTART,ASTEP,AEND,IASYMM,DIS,DET,XFR
C ICYC is number of parameter sets to read
	IF (NPTS .LT. 0) THEN 
	   NPTS = ABS(NPTS)
	   READ(2,*) WAVE1,WAVE2,RATIO21
	   WRITE(*,*) NPTS,WAVE1,WAVE2,RATIO21
	ENDIF
	NO = NPTS
	IF (NO .GT. MXD) STOP 'Too many data points'
C
C     READ IN OBSERVED VALUES 
C 
	read(2,*)(fobs(i),i=1,npts)
	read(2,*)(sigf(i),i=1,npts)
C find the minimum non-zero intensity
	DO I=1,NPTS
	   IF (FOBS(i) .GT. 0) THEN
	      FOBSMIN = FOBS(i)
	      goto 112
	   ENDIF
	ENDDO
 112	DO I=1,NPTS
	   IF (FOBS(i) .GT. 0 .AND. FOBS(i) .LT. FOBSMIN) THEN
	      FOBSMIN = FOBS(i)
	   ENDIF
	ENDDO
C now replace any zero sigmas with this minimum
	DO I=1,NPTS
	   IF (SIGF(i) .LE. 0) SIGF(I) = SQRT(FOBSMIN)
	ENDDO

C 
C     READ IN PARAMETER DESCRIPTION, INITIAL VALUE AND INCREMENT
C 
      READ(2,'(a36,f25.0)')(WHAT(I),PVALUE(I),I=1,NP)
!      write(*,*)(WHAT(I),PVALUE(I),I=1,NP)
c
c
c start cycle
c
C     READ IN PARAMETER SELECTION CARDS FOR EACH CYCLE
C 
	jcyc = 0
 90	READ(2,'(80i1)',end=92)(ISEL(I),I=1,nparam) 
 	READ(2,*,end=92)ncyc
C NCYC is the number of cycles with each parameter set
	kcyc = 0
	jcyc = jcyc + 1		! set number
 91	kcyc = kcyc + 1		! cycle number
C
c Calculate fraction of shift to apply
c
C      xfr = min(0.8,0.2 * jcyc)
c
c Count number of refined parameters and change refinement switches into pointers
c
      ncount=0
      NPP = NP
      do i=1,np
C if sam & det are both refined -- constrain them together
	 if (I .EQ. NP .AND. iasymm.eq.1 .and.
	1     isel(np-1).NE.0 .AND. isel(np).NE.0) then
	    NPP = NP - 1
	    isel(i) = ncount
	ELSEif(isel(i).ne.0) then
	   ncount=ncount+1 
	   isel(i) = ncount
	ENDIF
      enddo
c
c Clear normal equations matrices
c
      do i = 1,ncount
	bmat(i) = 0.0
	do j = 1,ncount
	  amat(j,i) = 0.0
	enddo
      enddo
      sumwdel2 = 0.0
c
c Loop through observations
c
      do i = 1,no
	tth = astart + (i-1)*astep	!Calculate 2theta for this observation
	!write (*,*) 'tth = ',tth
c
c evaluate the profile and derivatives
c
	fcalc(i) = Getval(pvalue,tth,deriv)
	wgt = 1.0/sigf(i)**2
	del = fobs(i) - fcalc(i)
	sumwdel2 = sumwdel2 + wgt * del**2
	do jj = 1,npp
	  if(isel(jj).ne.0)then
	    j = isel(jj)
	    bmat(j) = bmat(j) + wgt * del * deriv(jj)
	    do kk = jj,npp
	      if(isel(kk).ne.0)then
		k = isel(kk)
	    	amat(k,j) = amat(k,j) + wgt * deriv(jj)*deriv(kk)
	      endif
	    enddo
	  endif
	enddo
c
c end of loop through observations
c
      enddo
      fax = sumwdel2 / (no - ncount)
      write(*,'(2i3,a,f10.2)') kcyc,jcyc,' GOF:',fax
c
c begin conversion of A to correlation matrix - improves accuracy
c    of inversion
c
      do i = 1,ncount
	dsave(i) = 1.0/sqrt(amat(i,i))
      enddo
c Now do conversion and symmetrize
      do i = 1,ncount
	do j = i,ncount
	  amat(j,i) = amat(j,i) * dsave(i) * dsave(j)
	  amat(i,j) = amat(j,i)
	enddo
      enddo
c
c invert correlation matrix
c
      call smi10(amat,ncount)
c
c correct inverse for conversion to correlation matrix
c
      do j = 1,ncount
	do i = 1,ncount
	  amat(i,j) = amat(i,j) * dsave(i) * dsave(j)
	enddo
      enddo
c
c Calculate shifts and new increment for next cycle
c
      do i = 1,ncount
	x(i) = 0.0
	do j = 1,ncount
	  x(i) = x(i) + amat(i,j) * bmat(j)
	enddo
      enddo
      idone = 0
      do i=1,np
	 if(isel(i).ne.0) then
C       Apply damping fraction
	    adjust(i)=x(isel(i))*xfr
	    pnew(i)=adjust(i)+pvalue(i) 
C Keep parameters positive
	    if(pnew(i).lt.0.0)pnew(i)=pvalue(i)/2.0
	    sigp(i)=sqrt(fax*amat(isel(i),isel(i)))
	    if(abs(adjust(i)/sigp(i)).gt.0.1)idone=1
c Constrain Eta
	    if(i.eq.neta.and.pnew(i).gt.1.3)pnew(i)=1.3
	    pvalue(i)=pnew(i) 
	 else
	    adjust(i) = 0.0
	    sigp(i) = 0.0
	 endif
      enddo
	
      ICYC=ICYC-1
C stop if the sample height goes out of range
	IF (iasymm.eq.1 .and. PVALUE(NP) / dis .gt. 0.05) goto 92
      IF(idone.ne.0 .and. kcyc.lt.ncyc) GO TO 91
      IF(jcyc .lt. icyc) GO TO 90
C
C WRITE DATA FOR RETURN TO CALLER
C
 92	WRITE(3,'(8g15.8)')(PVALUE(I),ADJUST(I),SIGP(I),I=1,NP)
     1,FAX,(FCALC(I),I=1,NO)
      OPEN(UNIT=4,FILE='GPLS.LST',STATUS='UNKNOWN')
      do i = 1,no
	apos = astart + (i-1)*astep
	write(4,'(f10.4,f13.4)')apos,fobs(i)
      enddo
      CLOSE (UNIT=4)
      OPEN(UNIT=4,FILE='gpls.out',STATUS='UNKNOWN')
      write(4,*) no
      do i = 1,no
	apos = astart + (i-1)*astep
	write(4,'(f10.4,2f13.4)')apos,fobs(i),fcalc(i)
      enddo
	IF (idone .eq. 0) Then
	   write (4,'(I3,f12.3,A)') NP,FAX,' (Converged)'
	ELSE
	   write (4,'(I3,f12.3)') NP,FAX
	ENDIF
      WRITE(4,'(3g18.8)')(PVALUE(I),ADJUST(I),SIGP(I),I=1,NP)
      CLOSE (UNIT=4)

c      OPEN(UNIT=4,FILE='GPLS.CAL;1',STATUS='UNKNOWN')
c      astepp = 0.0005
c      no = (aend - astart) / astepp + 1
c      do i = 1,no
c	apos = astart + (i-1)*astepp
c	fnew = getval(pvalue,apos,deriv)
c	write(4,'(f10.4,f13.4)')apos,fnew
c      enddo
c      close (unit=4)
      close(unit=2)
      close (unit=3)
      end 
