#-----------------------------------------------------------------
# read profin (Dave Cox's Rietveld) data files
#------- define a command line option -----------------------------
# command line option 
lappend command(cmdopt) -profin
# proc to use 
set command(-profin)  readProfinData
#--------define a dialog box entry
# menu label
lappend command(readtypes) "BNL PROFIN file"
# proc for this entry
lappend command(readproc) ReadProfin
# allowed data types
if {$tcl_platform(platform) == "windows"} {
    lappend command(filterlist) {profin}
} else {
    lappend command(filterlist) {profin PROFIN}
}
# definitions for these data types
set command(ReadProfin_profin_type) "PROFIN data"
set command(ReadProfin_PROFIN_type) "PROFIN data"


proc ReadProfin {file} {
    global command
    if {$file == ""} return
    pleasewait "reading file $file"
    set ret [readProfinData $file]
    donewait
    if {$ret != ""} {return $ret}
    showlastentry $command(read_filelist)
}

proc readProfinData {filename} {

    #puts "opening PROFIN file $filename"
    global graph

    set lnum 0
    # signal errors by quitting
    if [catch {
	set fp [open $filename r]

	# Read the first 2 lines of the file and test if 
	# line 2 is the start, stop and step
	
	set npts {}
	for {set i 0} {$i<4} {incr i} {
	    incr lnum
	    set eof [gets $fp title]
	    if {$eof < 0} {return "early end-of-file"} 
	    set eof [gets $fp line]
	    if {$eof < 0} {return "early end-of-file"} 
	    # use the first line as the title whatever it is
	    set start [lindex $line 0]
	    set last [lindex $line 2]
	    set step [lindex $line 1]
	    if ![catch {set npts [expr 1. + ($last - $start)/$step]}] {
		break
	    }
	}
	if {$npts == ""} {
	    return "Scan range not found in line 2"
	}
	
	if {$npts > 60000 || $npts < 2} {
	    return "There are $npts points -- something is wrong!"
	}

	# Great!! Now we are positioned to read the data.

	# Initialize the data structure.
	set data [file root [file tail $filename]] 
	# eliminate spaces from the name
	regsub -all " " $data "_" data
	set data [initdata $data]
	global ${data}
	set ${data}(xlabel) "2theta"
	set ${data}(xunits) "2theta"
	set ${data}(ylabel) "scaled counts"
	set ${data}(title) $title
	
	# No missing points
	set ${data}(skip) 0
	set ptsread 0

	# Now, read the rest of the file.
	# until we get to the last data point, an end-of-file or error
	set i 0
	while {[gets $fp line1] >= 0 && [gets $fp line2] >= 0} {
	    incr lnum 2
	    if {$lnum > $::command(maxlines)} {
		return "Read > $::command(maxlines) lines. Something is wrong or change command(maxlines)!"
	    }
	    # assume a space between counts
	    foreach count $line1 esd $line2 {
		if {$count >= 0 && $esd >= 0} {
		    lappend ${data}(x) [expr $start + ($ptsread-1.)*$step]
		    lappend ${data}(y) [expr $count]
		    lappend ${data}(esd) [expr $esd]
		} else {
		    # there are skipped points
		    set ${data}(skip) 1
		}
		incr ptsread
	    }
	}
	if {$ptsread != $npts} {return "$ptsread were read, but expected $npts points!"}
    } errmsg] {
	# try to process the data we have read
	catch {resetdata $data}
	return "PROFIN error. Error reading line $lnum: $errmsg"
    }
    resetdata $data
    lappend graph(plotlist) $data
    catch {close $fp} test
    #puts "$ptsread valid points read"
    return {}
}
