# read ascii GADDS .plt (XY data) files
#
#----------------------------------------------------------------
#------- define a command line option -----------------------------
# command line option 
lappend command(cmdopt) -gadds
# proc to use 
set command(-gadds)  readPLTdata
#--------define a dialog box entry
# menu label
lappend command(readtypes) "GADDS .plt (ascii)"
# proc for this entry
lappend command(readproc) ReadPLT
# allowed data types
if {$tcl_platform(platform) == "windows"} {
    lappend command(filterlist) {plt}
    # definitions for these data types
    set command(ReadPLT_plt_type) "GADDS data"
} else {
    lappend command(filterlist) {plt PLT}
    # definitions for these data types
    set command(ReadPLT_plt_type) "GADDS data"
    set command(ReadPLT_PLT_type) "GADDS data"
 }

proc ReadPLT {file} {
    global command
    if {$file == ""} return
    pleasewait "reading file $file"
    set ret [readPLTdata $file]
    donewait
    if {$ret != ""} {return $ret}
    showlastentry $command(read_filelist)
}

proc readPLTdata {filename} {

    #puts "opening XY Data file $filename"
    global graph

    set lnum 0
    # signal errors by quitting
    if [catch {
	set fp [open $filename r]
	set data [file root [file tail $filename]] 
	# eliminate spaces from the name
	regsub -all " " $data "_" data

	# Great!! Now we are positioned to read the data.
	seek $fp 0

	# Initialize the data structure.
    set data [initdata $data]
    global ${data}
    set ${data}(xlabel) "2theta"
    set ${data}(xunits) "2theta"
    set ${data}(ylabel) "counts"

    # No missing points
    set ${data}(skip) 0
    set ptsread 0
	set lnum 0
    # Now, read the rest of the file.
    # until we get to the last data point, an end-of-file or error
    set i 0
    while {[gets $fp line] >= 0} {
	incr lnum
	incr ptsread
	# change commas to blanks 
	#regsub -all , $line " " line
	
	if {$lnum > $::command(maxlines)} {
	    return "Read > $::command(maxlines) lines. Something is wrong or change command(maxlines)!"
	}
	set yyyy -1
	catch {
	    set xxxx [expr [lindex $line 0]]
	    set yyyy [expr [lindex $line 1]]
	}
	set yyyyesd -1
	catch {
	    set yyyyesd [expr [lindex $line 2]]
	}
	# set the esd
	if {$yyyyesd < 0} {
	    if {$yyyy <= 0} {
		set yyyyesd 1
	    } else {
		set yyyyesd [expr sqrt(1.0 * $yyyy )] 
	    }
	}
	# skip negative or garbled points
	if {[lindex $line 1] >= 0 && $yyyy >= 0} {
	    lappend ${data}(x)   $xxxx
	    lappend ${data}(y)   $yyyy		
	    lappend ${data}(esd) $yyyyesd
	} else {
	    # there are skipped points
	    set ${data}(skip) 1
	}
	incr ptsread
    }
	} errmsg] {
	# try to process the data we have read
	catch {resetdata $data}
	return "XY Data error. Error reading line $lnum: $errmsg"
    }
    resetdata $data
    lappend graph(plotlist) $data
    catch {close $fp} 
    #puts "$ptsread valid points read"
    return {}
}
