#-----------------------------------------------------------------
# read data from EPICS in MDA format, filtered through mda2ascii or mdaplot
# reads 11-BM Slew (fly) scans, but crudely kludged (krudely cludged?) 
# to do that.
#
# $Revision: 421 $ $Date: 2010-09-03 14:58:59 -0500 (Fri, 03 Sep 2010) $
#------- define a command line option -----------------------------
# command line option 
#lappend command(cmdopt) -epics -epics
# proc to use 
#set command(-EPICS) readEPICSdata
#set command(-epics) readEPICSdata
#--------define a dialog box entry
# menu label
lappend command(readtypes) "EPICS MDA data"
# proc for this entry
lappend command(readproc) ReadEPICS
# are the MDA processing programs anywhere to be found?
set dirlist [list {} $scriptdir [file join $scriptdir mdautils]]
if {$tcl_platform(platform) != "windows"} {
    lappend dirlist "/usr/local/bin" "~/bin" 
    foreach dir $dirlist {
	set command(mda_fltr) [auto_execok [file join $dir mda2ascii]]
	if {$command(mda_fltr) != ""} break
    }
} else {
    lappend dirlist "C:/MDAUTILS"  "~/MDAUTILS"
    foreach dir $dirlist {
	set command(mda_fltr) [auto_execok [file join $dir mda2ascii.exe]]
	if {$command(mda_fltr) != ""} break
    }
}
 
# allowed data types
if {$command(mda_fltr) != ""} {
    lappend command(filterlist) {ascii asc mda}
} else {
    lappend command(filterlist) {ascii asc}
}

# DEFINITIONS for these data types
#set command(ReadEPICS_ascii_type) "EPICS scan file"
#set command(ReadEPICS_asc_type) "EPICS scan file"
#set command(ReadEPICS_mda_type) "EPICS scan file"

proc ReadEPICS {file} {
    global command
    if {$file == ""} return
#    pleasewait "reading file $file"
    set ext [string tolower [file extension $file]]
    if {$ext == ".ascii"} {
	set ret [readEPICSdata $file]; # MDAplot output
    } else {
	set ret [readEPICSmda $file]; # MDA2ASCII output
    }
#    donewait
    if {$ret != ""} {return $ret}
    showlastentry $command(read_filelist)
}

#--------------------------------------------------------------------------
set command(FirstMonitor) 1
set command(chooseM) (none)
set command(MonitorScale) 1.0
trace variable command(FirstMonitor) w SpecDisableMonitorBoxes
trace variable command(chooseM) w SpecDisableMonitorBoxes
proc SpecDisableMonitorBoxes {args} {
    global command
    if {! [winfo exists .ask]} return
    if {$command(chooseM) == "(none)"} {
	.ask.4a.a config -fg gray
	.ask.4a.b config -state disabled
    } else {
	.ask.4a.a config -fg black
	.ask.4a.b config -state normal
    }
    if {$command(chooseM) == "(none)" || $command(FirstMonitor)} {
	.ask.4a.c.a config -fg gray
	.ask.4a.c.b config -state disabled
    } else {
	.ask.4a.c.a config -fg black
	.ask.4a.c.b config -state normal
    }
}
# load data from EPICS via MDA2ASCII or using MDA2ASCII as a filter
proc readEPICSmda {filename} {
    global graph command
    # signal errors by quitting
    if {[string tolower [file extension $filename]] == ".mda" && \
	    $command(mda_fltr) != ""} {
	set opencmd "| $command(mda_fltr) -o- $filename"
    } else {
	set opencmd $filename
    }
    set flnm [file tail $filename]
    set scnnm {?}

    if [catch {
	#puts "opening EPICS file $filename"
	set fl [open $opencmd r]
	set lnum 0
	set command(mode) 0
	set scan 0
	set mode step

	set ptsread 0
	# read the header
	set line {}
	while {[string trim $line] != "# 1-D Scan Values"} {
	    if {[gets $fl line] < 0} {return "Unexpected end of file"}
	    incr lnum
	    # store the extra PV info
	    if {[string range $line 0 9] == "# Extra PV"} {
		set ln [string range $line 10 end]
		set PVnum [string trim [lindex [split $ln ":"] 0]]
		set pos [string first {:} $ln]
		incr pos
		set ln [string range $ln $pos end]
		set key [string trim [lindex [split $ln ,] 0]]		
		set PV($key) $ln
		if {[regexp {scanNumber.*"([0-9]+)".*} $ln x y]} {set scnnm $y}
	    }
	    # parse put the column labels
	    if {[string trim $line] == "# Column Descriptions:"} {
		if {[gets $fl line] < 0} {return "Unexpected end of file"}
		incr lnum
		while {[set col [lindex $line 1]] != ""} {
		    # is this a slew scan? (not very well flagged at present)
		    if {[regexp {Positioner.*FLY.*} $line]} {set mode slew}
		    set x {[}; set delim {]}; # workaround for emacs indent bug
		    set pos [string first $delim $line]
		    incr pos
		    set lbl [string trim [lindex [split [string range $line $pos end] ,] 0]]
		    if {$lbl == ""} {set lbl "Index"}
		    lappend collist $lbl
		    if {[gets $fl line] < 0} {return "Unexpected end of file"}
		}
	    }
	}
	# slew scan, extract the start position & step
	if {$mode == "slew"} {
	    set scanstart {}
	    set scanstep {}
	    # format as of 2/1/07
	    foreach key [array names PV *slew*] {
		if {[string first start_tth $PV($key)] != -1} {
		    regexp {.*"(\-?[0-9]+\.?[0-9]*)".*} $PV($key) x scanstart
		}
		if {[string first step_size_input $PV($key)] != -1} {
		    regexp {.*"(\-?[0-9]+\.?[0-9]*)".*} $PV($key) x scanstep
		}
	    }
	    # original format
	    if {$scanstart == "" || $scanstep == ""} {
		foreach key [array names PV] {
		    if {$key == "11bmb:m28.RBV"} {
			regexp {.*"([0-9]+\.?[0-9]*)".*} $PV($key) x scanstart
		    }
		    if {$key == "11bmb:3820:Prescale"} {
			regexp {.*"([0-9]+\.?[0-9]*)".*} $PV($key) x prescale
			# convert preset to step size
			set scanstep [expr {0.0001 * int($prescale)}]
		    }
		}
	    }
	    if {$scanstart == "" || $scanstep == ""} {
		return "Error parsing slew scan step info"
	    }
	}
	# deal with defaults 
	if {[catch {set command(chooseX); }]} {
	    set command(chooseX)  [lindex $collist 1]
	    set command(chooseM) "(none)"
	}
	if {[lsearch $collist $command(chooseX)] == -1} {
	    set command(chooseX)  [lindex $collist 1]
	}
	if {[lsearch $collist $command(chooseM)] == -1 && $command(chooseM) != "(none)"} {
	    set command(chooseM) "(none)"
	}

	    
	# make a window to select x & y
	catch {toplevel .ask}
	eval destroy [winfo children .ask]
	pack [label .ask.1 \
		      -text "Choose the entries to read"] -side top
	pack [frame .ask.2] -side top
	pack [label .ask.2.a -text "X-axis"] -side left
	eval tk_optionMenu .ask.2.b command(chooseX) $collist
	pack .ask.2.b -side left
	pack [frame .ask.3 -bd 2 -relief groove] -side top
	pack [label .ask.3.a -text "Y-axis"] -side left
	set n 0
	foreach val $collist {
	    pack [checkbutton .ask.3.b_$n -text $val \
		  -variable command(chooseY_$n) -anchor w] -side top  -anchor w
	    incr n
	}
	pack [frame .ask.4] -side top
	pack [label .ask.4.a -text "Monitor"] -side left
	eval tk_optionMenu .ask.4.b command(chooseM) [concat (none) $collist]
	pack .ask.4.b -side left
	pack [frame .ask.4a] -side top
	pack [label .ask.4a.a -text "Scale Monitor to:" -anchor w] -side top -anchor w
	pack [checkbutton .ask.4a.b -text "First monitor value" \
		  -variable command(FirstMonitor)] -side top
	pack [frame .ask.4a.c] -side top
	pack [label .ask.4a.c.a -text "(or) value:"] -side left
	pack [entry .ask.4a.c.b -width 10 -textvariable command(MonitorScale)] -side left
	SpecDisableMonitorBoxes 
	pack [frame .ask.c] -side top
	pack [button .ask.c.c -text "Read" -command "destroy .ask"] -side left	
	putontop .ask
	tkwait window .ask
	afterputontop
	set n 0
	set indexlist {}
	set lbllist {}
	foreach var $collist {
	    if {$command(chooseY_$n)} {
		lappend indexlist $n
		lappend lbllist $var
	    }
	    incr n
	}

	set command(Xcol) [lsearch $collist $command(chooseX)]
	set command(Mcol) [lsearch $collist $command(chooseM)]
	set FirstMonitorVal $command(MonitorScale)
	if {$command(FirstMonitor)} {
	    set FirstMonitorVal ""
	} 

	set i -1
	while {[gets $fl line] >= 0} {
	    incr i
	    incr lnum
	    # rescue the incompetent
	    if {$lnum > 10*$::command(maxlines)} {
		return "Read > 10*$::command(maxlines) lines. Something is wrong or change command(maxlines)!"
	    }

	    # reading the data
	    set x [lindex $line $command(Xcol)] 
	    # kludge a slew scan correction for the scan var
	    if {$mode == "slew" && $command(chooseX) == "11bmb:m28.VAL"} {
		set x [expr {$scanstart + $i * $scanstep}]
	    }
	    if {$x != ""} {
		set mon [lindex $line $command(Mcol)]
		if {$command(chooseM) != "(none)" && \
			$FirstMonitorVal == "" && $mon != ""} {
		    set FirstMonitorVal $mon
		    # save this as the default for subsequent files
		    set command(FirstMonitor) 0
		    set command(MonitorScale) $mon		    
		}
		if {$command(chooseM) != "(none)"} {
		    catch {
			set scale [expr {(1.0* $FirstMonitorVal) / $mon}]
		    }
		} else {
		    set scale 1.
		}
		foreach n $indexlist {
		    set y [lindex $line $n]
		    if {$y != ""} {
			set esd 0
			catch {
			    expr $x
			    expr $y
			    set esd 1
			    # allow for negative values
			    catch {set esd [expr sqrt($y)]}
			    if {$command(chooseM) != "(none)"} {
				catch {
				    set y [expr {$y * $scale}]
				    set esd [expr {$esd * $scale}]
				}
			    }
			    lappend xlist($n) $x
			    lappend ylist($n) $y
			    lappend esdlist($n) $esd
			}
		    }
		}
		incr ptsread
	    }
	}
    } errmsg] {
	# try to process the data we have read
	append errmsg " "
    } else {
	set errmsg ""
    }
    if {$ptsread > 0} {
	catch {
	    foreach n $indexlist lbl $lbllist {
		set jj $n
		incr jj
		set data [file root [file tail $filename]]_$jj
		# eliminate spaces from the name
		regsub -all " " $data "_" data
		set data [initdata $data]
		global $data
		set ${data}(skip) 1
		set ${data}(xlabel) $command(chooseX)
		set ${data}(xunits) $command(chooseX)
		set ${data}(ylabel) $lbl
		set ${data}(title) "file $flnm scan $scnnm"
		if {$command(chooseM) != "(none)"} {
		    append set ${data}(title) " Monitor ($command(chooseM)) corrected"
		}
		set ${data}(x) $xlist($n)
		set ${data}(y) $ylist($n)
		set ${data}(esd) $esdlist($n)
		resetdata $data
		lappend graph(plotlist) $data
		#puts "$data: $ptsread valid points read"
	    }
	} err
	append errmsg $err
    }
    
    catch {close $fp} test
    if {$errmsg != ""} {
	return "EPICS error. Error reading line $lnum: $errmsg"
    }
    return {}
}

# load data from EPICS via MDAPLOT output
proc readEPICSdata {filename} {
    global graph command
    # signal errors by quitting
    if [catch {
	#puts "opening EPICS file $filename"
	set fl [open $filename r]
	set lnum 0
	set command(mode) 0
	set scan 0

	set ptsread 0
	# get a line
	gets $fl line
	incr lnum
	if {[string range $line 0 9] == "File name:"} {
	    set flnm [string range $line 11 end]
	} else {
	    puts "wrong line $lnum"
	}
	gets $fl line
	incr lnum
	if {[string range $line 0 9] == "Scan name:"} {
	    set scnnm [string range $line 11 end]
	} else {
	    puts "wrong line $lnum"
	}
	gets $fl line
	incr lnum
	if {[string range $line 0 10] == "Dimensions:"} {
	    set pts [lindex [split [string range $line 12 end] "\[\]"] 1]
	} else {
	    puts "wrong line $lnum"
	}
	gets $fl line
	incr lnum
	set collist $line
	# deal with defaults 
	if {[catch {set command(chooseX); }]} {
	    set command(chooseX)  [lindex $collist 1]
	    set command(chooseM) "(none)"
	}
	if {[lsearch $collist $command(chooseX)] == -1} {
	    set command(chooseX)  [lindex $collist 1]
	}
	if {[lsearch $collist $command(chooseM)] == -1 && $command(chooseM) != "(none)"} {
	    set command(chooseM) "(none)"
	}

	    
	# make a window to select x & y
	catch {toplevel .ask}
	eval destroy [winfo children .ask]
	pack [label .ask.1 \
		      -text "Choose the entries to read"] -side top
	pack [frame .ask.2] -side top
	pack [label .ask.2.a -text "X-axis"] -side left
	eval tk_optionMenu .ask.2.b command(chooseX) $collist
	pack .ask.2.b -side left
	pack [frame .ask.3 -bd 2 -relief groove] -side top
	pack [label .ask.3.a -text "Y-axis"] -side left
	set n 0
	foreach val $collist {
	    pack [checkbutton .ask.3.b_$n -text $val \
		  -variable command(chooseY_$n) -anchor w] -side top  -anchor w
	    incr n
	}
	pack [frame .ask.4] -side top
	pack [label .ask.4.a -text "Monitor"] -side left
	eval tk_optionMenu .ask.4.b command(chooseM) [concat (none) $collist]
	pack .ask.4.b -side left
	pack [frame .ask.4a] -side top
	pack [label .ask.4a.a -text "Scale Monitor to:" -anchor w] -side top -anchor w
	pack [checkbutton .ask.4a.b -text "First monitor value" \
		  -variable command(FirstMonitor)] -side top
	pack [frame .ask.4a.c] -side top
	pack [label .ask.4a.c.a -text "(or) value:"] -side left
	pack [entry .ask.4a.c.b -width 10 -textvariable command(MonitorScale)] -side left
	SpecDisableMonitorBoxes 
	pack [frame .ask.c] -side top
	pack [button .ask.c.c -text "Read" -command "destroy .ask"] -side left	
	putontop .ask
	tkwait window .ask
	afterputontop
	set n 0
	set indexlist {}
	set lbllist {}
	foreach var $collist {
	    if {$command(chooseY_$n)} {
		lappend indexlist $n
		lappend lbllist $var
	    }
	    incr n
	}

	set command(Xcol) [lsearch $collist $command(chooseX)]
	set command(Mcol) [lsearch $collist $command(chooseM)]
	set FirstMonitorVal $command(MonitorScale)
	if {$command(FirstMonitor)} {
	    set FirstMonitorVal ""
	} 


	while {[gets $fl line] >= 0} {
	    incr lnum
	    # rescue the incompetent
	    if {$lnum > 10*$::command(maxlines)} {
		return "Read > 10*$::command(maxlines) lines. Something is wrong or change command(maxlines)!"
	    }

	    # reading the data
	    set x [lindex $line $command(Xcol)] 
	    if {$x != ""} {
		set mon [lindex $line $command(Mcol)]
		if {$command(chooseM) != "(none)" && \
			$FirstMonitorVal == "" && $mon != ""} {
		    set FirstMonitorVal $mon
		    # save this as the default for subsequent files
		    set command(FirstMonitor) 0
		    set command(MonitorScale) $mon		    
		}
		if {$command(chooseM) != "(none)"} {
		    catch {
			set scale [expr {(1.0* $FirstMonitorVal) / $mon}]
		    }
		} else {
		    set scale 1.
		}
		foreach n $indexlist {
		    set y [lindex $line $n]
		    if {$y != ""} {
			set esd 0
			catch {
			    expr $x
			    expr $y
			    set esd 1
			    # allow for negative values
			    catch {set esd [expr sqrt($y)]}
			    if {$command(chooseM) != "(none)"} {
				catch {
				    set y [expr {$y * $scale}]
				    set esd [expr {$esd * $scale}]
				}
			    }
			    lappend xlist($n) $x
			    lappend ylist($n) $y
			    lappend esdlist($n) $esd
			}
		    }
		}
		incr ptsread
	    }
	}
    } errmsg] {
	# try to process the data we have read
	append errmsg " "
    } else {
	set errmsg ""
    }
    if {$ptsread > 0} {
	catch {
	    foreach n $indexlist lbl $lbllist {
		set jj $n
		incr jj
		set data [file root [file tail $filename]]_$jj
		# eliminate spaces from the name
		regsub -all " " $data "_" data
		set data [initdata $data]
		global $data
		set ${data}(skip) 1
		set ${data}(xlabel) $command(chooseX)
		set ${data}(xunits) $command(chooseX)
		set ${data}(ylabel) $lbl
		set ${data}(title) "file $flnm scan $scnnm"
		if {$command(chooseM) != "(none)"} {
		    append set ${data}(title) " Monitor ($command(chooseM)) corrected"
		}
		set ${data}(x) $xlist($n)
		set ${data}(y) $ylist($n)
		set ${data}(esd) $esdlist($n)
		resetdata $data
		lappend graph(plotlist) $data
		#puts "$data: $ptsread valid points read"
	    }
	} err
	append errmsg $err
    }
    
    catch {close $fp} test
    if {$errmsg != ""} {
	return "EPICS error. Error reading line $lnum: $errmsg"
    }
    return {}
}
