#-----------------------------------------------------------------
# read Kratos ASCII dump data file
#------- define a command line option -----------------------------
# command line option 
lappend command(cmdopt) -kratos
# proc to use 
set command(-kratos) readKratosdata
#--------define a dialog box entry
# menu label
lappend command(readtypes) "Kratos ASCII dump"
# proc for this entry
lappend command(readproc) ReadKratos
# allowed data types
lappend command(filterlist) {txt}
# definitions for these data types
set command(ReadKratos_txt_type) "Kratos ASCII dump"

proc ReadKratos {file} {
    global command
    if {$file == ""} return
    pleasewait "reading file $file"
    set ret [readKratosdata $file]
    donewait
    if {$ret != ""} {return $ret}
    showlastentry $command(read_filelist)
}

proc readKratosdata {filename} {

    #puts "opening Kratos file $filename"
    global graph

    set lnum 0
    # signal errors by quitting
    if [catch {
	set fp [open $filename r]
	# Initialize the data structure.
	set data [file root [file tail $filename]] 
	# eliminate spaces from the name
	regsub -all " " $data "_" data
	set data [initdata $data]
	global ${data}

	set ${data}(xlabel) "2theta"
	set ${data}(xunits) "2theta"
	set ${data}(ylabel) "counts"
	# Assume no missing points
	set ${data}(skip) 0
	set ptsread -1

	set lnum 0
	set eof [gets $fp line]
	while {$eof >= 0} {
	    if {[lindex $line 0] == "comment" && \
		    [lindex $line 1] == "="} {
		set ${data}(title) [lindex [split $line "="] 1]
	    } elseif {[lindex $line 0] == "#" && \
			  [lindex $line 1] == "Data"} {
		set ptsread 0
		break
	    }
	    incr lnum
	    set eof [gets $fp line]
	}
	# skip header line
	incr lnum
	set eof [gets $fp line]
	incr lnum
	set eof [gets $fp line]
	while {$eof >= 0} {
	    lappend ${data}(x) [lindex $line 0]
	    lappend ${data}(y) [lindex $line 1]
	    set num -1
	    catch {
		set num [expr {sqrt([lindex $line 1])}]
	    }
	    lappend ${data}(esd) $num
	    incr ptsread
	    if {$lnum > $::command(maxlines)} {
		return "Read > $::command(maxlines) lines. Something is wrong or change command(maxlines)!"
	    }
	    incr lnum
	    set eof [gets $fp line]
	}
	resetdata $data
    } errmsg] {
	# try to process the data we have read
	catch {resetdata $data}
	catch {close $fp}
	return "Kratos file error: $errmsg"
    }
    lappend graph(plotlist) $data
    catch {close $fp}
    if {$ptsread == -1} {
	return "Kratos file error. No Data section found."
    }
    #puts "$ptsread valid points read"
    return
}
