#-----------------------------------------------------------------
# read BT1 multidetector data as a pseudo-single detector file
# process .raw files through gformat and .bt1 files through 
# gformat and proprep
# .bt1 to .raw filter
set bt1(raw_fltr) ""
# .raw to .gsas merge banks filter
set bt1(merge_fltr) ""

# are the BT-1 processing programs anywhere to be found?
set dirlist [list {} $scriptdir]
if {$tcl_platform(platform) == "windows"} {
    foreach dir $dirlist {
	set f [file join $dir proprep.exe]
	if {[auto_execok $f] != ""} {
	  set bt1(raw_fltr) $f
	  break
	}
    }
    foreach dir $dirlist {
	set f [file join $dir gformat.exe]
	if {[auto_execok $f] != ""} {
	  set bt1(merge_fltr) $f
	  break
	}
    }
} else {
    lappend dirlist "/usr/local/bin ~/bin" 
    foreach dir $dirlist {
	set bt1(raw_fltr) [auto_execok [file join $dir proprep]]
	if {$bt1(raw_fltr) != ""} break
    }
    foreach dir $dirlist {
	set bt1(merge_fltr) [auto_execok [file join $dir gformat]]
	if {$bt1(merge_fltr) != ""} break
    }
}	
if {$bt1(raw_fltr) != "" && $bt1(merge_fltr) != ""} {
    # command line option 
    lappend command(cmdopt) -1D -1d
    # proc to use 
    set command(-1D) readgformatdata
    set command(-1d) readgformatdata
    #--------define a dialog box entry
    # menu label
    lappend command(readtypes) "BT-1 pseudo-1D"
    # proc for this entry
    lappend command(readproc) ReadBT1P
    # allowed data types
    lappend command(filterlist) {bt1 raw bt1gz}
    # definitions for these data types
    set command(ReadBT1P_bt1_type) "BT-1 as-collected"
    set command(ReadBT1P_bt1gz_type) "BT-1 as-collected compressed"
    set command(ReadBT1P_raw_type) "BT-1 proprep"
}

proc ReadBT1P {file} {
    global command
    if {$file == ""} return
    pleasewait "reading file $file"
    set ret [readgformatdata $file]
    donewait
    if {$ret != ""} {return $ret}
    showlastentry $command(read_filelist)
}

proc readgformatdata {filename} {
    global bt1 graph
    global command
    set lnum 0
    # signal errors by quitting
    if [catch {

	# is this a bt1 file? Check extensions.
	set ext [file extension $filename]
	if {$ext == ".bt1"} {
	    if {$command(debug)} {puts "opening BT1 file $filename"}
	    exec $bt1(raw_fltr) -f -k < $filename | \
		$bt1(merge_fltr) -f > bt1.tmp 2> bt1.err
	} elseif {$ext == ".bt1gz"} {
	    if {$command(debug)} {puts "opening compressed BT1 file $filename"}
	    exec gunzip < $filename | $bt1(raw_fltr) -f -k | \
		$bt1(merge_fltr) -f > bt1.tmp 2> bt1.err
	} elseif {$ext == ".raw"} {
	    if {$command(debug)} {puts "opening raw file $filename"}
	    exec $bt1(merge_fltr) -f < $filename > bt1.tmp 2> bt1.err
	} else {
	    return "file $filename has an invalid extension for BT1 data"
	}
	set fp [open bt1.tmp r]
	
	# output from gformat does not need to be checked as closely as 
	# the general GSAS case it will always be CONST - ESD format

	# 1st line is title
	incr lnum
	set eof [gets $fp title]
	if {$eof < 0} {return "end-of-file before BANK found"}
	# second line may be "Instrument parameter" line
	incr lnum
	set eof [gets $fp line]
	if {$eof < 0} {return "end-of-file before BANK found"} 
	# skip line if it does not contain BANK starting in the 1st column
	if {[string range $line 0 3] != "BANK"} {
	    incr lnum
	    set eof [gets $fp line]
	    if {$eof < 0} {return "end-of-file before BANK found"} 
	}
	set start [lindex $line 5]
	set step [lindex $line 6]
	set npts [lindex $line 2]
	if {[lindex $line 9] == ""} {set esdflag 0} {set esdflag 1}
	set ptnum 0
	set data [file root [file tail $filename]] 
	# eliminate spaces from the name
	regsub -all " " $data "_" data
	set data [initdata $data]
	global ${data}
	set ${data}(title) [string trim [string range $title 0 45]]
	set ${data}(xlabel) "2theta"
	set ${data}(xunits) "2theta"
	set ${data}(ylabel) "scaled counts"

	set ptsread 0
	# are there missing points?
	set ${data}(skip) 0
	if {$esdflag} {
	    while {$ptnum < $npts} {
		incr lnum
		set eof [gets $fp line]
		if {$eof < 0} {return "end-of-file before all data read"} 
		if {$lnum > $::command(maxlines)} {
		    return "Read > $::command(maxlines) lines. Something is wrong or change command(maxlines)!"
		}
		foreach num {0 16 32 48 64} {
		    set num7 [expr $num + 7]
		    set count [string trim [string range $line $num $num7]]
		    set num8 [expr $num + 8]
		    set num15 [expr $num + 15]
		    set esd [string trim [string range $line $num8 $num15]]
		    if {$count >= 0 && $esd > 0} {
			lappend ${data}(x) \
				[expr ($start+$step*$ptnum)/100.]
			lappend ${data}(y) $count
			lappend ${data}(esd) $esd
			incr ptsread
		    } else {
			# missing points
			set ${data}(skip) 1
		    }
		    incr ptnum
		}
	    }
	} else {
	    return "Incorrect format -- no ESD flag!"
	}
	
    } errmsg] {
	# try to process the data we have read
	catch {resetdata $data}
	return "BT1 error. Error reading line $lnum: $errmsg"
    }    
    resetdata $data
    lappend graph(plotlist) $data
    catch {close $fp} test
    file delete -force bt1.tmp bt1.err
    if {$command(debug)} {puts "$ptsread valid points read"}
    return {}
}
