#-----------------------------------------------------------------
# read BT1 multidetector data directly from the instrument
#-----------------------------------------------------------------
# This will run only in UNIX and only if 
# /net/charlotte/var/ftp/pub/icpdata/bt1/current/ is accessible 
# (within *.ncnr.nist.gov only) 
#------------------------------------------------------------------

# test if the command to get the file exists on this computer
if {[file isdirectory /net/charlotte/var/ftp/pub/icpdata/bt1/current/]} {

    #--------define a dialog box entry
    lappend command(readbuttons) "Read Active file on BT-1"
    lappend command(readbuttonproc) "ReadBT1active;displaylist"

    proc ReadBT1active {} {
	global command
	pleasewait "reading the active file"
	set ret [readBT1active]
	donewait
	if {$ret != ""} {return $ret}
	showlastentry $command(read_filelist)
    }

    #--------------------------------------------------------------------------
    # load multi detector data directly from BT1
    proc readBT1active {} {
	set filelist [glob -nocomplain /net/charlotte/var/ftp/pub/icpdata/bt1/current/*.bt1]
	if {[llength $filelist] == 0} {return "No current file found"}
	if {[info proc ReadBT1] == ""} {return "BT1 driver (read_bt1m.tcl) not loaded"}
	set msg {}
	foreach file $filelist {
puts $file
	    set fl [open $file r]
	    set ret [readbt1activemultidata $file $fl]
	    if {$ret != ""} {append msg \r $ret}
	}
	return $msg
    }
    # load multi detector data in BT1 .bt1 (as collected) format
    proc readbt1activemultidata {filename fl "zerocorr 1" "multcorr 1"} {
	#   zerocorr != 0 ==> apply detector zero correction
	#   multcorr != 0 ==> apply detector sensitivity correction
	#
	global bt1 graph
	global command
	
	set lnum 0

	# signal errors by quitting
	if [catch {
	    # get a line and turn single quotes into double
	    incr lnum
	    gets $fl line
	    regsub -all {'} $line {"} line
	    set prefact [expr [lindex $line 8] * [lindex $line 9]]
	    set npts [lindex $line 11]
	    incr lnum
	    gets $fl line
	    incr lnum
	    gets $fl line
	    set title [string trim $line]
	    incr lnum
	    gets $fl line
	    regsub -all {'} $line {"} line
	    set wave  [lindex $line 7]
	    set ndet [lindex $line 11]
	    incr lnum
	    gets $fl line
	    incr lnum
	    gets $fl line
	    incr lnum
	    gets $fl line
	    # get the scan range for motor 4
	    set start [lindex $line 1]
	    set step  [lindex $line 2]
	    incr lnum
	    gets $fl line
	    # get the normalization constants
	    incr lnum
	    gets $fl line
	    set j 0
	    for {set i 1} {$i <=$ndet} {incr i} {
		set norm_array($i) [lindex $line $j]
		if {[string trim $norm_array($i)] == ""} {
		    set j 0
		    incr lnum
		    gets $fl line
		    set norm_array($i) [lindex $line $j]
		}
		incr j
	    }
	    incr lnum
	    gets $fl line
	    # get the zero corrections
	    incr lnum
	    gets $fl line
	    set j 0
	    for {set i 1} {$i <=$ndet} {incr i} {
		set zero_array($i) [lindex $line $j]
		if {[string trim $zero_array($i)] == ""} {
		    set j 0
		    incr lnum
		    gets $fl line
		    set zero_array($i) [lindex $line $j]
		}
		incr j
	    }
	    incr lnum
	    gets $fl line
	    incr lnum
	    gets $fl line
	    for {set i 1} {$i <=$ndet} {incr i} {set pt($i) ""}
	    # read through the data add to the pt array
	    set i 1
	    while {[gets $fl line] >= 0} {
		incr lnum
		if {$lnum > $::command(maxlines)} {
		    return "Read > $::command(maxlines) lines. Something is wrong or change command(maxlines)!"
		}
		if {[string range $line 0 0] != "$"} {
		    # change commas to spaces
		    regsub -all {,} $line { } line
		    set j 0
		    # anything left to read?
		    while {[lindex $line $j] != ""} {
			lappend pt($i) [lindex $line $j] 
			incr i
			if {$i > $ndet} {set i 1}
			incr j
		    }
		}
	    }
	    close $fl
	    if {$i != 1} {
		return "Unable to parse, not enough points for all $ndet detectors"
	    }
	    
	    set norm 1
	
	    set bank 0
	    # is this old or new BT1 data?
	    if {$ndet == 5} {set bankoffset 20} {set bankoffset 5}
	    set ptsread 0
	    while {$bank < $ndet} {
		incr bank
		set data [file root [file tail $filename]]_$bank 
		# eliminate spaces from the name
		regsub -all " " $data "_" data
		set data [initdata $data]
		global $data
		set ${data}(xlabel) "2theta"
		set ${data}(xunits) "2theta"
		set ${data}(ylabel) "counts"
		set ${data}(title) "Bank $bank $title"
		set zero 0
		if {$zerocorr} {set zero $zero_array($bank)}
		set mult $norm
		if {$multcorr} {set mult [expr $norm_array($bank) * $norm]}
		#	puts "$bank $mult $norm_array($bank) * $norm"
		set ptnum 0
		foreach count $pt($bank) {
		    if {$count > 0} {
			lappend ${data}(x) \
			    [expr $start + ($bank-1.)*$bankoffset - $zero/100.\
				 + $step*$ptnum]
			lappend ${data}(y) [expr $mult*$count]
			lappend ${data}(esd) [expr $mult*sqrt($count)]
			incr ptsread
		    }
		    incr ptnum
		}
		resetdata $data
		lappend graph(plotlist) $data
	    }
	} errmsg] {
	    # try to process the last data we have read
	    catch {resetdata $data}
	    return "BT1m bt1 error. Error reading line $lnum: $errmsg"
	}
	catch {close $fp} test
	if {$command(debug)} {puts "$ptsread non-zero points read"}
	return {}
    }

}
