#-----------------------------------------------------------------
# read Sector 1 ASCII data files
#------- define a command line option -----------------------------
# command line option 
lappend command(cmdopt) -sector1
# proc to use 
set command(-sector1) readsector1data
#--------define a dialog box entry
# menu label
lappend command(readtypes) "Sector #1 new File"
# proc for this entry
lappend command(readproc) Readsector1
# allowed data types
if {$tcl_platform(platform) == "windows"} {
    lappend command(filterlist) {pow}
} else {
    lappend command(filterlist) {pow POW}
}
# definitions for these data types
set command(Readsector1_pow_type) "POW data"
set command(Readsector1_POW_type) "POW data"


proc Readsector1 {file} { 
    global command
    if {$file == ""} return
    pleasewait "reading file  $file"
    set ret [readsector1data $file]
    donewait
    if {$ret != ""} {return $ret}
    showlastentry $command(read_filelist)
}
#proc pop_up_zerocorrection { z } {
#pack [label .pop_up_zerocorrection -text "Zero Correction "] -side left
#pack [entry .pop_up_zerocorrection -variable z] -side left
#}
proc readsector1data {filename} {

    puts "opening POW file $filename"
    global graph zerocorrect

    if {[catch {set zerocorrect(value)}]} {set zerocorrect(value) ""}
    set lnum 0

    # signal errors by quitting
    if [catch {
	set fp [open $filename r]

	
	# Great!! Now we are positioned to read the data.  We need to normalize
	# the data and calculate esds.  We will use the first datapoint
	# in the file as our reference.   We will normalize everything to
	# the IO of this reading.
	
	# Initialize the data structure.
	set data [file root [file tail $filename]] 
	initdata $data
	global ${data}
	set ${data}(xlabel) "2theta"
	set ${data}(xunits) "2theta"
	set ${data}(ylabel) "scaled counts"
	# No missing points
	set ${data}(skip) 0
	set ${data}(title) "POW data"
	set ptsread 0
	set ${data}(zerocorrect) $zerocorrect(value) 

	# Now, read the rest of the file.  Continue reading 
	# until we get to the last data point, an end-of-file or error
	set firstpass 1
	set i 0
	set coltime 2
	set colangle 0
	set colct 5
	set colmon 4
	set colma 9
	while {[gets $fp line] >= 0} {
          set nolinehere 1
          regexp {#.*} [lindex $line 0] match nolinehere
          if { $nolinehere == 1 && [lindex $line 0] > 0} {
	    incr lnum
	    #  puts "$lnum\t>$line< $nolinehere >" 
	    if {$lnum > $::command(maxlines)} {
		return "Read > $::command(maxlines) lines. Something is wrong or change command(maxlines)!"
	    }
	    if {$zerocorrect(value) == 0.0 || $zerocorrect(value) == ""} {
	    set angle [lindex $line $colangle]
	    } else {
	    set angle [expr ( [lindex $line $colangle] + $zerocorrect(value) )]
	    }
	    set ctimetemp [lindex $line $coltime]
	    set ctime [expr (1.0*$ctimetemp)/10000000.0]
	    set count [lindex $line $colct]
	    set mon   [lindex $line $colmon]
	    set matemp    [lindex $line $colma]
	    set ma [expr ((1.0*$matemp)-($ctime*500.0))/($ctime*5000.0)]
	    
	    if $firstpass {
		set firstpass 0
		set firstmon $mon
		set firstma $ma
		set firstct $ctime
		puts $firstma
		puts $firstmon
		puts $ctime
	    } 
	    # puts $angle
	    #the data is normalized internally by the monitor which also
	    #takes care of differences in counting times.  However, when
	    #running a long series of reaction scans, there is no mechanism
	    #to normalize among the scans so I have added a normalization
	    #factor based on the initial ma reading relative to 100 ma.
	    lappend ${data}(x) $angle
#		set ratio [expr $mon/(1.0*$firstmon)]
#		puts $ratio
	    lappend ${data}(y) [expr ((1.0*$count)*((1.0*$firstmon)/(1.0*$mon))/$firstct) \
		*(100.0/(1.0*$firstma))]
#	    lappend ${data}(y) [expr (1.0*$count)*((1.0*$firstmon)/(1.0*$mon))]
	    lappend ${data}(esd) [expr (sqrt(1.0*$count)*((1.0*$firstmon)/(1.0*$mon))/$firstct) \
		*(100.0/(1.0*$firstma))]
#	    lappend ${data}(esd) [expr sqrt(1.0*$count)*((1.0*$firstmon)/(1.0*$mon))]
	    incr ptsread
          } else {
	    set nocolumn 1
	    regexp {#N.*} [lindex $line 0] match nocolumn
		if {$nocolumn != 1} {
		    set colct [expr int([lindex $line 2])-1]
		    set colmon [expr int([lindex $line 3])-1]
		    set colma [expr int([lindex $line 4])-1]
		    set coltime [expr int([lindex $line 5])-1]
		    set colangle [expr int([lindex $line 6])-1]
		}
	  }
	}
    } errmsg] {
	# try to process the data we have read
	catch {resetdata $data}
	return "POW error. Error reading line $lnum: $errmsg"
    }
    resetdata $data
    lappend graph(plotlist) $data
    catch {close $fp} test
    puts "$ptsread valid points read"
    return {}
}
