#!/usr/local/bin/tclsh
# this script fetches a JCPDS-ICDD card and write it out in format 
# that can be executed in tcl
#
# where are we?
set scriptname [info script]
# translate links -- go six levels deep
foreach i {1 2 3 4 5 6} {
    if {[file type $scriptname] == "link"} {
	set link [file readlink $scriptname]
	if { [file  pathtype  $link] == "absolute" } {
	    set scriptname $link
	} {
	    set scriptname [file dirname $scriptname]/$link
	}
    } else {
	break
    }
}
set scriptdir [file dirname $scriptname]
lappend auto_path $scriptdir
package require logic
if {$argv == ""} {
    puts "\nno card number specified"
    puts "\n\tusage: $argv0 <cardnumber>\n"
    exit
}
set num {}
catch {set num [findnumber -and -list $argv]}
if {$num == {}} {puts stderr "card number not found";exit}
if {$num > 1} {puts stderr "too many ($num) cards found";exit}
set list [getpdf2 -seq [nexthit -first ] ]
foreach line $list {
    if {[string range $line 79 79 ] == "I"} {
	foreach j {0 23 46} {
	    foreach i {6 2 0 2 2 2} var {d int f h k l} {
		set ll [expr $j + $i]
		set $var [string trim [string range $line $j $ll ]]
		if {[set $var] == ""} {set $var 0}
		set j [expr $ll + 1]
	    }   
	    if {$d > 0} {
		lappend hlist $h
		lappend klist $k
		lappend llist $l
		lappend dlist $d
		lappend intlist $int
		#puts "$h $k $l $d $int"
	    }
	}
    }
}
puts "set h [list $hlist]"
puts "set k [list $klist]"
puts "set l [list $llist]"
puts "set d [list $dlist]"
puts "set int [list $intlist]"
