#--------------------------------------------------------------------
# GUI for combining and linearly interplolating data sets
# starting draft by A.McGhie - finished by B. Toby and R. Harlow

# queue a command to execute later
lappend command(ExecuteLater) SetupInterp

proc SetupInterp {} {
    global scriptdir interp menulist helplist
    # initial conditions
    if {$::tcl_platform(platform) == "windows"} {
	set interp(program) [file join $::command(exedir) linterp.exe]
    } else {
	set interp(program) [file join $::command(exedir) linterp]
    }
    
    if {[file exists $interp(program)]} {
	set interp(newname) {}
	foreach var {ttmin ttmax dlt} {
	    set interp($var) {}
	}
	lappend menulist(compute) Interp
	lappend menulist(pages) Interp
	set helplist(Interp) {
	    Interpolate File(s)
	}
    }

    foreach var {ttmin ttmax ns s} {
	trace variable interp($var) w UpdateInterpOutputFile
    }

    # deal with deleting regions
    bind .plot <Key-d> {SetupDeleteRegion %x}
    bind .plot <Key-D> {SetupDeleteRegion %x}
    bind .plot <Key-n> AddInterpDelete
    bind .plot <Key-N> AddInterpDelete
}

# create the Interp page (once)
proc MakeInterp {page} {
    global graph interp command

    #pack [frame $page.a] -side left -fill y -anchor n
    grid [frame $page.a] -column 1 -row 1 -sticky news
    grid columnconfigure $page 1 -weight 1
    pack [label $page.a.t1 -text {Select Dataset(s) to}] -side top
    pack [label $page.a.t2 -text {interpolate/merge}] -side top
#    pack [frame $page.a.2 ] -side top -expand yes -fill y
    pack [frame $page.a.2 ] -side top
    makeselectbox $page.a.2
    # makeselectbox creates $page.a.2.1 with datafiles
    bind $page.a.2.1 <<ListboxSelect>> "InterpUpdate $page.a.2"
    bind $page.a.2.1 <Button-3> "[bind $page.a.2.1 <Button-3>]; InterpUpdate $page.a.2"
    bind $page.a.2.1 <Double-Button-1> "InterpUpdate $page.a.2; displayinterp"
    #pack [frame $page.a1 -borderwidth 3 -relief groove]  -side left -fill both -anchor n -expand yes
    grid [frame $page.a1 -borderwidth 3 -relief groove] \
	-column 2 -row 1 -sticky news
    grid columnconfigure $page 2 -weight 1
    #pack [frame $page.a2]  -side left -fill both -anchor n -expand yes
    grid [frame $page.a2] -column 3 -row 1 -sticky news
    grid [frame $page.a2.a -borderwidth 3 -relief groove] \
	-column 1 -row 1 -sticky nsew
    grid [frame $page.a2.b -borderwidth 3 -relief groove]  \
	-column 1 -row 2 -sticky nsew
    grid rowconfigure $page.a2 2 -weight 1
    #grid columnconfigure $page.a2 1 -weight 1
    #################################################################

    #################################################################
    set rown 1

    #grid rowconfigure $page.a1 $rown -minsize 20
    #incr rown

    grid [label $page.a1.c1$rown -text Method] -column 1 -columnspan 2 -row $rown
    incr rown
    grid [radiobutton $page.a1.c1$rown -text "Linear interpolation" \
	    -variable interp(spline) -value 0 \
	    -command "DisableSpline $page.a.2"] \
	    -column 1 -columnspan 2 -row $rown -sticky w
    incr rown
    grid [radiobutton $page.a1.c1$rown -text "Spline interpolation" \
	    -variable interp(spline) -value 1 \
	    -command "DisableSpline $page.a.2"] \
	    -column 1 -columnspan 2 -row $rown -sticky w
    incr rown
    grid [radiobutton $page.a1.c1$rown -text "Rebin (no interpolation)" \
	    -variable interp(spline) -value 2 \
	    -command "DisableSpline $page.a.2"] \
	    -column 1 -columnspan 2 -row $rown -sticky w
    set interp(spline) 0

    incr rown
    grid rowconfigure $page.a1 $rown -minsize 10
    grid columnconfigure $page.a1 2 -weight 1
    incr rown
    grid [label $page.a1.c1$rown -text {Spline Variables}] -column 1 -columnspan 2 -row $rown
    set  interp(spline_widgets) $page.a1.c1$rown

    incr rown
    grid [label $page.a1.c1$rown -text "Pts in spline:  "] -column 1 -row $rown
    lappend interp(spline_widgets) $page.a1.c1$rown
 
    grid [entry $page.a1.c2$rown -width 8 \
	    -textvariable interp(ns)] -column 2 -row $rown 
    lappend interp(spline_widgets) $page.a1.c2$rown 

    incr rown
    grid [label $page.a1.c1$rown -text "Spline smooth:  "] -column 1 -row $rown 
    lappend interp(spline_widgets) $page.a1.c1$rown
    grid [entry $page.a1.c2$rown -width 8 \
	    -textvariable interp(s)] -column 2 -row $rown 
    lappend interp(spline_widgets) $page.a1.c2$rown


    incr rown
    grid rowconfigure $page.a1 $rown -minsize 20
    incr rown


    grid [label $page.a1.c1$rown -text {Output parameters}] -column 1 -columnspan 2 -row $rown

    incr rown
    grid [label $page.a1.c1$rown -text "2Theta min:  "] \
	    -column 1 -row $rown -sticky e
 
    grid [entry $page.a1.c2$rown -width 10 \
	    -textvariable interp(ttmin)] -column 2 -row $rown -sticky ew

    incr rown
    grid [label $page.a1.c1$rown -text "2Theta max:  "] \
	-column 1 -row $rown -sticky e
    grid [entry $page.a1.c2$rown -width 10 \
	    -textvariable interp(ttmax)] -column 2 -row $rown -sticky ew

    incr rown
    grid [label $page.a1.c1$rown -text "2Theta step:"] \
	-column 1 -row $rown -sticky e
    grid [entry $page.a1.c2$rown -width 10 \
	    -textvariable interp(dlt)] -column 2 -row $rown -sticky ew

    incr rown
    grid [label $page.a1.c1$rown -text "Wavelength:"] \
	-column 1 -row $rown -sticky e
    grid [entry $page.a1.c2$rown -width 10 \
	    -textvariable interp(wave)] -column 2 -row $rown -sticky ew

    incr rown
    grid [label $page.a1.c1$rown -text {Output Name}] -column 1 -columnspan 2 -row $rown

    incr rown
    grid [entry $page.a1.c2$rown -width 25 \
	    -textvariable interp(newname)] -column 1 -columnspan 2 \
	-row $rown -sticky news

 
    #################################################################
    incr rown
    grid rowconfigure $page.a1 $rown -minsize 20
    incr rown
    grid [button $page.a1.b1 -text "Run" \
		-command "runInterp $page.a.2" ] -row $rown -column 1 -columnspan 3 
    set interp(run_button) $page.a1.b1

    set interp(plot_button) $page.a.4
    pack [button $page.a.4    -text "  Update Plot  " \
	      -command "getfilelist $page.a.2; displayinterp"] -side bottom
    pack [checkbutton $page.a.5 -text "Stack plots" \
	      -command "$page.a.4 invoke" \
	      -variable command(inter_offset)] -side bottom
    #################################################################
    set command(exclude_points_box) $page.a2.a
    set command(interp_data_range) -1
    grid [label $page.a2.a.alab -text "Points to exclude" -justify center] \
	-column 0 -columnspan 6 -row 0 -sticky new
    grid [label $page.a2.a.a1 -text "Before\n#"] \
	-column 0 -row 1 -sticky nes
    grid [entry $page.a2.a.a2 -textvariable command(exclude_below)\
	     -width 6] -column 1 -row 1 -sticky e
    grid [label $page.a2.a.a3 -text " fraction: "] \
	-column 2 -row 1 -sticky nes
    grid [scale $page.a2.a.a4 -orient horizontal -from 0 -to 1 \
	      -resolution 0.05 -variable command(exclude_min_frac) \
	      -command {SetInterpExcludeFraction exclude_below} \
	     ] -column 3 -row 1 -sticky nes
    bind $page.a2.a.a2 <Leave> {SetInterpExcludePoints 1}
    bind $page.a2.a.a2 <Return> {SetInterpExcludePoints 1}
    grid [label $page.a2.a.b1 -text "After\n #"] \
	-column 0 -row 2 -sticky nes
    grid [entry $page.a2.a.b2 -textvariable command(exclude_after)\
	     -width 6] -column 1 -row 2 -sticky e
    grid [label $page.a2.a.b3 -text " fraction: "] \
	-column 2 -row 2 -sticky nes
    grid [scale $page.a2.a.b4 -orient horizontal -from 0 -to 1 \
	      -resolution 0.05 -variable command(exclude_max_frac) \
	      -command {SetInterpExcludeFraction exclude_after} \
	     ] -column 3 -row 2 -sticky nes
    bind $page.a2.a.b2 <Return> {SetInterpExcludePoints 0}
    bind $page.a2.a.b2 <Leave> {SetInterpExcludePoints 0}
    grid [label $page.a2.a.flab -text "" -justify left] \
	-column 0 -columnspan 6 -row 3 -sticky new

    set command(delete_region_box) $page.a2.b
    grid [label $page.a2.b.l -text "Regions to Ignore"] -column 1 -row 0 -sticky new
    grid [canvas $page.a2.b.c -scrollregion {0 0 500 500} -width 0 -height 100 \
	      -xscrollcommand "$page.a2.b.x set" \
	      -yscrollcommand "$page.a2.b.y set"] \
	-column 1 -row 1 -sticky news

    grid columnconfigure $page.a2.b 1 -weight 1
    grid rowconfigure $page.a2.b 1 -weight 1

    grid [scrollbar $page.a2.b.x -orient horizontal -command "$page.a2.b.c xview"] \
	-column 1 -row 2 -sticky ew
    grid [scrollbar $page.a2.b.y  -command "$page.a2.b.c yview"] -column 2 -row 1 -sticky ns

    frame [set command(deleteframe) $page.a2.b.c.fr]
    $page.a2.b.c create window 0 0 -anchor nw -window $command(deleteframe)
    grid [button $page.a2.b.b -text "Add Region" -command AddInterpDelete] \
	-column 1 -row 3
    DisableSpline $page.a.2
}
proc SetInterpExcludeFraction {var val} {
    global command
    catch {
	set command($var) [expr {int($command(interp_data_range)*$val + 0.5)}]
	if {$command($var) <= 0} {set command($var) 1}
    }
}
proc SetInterpExcludePoints {below} {
    global command
    if $below {
	catch {set command(exclude_min_frac) [ \
				       expr {1.*$command(exclude_below) / \
					     $command(interp_data_range)} \
					   ]}
    } else {
	catch {set command(exclude_max_frac) [ \
				       expr {1.*$command(exclude_after) / \
					     $command(interp_data_range)} \
					   ]}
    }
}
SetInterpExcludePoints 0

proc SetExcludePointsBox {on "length ?"} {
    foreach w [winfo children $::command(exclude_points_box)] {
	if $on {
	    catch {$w config -state normal}
	} else {
	    catch {$w config -state disabled}
	}
    }
    if $on {
	set ::command(interp_data_range) $length
	$::command(exclude_points_box).flab config -state normal \
	    -text "All datasets have $length points" -fg black
	set ::command(exclude_below) 1
	set ::command(exclude_after) $length
	SetInterpExcludePoints 0
	SetInterpExcludePoints 1
    } else {
	$::command(exclude_points_box).flab config -state normal \
	    -text "(Datasets have unequal lengths)" -fg red
	set ::command(interp_data_range) -1
    }
}

# "cleanup" the Interp page each time it is selected
proc PostPageInterp {page}  {
    global graph interp command
    updateselectbox $page.a.2
    $interp(run_button) config -state disabled
    foreach w $interp(spline_widgets) {
	$w config -fg gray
	catch {$w config -state disabled}
    }
    eval destroy [winfo children $command(deleteframe)]
    resizeInterpDelete
    set interp(deleteentries) 0
    set interp(deleteselected) 0
    eval $graph(blt) marker delete  [$graph(blt) marker names]
    SetExcludePointsBox 0
    # resize
    wm geom . {}
}    

# disable the spline inputs except when needed
proc DisableSpline {box} {
    InterpUpdate $box
    global interp
    foreach w $interp(spline_widgets) {
	if {$interp(spline) == 1} {
	    $w config -fg black
	    catch {$w config -state normal}
	} else {
		$w config -fg gray
	    catch {$w config -state disabled}
	}
    }
}

# update the data limits each time a file is selected or the 
# Interp method changes (see DisableSpline)
proc InterpUpdate {box} {
    global graph interp
    getfilelist $box
    set xmin ""
    set xmax ""
    set xstep ""
    if {[llength $graph(plotlist)] == 0} return
    set nw 0
    set wa 0
    set invalidwave 0
    set nptsmin {}
    set nptsmax {}
    foreach data $graph(plotlist) {
	global $data 
	if {[set ${data}(type)] == "peaks"} continue
	set xvector [set ${data}(xvector)]
	global $xvector
	set npts [$xvector length]
	if {$nptsmin == {}} {
	    set nptsmin $npts
	    set nptsmax $npts
	}
	if {$npts < $nptsmin} {set nptsmin $npts}
	if {$npts > $nptsmax} {set nptsmax $npts}
	set min [set ${xvector}(min)] 
	if {$xmin == ""} {
	    set xmin $min
	} elseif {$min < $xmin} {
	    set xmin $min
	}
	set max [set ${xvector}(max)]
	if {$xmax == ""} {
	    set xmax $max
	} elseif {$max > $xmax} {
	    set xmax $max
	}
	set step [expr {($max - $min)/($npts - 1)}]
	if {$xstep == ""} {
	    set xstep $step
	} elseif {$step > $xstep} {
	    set xstep $step
	}
	set w [set ${data}(wavelength)]
	if {$w != ""} {
	    incr nw
	    set wa [expr {$wa + $w}]
	} else {
	    set invalidwave 1
	}
    }
    set interp(ttmin) $xmin
    set interp(ttmax) $xmax
    if {$invalidwave} {
	set interp(wave) "(not used)"
    } else {
	set interp(wave) [expr {$wa/$nw}]
    }
    if {$interp(spline) == 2} {
	set interp(dlt)   [expr {2*$xstep}]
    } else {
	set interp(dlt)   $xstep
    }
    if {[catch {expr {$xmin+$xmax+$xstep}}]} {
	$interp(run_button) config -state disable
    } else {
	$interp(run_button) config -state normal
    }
    if {$nptsmax == $nptsmin} {
	SetExcludePointsBox 1 $nptsmax
    } else {
	SetExcludePointsBox 0
    }
}

proc UpdateInterpOutputFile {args} {
    global interp graph
    set interp(newname) [lindex $graph(plotlist) end]
    append interp(newname) "_$interp(ttmin)"
    append interp(newname) "_$interp(ttmax)" 
    if {$interp(spline) == 1} {
	append interp(newname) "_$interp(ns)" 
    } elseif {$interp(spline) == 2} {
	append interp(newname) "_bin"
    }
}

# add a region to delete (button press, or N key)
proc AddInterpDelete {} {
    if {$::command(pagenow) != "interp"} return
    global command interp graph
    set bx $command(deleteframe)
    set filelist {}
    foreach data $graph(datalist) {
	global $data 
	if {[set ${data}(type)] == "peaks"} continue
	lappend filelist $data
    }
    if {[llength $filelist] == 0} return
    set i [incr interp(deleteentries)]
    eval tk_optionMenu $bx.a$i command(delete$i) "(select)" $filelist
    set  command(delete$i) "(select)"
    if {[trace vinfo command(delete$i)] == ""} {
	trace variable command(delete$i) w resizeInterpDelete
    }
    grid $bx.a$i -column 1 -row $i
    grid [entry $bx.b$i -width 10 -textvariable interp(b$i)] -column 2 -row $i
    grid [entry $bx.c$i -width 10 -textvariable interp(e$i)] -column 3 -row $i
    set interp(b$i) ""
    set interp(e$i) ""
    resizeInterpDelete
}

# resize & show the scroll bars for the deleted regions canvas
proc resizeInterpDelete {args} {
    update idletasks
    set bx $::command(delete_region_box)
    set bbox [grid bbox $bx.c.fr]
    set w [lindex $bbox 2]
    set h [expr [winfo height $bx.c] -6]
    $bx.c config -scrollregion $bbox -width $w -height $h
    # show the scrolls when needed
    if {[lindex $bbox 3] > [winfo height $bx.c]} {
	grid $bx.y -sticky ns -column 2 -row 1
    } else {
	grid forget $bx.y 
    }
    if {[lindex $bbox 2] > [winfo width $bx.c]} {
	grid $bx.x -sticky ew -column 1 -row 2
    } else {
	grid forget $bx.x
    }
}

# respond to the "D" key; mark the beginning point and draw a red line
# when D is pressed again, mark the range and draw all regions
proc SetupDeleteRegion { x } {
    if {$::command(pagenow) != "interp"} return
    global graph interp
    if {$interp(deleteentries) == 0} AddInterpDelete

    set x [format %.3f \
	    [$graph(blt) xaxis invtransform $x]]
    if {$interp(deleteselected) == 0} {
	set i $interp(deleteentries)
	set interp(b$i) $x
	set interp(deleteselected) $i
	$graph(blt) marker create line -name temp -coords "$x -Inf $x -Inf"\
	    $graph(MarkerColorOpt) red -linewidth 2 -under 1
	bind $graph(blt) <Motion> "InterpShowDelete $x $i %x"
    } else {
	bind $graph(blt) <Motion> ""
	set i $interp(deleteselected)
	set interp(e$i) $x
	set interp(deleteselected) 0
    }
    # redraw deleted regions
    if {$interp(deleteselected) == 0} {
	eval $graph(blt) marker delete  [$graph(blt) marker names]
	for {set i 1} {$i <= $interp(deleteentries)} {incr i} {
	    set x1 $interp(b$i)
	    set x2 $interp(e$i)
	    if {[catch {expr {$x1+$x2}}]} continue
  	    $graph(blt) marker create line -coords "$x1 -Inf $x2 -Inf"\
		$graph(MarkerColorOpt) yellow -linewidth 5 -under 1
	}
    }
}

# draw a red line from the region starting position to the current 
# mouse position
proc InterpShowDelete {x1 i x} {
    if {$::command(pagenow) != "interp"} return
    global graph interp
    set x2 [format %.3f \
	    [$graph(blt) xaxis invtransform $x]]
    set interp(e$i) $x2
    catch {
	$graph(blt) marker configure temp -coords "$x1 -Inf $x2 -Inf"
    }
}

# respond to the "Run" button
proc runInterp {box} {
    global interp graph command
    getfilelist $box

    if {[llength $graph(plotlist)] == 0} return

    set maxin 0
    foreach data $graph(plotlist) {
	global $data 
	set n [[set ${data}(xvector)] length]
	if {$n > $maxin} {set maxin $n}
    }

    set fp [open interp.inp w]
    puts $fp "$maxin"
    puts $fp [expr {int(1+($interp(ttmax)-$interp(ttmin))/$interp(dlt))}]
    puts $fp "$interp(ttmin), $interp(ttmax), $interp(dlt)"
    puts $fp "$interp(spline)"
    if {$interp(spline) == 1} {
	puts $fp "$interp(ns), $interp(s)"
    }

    set newwave $interp(wave)
    if {[catch {expr $newwave} errmsg]} {
	set newwave ""
    } elseif {$newwave <= 0} {
	set newwave ""
    } else {
	# are all wavelengths the same as the target?
	set flag 1
	foreach data $graph(plotlist) {
	    global $data 
	    if {[set ${data}(type)] == "peaks"} continue
	    if {[set ${data}(wavelength)] != $newwave} {set flag 0}
	}
	if {$flag} {set newwave ""}
    }
    set interp(status) "starting"
    pleasewait "while" interp(status)

    foreach data $graph(plotlist) {
	global $data 
	if {[set ${data}(type)] == "peaks"} continue
	set interp(status) "processing $data"
	update
	# reset the data arrays
	[set ${data}(xvector)] set [set ${data}(x)]
	[set ${data}(yvector)] set [set ${data}(y)]
	[set ${data}(esdvec)] set [set ${data}(esd)]
	if {$newwave != ""} {
	    set interp(status) "set wavelength for $data"
	    ConvertX $data "2theta" $newwave
	    [set ${data}(xvector)] notify now
	}
	update
	set xvector [set ${data}(xvector)]
	#global $xvector
	set yvector [set ${data}(yvector)]
	#global $yvector
	set esdvec [set ${data}(esdvec)]
	#global $esdvec
	# compile list of drop ranges for current file
	set xminlist {}
	set xmaxlist {}
	for {set i 1} {$i <= $interp(deleteentries)} {incr i} {
	    if {$command(delete$i) != $data} {continue}
	    set x1 $interp(b$i)
	    set x2 $interp(e$i)
	    if {[catch {expr {$x1+$x2}}]} continue
	    if {$x1 > $x2} {
		set t $x1
		set x1 $x2
		set x2 $t
	    }
	    lappend xminlist $x1
	    lappend xmaxlist $x2
	}
	if {$::command(interp_data_range) > 0} {
	    set num1 $::command(exclude_below)
	    incr num1 -1 
	    set num2 $::command(exclude_after)
	    incr num2 -1 
	} else {
	    set num1 0
	    set num2 end
	}
	set droplist {}
	set j $num1
	foreach x [$xvector range $num1 $num2] \
	    y [$yvector range $num1 $num2] \
	    e [$esdvec  range $num1 $num2] {
		set drop 0
		foreach x1 $xminlist x2 $xmaxlist {
		    if {$x >= $x1 && $x <= $x2} {
			set drop 1
			break
		    }
		}
		if {$drop} {
		    lappend droplist $j
		    puts $fp "$x, $y, -1"
		} else {
		    puts $fp "$x, $y, $e"
		}
		incr j
	    }
	puts $fp "-999., -999., -999."
	if {$droplist != ""} {
	    eval $xvector del $droplist
	    eval $yvector del $droplist
	    eval $esdvec del $droplist
	    $xvector notify now
	}
    }
    close $fp
  #    run BT's fortran program
    set interp(status) "running interp"
    update
    exec $interp(program) < interp.inp
    set interp(status) "reading back input"
    update
    source interp.out

    donewait
    set newdata $interp(newname)

    set newdata [initdata $newdata]
    global ${newdata}
    # set attributes
    set ${newdata}(xlabel) "2theta"
    set ${newdata}(xunits) "2theta"
    set ${newdata}(ylabel) "intensity"
    # no skipped points
    set ${newdata}(skip) 0
    # store the results
    set ${newdata}(x) $newx
    set ${newdata}(y) $newy
    set ${newdata}(esd) $newesd
    # set rescaling to unity
    resetdata $newdata
    # add the new file to the plot list
    if {[lsearch $graph(plotlist) $newdata] == -1} {
	lappend graph(plotlist) $newdata
    }
    updateselectbox $box
    displayinterp
    # file delete interp.inp
}

# displayinterp plots the entries in graph(plotlist)
proc displayinterp {} {
    global graph command
    $::interp(plot_button) config -relief sunken
    update idletasks
    eval $graph(blt) element delete [$graph(blt) element names]
    eval $graph(blt) marker delete  [$graph(blt) marker names]
    set firstpass 1
    if {$graph(ReversePlotOrder)} {
	set itemstoplot [ReverseList $graph(plotlist)]
    } else {
	set itemstoplot $graph(plotlist) 
    }
    set num -1
    set  colorlist "#00ff00 #ff0000 #0000ff #00ffff #ff00ff #ffff00"
    set lcolorlist "#c0ffc0 #ffc0c0 #c0c0ff #c0ffff #ffc0ff #ffffc0"
    foreach data $itemstoplot {
	global $data 
	incr num
	set col [lindex $colorlist [expr $num % 6]]
	set lcol [lindex $lcolorlist [expr $num % 6]]
	if {$firstpass} {
	    $graph(blt) xaxis configure -title [set ${data}(cxlabel)]
	    $graph(blt) yaxis configure -title [set ${data}(cylabel)]
	    set firstpass 0
	}
 	catch {
 	    vector create ${num}xa ${num}xb ${num}xc
 	    vector create ${num}ya ${num}yb ${num}yc
 	}
	if {$::command(interp_data_range) > 0} {
	    set num1 $::command(exclude_below)
	    incr num1 -1 
	    set num2 $::command(exclude_after)
	    incr num2 -1 
	} else {
	    set num1 0
	    set num2 end
	}
	set var [[set ${data}(yvector)] variable]
	global $var
	set ymax$num [set [set var](max)]
	if {$num == 0} {
	    set ymax [set ymax$num]
	} elseif {$num == 1} {
	    set ymax1 [set [set ${data}(yvector)](max)]
	    if {[set ymax$num] > $ymax} {set $ymax [set ymax$num]}
	}
	if {$::command(inter_offset)} {
	    set offset [expr {$num*$ymax/10.}]
	} else {
	    set offset 0.
	}
 	if {$num1 > 0} {
 	    ${num}xa set [[set ${data}(xvector)] range 0 $num1]
 	    ${num}ya set [[set ${data}(yvector)] range 0 $num1]
 	    if {$offset != 0} {
 		${num}ya set [${num}ya + $offset]
 	    }
 	    $graph(blt) element create ${data}a \
 		-linewidth [set ${data}(line)]  -label {} \
 		-color $lcol -symbol [set ${data}(symbol)] \
 		-xdata ${num}xa -ydata ${num}ya \
 		-pixels [expr 0.125*[set ${data}(symsize)]]i
 	}
  	${num}xb set [[set ${data}(xvector)] range $num1 $num2]
  	${num}yb set [[set ${data}(yvector)] range $num1 $num2]
 	if {$offset != 0} {
 	    ${num}yb set [${num}yb + $offset]
 	}
  	$graph(blt) element create $data \
  	    -linewidth  [set ${data}(line)] \
  	    -color $col -symbol [set ${data}(symbol)] \
  	    -xdata ${num}xb -ydata ${num}yb \
  	    -pixels [expr 0.125*[set ${data}(symsize)]]i
 	if {$num2 == "end" || $num2 <= [[set ${data}(xvector)] length ]} {
 	    ${num}xc set [[set ${data}(xvector)] range $num2 end]
 	    ${num}yc set [[set ${data}(yvector)] range $num2 end]
 	    if {$offset != 0} {
 		${num}yc set [${num}yc + $offset]
 	    }
 	    $graph(blt) element create ${data}c \
 		-linewidth [set ${data}(line)]  -label {} \
 		-color $lcol -symbol [set ${data}(symbol)] \
 		-xdata ${num}xc -ydata ${num}yc \
 		-pixels [expr 0.125*[set ${data}(symsize)]]i
 	}

	if {$graph(LabelByTitle)} {
	    catch {
		$graph(blt) element config $data -label [set ${data}(title)]
	    }
	}
    }
    $::interp(plot_button) config -relief raised
}