#!/bin/sh
# the next line restarts this script using wish found in the path\
exec wish "$0" "$@"
# If this does not work, change the #!/usr/bin/wish line below
# to reflect the actual wish location and delete all preceeding lines
#
# (delete here and above)
#!/usr/bin/wish
package require Tk
set Revision {$Revision: 450 $ $Date: 2010-10-15 17:45:52 -0500 (Fri, 15 Oct 2010) $}
#-----------------------------------------------------------
#-----------------------------------------------------------
# CMPR notes (to do)
# idea: bind <F1> for toplevels to generate the appropriate help
#-----------------------------------------------------------
#-----------------------------------------------------------
# load default values for variables into the userdefaults namespace
# from file ~/cmpr.defaults or "~/.cmpr_defaults
set initfile {}
set loadedinitfiles {}
if {$::tcl_platform(platform) == "windows"} {
    set filelist C:/cmpr.defaults 
    lappend filelist [file normalize ~/cmpr.defaults]
} else {
    set filelist [file normalize "~/.cmpr_defaults"]
}
foreach file $filelist {
    set flag 0 
    if {! [file exists $file]} continue
    if [catch {
	namespace eval ::userdefaults "source [list $file]"
	set initfile $file
	set flag 1
	lappend loadedinitfiles $initfile
    } err] {puts "error = $err"}
    if $flag break
}
set command(initfiles) $loadedinitfiles

set command(debug) 0
catch {if $env(DEBUG) {set command(debug) 1}}
# where are we?
set scriptname [info script]
# translate links -- go six levels deep
foreach i {1 2 3 4 5 6} {
    if {[file type $scriptname] == "link"} {
	set link [file readlink $scriptname]
	if { [file  pathtype  $link] == "absolute" } {
	    set scriptname $link
	} {
	    set scriptname [file dirname $scriptname]/$link
	}
    } else {
	break
    }
}
# fixup relative paths
if {[file pathtype $scriptname] == "relative"} {
    set scriptname [file join [pwd] $scriptname]
}
set scriptdir [file dirname $scriptname]
#----------------------------------------------------------------

if [catch {package require BLT} errmsg] {
    tk_dialog .err "BLT Error" "Error -- Unable to load the BLT package" \
	    error 0 Quit
#    destroy .
    exit
}
# handle Tcl/Tk v8+ where BLT is in a namespace
#  use the command so that it is loaded
catch {blt::graph}
catch {
    namespace import blt::graph
    namespace import blt::vector
}
catch {graph}

# old versions of BLT (<=2.1) don't report a version number
if [catch {set blt_version}] {set blt_version 0}

# option for coloring markers: note that GH keeps changing how to do this!
if {$blt_version < 2.3 || $blt_version >= 8.0} {
    set graph(MarkerColorOpt) -fg 
} elseif {$blt_version >= 2.4} {
    set graph(MarkerColorOpt) -outline
} else {
    set graph(MarkerColorOpt) -color
}

lappend auto_path $scriptdir
set command(haveBW) 1
# for debugging non-BWidget version set environment variable NOBWIDGET
catch {if $env(NOBWIDGET) {set command(haveBW) 0}}
if $command(haveBW) {
    if [catch {package require BWidget}] {set command(haveBW) 0}
}

# transfer default values for variables from the userdefaults namespace 
# to the global namespace
proc XferDefaults {} {
    foreach array [info vars ::userdefaults::*] {
	set var [namespace tail $array]
	foreach item [array names $array] {
	    set ::${var}($item) [set ${array}($item)]
	}
    }
}

# Save the user's default values in ~/cmpr.defaults (win) or ~/.cmpr_defaults (unix)
proc SaveDefaults {} {
    if {$::tcl_platform(platform) == "windows"} {
	if {[catch {set fp [open [file normalize "~/cmpr.defaults"] w]}]} {
		set fp [open "C:/cmpr.defaults" w]
	}
    } else {
	set fp [open [file join ~ .cmpr_defaults] w]
    }
    # make sure the namespace exists
    namespace eval ::userdefaults {}
    foreach item {legend printout outname outcmd font} {
	set ::userdefaults::graph($item) $::graph($item)
    }
    foreach item {fitonplot fitinnewplot} {
	set ::userdefaults::gpls($item) $::gpls($item)
    }
    global cellparm
    foreach item {sens abc_tol alphabeta_tol fadetime fontsize} {
	set ::userdefaults::cellparm($item) $::cellparm($item)
    }
    global command
    foreach item {helpmode} {
	set ::userdefaults::command($item) $command($item)
    }
    puts $fp "# CMPR saved options from [clock format [clock seconds]]"
    foreach array [info vars ::userdefaults::*] {
	puts $fp "array set [namespace tail $array] {"
	foreach item [array names $array] {
	    puts $fp "\t$item \"[set ${array}($item)]\" "
	}
	puts $fp "}"
    }
    close $fp
}

set command(cmprversion) 0
set command(exedir) [file join $scriptdir "exe"]
XferDefaults

if $command(cmprversion) {
    if {[file exists [file join $scriptdir cmprdev cmprmain.tcl]]} {
	set scriptdir [file join $scriptdir cmprdev]
    } else {
	tk_dialog .err "Development version not found" \
	    "An error was encountered: file cmprmain.tcl not found in [file join $scriptdir cmprdev]" \
	    error 0 Continue
	set command(cmprversion) 0
    }
}
source [file join $scriptdir cmprmain.tcl]
