# write an ascii listing of the contents of a data file

lappend command(writetypes) "Data listing (.txt)"
lappend command(writeproc) writelistdump

proc writelistdump {data} {
    global graph command
    global $data 
    set filename [file join $command(pwd) ${data}.txt]
    if {$command(write_useSaveAs)} {
	set filename [tk_getSaveFile -title "Select output file" -parent . \
			  -initialdir [file dirname $filename] \
			  -initialfile [file tail $filename]]
	if {[string trim $filename] == ""} return
    }
    set fil [open $filename w]

    if {[set ${data}(type)] == "peaks"} {
	# write a peak file
	puts $fil "Peak file $data"
	foreach lbl  {title\t wavelength "x-axis units" "x-axis label" \
		"space group" "extintion codes"} \
		item {title wavelength  xunits         xlabel \
		spg           extcodes         } {
	    puts $fil "$lbl\t[list [set ${data}(${item})]]"
	}
	puts $fil "cell"
	foreach lbl  {a b c alpha beta gamma} {
	    puts -nonewline $fil "\t$lbl  [list [set ${data}($lbl)]]"
	}
	puts $fil ""
	foreach x   "x [set ${data}(x)]" \
		y   "y [set ${data}(y)]" \
		h   "h [set ${data}(h)]" \
		k   "k [set ${data}(k)]" \
		l   "l [set ${data}(l)]" \
		d   "d-space [set ${data}(dspaces)]" \
		e   "extinct [set ${data}(extinctions)]" \
		hg  "height [set ${data}(heights)]" \
		wid "width [set ${data}(widths)]" {
	    puts $fil "$x\t$y\t$wid\t$hg\t($h $k $l)\t$d\t$e"
	}
    } else {
	# write a data file
	puts $fil "Peak file $data"
	foreach lbl  {title\t wavelength "x-axis units" "x-axis label" \
		"y-axis label" "missing points" } \
		item {title   wavelength  xunits         xlabel \
		ylabel         skip             } {
	    puts $fil "$lbl\t[list [set ${data}(${item})]]"
	}
	foreach x   "x   [set ${data}(x)]" \
		y   "y   [set ${data}(y)]" \
		xs  "{scaled x} [[set ${data}(xvector)] range 0 end]" \
		ys  "{scaled y} [[set ${data}(yvector)] range 0 end]" \
		es  "{scaled esd} [[set ${data}(esdvec)] range 0 end]" \
		esd "esd [set ${data}(esd)]" {
		    # example for Harlow on how to force a field length
		    #catch {set y [format %.3f $y]}
	    if {$command(writeunits) == 0} {
		puts $fil "$x\t$y\t$esd\t$xs\t$ys\t$es"
	    } else {
		puts $fil "$xs\t$ys\t$es\t$x\t$y\t$esd"
	    }
	}
     }
    close $fil
    return $filename
}
