# write data out in RIETICA ascii .dat file format
#-------------------------------------------- 
# Beta Version Oct 20 2010 M. Suchomel
# Based on example dataset from Jakoah Brgoch
# Not tested 
#-------------------------------------------- 
# Example of RIETICA ascii .dat file format
# for file with 2theta range 4 -> 100, step size of 0.005 deg and title field "JRB29_1"
#
#xx4.000   0.005 100.000 JRB29_1
#xxxxx634     635     626     629     627     616     615     613     612     626
#     632     622     617     621     633     629     626     631     621     625
# ...skip to end of line
#     353     350     352     353     350     353     347     353     358     358
#     358     1.      1.      1.      1.      1.      1.      1.      1.      1. 
#-------------------------------------------- 

lappend command(writetypes) "RIETICA ascii (.dat)"
lappend command(writeproc) writeRIETICAdat


proc writeRIETICAdat {data} {
    global graph command
    global $data 
    
    if {[set ${data}(type)] == "peaks"} {
        write a peak file
        MyMessageBox -title "Not implemented" -type OK -default ok \
        	-message "Peaks file not implemented for this format"
        return
    }

    if {$command(writeunits) == 0} {
    	set ydata [set ${data}(y)]
    	set xdata [set ${data}(x)]
    	set esddata [set ${data}(esd)]
        } else {
    	set ydata [[set ${data}(yvector)] range 0 end]
    	set xdata [[set ${data}(xvector)] range 0 end]
    	set esddata [[set ${data}(esdvec)] range 0 end]
    }

	# check step size
	set step_size [expr 1.0 * ([lindex $xdata 1] - [lindex $xdata 0]) ]
	set checkstepsize [expr 1.0 * ([lindex $xdata end] - [lindex $xdata 0]) \
			       / ([llength $ydata ] - 1) ]

	if {abs($checkstepsize - $step_size)/$checkstepsize > 0.001 } {
	    MyMessageBox -title "Warning" -type OK -default ok \
		-message "Warning: Step sizes is not uniform ($checkstepsize != $step_size)!"
	    continue
    }

    # set file name 
    set filename [file join $command(pwd) ${data}_RIETICA.dat]
    if {$command(write_useSaveAs)} {
    	set filename [tk_getSaveFile -title "Select output file" -parent . \
    			  -initialdir [file dirname $filename] \
    			  -initialfile [file tail $filename]]
    	if {[string trim $filename] == ""} return
    }

    set fil [open $filename w]
    
    # use windows friendly end of line character   
    fconfigure $fil -translation crlf
    
	# total number of data points
	set nchan [llength $ydata ]
	
	# determine file line number, step size 2theta range
    # should round down (div by 10 for # of columns)
    set nrec  [expr round ($nchan / 10) ]    
	set itt [lindex $xdata 0]
    set ssize [expr ([lindex $xdata 1] - [lindex $xdata 0])]
    set ftt [lindex  $xdata [expr $nchan - 1]]
    
    # header line 
    set header [format "%8.4f%8.4f%8.4f %s" $itt $ssize $ftt [set ${data}(title)]]
    puts $fil "$header"

    # initialize line & column counters
    set i 0
    set j 0
    set k 0
    
    # print out file line by line, intensity value only
	while { $i < $nrec } {
	    set line [format "%8.0f%8.0f%8.0f%8.0f%8.0f%8.0f%8.0f%8.0f%8.0f%8.0f" \
			  [lindex  $ydata $j           ] [lindex  $ydata [expr $j + 1]] \
			  [lindex  $ydata [expr $j + 2]] [lindex  $ydata [expr $j + 3]] \
			  [lindex  $ydata [expr $j + 4]] [lindex  $ydata [expr $j + 5]] \
			  [lindex  $ydata [expr $j + 6]] [lindex  $ydata [expr $j + 7]] \
			  [lindex  $ydata [expr $j + 8]] [lindex  $ydata [expr $j + 9]]]
        puts $fil "$line"
	    incr j 10
	    incr i
	}

    # print out last partial line        
    while { $j < $nchan } {
        set line [format "%8.0f" [lindex $ydata $j]]
        puts -nonewline $fil "$line"
        incr j
        incr k
    }

    # pad out remaining spaces in last line with "     1. "       
    while { $k < 10 } {
        set padvalue "     1. "
        set line [format "%s" $padvalue]
        puts -nonewline $fil "$line"
        incr k
    }

    close $fil
    return $filename
}		
