#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "logiclib.h"

/*  Program sublist 

    This program lists the name associated with a subfile
    or all subfiles.

    Command syntax:
       sublist 
       sublist n
*/

int main (int argc, char *argv[])
{
    INTEGER4 i,j;
    char string[40];

    if (argc == 1) 
      {
	j = 0;
	i = 1;
	j = PSL_TBLLIST(&i, string);
	while (j >= 0)
	  {
	    printf("%s\n", string);
	    i++;
	    j = PSL_TBLLIST(&i, string);
	  }
      }
    else if (argc == 2) 
      {
	i = 0;
	i = strtol(argv[1], (char **)NULL, 10);
	if (i == 0) 
	  {
	    fprintf(stderr, "\nusage:\n\t sublist\n(or)\t sublist <int>\n");
	    return 1;
	  }
	if (PSL_TBLLIST(&i, string) < 0 ) 
	  {
	    fprintf(stderr,"out of range subfile: %s\n", argv[1]); 
	    return 1;
	  }
	printf("%s\n", string);
      }
    else
      {
	fprintf(stderr,"\nusage:\n\t sublist\n(or)\t sublist <int>\n");
	return 1;
      }
    return 0;
}
