	SUBROUTINE TRFNCH (INCHR, USENEW, STATUS, OUTCHR, OUTPI, COUNT)

C==========================================================================
C
C	   TRanslate/get FootNote CHaracters for the PHOTO routines
C	   that prepare the data for the photocomposition of the PDF
C	   Cards.
C
C		INCHR  - character sent by the calling routine.  Character
C		         is validated against list of legal characters
C		         in LEGCHR.  Can also be a command:
C		         'RESET_ALL'    to reset the counters & EXISTance
C		                        codes before processing each
C		                        new card.
C		         'RESET_COUNTS' to reset the count of the # of
C		                        times each character has been
C		                        referenced (used in ADDFN to
C		                        check if the same character occurs
C		                        in more than one footnote to
C		                        alert the user to the ambiguity.)
C		USENEW - LOGICAL value that is .TRUE. if this routine may
C		         use a character not used since the last RESET_ALL,
C		         .FALSE. if not allowed.
C		STATUS - 0 if successful
C		         1 if error occurred
C		OUTCHR - converted character that will be transferred to
C		         the photocomposer.  Blank if an error occurred.
C		OUTPI  - the SED PI code needed to produce the correct
C		         footnote character in the PDF Card comments box.
C		         [should be CHARACTER*3]
C		COUNT  - # of times this character has been referenced
C		         since the last RESET_COUNTS or RESET_ALL.  The
C		         first time a character is referenced, COUNT
C		         will be 1.
C
C
C	   By: Mark Holomany, JCPDS     Date: 30-Apr-1985
C	   Revised
C	   -------
C	   27-Feb-86 MAH Added logic to allow mapping from the footnote
C	             character in the MDB to an allowable footnote character,
C	             where there are more from's than to's.
C
C==========================================================================

	IMPLICIT INTEGER (A-Z)
	CHARACTER*(*)	INCHR, OUTCHR
	CHARACTER*(*)	OUTPI
	LOGICAL		USENEW

	PARAMETER  (MAXCHR = 5)
	PARAMETER  (MAXLEG = 7)
	CHARACTER*1		PHCHR(MAXCHR)
	CHARACTER*3		PHPI (MAXCHR)
	CHARACTER*(MAXLEG)	LEGCHR
	CHARACTER*20		BUFFER
	INTEGER			MAP  (MAXLEG)
	INTEGER			REFCNT(MAXCHR)
	LOGICAL			EXIST (MAXCHR)

	SAVE EXIST,REFCNT,MAP,AVAIL

	DATA	PHCHR  /'1', '2', '3', '4', '5'/
	DATA	LEGCHR /'*$12345'/
	DATA	PHPI   /'*  ', '$DA', '$DD', '$SE', '$PG'/
C	.. Codes are: *, dagger, double-daggar, section-sign, paragraph-sign

C	CALL ESTMOD ('TRFNCH')

	IF(LEN(INCHR) .GT. 1) GO TO 200

C
C	... Map from LEGCHR to PHCHR using MAP and AVAIL
	N = INDEX (LEGCHR, INCHR)
	IF(N .EQ. 0) THEN
C	   CALL ERRTXT ('E', 
C	1    'Illegal footnote character (see next line)')
C	   CALL ERRTXT ('C', INCHR)
	   GO TO 9999
	ENDIF

	IF(MAP(N) .EQ. 0) THEN
C	   .. New MDB character; map it to a photocomp character code
	   IF(AVAIL .LE. MAXCHR) THEN
C	      .. Map to next available code
	      MAP(N) = AVAIL
	      AVAIL = AVAIL + 1

	   ELSE
C	      .. Photocomp character codes exhausted
	      WRITE(UNIT=BUFFER, FMT='(I2)') MAXCHR
C	      CALL ERRTXT ('E', 
C	1       'Exhausted max of ' // BUFFER(1:2) // 
C	2       'photocomp footnote codes.')
	   ENDIF
	ENDIF
	PLC = MAP(N)

	IF((.NOT. USENEW) .AND. (.NOT. EXIST(PLC)) ) THEN
	   STATUS = 1
	   OUTCHR = ' '
	   GO TO 9999
	ENDIF

	OUTCHR = PHCHR(PLC)
	OUTPI  = PHPI (PLC)
	EXIST (PLC) = .TRUE.
	REFCNT(PLC) = REFCNT(PLC) + 1
	COUNT  = REFCNT(PLC)
	STATUS = 0
	GO TO 9999

C
C	... INCHR assumed to have a command (LEN > 1)
200	CONTINUE
	IF(INCHR .EQ. 'RESET_ALL') THEN
	   DO 4001 N=1,MAXCHR
	   EXIST (N) = .FALSE.
4001	   REFCNT(N) = 0
	   DO 4003 N=1,MAXLEG
4003	   MAP(N) = 0
	   AVAIL = 1

	ELSE IF(INCHR .EQ. 'RESET_COUNTS') THEN
	   DO 4002 N=1,MAXCHR
4002	   REFCNT(N) = 0

	ELSE
C	   CALL ERRTXT ('W', 'Illegal command (see next line)')
C	   CALL ERRTXT ('C', INCHR)
	ENDIF

9999	CONTINUE
C	CALL DESMOD ('TRFNCH')
	RETURN
	END
