	SUBROUTINE SPLONG (START, LASTBL)
C
C	   Finds an appropriate spot to split a comments line that DIVCOM
C	   thinks will fit on one line of the PDF Card, but unfortunately
C	   happens to be >80 characters long and thus will not fit on one
C	   80 column card image.  Ideally, SPLONG will use these rules
C	   to find a good spot to split:
C
C		1.  Just after a ")" that is followed by a capital letter
C		2.  Just before a "("
C		3.  Just before a capital letter which is preceeded
C		    by non-capital letter
C
C	   If neither rule 1 nor 2 can be used, SPLONG will simply
C	   set LASTBL = START + 79 (thus just selecting the first 80
C	   characters.)
C
C	   Normally, this routine is called only when a chemical formula
C	   which should fit on one comments line of the PDF Card after
C	   photocomposition, exceeds the space on the 80 column card image
C	   of the interchange tape format due to the '#'s used to indicate
C	   subscripts and also the lack of blanks in the formula.
C
C	   By: Mark Holomany, JCPDS     Date: 7-May-1985
C
C	   Revised:
C	   10-Jan-86 MAH Completely changed algorithm to rules 1-3 above
C
C
	IMPLICIT INTEGER (A-Z)

	COMMON /COMCRD/  CCARD, NUMPHC, CHPHC, CDCNT, FSTCRD, LINKCM,
	1                STCRD, NUMCD
	CHARACTER        CCARD*1760
	INTEGER          CDCNT(30), FSTCRD(30), LINKCM(20)
	INTEGER          STCRD(30)

C	CALL ESTMOD ('SPLONG')

	OLD = LASTBL

C	... Look for ")" followed by a capital letter OR just a "("
	DO 4010 N=LASTBL-1, START+1, -1
	IF(CCARD(N:N) .EQ. ')'  .AND.
	1 (CCARD(N+1:N+1) .GE. 'A'  .AND.
	2  CCARD(N+1:N+1) .LE. 'Z'       )) THEN
	   IF(N-START+1 .LE. 80) THEN
	      LASTBL = N
	      GO TO 9000
	   ENDIF

	ELSE IF(CCARD(N:N) .EQ. '(') THEN
	   IF((N-1)-START+1 .LE. 80) THEN
	      LASTBL = N - 1
	      GO TO 9000
	   ENDIF
	ENDIF
4010	CONTINUE
C
C	... Check for capital letter preceeded by a non-capital letter
	DO 4020 N=LASTBL-1, START+1, -1
	IF( (CCARD(N:N) .GE. 'A'  .AND.  CCARD(N:N) .LE. 'Z')  .AND.
	1   (CCARD(N-1:N-1) .LT. 'A'  .OR.
	2    CCARD(N-1:N-1) .GT. 'Z'       )) THEN
	   IF((N-1)-START+1 .LE. 80) THEN
 	      LASTBL = N - 1
	      GO TO 9000
	   ENDIF
	ENDIF
4020	CONTINUE

C
C	... Make sure LASTBL is short enough
9000	CONTINUE
C	.. no delimeters or capital letters in the string
	IF(LASTBL .GE. OLD)   LASTBL = START + 79
C	.. first character is delimeter
	IF(LASTBL .LE. START) LASTBL = START + 79
C>>>	IF(LENGTH(CCARD(START:LASTBL)) .GT. 80) GO TO 100
C	CALL ERRTXT ('W', 
C	1  'Comments line arbitrarily split, make sure it looks OK now')

C	CALL DESMOD ('SPLONG')
	RETURN
	END
