	SUBROUTINE SCANIN(INSTR,DELSTR)
C
C	   Routine to initialize the COMMON /SCNCMN/ used by the
C	   parsing subroutine SCANER.
C
C		INSTR  - A string of 1-200 characters to be parsed by the
C		         scanner.  This string is copied to an internal
C		         work area for use during the parsing.  This
C		         means that changes made to INSTR by the calling
C		         program between the execution of THIS routine
C		         and successive CALLS to SCANER will not modify
C		         the parsing.  Neither does this routine nor
C		         SCANER modify the original copy of INSTR.
C		DELSTR - A string of 1-96 ASCII characters to be used
C		         as field delimiters.  These are stored in DELIM.
C		DELIM  - The string of delimiters used by SCANER.
C		NUMDEL - Then number of delimiter characters in DELSTR.
C		STRING - The string that is parsed by SCANER.
C		LENSTR - The length of INSTR.
C		PTR    - Pointer to the next character to be parsed.
C
C	   By: Mark Holomany, JCPDS     Date: 30-Jan-1984
C
C
	IMPLICIT INTEGER (A-Z)
	CHARACTER  INSTR*(*), DELSTR*(*)
	CHARACTER  DELIM*96,STRING*200
	COMMON /SCNCMN/ PTR,NUMDEL,LENSTR,DELIM,STRING

	PTR = 1
	NUMDEL = LEN(DELSTR)
	DELIM(1:NUMDEL) = DELSTR

	LENSTR = LEN(INSTR)
	STRING(1:LENSTR) = INSTR

	RETURN
	END
