	SUBROUTINE SCANER(TOKEN,SIZE)
C
C	   Routine to scan the STRING and parse it into individual
C	   fields.  Each time SCANER is called it returns the next
C	   field in TOKEN and its length in SIZE.  The field
C	   delimiters are stored in DELIM.  The variables DELIM,
C	   NUMDEL, STRING, LENSTR and PTR are initialized in the
C	   cooperating routine SCANIN.  SCANIN must be called once
C	   before SCANER is called for each string parsed.  Multiple
C	   blanks between fields are compressed down to one.
C
C	   When the field is null, TOKEN is set to blanks.
C	   When no fields remain, TOKEN(1:1) is set to blank, while
C	   the rest of TOKEN is unchanged.
C
C		DELIM  - The string of 1-96 delimiters used by SCANER.
C		NUMDEL - Then number of delimiter characters in DELIM.
C		STRING - The string of 1-200 characters to be parsed.
C		LENSTR - The length of STRING.
C		PTR    - Pointer to the next character to be parsed.
C		TOKEN  - The field returned to the calling program.
C		SIZE   - Length of the TOKEN.  Possible values are:
C		            1-n  a string from one to "n" characters
C		                 long,
C		              0  two successive delimiters resulted in
C		                 a null field of length zero,
C		             -1  the end of the string has been reached,
C		                 no fields remain.
C
C
C	   By: Mark Holomany, JCPDS     Date: 30-Jan-1984
C
C
	IMPLICIT INTEGER (A-Z)
	CHARACTER  TOKEN*(*)
	CHARACTER  DELIM*96,STRING*200
	COMMON /SCNCMN/ PTR,NUMDEL,LENSTR,DELIM,STRING
C
C	... Find the the first non-blank character.
	DO 10 I=PTR,LENSTR
	IF(STRING(I:I) .NE. ' ') GO TO 20
10	CONTINUE
C
C	... No fields remain in the STRING
	PTR = LENSTR
	SIZE = -1
	TOKEN(1:1) = ' '
	RETURN
C
C	... Search for the next delimiter
20	CONTINUE
	START = I
	DO 30 I=START,LENSTR
	IF( INDEX(DELIM(1:NUMDEL), STRING(I:I))  .NE.  0) THEN
	   PTR = I + 1
	   SIZE = I - START
	   IF(SIZE.GE.1) THEN
	      TOKEN = STRING(START:I-1)
	   ELSE
	      TOKEN = ' '
	   ENDIF
	   RETURN
	ENDIF
30	CONTINUE
C
C	... No delimiters remain; therefore the field extends to the
C	... end of the STRING.
	PTR = LENSTR + 1
	SIZE = LENSTR - START + 1
	IF(SIZE.GE.1) THEN
	   TOKEN = STRING(START:LENSTR)
	ELSE
	   TOKEN = ' '
	ENDIF
	RETURN
	END
