      SUBROUTINE PIEXP (INSTR, LENSTR)
C
C        Expands all PI codes and '!' in the input string INSTR.  Length
C        of INSTR is returned in LENSTR.
C
C        By: Mark Holomany     Date: 7-Oct-1987
C
C
      IMPLICIT INTEGER (A-Z)
      CHARACTER*(*) INSTR
      INTEGER       LENSTR
      CHARACTER*10  EXPCOD

      SIZE = LENGTH (INSTR)
      INISIZ = SIZE
      BEG = 1
100   NPI = INDEX (INSTR(BEG:), '$')
      IF(NPI .GT. 0) THEN
         NPI = NPI + BEG - 1
         BEG = NPI + 1
         CALL PITRAN (INSTR(NPI+1:NPI+2), EXPCOD, LENPI)
         NDELTA = LENPI - 3
         IF(SIZE+NDELTA .GT. LEN(INSTR)) THEN
C            CALL ERRTXT ('W', 'NO ROOM LEFT TO CONVERT PI CODE')
            GO TO 9000
         ENDIF
C
C        ... Set from/to for the DO loop to correspond to correct
C        ... direction for sign of NDELTA (l to r / r to l in INSTR)
         NXFROM = SIZE
         NXTO   = NPI + 3
         NXSTEP = -1
         IF(NDELTA .LE. -1) THEN
            NXFROM = NPI + 3
            NXTO   = SIZE
            NXSTEP = 1
         ENDIF

         DO 4010 NX=NXFROM,NXTO,NXSTEP
4010     INSTR(NX+NDELTA:NX+NDELTA) = INSTR(NX:NX)
C        ... Insert PI code translation
         INSTR(NPI:NPI+LENPI-1) = EXPCOD(1:LENPI)
         SIZE = SIZE + (LENPI - 3)
C        ... See if there are more codes
         GO TO 100
      ENDIF
C
C     ... All done
9000  LENSTR = SIZE
      IF(LENSTR .LT. INISIZ) INSTR(LENSTR+1:INISIZ) = ' '
C
C     ... Convert '!' to center dots
      DO 4020 N=1,LENSTR
      IF(INSTR(N:N) .EQ. '!') INSTR(N:N) = CHAR(249)
4020  CONTINUE
      RETURN
      END
