	SUBROUTINE PHREF (TSC, NCARD, STRING, STATUS, L2AUTH)

C-----------------------------------------------------------------------
C
C	   Routine to Photocomp the PDF card References.  It accepts
C	   the starting card of card type 9 (NCARD) and returns
C	   the STATUS.
C
C		NCARD  - Position of first card of reference to
C		         prep for photocomp in array CARD9
C		STRING - A character string returned
C		         with the photocomp ready reference
C		STATUS - Completion status of PHREF:
C		           0 if successful
C		           1 if CODEN wasn't found in the CODENS file
C		           2 if couldn't read CODENS file
C		           3 if reference longer than LEN(STRING) characters
C		           4 if >2 cards used for Authors
C
C		L2AUTH - .TRUE. to allow at most 2 author's names, .FALSE.
C		         to return as many as exist.  If restricted, retruned
C		         string is of the form "name., et al."
C
C		TSC    -   .TRUE. if type setting codes are to be inserted
C                          into the STRING, .FALSE. otherwise.
C
C	   By: Mark Holomany, JCPDS     Date: 13-Feb-1984
C
C	   Revised:
C	   22-Mar-84 MAH -- Words nolonger split across card bundaries;
C	                    warning issued if reference is too long.
C
C	   28-Feb-86 MAH -- Keep track of which references are photocomped
C	                    so that those that are not can be added to the
C	                    comments box.
C
C	    4-Mar-86 MAH -- Commented-out code to inhibit fixup of words
C	                    crossing card boundaries, allow STRING to be
C	                    of any length.
C
C	    5-Apr-86 MAH -- Allow reduction to at most 2 author's names
C
C	    3-Mar-86 MAH -- Allow up to 3 cards (first plus 2 continuations
C	                    in reference; check for stuff at end of mult
C	                    authors, ie. '(to be published)'
C
C          15-Jul-87 SJK -- RET5MDB Modifications
C
C          24-Sep-90 MAH -- Print reference even if CODEN cannot be found
C                           in the CODENS file.
C
C           1-Sep-92 MAH -- Leave '.' at end of authors if the string ends
C                           in ', Ll' and the preceding character is not
C                           a '.'
C
C           1-Sep-92 MAH -- Correctly handle cases where patent numbers
C                           occur when multiple authors are reduced to one
C                           author plus et al.  Don't count junior (' Jr.,')
C                           as an author delimiter.
C___________________________________________________________________________

	IMPLICIT  INTEGER (A-Z)

	CHARACTER 	STRING*(*)
	CHARACTER*4	VOL, YEAR
	CHARACTER*5	STR5, PAGE
	CHARACTER*71	JOURNL
	LOGICAL         L2AUTH, TSC, DIGIT

	INCLUDE 'ioret.cmn'
	INCLUDE 'pdfdata.cmn'
	INCLUDE 'reftrk.cmn'

C\$INCLUDE:'IORET.CMN'
C\$INCLUDE:'PDFDATA.CMN'
C\$INCLUDE:'REFTRK.CMN'

C	CALL ESTMOD ('PHREF')

	MAXREF = LEN(STRING)
C
C	... Keep track of those references that are photocomposed
	REFCNT(NCARD) = .TRUE.
C
C	   Author(s) -- maximum of three cards
C
C	... NCHAR is the number of characters used in STRING
	STRING = CARD9(NCARD)(22:67)
	NCHAR = 46
	IF(CARD9(NCARD)(70:70) .EQ. 'C')  THEN

C	   .. Continuation card #1
	   NCHAR = LENGTH(STRING(1:46))
	   STRING(NCHAR+1 : NCHAR+1) = ' '
	   NCHAR = NCHAR + 1
	   STRING(NCHAR+1 : NCHAR+46) = CARD9(NCARD+1)(22:67)
	   NCHAR = NCHAR + 46
	   IF(CARD9(NCARD+1)(70:70) .EQ. 'C') THEN

C	      .. Continuation card #2
	      NCHAR = LENGTH(STRING(1:NCHAR))
	      STRING(NCHAR+1 : NCHAR+1) = ' '
	      NCHAR = NCHAR + 1
	      L3 = LENGTH (CARD9(NCARD+2)(22:67))
	      IF(NCHAR+L3 .LE. MAXREF) THEN
	         STRING(NCHAR+1 : NCHAR+L3) = CARD9(NCARD+2)(22:L3+21)
	      ELSE
C	         CALL ERRTXT ('W',
C	1          'Second continuation ref card truncated')
	         STRING(NCHAR+1:) = CARD9(NCARD+2)(22:L3+21)
	      ENDIF
	      NCHAR = NCHAR + L3
	      IF(CARD9(NCARD+2)(70:70) .EQ. 'C') THEN
C	         CALL ERRTXT ('W', 
C	1          'Authors on cards 4+ will not appear on the card')
	         STATUS = 4
	      ENDIF
	   ENDIF
	ENDIF
C
C	... Handle "Ibid." or "IBID." or ...
	STR5 = STRING(1:5)
	CALL UPPER(STR5)
	IF(STR5 .EQ. 'IBID.') THEN
	   STRING(NCHAR:) = ' '
	   STATUS = 0
	   GO TO 9000
	ENDIF
C
C	... Check for excessive number of author's names
	NCHAR = LENGTH(STRING(1:NCHAR))
	IF(.NOT. L2AUTH) GO TO 100
	IF(NCHAR .LE. 0) GO TO 100
	IF(CARD9(NCARD)(1:6) .EQ. '00GRNT' .OR.
	1  CARD9(NCARD)(1:6) .EQ. '0PCOMC' .OR.
	2  CARD9(NCARD)(1:6) .EQ. 'JACGAR' .OR.
	3  CARD9(NCARD)(1:6) .EQ. 'ACCRA9'      ) GO TO 100

	FSTDC = 0
	KNTDC = 0
	POSDC = 0
C
C	.. Search for dot-comma combination that should signal end of
C	.. each author's name.  Rules for card are: as is if there
C	.. two (2) or fewer authors, or first author plus " et al."
C	.. if there are three (3) or more authors
	DO 4050 LOOK=1,NCHAR-1
	IF(STRING(LOOK:LOOK+1) .EQ. '.,') THEN
C        .. Don't count junior (' Jr.,') as an author delimiter
	   IF (LOOK .GE. 4) THEN
	      IF (STRING(LOOK-3:LOOK) .EQ. ' Jr.') GO TO 4050
	   ENDIF

	   KNTDC = KNTDC + 1
	   IF(KNTDC .LE. 2) THEN
	      POSDC = LOOK
	      IF(KNTDC .EQ. 1) FSTDC = LOOK
	   ELSE
C	      .. Third occurrence of '.,' found (ie. >2 authors here)
	      POSDC = FSTDC
	      STRING(POSDC+1:POSDC+7) = ' et al.'
C
C              .. Check for '(to be published)' or Patent number at the
C              .. end of mult authors.  either exists, make sure it appears
C              .. on the card.
	      POSTBP = INDEX( STRING(LOOK:NCHAR), '(' )
	      IF(POSTBP .NE. 0) THEN
	         IF(STRING(NCHAR:NCHAR) .EQ. '.') NCHAR = NCHAR - 1
	         LTBP = (NCHAR - LOOK + 1) - POSTBP + 1
	         STRING(POSDC+8:) = ' ' // STRING(LOOK+POSTBP-1:NCHAR)
	         NCHAR = POSDC + 7 + 1 + LTBP

	      ELSE IF ( DIGIT (STRING(NCHAR-1:NCHAR-1) ) ) THEN
C                 .. Find the previous ', ' combination which signals the
C                 .. beginning of the patent number (both US and foreign).
	         DO 4060 POS_COMMA=NCHAR-3, 1, -1
	         IF (STRING(POS_COMMA:POS_COMMA+1) .EQ. ', ') THEN
	            IF(STRING(NCHAR:NCHAR) .EQ. '.') NCHAR = NCHAR - 1
	            LEN_PATENT = NCHAR - POS_COMMA + 1
	            STRING(POSDC+8:) = STRING(POS_COMMA:NCHAR)
	            NCHAR = POSDC + 7 + LEN_PATENT
	            GO TO 100
	         ENDIF
4060	         CONTINUE

	      ELSE
	         NCHAR = POSDC + 7
	         IF(STRING(POSDC+1:POSDC+7) .NE. ' et al.')
     1             STRING(NCHAR+1:) = ' '
            ENDIF

C>>>	      CALL ERRTXT 
C>>>	1       ('I', 'Mult authors reduced to one plus et al.')
	      GO TO 100
	   ENDIF
	ENDIF
4050	CONTINUE

100	CONTINUE
C
C	... Leave the trailing '.' only if the character before the '.'
C       ... is a Capital-letter, and the character preceding the cap-letter
C       ... is a non-cap.  Ex. "sA.", "S.", "S.-T." keep the '.'
C       ...                    "USA.", "USSR.", "SSSR." loose the '.'
C       ... "et al." is handled as an exception to keep the '.'
                                     
	ADDIT = 0      
	IF(NCHAR .GT. 3) THEN
	   IF(NCHAR .GE. 6) THEN
C              .. Correct for 'et al.' exception
	      IF(STRING(NCHAR-5:NCHAR) .EQ. 'et al.') 
     1	        ADDIT = 1
	   ENDIF
C
C           ... Check for case where end of STRING is   [lL.]
	   IF( STRING(NCHAR:NCHAR) .EQ. '.') THEN
	      IF((STRING(NCHAR-1:NCHAR-1).GE.'A' .AND.
     1            STRING(NCHAR-1:NCHAR-1).LE.'Z'      ) .AND.
     2           (STRING(NCHAR-2:NCHAR-2).LT.'A' .OR.
     3            STRING(NCHAR-2:NCHAR-2).GT.'Z'      )) THEN
	         CONTINUE
	      ELSE
C                  ... Keep trailing '.' if the last item in the authors
C                  ... is ", Ll" (a two letter abbreviation for a last name),
C                  ... and the previous character is not a '.' (indicating
C                  ... the end of an author's name).  [MAH 1-Sep-92]
	         IF(NCHAR .GT. 5) THEN
	            IF((STRING(NCHAR-4:NCHAR-3) .EQ. ', ')  .AND.
     1                 (STRING(NCHAR-2:NCHAR-2) .GE. 'A' .AND.
     2                  STRING(NCHAR-2:NCHAR-2) .LE. 'Z' )  .AND.
     3                 (STRING(NCHAR-1:NCHAR-1) .GE. 'a' .AND.
     4                  STRING(NCHAR-1:NCHAR-1) .LE. 'z' )  .AND.
     5                 (STRING(NCHAR-5:NCHAR-5) .NE. '.' )       ) THEN
	                CONTINUE
	            ELSE
	               NCHAR = NCHAR - 1
	            ENDIF
	         ELSE
	            NCHAR = NCHAR - 1
	         ENDIF

	      ENDIF
	   ENDIF
	ENDIF
	NCHAR = NCHAR + ADDIT
C
C	... Add a "," and switch to Italics
	IF(NCHAR .GT. 0) THEN
	   IF(STRING(NCHAR:NCHAR) .EQ. ',') THEN
	      STRING(NCHAR+1 : NCHAR+1) = ' '
	      NCHAR = NCHAR + 1
	   ELSE
	      STRING(NCHAR+1 : NCHAR+2) = ', '
	      NCHAR = NCHAR + 2
	   ENDIF
	ENDIF
	IF(TSC) THEN
	   STRING(NCHAR+1 : NCHAR+3) = '\IT'
	   NCHAR = NCHAR + 3
	ENDIF
C
C	   Journal -- get journal from CODEN then format correctly
C
C>>>	READ (UNIT=NFIN, KEYEQ=CARD9(NCARD)(1:6), KEYID=0, IOSTAT=IOS)
C>>>	1  JUNK,JOURNL

        CALL SEEKX (CARD9(NCARD)(1:6), JOURNL, STATUS)

	IF(STATUS .EQ. 1) THEN
           CONTINUE
C	   CALL ERRTXT ('W', 
C	1    'CODEN "' // CARD9(NCARD)(1:6) // '" not found in file')
C
C         ... Continue generating reference without journal name.

	ELSE IF(STATUS .NE. 0) THEN
C	   CALL ERRTXT ('E', 'Unable to read CODEN file')
	   STATUS = 2
	   GO TO 8000
	ENDIF

	L = MAX0(1, LENGTH(JOURNL))
	IF(NCHAR+L .LE. MAXREF) THEN
	   STRING(NCHAR+1 : NCHAR+L) = JOURNL(1:L)
	   NCHAR = NCHAR + L
	ELSE
	   GO TO 8001
	ENDIF
C
C	... Got Journal; make certain that a "," is not the last char
	IF(STRING(NCHAR:NCHAR) .EQ. ',') THEN
	   NCHAR = NCHAR - 1
	ENDIF
C
C	... Turn off Italics and add a ", "  --  save this position
C	... to blank out the "," if there is no volume, page or year.
	IF(NCHAR+5 .LE. MAXREF) THEN
	   IF(TSC) THEN
	      STRING(NCHAR+1 : NCHAR+3) = '\RG'
	      NCHAR = NCHAR + 3
	   ENDIF
	   STRING(NCHAR+1 : NCHAR+2) = ', '
	   NCHAR = NCHAR + 2
	   SAVE = NCHAR
	ELSE
	   GO TO 8001
	ENDIF
C
C	   Volume -- photocomp it in BOLD face
C
	VOL = CARD9(NCARD)(7:10)
	CALL LEFT(VOL, SIZE)
	IF(SIZE.GT.0) THEN
	   IF(NCHAR+SIZE+7 .LE. MAXREF) THEN
	      IF(TSC) THEN
	         STRING(NCHAR+1 : NCHAR+SIZE+7) =
	1          '\BF' // VOL(1:SIZE) // '\RG '
	         NCHAR = NCHAR + SIZE + 7
	      ELSE
	         STRING(NCHAR+1 : NCHAR+SIZE+1) =
	1           VOL(1:SIZE) // ' '	        
	         NCHAR = NCHAR + SIZE + 1
	      ENDIF
	   ELSE
	      GO TO 8001
	   ENDIF
	ENDIF
C
C	   Page
C
	PAGE = CARD9(NCARD)(11:15)
	CALL LEFT(PAGE, SIZE)
	IF(SIZE.GT.0) THEN
	   IF(NCHAR+SIZE+1 .LE. MAXREF) THEN
	      STRING(NCHAR+1 : NCHAR+SIZE+1) =
	1       PAGE(1:SIZE) // ' '
	      NCHAR = NCHAR + SIZE + 1
	   ELSE
	      GO TO 8001
	   ENDIF
	ENDIF
C
C	   Year
C
	YEAR = CARD9(NCARD)(17:20)
	CALL LEFT(YEAR, SIZE)
	IF(SIZE.GT.0) THEN
	   IF(NCHAR+SIZE+2 .LE. MAXREF) THEN
	      STRING(NCHAR+1 : NCHAR+SIZE+2) = 
	1       '(' // YEAR(1:SIZE) // ')'
	      NCHAR = NCHAR + SIZE + 2
	   ELSE
	      GO TO 8001
	    ENDIF
	ENDIF
C
C	... Remove last "," if there was no volume, page or year.
	IF(SAVE.EQ.NCHAR) NCHAR = NCHAR - 2
C
C	... Blank fill the rest of the STRING
	IF(NCHAR .LT. LEN(STRING)) STRING(NCHAR+1:) = ' '
	STATUS = 0
	GO TO 9000

8000	CONTINUE
	GO TO 9000

8001	CONTINUE
C	CALL ERRTXT ('W', 
C	1  'Reference beyond 160 characters will be truncated')
	STATUS = 3

9000	CONTINUE
C	CALL DESMOD ('PHREF')
	RETURN
	END
