      SUBROUTINE pdf2fmt(buffer,nlines,filename,RADUNIT)
C
C	This routine formats a PDF-2 card from buffer and writes a 
C	it as a formatted entry on filename 
C
C       Units for display of peaks is passed as RADUNIT
C	   		 where
C				S=sin(theta) / lambda
C				Q=q
C				D=dspace
C                               CU, CR, FE, CO, MO, AG or 
C				explicit wavelength for 2-theta
C

C
	IMPLICIT INTEGER (A-Z)
	CHARACTER*80 buffer(135)
	INTEGER*4 nlines
	character*80 filename
	character*20 radunit


        LOGICAL FIRSTPASS

      include '../pdf.cmn'
      integer*4 ps_readdbloc

	include 'ioret.cmn'
	include 'pdfdata.cmn'
	include 'cvtsp.cmn'
	include 'counts.cmn'
	INCLUDE 'ret3.cmn'
	INCLUDE 'picds.cmn'

	integer dbln, cdln

        SAVE FIRSTPASS
        DATA FIRSTPASS/.true./

C replace the blockdata
        CALL INITBLOCKDATA

	DBSW = 'PDF2'
	CPDFYR = '2000'

	cdln = lench(cdloc)
	dbln = lench(dbloc)
C
	call upper(RADUNIT)
        
        if (RADUNIT(1:2) .eq. 'CR') then
           const=(2.28962/2)
        elseif (RADUNIT(1:2) .eq. 'FE') then
           const=(1.93597/2)
        elseif (RADUNIT(1:2) .eq. 'CO') then
           const=(1.78892/2)
        elseif (RADUNIT(1:2) .eq. 'MO') then
           const=(0.70932/2)
        elseif (RADUNIT(1:2) .eq. 'AG') then
           const=(0.55936/2)
        elseif (RADUNIT(1:2) .eq. 'CU') then
           CONST=(1.54056/2)
        elseif (RADUNIT(1:1) .eq. 'D' .or. RADUNIT(1:1) .eq. 'S'
     $          .or. RADUNIT(1:1) .eq. 'Q') then
           CONST=0
        else
           read(RADUNIT(:lench(RADUNIT)),'(f8.0)',iostat=i) const
           if (i .ne. 0) then
              write(0,*) 'Error: ISPACG ',RADUNIT(:lench(RADUNIT)),
     $             ' is invalid'
              return
           endif
           const=const/2
        endif
        if (const .ne. 0) THEN
           ISPACG = '2'
        else 
           ISPACG=RADUNIT(1:1)
        ENDIF

        IF (FIRSTPASS) THEN
           FIRSTPASS = .FALSE.

           open (unit=NMINRL, file=dbloc(:dbln)//'stdcodes.tbl',
     $          status='old',iostat=j)
           if (j .ne. 0) open (unit=NMINRL,
     $          file=cdloc(:cdln)//'stdcodes.tbl',
     $          status='old',iostat=j)
           if (j .ne. 0) write (0,*) 'unable to open stdcodes.tbl'
           
           open (unit=NMINGP, file=dbloc(:dbln)//'mineral.tbl',
     $          status='old',iostat=j)
           if (j .ne. 0) open (unit=NMINGP,
     $          file=cdloc(:cdln)//'mineral.tbl',
     $          status='old',iostat=j)
           if (j .ne. 0) write (0,*) 'unable to open mineral.tbl'
           
           open (unit=ncoden,
     $          file=dbloc(:dbln)//'picodes.tbl',
     $          status='old',iostat=j)
           if (j .ne. 0) open (unit=ncoden,
     $          file=cdloc(:cdln)//'picodes.tbl',
     $          status='old',iostat=j)
           NPICDS = 0
           if (j .ne. 0) then
              write (0,*) 'unable to open picodes.tbl'
           else
 80           read (ncoden,'(a2,i1,a8)',end=81)
     $             PICDS(NPICDS+1), LNTEX2(NPICDS+1), PLTEX2(NPICDS+1)
              NPICDS = NPICDS +1
              GOTO 80
           endif
 81        close (ncoden)
           
           open (unit=ncoden,
     $          file=dbloc(:dbln)//'codens.tbl',
     $          status='old',iostat=j,
     $          access='direct',form='formatted',recl=81)
           if (j .ne. 0) open (unit=ncoden,
     $          file=cdloc(:cdln)//'codens.tbl',
     $          status='old',iostat=j,
     $          access='direct',form='formatted',recl=81)
           if (j .ne. 0) then
              write (0,*) 'unable to open codens.tbl'
              numcod = 0
           else
C     read the number of codens records from the first record (added in prepfiles)
              read(ncoden,'(6x,i10)',rec=1) NUMCOD
           endif
        ENDIF

        nbytes = 80*nlines
	call readbf (buffer,nbytes,readbf_status)
	if (readbf_status .eq. 1) then
           write (0,*) 'Error in READBF'
           return
        ENDIF

	call lines
        
        open(unit=8,file=filename,status='unknown',iostat=I)
        if (i .ne. 0) then
           write (0,*) 'unable to open ',filename,' for pdf2 output'
           return
        ENDIF
	call prtcrd(8)
        close(8)

	RETURN
	END


