	SUBROUTINE ADDREF(STATUS)
C
C	   Adds any references not as of yet photocomposed in any of the
C	   previous routines to the comments box.
C
C	   By: Mark Holomany, JCPDS     Date: 28-Feb-1986
C
C
	IMPLICIT INTEGER (A-Z)
	CHARACTER*5	STR5
	CHARACTER*500	REFSTR

	PARAMETER	(MAXTYP = 12)
	CHARACTER*2	RFCODE(0:MAXTYP)
	CHARACTER*11	RFWORD
	CHARACTER*20	RFTEXT(0:MAXTYP)
	INTEGER		RFTLEN(0:MAXTYP)
	LOGICAL		RFADD (0:MAXTYP)

	INCLUDE 'reftrk.cmn'
	INCLUDE 'ioret.cmn'
	INCLUDE 'pdfdata.cmn'

C\$INCLUDE:'REFTRK.CMN'
C\$INCLUDE:'IORET.CMN'
C\$INCLUDE:'PDFDATA.CMN'

	DATA	(RFCODE(I), RFTEXT(I), RFTLEN(I), RFADD(I),  I=0,MAXTYP) 
	1	/ 'XX',  'INVALID',		 7,	.FALSE.,
	1	  'OP',  'optical data',	12,	.TRUE.,
	2	  'PD',  'powder pattern',	14,	.TRUE.,
	3	  'UC',  'unit cell',		 9,	.TRUE.,
	4	  'ST',  'Structure',		 9,	.FALSE.,
	5	  'PM',  'Polymorphism',	12,	.FALSE.,
	6	  'AD',  'powder pattern',	14,	.TRUE.,
	7	  'AN',  'Analysis',		 8,	.FALSE.,
	8	  '  ',  'Primary pattern',	15,	.FALSE.,
	9	  'PR',  'Preparation',		11,	.FALSE.,
	1	  'SM',  'Sample source',	13,	.FALSE.,
	1	  'TM',  'Temperature',		11,	.FALSE.,
	1	  'TH',  'Thermal parameter',	17,	.FALSE.     /


	DATA		RFWORD /' references'/

C	CALL ESTMOD('ADDREF')


	DO 4010 N=1,NUMC(9)
	IF(N .GT. 1) THEN
	   IF(CARD9(N-1)(70:70) .EQ. 'C') GO TO 4010
	ENDIF
	IF(.NOT. REFCNT(N)) THEN
C	   .. Found a possible un-typeset reference
C	   .. Don't print if it's a contributed pattern reference - internal
C	   ..   use only, OR if it's an "Ibid."
	   IF(CARD9(N)(68:69) .EQ. 'CO') GO TO 4010
	   STR5 = CARD9(N)(22:26)
	   CALL UPPER (STR5)
	   IF(STR5 .EQ. 'IBID.') GO TO 4010
C
C	   .. Found a valid un-typeset refference
C>>>	   CALL ERRTXT ('I', '*****Left over reference card.')
C>>>	   CALL ERRTXT ('I', CARD9(N)(1:70))
	   CALL DOREFS (CARD9(N)(68:69), .FALSE., .FALSE., 
	1               IRET, REFSTR, NCHAR)

	   IF(IRET .NE. 0) GO TO 4010
	   LRFWRD = 10
	   IF(INDEX(REFSTR(1:NCHAR), ';') .NE. 0) LRFWRD = 11
	   DO 4030 CODNUM=1,MAXTYP
	   IF(RFCODE(CODNUM) .EQ. CARD9(N)(68:69)) GO TO 250
4030	   CONTINUE
C	   CALL ERRTXT ('E', 
C	1    'Invalid ref code "' // CARD9(N)(68:69) // '"')
	   CODNUM = 0
250	   CONTINUE
C	   IF(CARD9(N)(68:69) .EQ. ' ') THEN
C	      CALL ERRTXT ('I', 
C	1     'Primary pattern reference ended up in the comments box')
C	   ENDIF

	   IF(RFADD(CODNUM)) THEN
	      CALL CONCAT ('Additional ' // 
	1                  RFTEXT(CODNUM)(1:RFTLEN(CODNUM)) //
	2                  RFWORD(1:LRFWRD) // ': ' //
	3                  REFSTR(1:NCHAR) // '.  ' )
	   ELSE
	      CALL CONCAT (RFTEXT(CODNUM)(1:RFTLEN(CODNUM)) //
	1                  RFWORD(1:LRFWRD) // ': ' //
	2                  REFSTR(1:NCHAR) // '.  ' )
	   ENDIF
	ENDIF

4010	CONTINUE

C	CALL DESMOD('ADDREF')
	RETURN
	END
