#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "logiclib.h"

/* This subroutine parses elements in a list separated by spaces or commas 
  and sets flags in arrays elem and group accordingly */

int ParseElementList (const char * arg, INTEGER4 *elem, INTEGER4 *group)
{
  char * strg, * sub_string;
  long i;
  /*  Make a copy of the argument */
  strg = (char *) malloc((strlen(arg)+1) * sizeof(char));
  strcpy(strg, arg);
  sub_string= strtok(strg, " ,");
  while (sub_string != NULL)
    {
      i = strtol(sub_string, NULL, 10);
      if (i > 0 && i < 104) 
	elem[i-1] = 1;
      else if (i > 103 && i < 122) 
	group[i-104] = 1;
      else 
	{
	  fprintf(stderr,"invalid value: \"%s\" in element list \"%s\"\n",sub_string,arg);
	  free (strg);
	  return 1;
	}
      sub_string= strtok(NULL, " ,");
    }
  free (strg);
  return 0;
}

/* This subroutine parses a list of integers in a list separated by spaces 
   or commas and places the items into an array 
   returns the number of elements in the list 
*/
int ParseIntegerList (const char * arg, INTEGER4 **array) {
  char * strg, * sub_string;
  int c;
  long i;
  /*  Make a copy of the argument */
  strg = (char *) malloc((strlen(arg)+1) * sizeof(char));
  strcpy(strg, arg);
  /*  now scan it and see how many items there are */
  c = 0;
  sub_string= strtok(strg, " ,");
  while (sub_string != NULL) {
    i = strtol(sub_string, NULL, 10);
    c++;
    sub_string= strtok(NULL, " ,");
  }

  *array = (INTEGER4 *) malloc(c * sizeof(INTEGER4));

  /*  now scan it again and store the elements */
  strcpy(strg, arg);
  c = 0;
  sub_string= strtok(strg, " ,");
  while (sub_string != NULL) {
    i = strtol(sub_string, NULL, 10);
    (*array)[c] = i;
    c++;
    sub_string= strtok(NULL, " ,");
  }
  free (strg);
  return c;
}

/* This subroutine parses a list of floating point numbers in a list 
   separated by spaces or commas and places the items into an array 
   returns the number of elements in the list 
*/
int ParseRealList (const char * arg, REAL4 **array) {
  char * strg, * sub_string;
  int c;
  long i;
  /*  Make a copy of the argument */
  strg = (char *) malloc((strlen(arg)+1) * sizeof(char));
  strcpy(strg, arg);
  /*  now scan it and see how many items there are */
  c = 0;
  sub_string= strtok(strg, " ,");
  while (sub_string != NULL) {
    i = strtol(sub_string, NULL, 10);
    c++;
    sub_string= strtok(NULL, " ,");
  }

  *array = (REAL4 *) malloc(c * sizeof(REAL4));

  /*  now scan it again and store the elements */
  strcpy(strg, arg);
  c = 0;
  sub_string= strtok(strg, " ,");
  while (sub_string != NULL) {
    (*array)[c] = strtod(sub_string, NULL);
    c++;
    sub_string= strtok(NULL, " ,");
  }
  free (strg);
  return c;
}

