#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "logiclib.h"

/*  Program loadsub

    This program loads a subfile into a bitmap file

  Command syntax:
    loadsub <file> -all
    loadsub <file> -none
    loadsub <file> -or  -subfile <int>
    loadsub <file> -and -subfile <int>
    loadsub <file> -remove -subfile <int>
    loadsub <file> -not -subfile <int>
    loadsub <file> -replace -subfile <int>
*/

int main (int argc, char *argv[])
{
  int error;			/* error flag */
  INTEGER4 ilogic,subfile,j;
  error = 0;
  subfile = -1;
  ilogic = -1;
  j = 0;

  if (PSL_INIT() != 0) 
    {
      fprintf(stderr,"error initializing the ICDD database\n");
      return 1;
    }


  if (argc == 3 && !strcmp(argv[2],"-all"))
    {
      ilogic = 6;
      subfile = 0;
    }
  else if (argc == 3 && !strcmp(argv[2],"-none"))
    {
      ilogic = 5;
      subfile = 0;
    }
  else if (argc == 5)
    {
      j = 1;
      while (j < 4)
	{
	  j++;
	  if (!strcmp(argv[j],"-or"))
	    ilogic = 1;
	  else if (!strcmp(argv[j],"-and"))
	    ilogic = 0;
	  else if (!strcmp(argv[j],"-remove"))
	    ilogic = 2;
	  else if (!strcmp(argv[j],"-not"))
	    ilogic = 3;
	  else if (!strcmp(argv[j],"-replace"))
	    ilogic = 4;
	  else if (!strcmp(argv[j],"-subfile"))
	    {
	      j++;
	      subfile = atol(argv[j]);
	    }
	  else  /* unrecognized option */
	    {
	      fprintf(stderr,"error: unknown option: %s\n",argv[j]);
	      error = 1;
	      j = 5;   /* terminate the loop */
	    }
	}
    }

  if (ilogic < 0 || subfile < 0) 
    {
      fprintf(stderr,"error: required option missing\n");
      error = 1;
    }
  if (!error)
    {
      /*printf("Calling tblload with ilogic = %ld and subfile = %ld\n", */
      /* 	     ilogic, subfile); */
      if (ilogic < 4) 
	{
	  INTEGER4 l = 4;
	  error = PSL_READBITMAP(argv[1],&l);
	  if (error) 
	    {      
	      fprintf(stderr, "error reading subfile %s\n",argv[1]);
	      return 1;
	    }
	}
      j = PSL_TBLLOAD(&ilogic, &subfile);
      if (j < 0) 
	{
	  error = 1;
	  fprintf(stderr, "error loading subfile\n");
	}
      else
	error = PSL_SAVEBITMAP(argv[1]);
      if (error) 
	{      
	  fprintf(stderr, "error writing subfile %s\n",argv[1]);
	  return 1;
	}
      printf("%d\n",j);
    }
  if (error)
    {
      fprintf(stderr, "\nusage:\n\t loadsub <file> -all\n(or)\t loadsub <file> -none\n");
      fprintf(stderr, "(or)\t loadsub <file> [-or | -and | -remove | -not | -replace ] -subfile <int>\n");
      return 1;
    }
  return 0;
}
