#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "logiclib.h"

/*  Program getpdf2
    This program returns the AIDS*83 record for the entry # <int>.

  Program arguments:
    getpdf2 -seq <int>
or  getpdf2 -seq <int> [-format <peak-unit> -file <filename>]

  Note that -format and -file must be used together, or must be
  omitted. When used the output is reformatted for printing and written 
  on file.
    -file specifies the name of the file.
    -format specifies the units of peak positions where values for 
       <peak-unit> are D,Q,cr,fe,co,cu,mo,ag or a real number
       where D=d-space, Q=Q and the remaining values
       give 2theta values at the corresponding wavelength
*/

int main (int argc, char *argv[])
{
  int error = 0;
  INTEGER4 iseq = 0;
  INTEGER4 iline;
  CHAR string[81];
  CHAR filename[81] = "";
  CHAR format[21] = "";

  if (PSL_INIT() != 0) {
    fprintf(stderr,"error initializing the ICDD database\n");
    error = 1;
  }

  if (argc == 3 && !strcmp(argv[1],"-seq") && !error) {
    INTEGER4 l = 1;
    iseq = strtol(argv[2], NULL, 10);
    if (iseq < 1 || iseq > PSL_REPHITS(&l)) {
      fprintf(stderr,"error: invalid sequence number %s\n", argv[2]);
      error = 1;
    }
  } else if (argc == 7 && !error) {
      int j;
      j = 1;
      while (j < argc && !error) { 
	if (!strcmp(argv[j],"-seq")) { 	             /* get sequence number */
	  INTEGER4 l = 1;
	  j++;
	  iseq = strtol(argv[j], NULL, 10);
	  if (iseq < 1 || iseq > PSL_REPHITS(&l)) {
	    fprintf(stderr,"error: invalid sequence number %s\n", argv[j]);
	    error = 1;
	  }
	} else if (!strcmp(argv[j],"-format")) {   /* get format option (peak units) */
	  j++;
	  strcpy(format, argv[j]);
	} else if (!strcmp(argv[j],"-file")) {     /* get filename */
	  j++;
	  strcpy(filename, argv[j]);
	} else {
	  error = 1;
	}
	j++;
      }
  } else {
    error = 1;
  }

  if (!error) {
    iline = 0;
    while(PSL_REPPDF2(&iseq, &iline, string, format, filename) > 0) {
      if (iline > 0) printf("%s\n", string);
      iline++;
    }
    if (iline == 0) {   /* if there are no lines then iseq must be invalid */
      fprintf(stderr, "error accessing sequence number: %d\n", iseq);
      error = 1;
    }
    return 0;
  }

  fprintf(stderr, "\nusage:\n");
  fprintf(stderr, "\t getpdf2 -seq <int>\n");
  fprintf(stderr, "  or\t getpdf2 -seq <int> -format <peak-unit> -file <filename>\n");
  return 1;
}
