C---------------------------------------------------------------------------ib
C	PDF1 ENCODE -- PART 3a   for the PDF-2 on DISK/CDROM 
C
C	Program for reading the PDF-1 JCPDS-ICDD DI data file
C	to create the d-space index bitmap files.
C
C	            =================================
C
C	   Written Jan-1995 by Brian H. Toby -- based on 1990 VAX version
C
C-------------------------------------------------------------------------
C-- INPUT ----------------------------------------------------------------
C       FILE	        USE           
C-------------------------------------------------------------------------
C       di.lib  	output database file containing the D/I info
C                       for each card 1st record (updated)
C       jcpds.ind	index file, one record per JCPDS card
C
C-------------------------------------------------------------------------
C-- OUTPUT ---------------------------------------------------------------
C       FILE	        USE
C-------------------------------------------------------------------------
C 	dsp%%.bitmap	D-space bitmap indices (see below)
C-------------------------------------------------------------------------
C-------------------------------------------------------------------------
	IMPLICIT NONE
	include 'copyrght.def'
C
	include 'pdfread.def'
	include 'pdfwrite.def'
	include 'bitops.def'
	include 'pdfdefs.par'
C cdloc -- filename (including path) of CDROM 
C dbloc -- path for cdif database files (ending in \)
	CHARACTER*64 cdloc,dbloc,localloc

	CHARACTER*8 filename*80

	INTEGER lastcrd,lastsub,N_reg,N_elemc
	integer n_cards,ipat,ncrd
	integer lench
	integer i,itype,j,k,n3s
	integer npt,dipt,refpt,cdpt
C-------------------------------------------------------------------------
C   BITMAP ARRAY
	integer n_lwords
	parameter(n_lwords=(31+max_cards)/32)
	INTEGER*4 DSPMAP(n_lwords,N_regions)
	integer*4 dspcnt(N_regions)

	logical PDFTOD,FLAG,DTOIND
	REAL dsp(255)
	INTEGER   INT(255),maxi
	integer ndsint, PDF2T
	INTEGER*1  IRELbyte(255)
	INTEGER*2  PDF2T2(255)
	

C
C---------------------------------------------------------------------------
C---------------------------------------------------------------------------
C Open the input file(s)
C---------------------------------------------------------------------------
	read(*,'(A)') dbloc
	read(*,'(A)') cdloc
	read(*,'(A)') localloc
C terminate strings with nulls
	localloc(lench(localloc)+1:) = char(0)
	cdloc(lench(cdloc)+1:) = char(0)
	dbloc(lench(dbloc)+1:) = char(0)
	write (*,'(/3(A,/))') '======================',
	1    'Beginning program WRDI','======================'
	write (*,*) 'Reading files from location ',dbloc(:lench(dbloc))
!	write (*,*) 'CDROM location ',cdloc(:lench(cdloc))
!	write (*,*) 'local AIDS entries ',localloc(:lench(localloc))
!	i = ps_openpdf2 ('pdf2.dat'//char(0),dbloc,cdloc,0)
!	if (i .eq. -1) stop
	i = ps_openindex(dbloc,cdloc)
	if (i .ne. 0) stop 'error on open'
!	i = ps_opennamlib(dbloc,cdloc)
!	if (i .ne. 0) stop 'error on name open'
	i = ps_opendilib(dbloc,cdloc)
	if (i .ne. 0) stop 'error on di open'
!	i = ps_openreflib(dbloc,cdloc)
!	if (i .ne. 0) stop 'error on ref open'
	open (unit=99,file=dbloc(:lench(dbloc))//'runstat.txt',
     1		status='unknown')
	rewind(99)
	write (99,*) 'Initializing'
	call flush(99)
C read the sizes from the file and overwrite the actual value for N_REGIONS
	OPEN (UNIT=7,FILE=dbloc(:lench(dbloc))//'pdsize.txt',
     1		STATUS='OLD')
	read (7,*)  N_cards,lastcrd,lastsub,N_reg,N_elemc
	N_reg = N_REGIONS
	rewind(unit=7)
	write (7,*) N_cards,lastcrd,lastsub,N_reg,N_elemc
	CLOSE (UNIT=7)

C---------------------------------------------------------------------------
C get the type of bitmap to write
 100	read(*,'(I3)',end=9000) itype
	if (itype .gt. 99) goto 9000
	rewind(99)
	if (itype .lt. 0) then
	   write (99,*) 'creating strongest line bitmap'
	else
	   write (99,*) 'creating ',itype,'% bitmap'
	endif
	call flush(99)
C   ITYPE 	file(s)		use
C ------------	-------		---
C     70	DSP70.BITMAP	cards with I>=70% in region of record
C     30	DSP30.BITMAP	cards with I>=30% in region of record
C      0	DSP00.BITMAP	cards with a peak (any I) in region of record
C     -1	DSP3S.BITMAP	cards with 1 of 3 strongest lines ...

C initialize the bitmap
	DO J=1,n_Lwords
	  DO I=1,n_regions
	    DSPMAP(J,I) = 0
	  ENDDO
	ENDDO

C =========================================================================
C
C  Begin production of search files.
C
	DO 1 IPAT=1,n_cards
	   if (mod(ipat,1000) .eq. 0) THEN
	      rewind(99)
	      if (itype .lt. 0) then
		 write (99,*) 'strongest line bitmap, @entry #',ipat
	      else
		 write (99,*) itype,'% bitmap, @entry #',ipat
	      endif
	      call flush(99)
	   ENDIF
C... Read an entry from the DI file
	   i = ipat
	   k = ps_readindex(i,ncrd,npt,dipt,refpt,cdpt)
	   if (k .ne. 0) stop 'error on read'
	   k = ps_readdilib(dipt,PDF2T2,IRELbyte,ndsint)
	   do k=1,ndsint
	      call byte2long(irelbyte(k), int(k))
	      call short2long(PDF2T2(k), PDF2T)
	      FLAG = PDFTOD(PDF2T,DSP(k))
	   enddo
	  IF (NDSINT .le. 0) goto 1
C--------------------------------------------------------------------------
C	SET UP DSPACE BITMAP
	  if (itype .lt. 0) then 
C Catalog the three strongest peaks (may be more than 3 in case of tie)
	    N3S=0
	    DO WHILE (N3S .LT. 3)
C ... go through the list and find the maximum intensity
	      MAXI = -1
	      DO I=1,NDSINT
	        MAXI = MAX(MAXI,INT(I))
	      ENDDO
C ... there are no more valid peaks
	      IF (MAXI .le. 0) goto 1
C ... index all peaks with maximum intensity
	      DO I=1,NDSINT
	        IF (MAXI .eq. INT(I)) THEN
C ... set the intensity negative, so that the peak is not reused
		  INT(I) = -1
	          FLAG = DTOIND(dsp(I),J,n_regions)
	          IF (FLAG) THEN
	            N3S = N3S+1
		    call tblbitset(DSPMAP(1,J),
	1		 ipat, n_cards, 1)  
		  ENDIF
	        ENDIF
	      ENDDO
	    ENDDO
	  ELSE
C ... go through the list and find the maximum intensity
	     MAXI = -1
	     DO I=1,NDSINT
	        MAXI = MAX(MAXI,INT(I))
	     ENDDO
	    DO I=1,NDSINT
	      IF ((100./MAXI)*int(I) .GE. itype) then
	        FLAG = DTOIND(dsp(I),J,n_regions)
	        IF (FLAG)
	1	     call tblbitset(DSPMAP(1,J),
	2	     ipat, n_cards, 1)  
	      ENDIF
	    ENDDO
	  ENDIF
C
1	CONTINUE
C--------------------------------------------------------------------------
C	WRITE OUT BITMAP FILE

	if (itype .lt. 0) then 
	  filename = 'dsp3s.bit'//char(0)
	ELSE
	  write(filename,'(A,i2.2,2A)') 'dsp',itype,'.bit',char(0)
	ENDIF
	i = ps_createbitlib(filename, dbloc)
	if (i .ne. 0) then 
	   write (*,*) 'error creating ',filename
	   stop
	endif

	DO 202 I=1,n_regions
	   k = ps_writebitlib(i, dspmap(1,i), n_cards)
	   dspcnt(i) = tblcount(dspmap(1,i), n_cards)
202	CONTINUE
	call ps_closebit
	write(*,*) 'file ',filename(:lench(filename)),
	1    ' Entries/bin'
	write(*,'(11i7)') (dspcnt(i),i=1,n_regions)
C processing for this bitmap is complete, go on to next
	goto 100
C =========================================================================
C close input files
 9000	call ps_closeindex
!	call ps_closenamlib
	call ps_closedilib
!	call ps_closereflib
C--------------------------------------------------------------------------
	rewind(99)
	write (99,*) 'DONE'
	close(99)
	write (*,*) 'Normal End of Program'
	END
