	include 'copyrght.def'
C
C======================================================================
C this routine loads pointers to the first of each card type
      SUBROUTINE SETCARD (BUFFER, NBYTE, NUMC, POINTC, STATUS)
C======================================================================
	IMPLICIT NONE
      CHARACTER*80  BUFFER(135)
      INTEGER*4 NBYTE, NUMC(22), POINTC(22), STATUS
C======================================================================

      INTEGER*4 MAX(22)
      INTEGER*4 I,ITYPE
      CHARACTER*22 type

C load maximum cards of each type
	include 'max.dat'
      DATA TYPE/'123456789ABCDEFGHIJK+*'/
C						0123456789012

	STATUS = 0

      DO I=1,22
	  NUMC(I) = 0
	  POINTC(I) = 0
	ENDDO

      DO I=1,NBYTE/80
        ITYPE = INDEX (TYPE, BUFFER(I)(80:80))
        IF(ITYPE.EQ.0) THEN
		call errmsg('SETCARD',
     1    BUFFER(1)(73:78),'Invalid card type "'//BUFFER(I)(80:80)//'"')
	    STATUS = 2
	  ELSE
	   IF (NUMC(ITYPE) .eq. 0) POINTC(ITYPE) = I
	   NUMC(ITYPE) = NUMC(ITYPE) + 1
	  ENDIF
	ENDDO

      DO I=1,22
	  IF (NUMC(I) .gt. MAX(I) ) THEN
		call errmsg('SETCARD',
     1	BUFFER(1)(73:78),'Too many cards of type "'//type(I:I)//'"')
	    STATUS = 1
	  ENDIF
	ENDDO

	IF (NUMC(20) .eq. 0) THEN
		call errmsg('SETCARD',
     1	BUFFER(1)(73:78),'No card of type "'//type(20:20)//'"')
	    STATUS = 1
	ENDIF

	RETURN
	END
C!--------------------------------------------------------------
	SUBROUTINE ERRMSG(str1,str2,str3)
C!--------------------------------------------------------------
C report errors
	character*(*) str1,str2,str3
	write(*,*) 'ERROR in ',
     1	str1(:lench(str1)),
     1	'Entry=',str2(:lench(str2)),': ',str3(:lench(str3))
	return
	end
