C---------------------------------------------------------------------------
C	PDFENCODE (PART 1) to generate the PDF-1 (Portable Version)
C
C	Program for reading the full JCPDS-ICDD data base and
C	creating the DI and NAME files with the main index file,
C	and the subfile bitmap file
C
C	            =================================
C	   By: Richard Harlow     1-Oct-1987
C	   Rewritten by: Brian H. Toby	Oct-1990
C
C	This program was derived in part from Mark Holomany's SEARCHTP
C	program which condensed parts of the full data base into an ASCII
C	file more suitable for search/match procedures.  Codes have also
C	been borrowed from Ray Goehner and Mary Garbauskas.  The logic
C	file concept used by subsequent search/match software asscoiated
C	with the files that are about to be created was taken from codes
C	written by Gerry Johnson and Richard Harlow for search/match
C	procedures on the NBS Crystal-data data base.  
C---------------------------------------------------------------------------
	IMPLICIT NONE
	include 'copyrght.def'
C
	include 'pdfread.def'
	include 'pdfwrite.def'
	include 'bitops.def'
	include 'pdfdefs.par'
	include 'pdfdefs.cmn'
	include 'pdfparse.cmn'

	logical debug
	logical DELETED
	CHARACTER*1  ians
	INTEGER*4 Iwords, Ibytes, I, PDF2_OFFSET, lerr, ik
	CHARACTER*4 SUBLIST(100)
	INTEGER*4 isubs

      INTEGER*4 npt, dipt, REFPT, cdpt ! byte pointers
C=======================================================================
C=======================================================================
C
	INTEGER*4 j

!	LOGICAL*1     CHECKLIST(104)
!	CHARACTER*2   ELEMS(25)
!	INTEGER       NELEMS

	INTEGER	     STATUS
C cdloc -- filename (including path) of CDROM 
C dbloc -- path for cdif database files (ending in \)
	CHARACTER*64 cdloc,dbloc,localloc
	integer k
	integer lench
C---------------------------------------------------------------------------
	include 'pdfdefs.dat'
C Debug option -- causes cards to be displayed as processed
!	LISTEM=.FALSE.
C---------------------------------------------------------------------------
!	call gettim(i1,i2,i3,i4)
!	write (*,'(A,i2,a,i2.2)') ' start PDFENCOD @',i1,':',i2
	write (*,'(A)') '=================',' start PDFENCOD',
	1    '================='
	read(*,'(A)') dbloc
	read(*,'(A)') cdloc
	read(*,'(A)') localloc
C terminate strings with nulls
	localloc(lench(localloc)+1:) = char(0)
	cdloc(lench(cdloc)+1:) = char(0)
	dbloc(lench(dbloc)+1:) = char(0)
	write (*,*) 'Reading files from location ',dbloc(:lench(dbloc))
	write (*,*) 'CDROM location ',cdloc(:lench(cdloc))
	write (*,*) 'local AIDS entries ',localloc(:lench(localloc))
C initialize the RET3 routines
!	CALL INITRET3(STATUS)
C initialize the bitmaps and counter variables
	DO J=1,max_words
	  DO I=1,last_sub
	    MISC(J,I) = 0
	  ENDDO
	ENDDO
	NPAT = 0

C DISK/CDROM variables
	BYTES_READ = 0
	PDF2_OFFSET = 0
	namebyte = 0
C output options: ignore deleted patterns completely 
C                                     (SKIPDEL = .true.)
C OR: index them, but don't include D/I's in the PDF-1 
C                                     (SKIPDEL = USEDEL = .false.)
C OR: index them and include D/I's in the PDF-1 
C                                     (SKIPDEL = .false., USEDEL = .true.)
	SKIPDEL = .true.
	USEDEL = .false.
	WRITE(*,'(A,$)') 
     1		' Include DELETED patterns in the PDF-1? (Y/[N]): '
	READ(*,'(A1)') ians
	IF (IANS .eq. 'y' .OR. IANS .eq. 'Y') THEN
	  WRITE(*,'(A)') ' Including "Deleted" patterns'
	  SKIPDEL = .false.
	  WRITE(*,'(A,$)') 
     1     ' Include D/I info for DELETED patterns in PDF-1? (Y/[N]): '
	  READ(*,'(A1)') ians
	  IF (IANS .eq. 'y' .OR. IANS .eq. 'Y') USEDEL = .true.
	  IF (USEDEL) WRITE(*,'(A)') '... with D/I info'
	  IF (.not. USEDEL) WRITE(*,'(A)') '... without D/I info'
	ELSE
	  WRITE(*,'(A)') ' Ignoring "Deleted" patterns'
	ENDIF

C version for ICDD Headquarters:
!	WRITE(*,'(A)') 
!     1		' Enter processing option: ',
!     1		' 	0 Process all patterns',
!     1		' 	1 Process Inorganic patterns only',
!     1		' 	2 Process Minerals patterns only',
!     1		'$	3 Process Metals/Alloys patterns only'
!	READ(*,'(I1)',err=123) icddopt
!123	IF (icddopt .eq. 1) THEN
!	  WRITE(*,'(A)') ' Process Inorganic patterns only'
!	ELSEIF (icddopt .eq. 2) THEN
!	  WRITE(*,'(A)') ' Process Minerals patterns only'
!	ELSEIF (icddopt .eq. 3) THEN
!	  WRITE(*,'(A)') ' Process Metals/Alloys patterns only'
!	ELSE
!	  WRITE(*,'(A)') ' Process all patterns'
!	ENDIF

C---------------------------------------------------------------------------
C---------------------------------------------------------------------------
C Open the input file(s)
C---------------------------------------------------------------------------
C Try to open the PDF File on disk 
	DISK = .false.
	lerr = ps_openpdf2 ('pdf2.dat'//char(0),dbloc,cdloc,0)
	if (lerr .eq. 0) then
	   DISK = .true.
	   WRITE (*,'(/A/)') ' Reading PDF AIDS file'
	endif
1100	continue
C---------------------------------------------------------------------------
C Open the local PDF-2 file, if one exists
200	LOCAL = .false.
	lerr = ps_openpdf2 ('local_pdf2.dat'//char(0),dbloc,localloc,1)
	if (lerr .eq. 0) then
	   write (*,'(2A)') ' Reading local file'
	   LOCAL = .true.
	endif
C---------------------------------------------------------------------------
	IF (.NOT. DISK) STOP 'ERROR -- No database File to read'
C---------------------------------------------------------------------------
C---------------------------------------------------------------------------
C Open the output files
C---------------------------------------------------------------------------
!	open (unit=iname,file=dbloc(:lench(dbloc))//'name.lib',
!     1		status='unknown',form='unformatted')
	i = ps_createnamlib(dbloc)
	if (i .ne. 0) stop 'Error creating name file'
c
!	open (unit=idi,file=dbloc(:lench(dbloc))//'di.lib',
!     1		status='unknown',form='unformatted')
	i = ps_createdilib(dbloc)
	if (i .ne. 0) stop 'Error creating name file'
c
!	open (unit=iref,file=dbloc(:lench(dbloc))//'ref.lib',
!     1		status='unknown',form='unformatted')
	i = ps_createREFlib(dbloc)
	if (i .ne. 0) stop 'Error creating name file'
c
!	open (unit=iind,file=dbloc(:lench(dbloc))//'jcpds.ind',
!     1		status='unknown',form='unformatted')
	i = ps_createindex(dbloc)
	if (i .ne. 0) stop 'Error creating index file'

	open (unit=99,file=dbloc(:lench(dbloc))//'runstat.txt',
     1		status='unknown')
C==========================================================================
C
C	... Begin production of PDF-1 files.
C
C------------------------------------------------------------------------
	isubs = 0
100	DO WHILE (LOCAL .OR. DISK)

C save pointer to the next entry
	cdpt = PDF2_OFFSET
C	Read the next entry from the appropriate PDF2 file
	  IF (LOCAL) THEN
	    icode = 0
	    status =-3
	    status = ps_readpdf2(PDF2_OFFSET, BYTES_READ, max_bf, bf, 1)
	    IF(status .EQ. -1) then
!	       write (*,'(1x,a)') '*** Error reading AIDS entry: '
!	1	    ,(bf(j),j=1,BYTES_READ/80)
	      WRITE (*,'(A)') ' END OF FILE on Local database'
	      LOCAL = .false.
	      BYTES_READ = 0
		  PDF2_OFFSET = 0
	      GOTO 100
	    ELSEIF(status .EQ. -2) THEN
	      WRITE (*,'(A)') ' I/O ERROR Reading from the Local database'
	      LOCAL = .false.
	      BYTES_READ = 0
		  PDF2_OFFSET = 0
	      GOTO 100
	    ENDIF
C-----
	  ELSEIF (DISK) THEN 
	    icode = 1
	    status = ps_readpdf2(PDF2_OFFSET, BYTES_READ, max_bf, bf, 0)
	    IF(status .EQ. -1) then
!	       write (*,'(1x,a)') '*** Error reading AIDS entry: '
!	1	    ,(bf(j),j=1,BYTES_READ/80)
	      WRITE (*,'(A)') ' END OF FILE on DISK database'
	      DISK = .false.
	      BYTES_READ = 0
		  PDF2_OFFSET = 0
	      GOTO 100
	    ELSEIF(status .EQ. -2) THEN
	      WRITE (*,'(A)') ' Too many records from the Disk database'
!	      STOP 'ERROR -- This should not happen'
	      DISK = .false.
	      BYTES_READ = 0
		  PDF2_OFFSET = 0
	      GOTO 100
	    ENDIF
	  ENDIF
C------------------------------------------------------------------------
C now process the entry
C------------------------------------------------------------------------
C save pointers to the entry
	  npt = namebyte
	  dipt = dibyte
	  refpt = refbyte

	  debug = .false.
!	  if (mod(npat,10) .eq. 0 .or. npat .le. 10) debug = .true.
	  CALL SETCARD (bf, BYTES_READ, NUMC, pc, STATUS)
	  IF (STATUS .eq. 0) THEN
	     CALL PDPARSE(status, debug, deleted, sublist, isubs)
	  ENDIF
	  if (status .eq. 0) THEN
!	     write(iind) ncrd,npt,dipt,refpt,cdpt
	     if (deleted) then
		i = ps_writeindex(-ncrd, npt, dipt, refpt, cdpt)
	     else
		i = ps_writeindex( ncrd, npt, dipt, refpt, cdpt)
	     endif
!	     if (debug) write(*,*) 'pointers: ',npt,dipt,refpt,cdpt
	     if (mod(npat,1000) .eq. 0) THEN
		write (*,*) 'read ', npat, ' entries, most recent #',
	1	     BF(1)(73:74)//'-'//BF(1)(75:78), ' (',cdpt,' bytes)'
		call flush(6)
		rewind(99)
		write (99,*) 'read ', npat, ' entries, most recent #',
	1	     BF(1)(73:74)//'-'//BF(1)(75:78), ' (',cdpt,' bytes)'
		call flush(99)
	     endif
	  endif
!	write (*,'(1x,a)') (bf(j),j=1,BYTES_READ/80)
C------------------------------------------------------------------------
C Debug code: end early if the following 4 lines are present
!	  IF (NPAT .ge. 10000) THEN
!	     DISK = .false.
!	     LOCAL = .false.
!	  ENDIF
	ENDDO
C execute on end-of-file
!	IF (ktest .gt. 0) write (*,*) ktest,
!     1	' entries dropped from file due to duplicate ID numbers'
!	ktest = 0
C------------------------------------------------------------------------
C close the name/D-space files
C-------------------------------------------------------------------------
	call ps_closepdf2(0)
	call ps_closepdf2(1)
C-------------------------------------------------------------------------
	IF (isubs .gt. 0) THEN
	   WRITE (*,'(//A,i2,A)') 'Encountered',isubs,
	1	' unsupported subfile(s):'
	   WRITE (*,'(5x,A)') (sublist(IK),IK=1,isubs)
	ENDIF

C------------------------------------------------------------------------
C now write out bitmaps
	Iwords = (NPAT-1)/32 + 1
	Ibytes = Iwords * 4
C show statistics
	WRITE(6,1602) NPAT
1602	FORMAT ('0Total patterns processed:',I7,/,
     1	/,' Number of patterns by subfile number/name')

	i = ps_createbitlib('misc.bit'//char(0), dbloc)
	if (i .ne. 0) stop 'error creating misc.bit'
	DO I=1,last_sub
	   k = ps_writebitlib(i, misc(1,i), npat)
	   if (k .ne. 0) write (*,*) 'Error on bitmap write',k
	   k = tblcount(misc(1,i), npat)
	   j = 1
	   do while (subrec(j) .ne. I .and. J .le. max_sub)
	      j = j + 1
	   enddo
	   IF (j .le. max_sub) then
	      write (*,'(i8,i3,A)') K,I,'  '//sublbl(J)
	   else
	      write (*,'(i8,i3,A)') K,I
	   endif
	enddo
C------------------------------------------------------------------------
	OPEN (UNIT=7,FILE=dbloc(:lench(dbloc))//'pdsize.txt',
     1		STATUS='UNKNOWN')
	WRITE (7,*) NPAT, ' ',BF(1)(73:78),' ' ,last_sub,0,0
	CLOSE (UNIT=7)
C-------------------------------------------------------------------------
C	WRITE OUT THE BITMAP INDEX FILE
C-------------------------------------------------------------------------
C file sizes are computed in blocks (512 bytes/block) 
C    using:  NPAT * # bytes * nrec, where nrec is the # records/file

C write the SUBFILE bitmap
!	isize = last_sub * npat / (8.*512.) + 2.5
!	OPEN (UNIT=25,FILE='PS_BITMAP:MISC.BITMAP',STATUS='NEW',
!	1 FORM='UNFORMATTED',RECL=nword,RECORDTYPE='FIXED',
!	2 initialsize=isize,extendsize=isize/10,USEROPEN=USEROPEN)
!	DO I=1,last_sub
!	  WRITE (25) (MISC(J,I),J=1,nword)
!	ENDDO
!	CLOSE (UNIT=25)

	rewind(99)
	write (99,*) 'DONE'
	close(99)
	write (*,*) 'Normal End of Program'
	END

