      SUBROUTINE SGERRS(SPG,IER,LPT)

!Purpose:      List space group symbol error messages

!      INCLUDE '../inclds/COPYRIGT.FOR'

C       This program was developed for
C                    The Division of Chemistry
C                               of
C               The National Research Council of Canada
C                               by
C       Allen C. Larson, 14 Cerrado Loop, Santa Fe, NM 87505, USA

      CHARACTER*20      SPG
      CHARACTER*48      ERRMSG(30)

      DATA ERRMSG(1)/'Either a 5-axis anywhere or a 3-axis in field'/
      DATA ERRMSG(2)/'Less than 2 operator fields were found       '/
      DATA ERRMSG(3)/'Illegal Lattice type, not P, A, B, C, I, F or R'/
      DATA ERRMSG(4) /'Rhombohedral lattice without a 3-axis    '/
      DATA ERRMSG(5) /'Minus sign does not preceed 1, 2, 3, 4 or 6  '/
      DATA ERRMSG(6) /'Lattice S.R. found an error       '/
      DATA ERRMSG(7)/'1st operator in a field was a space. Impossible'/
      DATA ERRMSG(8) /'I for COMPUTED GO TO out of range.       '/
      DATA ERRMSG(9) /'An A-glide mirror normal to A           '/
      DATA ERRMSG(10)/'A B-glide mirror normal to B            '/
      DATA ERRMSG(11)/'A C-glide mirror normal to C            '/
      DATA ERRMSG(12)/'D-glide in a primitive lattice          '/
      DATA ERRMSG(13)/'A 4-axis not in the 2nd operator field  '/
      DATA ERRMSG(14)/'A 6-axis not in the 2nd operator field  '/
      DATA ERRMSG(15)/'More than 24 matrices needed to define group'/
      DATA ERRMSG(16)/'More than 24 matrices needed to define group'/
      DATA ERRMSG(17)/'Improper construction of a rotation operator'/
      DATA ERRMSG(18)/'No mirror following a /                 '/
      DATA ERRMSG(19)/'A translation conflict between operators'/
      DATA ERRMSG(20)/'The 2bar operator is not allowed        '/
      DATA ERRMSG(21)/'3 fields are legal only in R & m3 cubic groups'/
      DATA ERRMSG(22)/'Syntax error. Expected I-43d at this point.   '/
      DATA ERRMSG(24)/'A or B centered tetragonal?   IMPOSSIBLE      '/
      DATA ERRMSG(30)/'Illegal character in the space group symbol   '/

      WRITE (LPT,'(1X,A)') '****** Error processing symbol '//
     1  SPG,ERRMSG(IER+1)
      RETURN
      END
