      SUBROUTINE ARRAY(MODE,I,J,N,M,S,D)
C
C  COPIED FROM  THE I.B.M.  SCIENTIFIC SUBROUTINE PACKAGE.
C  TO BE USED IN COMBINATION WITH THE SUBROUTINE  MINV (MATRIX INVERSION
C
      DIMENSION S(64),D(64)
      NI=N-I
      IF(MODE .GT. 1) GO TO 20
      IJ=I*J+1
      NM=N*J+1
      DO 10 K=1,J
      NM=NM-NI
      DO 10 L=1,I
      IJ=IJ-1
      NM=NM-1
      D(NM)=S(IJ)
   10 CONTINUE
      GO TO 40
   20 IJ=0
      NM=0
      DO 30 K=1,J
      DO 25 L=1,I
      IJ=IJ+1
      NM=NM+1
      S(IJ)=D(NM)
   25 CONTINUE
      NM=NM+NI
   30 CONTINUE
   40 RETURN
      END
      SUBROUTINE BIBLIO
C  THE SUBROUTINE GIVES A BIBLIOGRAPHY ON INDEXING METHODS AND
C  DIRECTLY RELATED SUBJECTS. DO NOT EXPECT IT TO BE COMPLETE.
C
C  *********************************************************************
C  *  THE AUTHOR WILL BE VERY GRATEFUL FOR EVERY ADDITIONAL RELEVANT   *
C  *  REFERENCE. PLEASE SEND TO:       (fax + 31 15 123 593)           *
C  *  J.W. VISSER/ Henry Dunantlaan 81/ 2614 GL DELFT/ THE NETHERLANDS *
C  *********************************************************************
C
C
C  WHY THIS PROGRAM WORKS AND HOW:
C---------------------------------
C  P.M. DE WOLFF, ACTA CRYST. 10 (1957) 590-595:
C    ON THE DETERMINATION OF UNIT CELL DIMENSIONS FROM POWDER
C    DIFFRACTION PATTERNS.
C  P.M. DE WOLFF, ACTA CRYST. 11 (1958) 664-665:
C    DETECTION OF SIMULTANEOUS ZONE RELATIONS AMONG POWDER DIFFR.LINES
C  P.M. DE WOLFF, ACTA CRYST. 14 (1961) 579-582:
C    RELIABILITY OF UNIT CELLS DERIVED FROM POWDER DIFFRACTION PATTERNS.
C  P.M. DE WOLFF, ADVANCES IN X-RAY ANALYSIS, 6 (1962) 1-17:
C**  INDEXING OF POWDER DIFFRACTION PATTERNS.
C  P.M. DE WOLFF, J. APPL. CRYST. 1 (1968) 108-113:
C    A SIMPLIFIED CRITERION FOR THE RELIABILITY OF A POWDER PATTERN
C    INDEXING.
C  J.W. VISSER, J. APPL. CRYST. 2 (1969) 89-95:
C    A FULLY AUTOMATIC PROGRAM FOR FINDING THE UNIT CELL FROM POWDER DAT
C                       -----------------
C
C  OTHER WELL KNOWN METHODS:
C  -------------------------
C  HESSE,R.   ACTA CRYST. 1 (1948) 200
C    INDEXING POWDER PHOTOGRAPHS OF TETRAGONAL,HEXAGONAL AND
C    ORTHORHOMBIC CRYSTALS.
C  LIPSON,H.   ACTA CRYST.  2 (1949), 43
C    INDEXING POWDER PHOTOGRAPHS OF ORTHORHOMBIC CRYSTALS
C-TRIAL AND ERROR METHODS:
C  WERNER,P.-E.  Z. KRISTALLOGR. 120 (1964) 375-387
C    TRIAL AND ERROR COMPUTER METHODS FOR THE INDEXING OF UNKNOWN
C    POWDER PATTERNS.
C  WERNER,P-E.+ERIKSSON,L+WESTDAHL,M  J.APPL.CRYST.18 (1985) 367-370
C    TREOR, A SEMI-EXHAUSTIVE TRIAL-AND-ERROR POWDER INDEXING PROGRAM
C    FOR ALL SYMMETRIES.
C  TAUPIN,D.   J.APPL. CRYST. 1 (1968) 178-181
C    UNE METHODE GENERALE POUR L'INDEXATION DES DIAGRAMMES DE POUDRES.
C  TAUPIN,D.   J.APPL. CRYST. 6 (1973) 380-385
C    A POWDER-DIAGRAM AUTOMATIC-INDEXING ROUTINE.
C  TAUPIN,D.   J.Appl.Cryst. 22 (1989)  455-459
C    Enhancements in Powder-pattern indexing.
C  GOEBEL,J.B. AND WILSON,A.S. (1965) BATELLE-NORTHWEST REPORT BNWL-22
C    INDEX, A COMPUTER PROGRAM FOR INDEXING X-RAY DIFFRACTION POWDER
C    PATTERNS.
C  KOHLBECK,F. AND HOERL,E.M.  J. APPL. CRYST. 9 (1976) 28-33
C    INDEXING PROGRAM FOR POWDER PATTERNS, ESP. TRICL,MONOCL ETC.
C  KOHLBECK,F. AND HOERL,E.M.  J. APPL. CRYST. 11 (1978) 60-61
C    TRIAL AND ERROR PROGRAM FOR POWDER PATTERNS OF MONOCLINIC SUBSTANCE
C-DEDUCTIVE METHODS (ITO- TYPE):
C  HAENDLER,H.M. AND COONEY,W.A.  ACTA CRYST. 16 (1963) 1243-1248
C    COMPUTER DETERMINATION OF UNIT CELL FROM POWDER DIFFRACTION DATA.
C  ISHIDA,T. AND WATANABE,Y.  J.PHYS.SOC.JAPAN 23 (1967) 556
C  ISHIDA,T. AND WATANABE,Y.  J. APPL. CRYST. 4 (1971) 311-316
C    ANALYSIS OF POWDER DIFFRACTION PATTERNS OF MONOCLINIC AND
C    TRICLINIC CRYSTALS.
C  ISHIDA,T. AND WATANABE,Y.  Z. KRIST. 160 (1982) 19-32
C    A CRITERION METHOD FOR INDEXING UNKNOWN POWDER DIFFRACTION PATTERNS
C-TRIAL AND ERROR IN PARAMETER SPACE:
C  LOUER,D. AND LOUER,M. J. APPL. CRYST. 5 (1972) 271-275
C    METHODE D'ESSAIS ET ERREURS POUR L'INDEXATION AUTOMATIQUE DES
C    DIAGRAMMES DE POUDRE.  (METHOD OF SUCCESIVE DICHOTOMY)
C  LOUER,D  AND VARGAS,R   J.APPL.CRYST.  15 (1982) 542-545
C    INDEXATION AUTOMATIQUE DES DIAGRAMMES DE POUDRE PAR
C    DICHOTOMIES SUCCESIVES.
C-COMBINATIONS OF METHODS:
C  SHIRLEY,R AND LOUER,D   ACTA CRYST. A 34 (1978) S382 (ABSTRACT):
C    NEW POWDER INDEXING PROGRAMS FOR ANY SYMMETRY WHICH COMBINE
C    GRID-SEARCH WITH SUCCESSIVE DICHOTOMY.
C  SHIRLEY,R. IN 'CRYSTALLOGRAPHIC COMPUTING' DELFT UNIVERSITY PRESS 197
C    INDEXING POWDER DIAGRAMS. P 221-234.
C-UNKNOWN:
C  KIRCHMAYER,H. AND LEEB,M.: ZEITSCHR. FUR NATURF. 18A (1963)  1144
C
C
C  THE RELIABILITY OF THE UNIT CELL OBTAINED:
C  ------------------------------------------
C  WOLFF,P.M. DE,   J. APPL. CRYST. 1 (1968) 108-113:
C    A SIMPLIFIED CRITERION FOR THE RELIABILITY OF A POWDER PATTERN
C    INDEXING.
C  WOLFF,P.M. DE,   J. APPL. CRYST. 5 (1972) 243
C    THE DEFINITION OF THE INDEXING FIGURE OF MERIT M20.
C  WERNER,P.-E.   J. APPL. CRYST. 9 (1976) 216-219:
C   ON THE DETERMINATION OF UNIT CELL DIMENSIONS FROM INACCURATE DATA.
C  MIGHELL,A.D. AND STALICK,J.K.  ACCURACY IN POWDER DIFFRACTION 393-403
C    THE RELIABILITY OF POWDER INDEXING PROCEDURES.
C
C  REVIEW PAPERS:
C  --------------
C  P.M. DE WOLFF, ADVANCES IN X-RAY ANALYSIS, 6 (1962) 1-17:
C**  INDEXING OF POWDER DIFFRACTION PATTERNS.
C  SHIRLEY,R. IN ACCURACY IN POWDER DIFFRACTION  (1979) 361-382.
C** DATA ACCURACY FOR POWDER INDEXING.  (PAPER ON THE INDEXING PROBLEM)
C  SHIRLEY,R. ACTA CRYST. A 31 (1975) S197 (ABSTRACT):
C    RECENT ADVANCES IN DETERMINING UNKNOWN UNIT CELLS FROM POWDER
C    DIFFRACTION DATA.
C  SHIRLEY,R. IN 'CRYSTALLOGRAPHIC COMPUTING' DELFT UNIVERSITY PRESS 197
C    INDEXING POWDER DIAGRAMS. P 221-234.
C
C
C  LESS OFTEN USED METHODS AND RELATED PUBLICATIONS
C  ------------------------------------------------
C--GRAPHIC METHODS
C  ZSOLDOS,L.  ACTA CRYST. 11 (1958), 835-839  (A GRAPHICAL METHOD)
C    A GENERAL METHOD OF INDEXING PHOTOGRAPHS OF LOW-SYMMETRY CRYSTALS.
C  ARTHUR JR,P.  Z. KRISTALLOGR. 120 (1964) 415-426.
C    AN APPROACH TO THE INDEXING OF X-RAY POWDER DIFFRACTION PATTERNS.
C--DIOPHANTINE EQUATIONS (USING THE FACT THAT MILLER INDICES ARE INTEGER
C  STOSICK,A.J.  ACTA CRYST. 2 (1949) 271-277
C    A METHOD FOR INDEXING POWDER PHOTOGRAPHS, USING LINEAR DIOPHANTINE
C    EQUATIONS, AND SOME TESTS FOR CRYSTAL CLASSES.
C  VAND,V. AND JOHNSON JR,G.G.  ACTA CRYST. A24 (1968) 543-546
C    INDEXING OF X-RAY POWDER PATTERNS.PART I.
C    THE THEORY OF THE TRICLINIC CASE.
C--DEDUCTIVE METHODS, ITO-TYPE:
C  HOMES,G.A. AND GOUZOU,J.  REV. DE METALL. 51 (1954) 749-757
C    RECHERCHE D'UNE METHODE NOUVELLE DE DECHIFFREMENT DES DIAGRAMMES
C    DE DEBYE-SCHERRER.
C  MCMASTERS,O.D. & LARSEN,W.L.  IS-839   MARCH 1, 1964.
C    DETERMINATION OF THE CRYSTALLOGRAPHIC LATTICE TYPE AND CELL
C    CONSTANTS FROM X-RAY POWDER PATTERN DATA:  A COMPUTER PROGRAM.
C    AMES LABORATORY AT IOWA STATE UNIVERSITY.
C  PROST,M. & MENTZEN,B.  C.R.ACAD.SC. PARIS,(SER C) 274 (1972) 1123-112
C    SUR LE DEPOUILLEMENT AUTOMATIQUE DES DIAGRAMMES DE DIFFRACTION X
C    OBTENUS PAR LA METHODE DES POUDRES.
C--ON LIPSON METHODS:
C  DAVIES,P.T. ACTA CRYST. 7 (1954) 623
C    AN IMPROVED METHOD OF INDEXING POWDER DIFFRACTION PATTERNS OF
C    ORTHORHOMBIC CRYSTALS.
C  ZSOLDOS,L.  ACTA CRYST. 16 (1963), 572-573
C    ON THE MOST PROBABLE DIFFERENCES OCCURRING IN THE LIPSON-HESSE
C    DIFFERENCE METHOD FOR INDEXING POWDER PHOTOGRAPHS.
C--ON MONOCLINIC PATTERNS:
C  ZACHARIASEN,W.H.  ACTA CRYST. 16 (1963) 784-788
C    INTERPRETATION OF MONOCLINIC POWDER X-RAY DIFFRACTION PATTERNS.
C  SMITH,G.S. AND KAHARA,E.  J. APPL. CRYST. 8 (1975) 681-683
C    AUTOMATED COMPUTER INDEXING OF POWDER PATTERNS: THE MONOCLINIC CASE
C  GUO CHANG-LIN & MA LI-TAI, ACTA PHYSICA SINICA 32 (1983) 1-14
C    AN ANALYTICAL METHOD FOR INDEXING X-RAY POWDER PATTERNS
C    OF MONOCLIONIC SUBSTANCES. (IN CHINESE, ENGL. ABSTRACT)
C--ON HIGH-SYMMETRY LATTICES:
C  WU XUEQUAN AND ZUNG-PING CHANG   J.APPL. CRYST. 17 (1984) 395-399
C    AN ANALYTICAL METHOD FOR INDEXING POWDER DIFFRACTION PATTERNS
C    OF HIGHER-SYMMETRY SUBSTANCES.
C--RELATED AND UNCLASSIFIED PAPERS:
C  VAND,V.     ACTA CRYST.  1 (1948), 109-115 AND 290-291.
C    INDEXING METHOD OF POWDER PHOTOGRAPHS OF LONG-SPACING COMPOUNDS.
C  HAUCK,J.   Z. KRISTALLOGR. 149 (1979)  188-190
C    EIN EINFACHES HILFSMITTEL ZUR INDIZIERUNG VON PULVERAUFNAHMEN.
C  SMITH,G.S.   J. APPL. CRYST. 9 (1976) 424-428
C    ESTIMATING UNIT CELL VOLUMES FROM POWDER DIFFRACTION DATA:
C    THE TRICLINIC CASE.
C  SMITH,G.S.   J. APPL. CRYST.10 (1977) 252-255
C    ESTIMATING THE UNIT CELL VOLUME FROM ONE LINE IN A POWDER
C    DIFFRACTION PATTERN: THE TRICLINIC CASE.
C  FERRO,R.   ATTI D. ACAD. NAZ. LINCEI  15 (1953) 285-289
C    CRISTALLOGRAFIA DIFFERENZIALE DELLE POLVERI.
C  GUO CHANG-LIN & HUANG YUE-HONG, ACTA PHYSICA SINICA 31 (1982) 972-6
C    AN ITERATIVE CORRECTION METHOD FOR INDEXING THE X-RAY POWDER
C    DIFFRACTION PATTERNS.
C  SERYKH,V.P.   KRISTALLOGRAFIYA 27 (1982) 994(SOV.PH.CR. 27  596)
C    USE OF EXTINCTIONS IN PROGRAMS FOR INDEXING POWDER PATTERNS.
C  SERYKH,V.P.  KRISTALLOGRAFIYA 20 (1975) 1170-1174
C    ON UNAMBIGUOUS INDEXING OF X-RAY POWDER PHOTOGRAPHS OF MONOCLINIC
C    AND RHOMBIC CRYSTALS.(SOV. PHYS. CRYST. 20  710-712)
C  SERYKH,V.P.  KRISTALLOGRAFIYA 24 (1979) 1041-1042
C    RELIABILITY OF INDEXING OF X-RAY DIFFRACTION POWDER PATTERNS
C    (SOV. PHYS. CRYST. 24 (1979) 595-596  )
C  SERYKH,V.P.  TITOV,YU.G.  MATYUSHENKO,N.N.  KRIST.GRAFIYA 16 226-228
C    THE RANGES OF THE INDICES IN THE QUADRATIC FORMULA FOR
C    POLYCRISTALLINE AGGREGATES.   (SOV. PHYS. CRYST. 16 (1971) 181-182
C  PASZKOWICZ,W.   ACTA CRYST A40, C367 (1984):
C    INDEXING OF ORTHORHOMBIC POWDER PATTERNS WITH THE OPTIMIZATION METH
C  ZLOKAZOV,V.B. , MRIAAU- a program for autoindexing multiphase polycrystals.
C    J.APPL.CRYST. 25 (1992) , 69-72.
C  MACICEK,Jozef : BLAF - a robust program for tracking out ('finding')
C    admittable Bravais lattices from the experimental unit-cell data.
C    J.Appl.Cryst. 25 (1992) 73-80.
C                       ---------------------
C
C  OLDER PUBLICATIONS:
C  ------------------
C  RUNGE,C.   PHYS. Z. 18 (1917) 509-515
C    DIE BESTIMMUNG EINES KRISTALLSYSTEMS DURCH ROENTGENSTRAHLEN.
C  JOHNSEN,A. AND TOEPLITZ,O., PHYS. Z. 19 (1918) 47-55
C    UEBER DIE MATHEMATISCHE AUSWERTUNG DER DEBYE-SCHERRERSCHEN
C    ROENTGEN-SPEKTROGRAMME.
C  ITO,T.  NATURE (LONDON) 164 (1949) 755-756:
C     A GENERAL POWDER X-RAY PHOTOGRAPHY
C  ITO,T.  X-RAY STUDIES ON POLYMORPHISM   TOKIO, MARUZEN.(1960)
C--GRAPHICAL  METHODS:
C  HULL,A.W. AND DAVEY,W.P.  PHYS. REV. 17 (1921) SER. 2, 549-570
C  BJURSTROEM,T.  Z. PHYS. 69 (1931)  346-355
C  BUNN,C.W.   CHEMICAL CRYSTALLOGRAPHY (1945) OXFORD,UNIVERSITY PRESS.
C  NOVAK,C.  CZECHOSLOV. J. PHYS. 4 (1954) 496
C                       --------------------
C
C
C=======================================================================
C 'ADVANCES IN X-RAY ANALYSIS' ARE THE PROCEEDINGS OF THE ANNUAL
C    DENVER X-RAY CONFERENCES.
C 'ACCURACY IN POWDER DIFFRACTION'  IS THE PROCEEDINGS OF A SYMPOSIUM
C    WITH THAT TITLE, HELD AT THE NBS IN GAITHERSBURG IN 1979. IT IS
C    ISSUED AS  NAT. BUR. OF STANDARDS (USA) SPECIAL PUBLICATION 567.
C=======================================================================
C** THE PAPERS BY DE WOLFF AND SHIRLEY GIVE A GOOD INTRODUCTION TO
C   THE SUBJECT WITHOUT BECOMING TOO TECHNICAL.
C                        ----------------
C
      COMMON /LINES / IDOC,INP,IOUT,NCRT,MAX,OBS(40),CEL(10)
      WRITE(IOUT,90)
   90 FORMAT(    40(2H==)/
     1 ' ==A RESTRICTED BIBLIOGRAPHY IS GIVEN IN THE TEXT OF THE',
     2 ' SUBROUTINE  *BIBLIO*   ==' /     40(2H==)  //  )
      RETURN
      END
      SUBROUTINE     CRITER(K1,L1,CENTER,CRIT,NO,NC)
C  THIS SUBROUTINE CALCULATES THE PROBABILITY THAT A ZONE IS FOUND BY
C  PURE CHANCE. A LINE WITH ITS HIGHER ORDERS IS COUNTED AS ONE
C  OBSERVATION.
C  INPUT PARAMETERS:   K1 IS THE STEPSIZE FOR K
C                      L1 IS THE STEPSIZE FOR L (H)
C                      CENTER OBVIOUSLY GOVERNS THE TEST ON CENTERING
C                      PROB IS THE PROBABILTY OF FINDING A LINE BY CHANC
C  OUTPUT PARAMETER:   CRIT IS THE INVERSE OF THE PROBABILITY THAT THIS
C                      ZONE IS FOUND BY PURE CHANCE
C
C  EVAL IS
C             ZERO ON THE POSITIONS WHERE THE CALCULATED Q WAS TOO LARGE
C
C             NEGATIVE WHEN THE Q-VALUE WAS ONLY CALCULATED BUT NOT
C             OBSERVED,  AND
C
C             POSITIVE WHEN THE CALCULATED Q WAS ALSO OBSERVED.
C
C  THE VALUE OF EVAL IS A SORT OF PROBABILITY THAT A CALCULATED LINE
C  HITS AN OBSERVED LINE BY CHANCE.
C
C
      INTEGER   H,HG
      DIMENSION EVA(-8:8,0:8)
      LOGICAL   PRES,CENTER,RECTAN
      COMMON /EVALN / NORDER,RECTAN,PROB(40),EVAL(-8:8,0:8),
     1                UPBNDR(40)
      ZERO=1.0E-30
      NCENTR=1
      IF ( CENTER) NCENTR=2*K1
      DO 12 I=-8,8
      DO 10 J=0,8
   10 EVA(I,J)=EVAL(I,J)
   12 CONTINUE
      KG=NORDER*K1
      HG=NORDER*L1
      NC=0
      NO=0
      CRIT=1.
      LSTEP=L1
      IF (CENTER) LSTEP=NCENTR
      DO 110 K=0,KG, K1
         LMIN=0
         IF (CENTER) LMIN=MOD(K,NCENTR)
         IF (K .EQ. 0) LMIN=LSTEP
         DO 100 L=LMIN,HG, LSTEP
         H=L
   30    IF (ABS(EVA(H,K)) .LT. ZERO) GO TO 100
         PRES=.FALSE.
         DO 90 N=1,8
            NH=N*H
            NK=N*K
            IF (IABS(NH).GT.HG .OR. NK.GT.KG) GO TO 95
            IF (PRES) GO TO 85
            IF (CENTER .AND. (MOD((NH+NK),NCENTR) .NE. 0) ) GO TO 90
            IF (EVA(NH,NK) .GT. ZERO) THEN
               CRIT=CRIT*EVA(NH,NK)
               PRES=.TRUE.
            END IF
   85       EVA(NH,NK)=0.
   90    CONTINUE
   95    IF (PRES) NO=NO+1
         NC=NC+1
         IF (RECTAN) GO TO 100
         IF (H .LE. 0) GO TO 100
         H=-L
         GO TO 30
  100    CONTINUE
  110 CONTINUE
      MIN=3
      IF (RECTAN) MIN=2
      NO=NO-MIN
      NC=NC-MIN
C  WE REQUEST  THAT THE NUMBER OF OBSERVED LINES IS AT LEAST
C  25 PERCENT OF THE NUMBER OF CALCULATED LINES.
      IF (4*NO .GE. NC) THEN
         J=NO
         IF (2*NO .GT. NC) J=NC-NO
         IF (J .EQ. 0) GO TO 150
         DO 120 II=1,J
            I=II-1
            CRIT=CRIT*FLOAT(NC-I)/FLOAT(II)
  120    CONTINUE
      ELSE
         CRIT=100.
      END IF
  150 CRIT=1.0/CRIT
      IF (CRIT .GT. 1.0E+10) CRIT=9.999E+9
      RETURN
      END
      SUBROUTINE ECHO
C-----------------------------------------------------------------------
C  THE PURPOSE OF THIS SUBROUTINE IS TO PRINT THE CARD IMAGES OF THE
C  INPUT 'CARDS' ON A SEPARATE PAGE.
C  THIS IS VERY USEFUL FOR TEST PURPOSES AND FOR DOCUMENTATION.
C
C  THE INPUT DATA ARE READ AS CHARACTERS FROM THE 'INP' UNIT AND
C  WRITTEN ON THE *DOCUMENTATION FILE* (4) (IDOC=4).
C  THE OTHER SUBROUTINES READ FROM THE 'INTERNAL FILE' *CARD*
C
C  ECHO ALSO TESTS FOR THE END OF THE DATA. ('END' IN THE FIRST 4 COLS)
C-----------------------------------------------------------------------
      CHARACTER NAME*80,CARD*80,INTSY*2
      COMMON /LINES / IDOC,INP,IOUT,NCRT,MAX,OBS(40),CEL(10)
      COMMON /CHARCM/ NAME,CARD,INTSY(50)
      DATA NCRD/0/
      NCRD=NCRD+1
      IF (NCRD .EQ. 1) WRITE(IDOC,9900)
      READ(INP,9901,IOSTAT=IOS)  CARD
C     write(ncrt,9903) card
      IF (IOS .EQ. 0) THEN
         WRITE(IDOC ,9902) NCRD, CARD
         I=INDEX(CARD, 'END' )
         IF ( (I .EQ. 1) .OR. (I .EQ. 2) ) THEN
            WRITE(IOUT,9998)
            WRITE(NCRT,9998)
            STOP
         END IF
      ELSE  IF (IOS .LT. 0 ) THEN
         WRITE(IOUT,9995)
         WRITE(NCRT,9995)
         WRITE(NSUMM,9995)
         STOP
      ELSE
         WRITE(IOUT,9996)
         WRITE(NCRT,9996)
         WRITE(NSUMM,9996)
         STOP
      END IF
      RETURN
 9900 FORMAT(48H ON THIS PAGE THE CARD IMAGES OF THE INPUT CARDS ,
     1 14H ARE PRINTED.  //  20H  NR     CONTENTS       //
     2 7X,2H 0,8X,2H10,8X,2H20,8X,2H30,8X,2H40,8X,2H50,8X,2H60,
     3 8X,2H70,8X,2H80/ 8X,8(10HI....|....),1HI)
 9901 FORMAT(A80)
 9902 FORMAT(/ ,I3,5X,A80)
 9903 FORMAT(1H ,A80)
 9995 FORMAT(/' UNEXPECTED END OF INPUT, PROGRAM STOPS' /
     * ' DID YOU FORGET TO PUT  *-* END *-* IN THE LAST LINE' /
     * ' OF THE INPUT ??? ' )
 9996 FORMAT(/' ERROR IN INPUT, PROGRAM STOPS.'/
     * ' DID YOU FORGET TO PUT  *-* END *-* IN THE LAST LINE' /
     * ' OF THE INPUT ??? ' )
 9998 FORMAT(/' END OF INPUT,  NORMAL END OF PROGRAM')
      END
