C  ---------------------------------------------------------------------
C
C             THIS PROGRAM WAS WRITTEN BY
C                        J.W. VISSER
C             OF THE TECHNISCH PHYSISCHE DIENST TNO-TH
C             P.O.BOX 155 DELFT NETHERLANDS.
C             IT CONTAINS MANY IDEAS AND SUGGESTIONS FROM
C                       PROF.DR. P.M. DE WOLFF
C             OF THE TECHNICAL UNIVERSITY (T.H) DELFT.
C
C
C             A DESCRIPTION OF THE PROGRAM WAS PUBLISHED IN
C             JOURNAL OF APPLIED CRYSTALLOGRAPHY.(1969) 2,89.
C
C
C             THIS WORK WAS LARGELY SPONSORED BY THE  THEN NAMED
C             'JOINT COMMITTEE ON POWDER  DIFFRACTION STANDARDS '
C             now  'The International Centre for Diffraction Data'
C             at the   Newtown Square Corporate Campus
C             12 Campus Boulevard,  Newtown Square, PA 19073 - 3273
C             AND THE CENTRAL ORGANIZATION FOR  TNO, THE HAGUE,
C             NETHERLANDS.
C
C
C     THE PURPOSE OF THE PROGRAM IS TO FIND THE UNIT CELL FROM
C     THE POWDER PATTERN  OF COMPOUNDS OF LOW SYMMETRY.
C     ONE- AND TWO- PARAMETER PROBLEMS CAN BE SOLVED BY SIMPLER
C     METHODS, BUT WILL BE SOLVED TOO.
C
C
C     THANKS ARE DUE TO   ROBIN SHIRLEY    OF THE UNIVERSITEY OF SURREY
C     WHO CONTRIBUTED MANY EXCELLENT IDEAS  AND ALSO MADE THE OUTPUT
C     MUCH BETTER UNDERSTANDABLE,
C                   AND
C     DR. GERALD G. JOHNSON JR. OF THE PENNSYLVANIA STATE UNIVERSITY
C     FOR MANY EXCELLENT IDEAS, SOME AS A RESULT FROM FEEDBACK BY USERS
C     IN THE U.S.A. TO WHOM HE DISTRIBUTED  THIS PROGRAM,   AND FOR
C     FORCING ME TO WRITE THIS PROGRAM IN A STANDARD (ANSI) LANGUAGE.
C
C
CXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
C        THIS PROGRAM HAS PASSED THROUGH SEVERAL VERSIONS AND HAS
C     FOUND THE CORRECT UNIT CELL IN A LARGE NUMBER OF CASES. IT IS
C     POSSIBLE, HOWEVER, THAT UNDER SOME CIRCUMSTANCES, WITH A PARTICULA
C     SET OF DATA, OR WHEN USED WITH A PARTICULAR COMPUTER SYSTEM,
C     ERRONEOUS RESULTS WILL BE OBTAINED.
C     THE AUTHOR, THE  TECHNISCH PHYSISCHE DIENST TNO-TH, OR THE
C     JOINT COMMITTEE ON POWDER DIFFRACTION STANDARDS, THEREFORE, TAKE
C     NO RESPONSIBILITIES WHATSOEVER FOR  THE CORRECTNESS OF THE
C     PROGRAM OR THE RESULTS.
C        IT WOULD BE APPRECIATED IF ANY DISCREPANCIES IN THE PROGRAM
C     ARE BROUGHT TO THE ATTENTION OF THE AUTHOR, FOR IMPROVEMENTS IN
C     LATER VERSIONS.
CXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C                       VERSION  15      NOVEMBER  1993
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C        VERSION 0
C             VERSION 1 WAS PRECEDED BY SEVERAL VERSIONS OF AN
C             ALGOL PROGRAM, WHICH WAS SEMI-AUTOMATICALLY TRANSLATED
C             INTO A PL/1 PROGRAM, WHICH WAS THEN TRANSLATED INTO
C             A FORTRAN PROGRAM. THE CHANGE FROM ALGOL TO PL/1
C             BECAME NEARLY A NECESSITY BY SWITCHING FROM A TELEFUNKEN
C             TR4 TO AN IBM-MACHINE. PL/1 WAS ABANDONED BECAUSE IT WAS
C             NOT SO UNIVERSALLY KNOWN AS WE WERE LED TO BELIEVE.
C        VERSION 1
C             TRIALS TO MAKE THE  FORTRAN  PROGRAM EQUIVALENT TO
C             THE PL/I PROGRAM.
C        VERSION 2
C            = PROVISIONS FOR MOLECULAR WEIGHT AND DENSITY.
C            = PRINT-OUT OF INPUT CARDS.
C        VERSION 3
C            = ADDITION OF THE PROCEDURE SYMTST (TESTING ON
C              HIGHER SYMMETRIES) AND LESSER IMPROVEMENTS.
C        VERSION 4.
C            = ADAPTATIONS TO AVOID DIFFICULTIES ENCOUNTERED ON
C              OTHER MACHINES (INCLUDING OTHER IBM-MACHINES).
C            = INTRODUCTION OF SUBROUTINE  ECHO IN CONNECTION
C              WITH BACKSPACE DIFFICULTIES.
C            = MINOR CHANGES IN THE OUTPUT.
C            = SUBROUTINES IN ALFABETICAL  ORDER.
C        VERSION 5
C            = INSTRUCTION MANUAL
C            = IMPROVED OUTPUT TEXT.
C            = MORE TESTS ON INPUT.
C            = TESTING ON HIGHER SYMMETRIES  IMPROVED.
C            = AN EFFORT HAS BEEN MADE TO COMPLY WITH THE REQUIREMENTS
C              OF  *ANS* FORTRAN.  THIS WAS NOT EVERYWHERE POSSIBLE.
C        VERSION 6
C            = MANY WISHES FROM USERS FULFILLED.
C            = DISCLAIMERS, BOTH IN COMMENT ON MAIN AND IN OUTPUT.
C            = MIXED-MODE ARITHMETIC REMOVED.
C            = SUBROUTINE WRISP REWRITTEN FOR FASTER PRINTING.
C            = POSSIBILITY TO PRINT AN INSTRUCTION MANUAL ON THE
C              SPECIAL FEATURES OF THE PROGRAM.
C            = POSSIBILITY TO ENTER  INTENSITIES WITH THE LINES.
C            = POSSIBILITY TO PRODUCE A LIST OF ALL CALCULATED AND
C              OBSERVED LINES.
C            = POSSIBILITY TO ENHANCE CERTAIN CRYSTAL SYSTEMS. DUE TO
C              THE GENERAL CONSTRUCTION OF THE PROGRAM, THIS IS ONLY
C              POSSIBLE FOR ORTHORHOMBIC,MONOCLINIC OR TRICLINIC
C              LATTICES.
C            = PROBABILITY TO  *HIT*  A LINE IS SUBDIVIDED OVER THE
C              Q RANGE.   CHANGES IN  CRITER.
C            = ERROR LIMITS ON OBSERVED Q'S CALCULATED ONCE.  DISPLAYED
C              WHEN TEST=.TRUE.
C            = OVERLAYS  TESTED.
C        VERSION 7
C            = ALL  A-FORMATS REDUCED TO A1, EXCEPT THOSE THAT PRINT
C              INTENSITIES IN CHARACTER FORM (A3)-  THESE OCCUR  ONLY
C              IN *READER*, *LISTM* AND *REFINE* .
C            = TRIES TO INDEX ALL LINES WITH THE UNIT CELL OF
C              THE BEST SOLUTION.
C            = INSTRUCTIONS REWRITTEN, OTHER EXPLANATIONS EXTENDED.
C            = THE USE OF ONE SET OF HKL'S TO EXPLAIN MORE THAN
C              ONE OBSERVED LINE  IS FLAGGED.
C            = NUMBER OF SOLUTIONS THAT  ARE PRINTED OUT EXTENSIVELY
C              CAN BE CHANGED.
C        VERSION 8
C            = INPUT FORMAT CHANGED-- ADDITIONAL PARAMETER CARD.
C            = ZERO SHIFT (SPECIMEN DISPLACEMENT+TRANSPARENCY
C              CORRECTION ON DIFFRACTOMETER)--THE NEW PARAMETER CARD
C              STARTS WITH THE ZERO CORRECTION (ZERCOR), TO BE
C              APPLIED TO ALL ANGLES.
C            = ZERCHK-- THE PROGRAM APPLIES 20 DIFFERENT ZERO SHIFTS
C              AND GIVES FOR EACH SHIFT THE NUMBER OF HIGHER ORDER
C              LINES THAT FIT--   IN THIS WAY IT SHOULD BE POSSIBLE
C              TO DECIDE WHETHER A ZERO SHIFT IS NECESSARY.
C            = ONLY SOLUTIONS WITH A FIGURE OF MERIT THAT IS BETTER
C              THAN 4.0 ARE PRINTED--YOU MAY SET YOUR OWN MINIMUM
C              WITH PRNTMR.
C            = WITH PRNTLN YOU CAN SET YOUR OWN MINIMUM OF INDEXED
C              LINES THAT IS NEEDED IN ORDER THAT THE LATTICE
C              WILL BE PRINTED.
C            = FOR TRIAL, IT IS NOW POSSIBLE TO ENTER A DIRECT CELL.
C            = COMBINATIONS OF ZONES WITH ITSELF NOW TRIES BOTH AXES
C              AS 'COMMON' AXES.
C            = THE NUMBER OF CYCLES OF LATTICE REFINEMENT IS INCREASED.
C            = *REFPAR* IS SPLIT INTO TWO SUBROUTINES,ONE OF WHICH
C              (REFPAR) SETS THE PARAMETERS FOR THE OTHER (REFINE)--
C              THE LATTER SUBROUTINE DOES THE ACTUAL CALCULATIONS.
C            = TOLERANCES  ON FITTING LINES NOW EXPRESSED IN TWO THETA.
C            = A(3) FORMATS CHANGED INTO A(2),1X.
C        VERSION 8.5
C            =     THE MAIN PROGRAM IS NOW SPLIT INTO 3 PARTS,AABITO,
C              AAITO1 AND ANITO2--  THE NEW MAIN PROGRAM (AABITO)
C              COMMENTS, INITIALISES SOME VALUES AND CALLS READER, AAITO1
C              AND ANITO2.
C            = ZERCHK IS NOW OPTIONAL (COL. 33 IN PARAMETER CARD).
C            = THE SUBROUTINE *NTEST* LIMITS THE TEST OUTPUT TO
C              A SMALL PART OF THE PROGRAM, OR PRINTS ALL TEST OUTPUT
C              AFTER A CERTAIN POINT-- THE COMMENT IN THE SUBROUTINE
C              GUIDES YOU TO THE ACTUAL CALLS--  THE SUBROUTINE IS ONLY
C              USEFUL WHEN YOU ARE CHANGING PARTS OF THE PROGRAM.
C            = LATTICES THAT ARE DISCARDED IN *NORM3* ARE NOW
C              EXPLICITLY NAMED--  ALSO NAMED ARE THE LATTICES THAT ARE
C              DISCARDED BECAUSE THEY ARE  *EQUAL* TO OTHERS.
C        VERSION 9
C            = SUBROUTINE READER WAS SPLIT IN TWO PARTS, READER  AND
C              REDLIN. THIS LAST SUBROUTINE READS THE INPUT LINES. IT
C              ALSO CALCULATES THE MAXIMUM ERROR (IN TWO THETA) THAT
C              YOUR INPUT DATA COULD HAVE IN ORDER TO BE ABLE TO PASS
C              THE TESTS (FIGURE OF MERIT .GT. 10)--
C            = TWICE THIS MAXIMUM ERROR IS USED AS THE DEFAULT TOLG,
C              BUT ONLY IF TOLG REMAINS LESS THAN 0.060 DEGREES. --
C              ENTERING YOUR OWN TOLG OVERRIDES THE DEFAULTS.--
C            = IN THE LIST OF ALL CALCULATED AND OBSERVED LINES,
C              THE UNINDEXED LINES ARE NOW MARKED CONSPICUOUSLY (IDEA
C              FROM CAM HUBBARD)--
C            = THE FATE OF THE POSSIBLE LATTICES IS PRINTED IN FULL,
C              BUT ONLY IF YOU PRINT INTERMEDIATE RESULTS (ENL=TRUE)--
C            = THE MINIMUM VALUES OF THE RECIPROCAL LATTICE CONSTANTS
C              NOW ALLOWS THE FIRST LINE TO BE A FOURTH ORDER. IN AN
C              EXPERIMENTAL PATTERN, WHICH WAS ORTHORHOMBIC  WITH
C              SPACEGROUP FDD2, THIS SITUATION ACTUALLY OCCURRED ---
C        VERSION 10  (A)
C                          FORTRAN 77
C            = MODIFIED TO CONCUR WITH FULL FORTRAN 77.THIS ALLOWED A
C              SIMPLER VERSION OF SUBROUTINE ECHO.--
C            = EXPLANATION OF THE VARIABLES IN COMMON BLOCKS IS
C              GIVEN IN THIS PROGRAM (BELOW). --
C            = INDIVIDUAL PROBABILITIES FOR EACH LINE (FOR FINZON).--
C            = CRITER CHANGED TO CONCUR WITH EARLIER IDEAS.--
C            = SORTING OF ZONES IN THE NEW SUBROUTINE  *SRTZON* --
C            = THE OUTPUT OF EVALUATE IS SORTED ON THE CRITERION
C              CRIT,  BUT IF NO CORRECT LATTICE IS OBTAINED, IT IS USED
C              AGAIN BUT SORTED ON THE NUMBER OF OBSERVED LINES (NO)
C              THAT MATCH THE ZONE. A SUBSORT IS MADE ON THE NUMBER OF
C              CALCULATED LINES (NC). THIS SOMETIMES LEADS TO SUCCES.--
C            = THE PAPER BY MIGHELL AND STALICK IN 'ACCURACY IN POWDER
C              DIFFRACTION' HAS CONVINCED ME THAT IT IS NECESSARY TO
C              ENSURE THAT ALL AVAILABLE DATA (UP TO 40 LINES) IS
C              ENTERED INTO THE PROGRAM.
C            = IF YOU NOW WANT TO ENTER LESS THAN 32 LINES, YOU GET A
C              WARNING AND YOU HAVE TO ENTER THE CORRECT NUMBER OF LINES
C              ON THE SECOND PARAMETER CARD.--
C            = A TRIAL WAS MADE IN REFINING THE ZONES ON THETA
C              INSTEAD OF Q. THIS DID NOT WORK AS WELL AS REFINING ON Q.
C              THEREFORE, ONLY THE BEST ZONES ARE (AT THE END OF THE
C              EVALUATION PROCESS) REFINED ON THETA IN ORDER TO
C              ESTABLISH  A ZERO-SHIFT FOR EACH ZONE.
C            = SINCE I DO NOT KNOW YET HOW USEFUL THIS CAN BE, NOTHING
C              MUCH IS BEING DONE WITH IT.  IF YOU WANT TO, YOU CAN
C              USE THE INFORMATION BY ENTERING A CONVINCING
C              TWOTHETA-SHIFT INTO THE PROGRAM (REVERSE THE SIGN STATED
C              AND ENTER ON SECOND PARAMETER CARD IN COL 1-9). --
C            = LATTICES ARE ALSO REFINED ON TWOTHETA, TOGETHER
C              WITH A ZERO SHIFT. THE ZERO SHIFT IS STORED IN
C              ROSTER(I,11) AND PRINTED.
C
C        VERSION 11
C            = ECHO CHANGED FOR THE USE OF *IOSTAT*. --
C            = PRINTING OF Q-SCHEMES FOR THE LATTICES ONLY
C              WHEN TEST=TRUE. --
C            = INSTRUCTIONS CLARIFIED. --
C            = INPUT OF 32 LINES AND LESS WITHOUT DIFFICULTY AGAIN,
C              BUT WITH AMPLE WARNING. --
C            = FINAL SORTING OF LATTICES ON: M20/(21-LINES INDEXED).--
C            = A BIBLIOGRAPHY WAS ADDED IN THE TEXT OF THE NEW ROUTINE
C              BIBLIO. IT IS ANNOUNCED IN THE PROGRAM OUTPUT. --
C            = THE NAME OF SUBROUTINE SRTRON WAS CHANGED INTO SRTLIN. --
C            = CARDS (RECORDS) NO LONGER NUMBERED. --
C            = FOR *EXPORT* PURPOSES THE PROGRAM PLUS SUBROUTINES WAS
C              DIVIDED INTO 6 FILES OF ABT. 820 RECORDS EACH. --
C
C      VERSION 12
C            = OUTPUT OF A SUMMARY OF THE DATA OF THE BEST SOLUTION ON
C              UNIT NSUMM (66). THE LENGTH OF THE LINES IN THIS OUTPUT
C              IS RESTRICTED TO 70 CHARACTERS. --
C            = SOMETIMES A MONOCLINIC LATTICE IS FOUND TO BE A
C              RHOMBOHEDRAL LATTICE IN DISGUISE. A REFINEMENT OF THE
C              HEXAGONAL LATTICE CONSTANTS IS NOW CARRIED OUT IN THE
C              NEW SUBROUTINE *REFSYM* , FOLLOWED BY A PRINT-OUT OF
C              THE PATTERN AS INDEXED ON HEXAGONAL AXIS. --
C            = TETRAGONAL,HEXAGONAL AND CUBIC LATTICES ARE ALSO
C              RECOGNISED AND REFINED AS SUCH. THEY ARE PRINTED BY
C              THE NEW SUBROUTINE *SYMPRT*. --
C
C      VERSION 13                      JUNE 1987
C            = THE CALCULATED ZERO-SHIFT (WHICH ALSO ACCOUNTS FOR
C              THE SPECIMEN DISPLACEMENT ERROR AT SMALL TWOTHETAS)
C              IS NOW APPLIED TO THE CALCULATED TWOTHETAS, IN ORDER
C              NOT TO CHANGE THE *OBSERVED* VALUES.  THIS IS WRONG
C              IN PRINCIPLE, BUT SAVES MISUNDERSTANDINGS.
C
C      VERSION 14                      November 1993
C            = This version is specially adapted to a PC.
C              For AT's and '286-ers it gives intermediate output
C              on the screen. A '486 goes too fast for the intermediate
C              output to be useful.
C              It is a continuation of version 12.
C            = The program asks for the names of the input and
C              output files.
C            = The calculated zeroshift is applied again to the
C              *observed* values (return to version 12).
C            = Twothetas are now given in three decimals.
C            = The summary is again in a separate file, which can
C              be printed separately.
C            = The program continuously writes output onto the screen.
C            = Possibility to suppress the zeroshift.
C            = New division of the source code (3 'main' pgms).
C
C      VERSION 15                        December 1993
C            = Output of intermediate results on the monitor is suppressed.
C            = Possibility to enter the number of reflections that is
C              actually to be used.  Too few lines may not give enough
C              information, too many lines may give too many false clues.
C
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C           INPUT AND OUTPUT
C-----------------------------------------------------------------------
C     The program asks for the names of the input file and of the file for
C     the summary of the output.
C     Moreover, a copy of the input file is made on ITODOC.LST (for
C     checking and testing purposes), and a more elaborate output is
C     written onto ITOUT.LST.
C
C
C     THE INPUT OF THIS PROGRAM SHOULD CONSIST OF:
C     1. A TITLE RECORD,CONTAINING UP TO 80 CHARACTERS
C     2. TWO PARAMETER RECORDS,THAT CAN BE COMPLETELY BLANK
C     3. A NUMBER OF LINES RECORDS, CONTAINING THE POSITIONS OF THE LINES
C        THESE CAN BE ENTERED AS D-,Q- OR TWOTHETA VALUES. ( 8 F10.5 )
C        YOU MAY LEAVE ANY NUMBER OF POSITIONS PER RECORD  BLANK.
C        THIS MEANS THAT YOU CAN ALSO ENTER ONLY ONE LINE PER RECORD,
C        IN ANY ONE OF THE POSITIONS OF 8F10.5
C     4. A BLANK RECORD, TO FINISH THE INPUT OF ONE PROBLEM.
C
C        REPEAT THE ABOVE  AS MANY TIMES AS PROBLEMS,   -- THEN --
C     5. A RECORD CONTAINING THE WORD  --  END  -- IN THE THREE FIRST
C        COLUMNS,  TO FINISH THE INPUT.
C
C     Note: Instead of records that are completely blank, it is often
C           wise to enter  0.0    .
C
C
C  THE PROGRAM WILL TAKE ITS OWN (DEFAULT) PARAMETERS.
C  FOR THE INITIATED THE SUBROUTINE READER GIVES FULL DETAILS ABOUT
C  ALL THE  POSIBILITIES OF THE PROGRAM.
C
C
C-----------------------------------------------------------------------
C              THE SUBROUTINES  ARE  LISTED  IN  ALFABETICAL  ORDER.
C-----------------------------------------------------------------------
C
C                         GENERAL FLOW OF SUBROUTINES
C        (THE ACTUAL FLOW OF SUBROUTINES IS SLIGHTLY MORE COMPLICATED)
C-----------------------------------------------------------------------
C      SUBROUTINES TIMER AND NTEST ARE FREQUENTLY CALLED BY THE
C      MAIN PROGRAM. NTEST CALLS ARE MARKED BY 1+ , 2+ , ETC.
C.......................................................................
C
C
C        *******            *******           **********
C        *     *            *     * <-------> *  ECHO  *        ********
C        *  M  *            *  R  *           **********   |--> *SRTLIN*
C        *     *            *     * <-------> * REDLIN * <-|    ********
C      1+*  A  * <--------> *  E  *           **********   |--> *TETCAL*
C        *     *            *     * <-------> * RECCEL *        ********
C        *  I  *            *  A  *           **********
C        *     *            *     * <-------> * MANUAL *
C        *  N  *            *  D  *           **********
C   |--->*     *            *     * <-------> * INSTRS *
C   |    *******            *  E  *           **********
C   |       |               *     * <-------> * ZERCHK *
C   |       |               *  R  *           **********
C   |       |               *     * <-------> * BIBLIO *
C   |       |               *******           **********
C   |       |
C   |  2+*******            **********
C   |    *     *  <-------> * FINZON *
C   |    *     *            **********
C   |    *  A  *
C   |    *     *            *******           ******         *********
C   |    *     *            *     *  <------> * LS *  <----> * WRISP *
C   |    *     *            *  E  *           ******         *********
C   |    *  A  *            *  V  *           ********
C   |    *     *            *  A  *  <------> * NORM *
C   |    *     *  <-------> *  L  *           ********
C   |    *     *            *  U  *           **********
C   |  3+*  I  *            *  8  *  <------> * CRITER *
C   |    *     *            *     *           **********
C   |    *     *            *     *           *********
C   |    *     *            *******  <------> * TEXT1 *
C   |    *     *                              *********
C   |    *  T  *            **********
C   |    *     *  <-------> * SRTZON *
C   |    *     *            **********
C   |  4+*     *
C   |    *  O  *            **********
C   |    *     *  <-------> * ONEZON *
C   |    *     *            **********
C   |    *     *
C   |    *  1  *
C   |    *     *            ********
C   |  5+*     *  <-------> * REAR *
C   |    *******            ********
C   |
C   |
C   |
C   |    *******            **********
C   |--->*     *  <-------> * THREED *
C        *     *            **********
C      6+*     *
C        *     *            *********          **********
C        *     *  <-------> * NORM3 * <------> * WISSEL *
C        *  A  *            *********          **********
C        *     *
C      7+*     *
C        *     *
C      8+*     *        *******        *******           **********
C        *  N  *        *     *        *     *  <------> *        *
C        *     *        *  R  *        *  R  *           **********
C        *     *        *     *        *     *           *********
C        *     *        *  E  *        *  E  *  <------> * WRISP *
C        *     *        *     *        *     *           *********
C        *  I  * <----> *  F  * <----> *  F  *           *********
C        *     *        *     *        *     *  <------> * ARRAY *
C        *     *        *  P  *        *  I  *           *********
C        *     *        *     *        *     *           ********
C        *     *        *  A  *        *  N  *  <------> * MINV *
C        *  T  *        *     *        *     *           ********
C        *     *        *  R  *        *  E  *           *********
C        *     *        *     *        *     *  <------> * LISTM *
C        *     *        *******        *******           *********
C      9+*     *
C        *  O  *            **********
C        *     *  <-------> * UNTCEL *
C        *     *            **********
C        *     *
C        *  2  *            **********         **********
C        *     *  <-------> * SYMTST * <-----> * REFSYM *
C        *     *            **********         **********
C        *     *
C        *     *            **********
C        *     *  <-------> * SRTSYM *
C        *     *            **********
C        *     *                               **********
C        *     *            ********** <-----> *  LISTM *
C        *     *  <-------> * SYMPRT *         **********
C        *     *            ********** <-----> * REFSYM *
C        *     *                               **********
C        *******
C
C-----------------------------------------------------------------------
C                       MINIMISING STORAGE REQUIREMENTS.
C-----------------------------------------------------------------------
C                       ONLY VALID FOR VERSION 6.
C                FOR NEWER VERSIONS IT CAN SERVE AS A GUIDE.
C.......................................................................
C
C     1. OVERLAY.
C
C             THE SUGGESTED OVERLAY STRUCTURE NEEDS ONLY ABOUT 60%
C             OF THE STORAGE NEEDED FOR THE FULL PROGRAM,
C             WITHOUT IMPAIRING ITS EFFICIENCY.
C             THE SUBROUTINES  *FINZON*  AND *THREED*  HAVE THE
C             LARGEST REQUIREMENTS FOR MAIN STORAGE.    THEREFORE, IT IS
C             NOT NECESSARY TO GO BEYOND ONE LEVEL OF OVERLAY.
C             I SUGGEST THE FOLLOWING SCHEME
C
C             ENTRY  MAIN      COMMENT* ROOT SEGMENT, SEGMENT 1
C             OVERLAY ONE
C             INCLUDE SUB(READEM)     COMMENT*  SEGMENT 2
C             OVERLAY ONE
C             INCLUDE SUB(FINZON)     COMMENT* SEGMENT 3
C             OVERLAY ONE
C             ETC.  ETC.  ETC.
C
C             SEGMENT     CONTENTS
C                1        MAIN + COMMONS, EXCEPT *COUNTM*
C                2        READER+ECHO+MANUAL+INSTRS+SRTLIN
C                3        FINZON
C                4        EVALU8+LS+WRISP+NORM+CRITER+TEXT1
C                5        ONEZON+REAR
C                6        THREED
C                7        NORM3
C                8        REFPAR+WISSEL+ARRAY+MINV+LISTM+ *PRINS*
C                9        UNTCEL+SYMTST
C
C             THE FOLLOWING CHANGES ARE NECESSARY
C             A.DELETE THE COMMON *COUNTM* THROUGHOUT THE PROGRAM,
C               USE AN ARRAY  *ITL(5000)* INSTEAD OF THIS COMMON
C               IN THE SUBROUTINES *FINZON* AND *THREED*
C             B.DELETE THE SUBROUTINE CALL FOR *NORM3* FROM *REFPAR*
C               INSERT A CARD      95 CONTINUE
C             C.CHANGE THE NAME OF THE SUBROUTINE *WRISP* IN *REFPAR*
C               INTO SOMETHING DIFFERENT, LIKE *PRINS*  AND CHANGE THE
C               FOUR SUBROUTINE CALLS FOR *WRISP* IN *REFPAR*
C               ACCORDINGLY
C             THE CALL FOR *NORM3* IN *REFPAR* IS ONLY SELDOM
C             REALLY NECESSARY,  HOWEVER,
C             IF THE RESULTS OF A PARTICULAR POWDER PATTERN SEEM STRANGE
C             TO YOU, YOU CAN ALWAYS FORCE ANOTHER APPLICATION OF *NORM3
C             BY RE-ENTERING YOUR DATA AND THE STRANGE LATTICES,
C             SEE  MANUAL AND INSTRUCTIONS, USE COL 44 OF PARAMETER CARD
C
C
C     1B OVERLAY 2.
C
C             ON AN IBM 370/158 THE PROGRAM RAN IN  84K INSTEAD OF 140
C             AND WITHOUT MEASURABLE LOSS OF SPEED WITH THE FOLLOWING
C             SCHEME
C             A. COMPILE THE PROGRAM AS GIVEN WITH  PARM.LKED=OVLY
C             B.GIVE  LKED.SYSIN  DD  *
C                ENTRY MAIN
C                INSERT MAIN
C                OVERLAY  ALPHA
C                  INSERT READER,MANUAL,ECHO,INSTRS,SRTLIN,IHCSSCN
C                OVERLAY  ALPHA
C                  INSERT FINZON,THREED,COUNTM
C                OVERLAY  ALPHA
C                  INSERT EVALU8,LS,NORM,CRITER,TEXT1,EVALN,LINSTR,IHCSE
C                  INSERT REFPAR,WISSEL,WRISP,ARRAY,MINV,NORM3,LISTM
C                OVERLAY  ALPHA
C                  INSERT ONEZON,REAR,UNTCEL,SYMTST
C             /*
C
C
C     2. CHOPPING UP THE PROGRAM.
C
C             IF YOU HAVE A REALLY SMALL COMPUTER, IT IS STILL
C             POSSIBLE TO RUN THIS PROGRAM.
C             AS THE PROGRAM USES ITS MAIN SUBROUTINES SEQUENTIALLY,
C             IT IS POSSIBLE TO IMITATE AN OVERLAY AND DIVIDE THE MAIN
C             PROGRAM IN A NUMBER OF PIECES THAT WILL WORK AS
C             SEPARATE UNITS.  AFTER EVERY PART IT WILL BE NECESSARY
C             TO SAVE THE VALUES OF MOST COMMON AREAS AND OF THE
C             ARRAY  *STORE*.    THE DIVISION OF THE PROGRAM SHOULD
C             FOLLOW THE SAME MAIN LINE  AS THE  OVERLAY STRUCTURE.
C             I HAVE NOT TRIED THIS MYSELF, AS I HAVE A VERY LARGE
C             COMPUTER AVAILABLE.  I AM QUITE WILLING TO HELP ANYBODY
C             WHO TRIES THE ABOVE IDEA.   PLEASE CONTACT ME .
C
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C                EXPLANATION OF VARIABLES IN  COMMON.
C
C     1.LINES
C       IDOC     OUTPUT FILE FOR DOCUMENTATION PURPOSES. LISTS INPUT
C                AS GIVEN
C       INP      INPUT UNIT,FROM WHICH ALL INPUT IS READ.
C       IOUT     STANDARD OUTPUT UNIT (LINE PRINTER)
C       NCRT     Output to monitor
C      (NSUMM    OUTPUT UNIT FOR CRT-TERMINAL IS IN COMMON CONSTS)
C       MAX      THE NUMBER OF OBSERVED LINES THAT ARE USED (.LE. 40)
C       OBS(40)  CONTAINS THE Q-VALUES OF THE OBSERVED LINES.
C       CEL(10)  USED FOR SEVERAL PURPOSES, CAN CONTAIN UNIT CELLS
C                OR LINE COMBINATIONS OR ZONES.
C    2. CHARCM
C       NAME     NAME OF PROBLEM.
C       CARD     CONTAINS THE IMAGE OF THE 'CARD' THAT WAS LAST READ.
C       INTSY(50) CONTAINS THE INTENSITIES (GIVEN AS  VS , S , ETC.)
C                OF THE OBSERVED LINES.
C    3. PARMS
C       TOL2     TOLERANCE ON 2-DIMENSIONAL SEARCH FOR THE ANGLE BETWEEN
C                THE DIRECTIONS OF THE POINTS REPRESENTED BY Q-VALUES.
C       TOL3     SAME FOR THREE-DIMENSIONAL SEARCH (FOR D)
C       WAVEL    WAVELENGTH  (1.5406 BY DEFAULT)(1.5405891)
C       FMINEQ   MAXIMUM VALUE FOR THE DIFFERENCE BETWEEN 'EQUAL' VALUES
C       FMINIM   MINIMUM VALUE FOR THE FIRST THREE LATTICE CONSTANTS.
C       SELF     LOGICAL
C       ENL      LOGICAL FOR PRINTING INTERMEDIATE RESULTS.
C       TEST     LOGICAL FOR PRINTING ALL TEST RESULTS.
C       LIST     THE NUMBER OF LATTICES THAT ARE TO BE PRINTED OUT
C       NSYST(3) SEE INSTRUCTIONS. POSSIBILITY TO ENHANCE SOME CRYSTAL
C                SYSTEMS
C       OBSMT(40) Q-VALUES OF THE OBSERVED LINES MINUS TOLERANCE.
C       OBSPT(40) Q-VALUES OF THE OBSERVED LINES PLUS THE  TOLERANCE.
C       TWTHET(40) TWO-THETA'S OF THE OBSERVED LINES.
C       TOLG     TOLERANCE (IN HUNDREDTH OF A DEGREE  TWO THETA)
C
C    4. EVALN
C       NORDER   NUMBER OF ORDERS OF AXES' Q-VALUES, USUALLY 4.
C                NORDER DETERMINES THE INDEX-FIELD OF THE ZONES AT
C                EVALUATION.
C       RECTAN   LOGICAL THAT IS .TRUE. WHEN THE ZONE IS RECTANGULAR.
C       PROB(40) PROBABILITY TO 'HIT' AN OBSERVED LINE BY CHANCE.
C       EVAL(-8:8,0:8) ARRAY CONTAINING THE PROBABILITIES OF THE
C                CALCULATED LINES THAT ARE ALSO OBSERVED.
C       UPBNDR(40) UPPER BOUNDARY OF THE PROBABILITY FIELD OF EACH LINE.
C
C    5. TEMRES
C       LINCO    THE NUMBER OF LINE COMBINATIONS
C       NQ2      THE NUMBER OF THE LAST LINE TO BE COMBINED WITH OTHERS.
C       NINDEX   THE NUMBER OF LINES INDEXED AMONG THE FIRST NQ2 LINES
C       INDEX(40) ARRAY TO COUNT WHETHER A LINE WAS INDEXED BY A
C                PARTICULAR ZONE.
C       ROSTER(150,12) ARRAY IN WHICH THE USEFUL LATTICES ARE STORED.
C         1...6 CELL CONSTANTS, 7=LINES INDEXED,  8=M20, 9=BRAV.TYP,
C         10=PEDIGREE, 11=ZEROSHIFT,  12=VALUE FOR RANKING=[8]/(21-[7])
C
C    6. CONSTS
C       NSUMM    NUMBER OF UNIT ONTO WHICH A SUMMARY IS WRITTEN.
C                THE LENGTH OF THE LINES IS LESS THAN 71 CHARACTERS.
C       RAD,TWORAD FACTORS FOR CALCULATING DEGREES FROM RADIANS.
C       RRAD     FACTOR TO CALCULATE RADIANS FROM DEGREES (RECIPROCAL)
C       HLFLAM   WAVELENGTH/(2*100). FACTOR 100 STEMS FROM THE FACT
C                THAT Q HAS BEEN MULTIPLIED BY 100**2
C       WAVSQR   CONSTANT NEEDED FOR CALCULATING DERIVATIVES.
C       STORE(200,9) ARRAY TO STORE THE ZONES.
C
C    7. THETAS   --- ALL IN RADIANS ---
C       ZERTOT   TOTAL ZERO SHIFT OF THE DATA (RADIANS).
C       OBSTET   OBSERVED THETA.
C       SHFTET   OBSERVED THETAS, SHIFTED BY THE CALCULATED ZEROSHIFT.
C       TETPT    OBSERVED THETA PLUS TOLERANCE
C       TETMT    OBSERVED THETA MINUS TOLERANCE.
C
C    8. HISYM    DATA FOR HIGH-SYMMETRY LATTICES
C       ZERREF   logical which is .true. when the zero-correction
C                is to be refined.
C       ISOL     THE NUMBER OF THE SOLUTION
C       SYMCON(12,6) ARRAY TO STORE THE CELCONSTANTS OF THE HIGHLY
C                SYMMETRIC LATTICES. 1,2 CELCONSTANTS,3=CRYSTAL SYSTEM,
C                4=NUMBER OF LINES INDEXED,5=ZEROSHIFT, 6=VOLUME.
C       NMATCH(45) ARRAY TO STORE THE NUMBER OF CALCULATED LINES THAT
C                MATCH EACH OBSERVED LINE.
C
C    9. COUNTM
C       ITL(0:5000) ARRAY TO FIND THE VALUES OF  *F*  AND  *D* .
C                IT IS NOT NECESSARY TO PUT THE ARRAY(S) IN A COMMON,
C                BUT IT SAVES SPACE.
C
C
C
C-----------------------------------------------------------------------
C  last change  240493  added NCRT+output
C  last change  061193  deleted MOST NCRT+output
C  last change  080594  improved NCRT-output
C
C
C
      LOGICAL SELF,ENL,TEST,SOL,RECTAN,ZERREF
      CHARACTER NAME*80,CARD*80,INTSY*2,INFIL*80,SUMMFL*80
      COMMON /LINES / IDOC,INP,IOUT,NCRT,MAX,OBS(40),CEL(10)
      COMMON /CHARCM/ NAME,CARD,INTSY(50)
      COMMON /PARMS / TOL2,TOL3,WAVEL,FMINEQ,FMINIM,SELF,ENL,TEST,LIST,
     *                NSYST(3),OBSMT(40),OBSPT(40),TWTHET(40),TOLG
      COMMON /EVALN / NORDER,RECTAN,PROB(40),EVAL(-8:8,0:8),
     *                UPBNDR(40)
      COMMON /TEMRES/ LINCO,NQ2,NINDEX,INDEX(40),ROSTER(150,12)
      COMMON /CONSTS/ NSUMM,RAD,TWORAD,RRAD,HLFLAM,WAVSQR,STORE(200,9)
      COMMON /HISYM / ZERREF,ISOL,SYMCON(12,6),NMATCH(45)
      COMMON /COUNTM/ ITL(0:5000)
      keybrd=5
      NCRT=6
      IDOC=14
      INP=15
      IOUT=16
      NSUMM=66
      WRITE(NCRT, 91)
      WRITE(NCRT, 92)
      write(*,*)'Give a RETURN or ENTER when you have read the messages'
      read(keybrd, '( A )' )
C       PAUSE 'Give a RETURN or ENTER when you have read the messages'
C        ASK FOR THE NAME OF THE INPUT FILE (ON THE MONITOR SCREEN, CRT)
      write(ncrt,'(// '' What is the name of the INPUT file? '' /,
     2 '' Input file is ......:''  )' )
      read(keybrd, '( A )' )  INFIL
      OPEN(UNIT=INP  ,FILE= INFIL,STATUS='OLD',ERR=80)
C
C     NOW ASK FOR THE NAME OF THE FILE WITH THE summary OF THE OUTPUT:
C
      write(ncrt,'(// '' What is the CONDENSED  OUTPUT file? '' /,
     2 '' Output file is .....:''  )' )
      read(keybrd, '( A )' )  SUMMFL
      OPEN(UNIT=NSUMM,FILE= SUMMFL,STATUS='UNKNOWN',RECL=78,ERR=90,
     $     FORM='FORMATTED')
C
      OPEN(UNIT=IDOC ,FILE='ITODOC.LST',STATUS='UNKNOWN')
      OPEN(UNIT=IOUT ,FILE='ITOUT.LST' ,STATUS='UNKNOWN',
     $     FORM='FORMATTED')
      NORDER=4
      NRMAX=200
   1  CONTINUE
      CALL TIMER(0)
      NRRUN=0
      DO 10 I=1,150
         DO 5 J=1,12
   5     ROSTER(I,J)=0.0
  10  CONTINUE
C
      CALL READER(NZ1,NZ2,NR,NSOLMX,WMOL,DOBS,PRNTMR,PRNTLN,NTST)
C
      IF (MAX .LT. 11) GO TO 1
      IF (INP .EQ. 12345)  GO TO 9000
      CALL TIMER(1)
  100 SOL=.TRUE.
      IF (NR .EQ. 0) THEN
         NRRUN=NRRUN+1
         SOL=.FALSE.
         CALL AAITO1(NZ1,NZ2,NR,NRMAX,NTST,NRRUN)
         IF (LINCO .EQ. 0) THEN
            WRITE(NCRT ,93)
            WRITE(IOUT ,93)
            WRITE(NSUMM,93)
            GO TO 9000
         END IF
      END IF
      CALL ANITO2(SOL,NR,NSOLMX,WMOL,DOBS,PRNTMR,PRNTLN,NTST,NRRUN)
C  NRRUN=1 SIGNALS THAT NO REALLY SATISFACTORY SOLUTION HAS BEEN FOUND
C  IN THE FIRST TRIAL. WE NOW TRY AGAIN, USING THE SAME ZONES BUT
C  SORTING THEM DIFFERENTLY.
      IF (NRRUN .EQ. 1) THEN
         NR=0
         GO TO 100
      ELSE
         GO TO 1
      END IF
   80 WRITE(NCRT,'(''  ERROR.  DOES THIS FILE EXIST ?? ''/,
     1  '' CHECK SPELLING!! (EXTENSION !!)    PROGRAM STOPS'')' )
      GOTO 9000
   90 WRITE(NCRT,'(''  ERROR. SOMETHING WRONG WITH YOUR OUTPUT FILE'',
     1 /,'' PROGRAM STOPS'')' )
 9000 STOP
   91 FORMAT('             VERSION  15 '//,
     1 '  THIS VERSION GIVES VERY LITTLE OUTPUT ON THE SCREEN',//
     2 '  THE OUTPUT IS ONLY MEANT TO LET YOU KNOW THAT THE PROGRAM'/
     3 '  IS WORKING,  AND GIVE SOME INDICATION WHAT IT IS DOING. '//
     4 ' *** THE RESULTS ARE WRITTEN IN THE OUTPUT FILES !! *** '//)
   92 FORMAT(' THE PROGRAM WILL NOW ASK YOU FOR THE NAMES OF THE '/ ,
     1 ' INPUT FILE AND THE FILE WHERE THE CONDENSED OUTPUT ' /,
     2 ' WILL BE WRITTEN.' //,
     3 ' A COPY OF THE INPUT FILE WILL BE WRITTEN ON  **ITODOC.LST**'/,
     4 ' THE COMPLETE OUTPUT FILE (132 CHAR/LINE) WILL BE WRITTEN' /,
     5 ' ON  ** ITOUT.LST **  .' /// )
   93 FORMAT(/// ' THE PROGRAM COULD NOT FIND A COMBINATION OF ZONES '//
     1 ' END OF PROGRAM ' )
      END
