C     PROGRAM TO GENERATE A LIST OF HKLS FOR INPUT TO THE PROFILE
C     ANALYSIS PROGRAM. DATA INPUT IS ON 3 CARDS AS FOLLOWS.
C     CARD 1. TITLE (18A4)
C     CARD 2. CELL PARAMETERS A,B,C,ALPHA,BETA,GAMMA (6F8.0).
C     CARD 3. INPUT PARAMETERS (2F9.5,16I3)
C     COLS  1-9  XLAMDA
C          10-18 TTHMAX
C          19-21 LAUE
C                LAUE = 1 - LAUE GROUP -1
C                LAUE = 2 - LAUE GROUP 2/M (Y AXIS UNIQUE)
C                LAUE = 3 - LAUE GROUP 2/M (X AXIS UNIQUE)
C                LAUE = 4 - LAUE GROUP MMM
C                LAUE = 5 - LAUE GROUP 4/M
C                LAUE = 6 - LAUE GROUP 4/MMM
C                LAUE = 7 - LAUE GROUP M3
C                LAUE = 8 - LAUE GROUP M3M
C                LAUE = 9 - LAUE GROUP -3  (RHOMBOHEDRAL AXES)
C                LAUE =10 - LAUE GROUP -3M (RHOMBOHEDRAL AXES)
C                LAUE =11 - LAUE GROUP -3  (HEXAGONAL AXES)
C                LAUE =12 - LAUE GROUP -3M (HEXAGONAL AXES)
C                LAUE =13 - LAUE GROUP 6/M
C                LAUE =14 - LAUE GROUP 6/MMM
C                LAUE =15 - LAUE GROUP -3M (AXES ROTATED)
C     COLS 22-24 I1. NONEXTINCTION INDICATOR FOR LATTICE TYPE.
C                  I1 = 1 - A-CENTERED (K+L=2N)
C                  I1 = 2 - B-CENTERED (H+L=2N)
C                  I1 = 3 - C-CENTERED (H+K=2N)
C                  I1 = 4 - F-CENTERED (H+K,H+L,K+L=2N)
C                  I1 = 5 - I-CENTERED (H+K+L=2N)
C                  I1 = 6 - R-OBVERSE (-H+K+L=3N)
C                  I1 = 7 - R-REVERSE (H-K+L=3N)
C                  I1 = 8 - HEXAGONAL (H-K=3N)
C                  I1 = 9 - PRIMITIVE (NO CONDITIONS)
C     COLS 25-27 I2. NONEXTINCTION INDICATOR FOR (HK0) ZONE.
C                  I2 = 0 - NO CONDITIONS
C                  I2 = 1 - A-GLIDE (H=2N)
C                  I2 = 2 - B-GLIDE (K=2N)
C                  I2 = 3 - N-GLIDE (H+K=2N)
C                  I2 = 4 - D-GLIDE (H+K=4N;H,K=2N)
C     COLS 28-30 I3. NONEXTINCTION INDICATOR FOR (H0L) ZONE.
C                  I3 = 0 - NO CONDITIONS
C                  I3 = 1 - A-GLIDE (H=2N)
C                  I3 = 2 - C-GLIDE (L=2N)
C                  I3 = 3 - N-GLIDE (H+L=2N)
C                  I3 = 4 - D-GLIDE (H+L=4N;H,L=2N)
C     COLS 31-33 I4. NONEXTINCTION INDICATOR FOR (0KL) ZONE.
C                  I4 = 0 - NO CONDITIONS
C                  I4 = 1 - B-GLIDE (K=2N)
C                  I4 = 2 - C-GLIDE (L=2N)
C                  I4 = 3 - N-GLIDE (K+L=2N)
C                  I4 = 4 - D-GLIDE (K+L=4N;K,L=2N)
C     COLS 34-36 I5. NONEXTINCTION INDICATOR FOR (HHL) ZONE.
C                  I5 = 0 - NO CONDITIONS
C                  I5 = 1 - C(N)-GLIDE (L=2N)
C                  I5 = 2 - D-GLIDE (2H+L=4N)
C     COLS 37-39 I6. NONEXTINCTION INDICATOR FOR (-HHL) ZONE.
C                  I6 = 0 - NO CONDITIONS
C                  I6 = 1 - C(N)-GLIDE (L=2N)
C                  I6 = 2 - D-GLIDE (2H+L=4N)
C     COLS 40-42 I7. NONEXTINCTION INDICATOR FOR (HKH) ZONE
C                  I7 = 0 - NO CONDITIONS
C                  I7 = 1 - B(N)-GLIDE (K=2N)
C                  I7 = 2 - D-GLIDE (2H+K=4N)
C     COLS 43-45 I8. NONEXTINCTION INDICATOR FOR (HK-H) ZONE.
C                  I8 = 0 - NO CONDITIONS
C                  I8 = 1 - B(N)-GLIDE (K=2N)
C                  I8 = 2 - D-GLIDE (2H+K=4N)
C     COLS 46-48 I9. NONEXTINCTION INDICATOR FOR (HKK) ZONE.
C                  I9 = 0 - NO CONDITIONS
C                  I9 = 1 - A(N)-GLIDE (H=2N)
C                  I9 = 2 - D-GLIDE (H+2K=4N)
C     COLS 49-51 I10. NONEXTINCTION INDICATOR FOR (HK-K) ZONE.
C                  I10= 0 - NO CONDITIONS
C                  I10= 1 - A(N)-GLIDE (H=2N)
C                  I10= 2 - D-GLIDE (H+2K=4N)
C     COLS 52-54 I11. NONEXTINCTION INDICATOR FOR (H00) ROW.
C                  I11= 0 - NO CONDITIONS
C                  I11= 1 - 21 OR 42 SCREW (H=2N)
C                  I11= 2 - 41 OR 43 SCREW (H=4N)
C     COLS 55-57 I12. NONEXTINCTION INDICATOR FOR (0K0) ROW.
C                  I12= 0 - NO CONDITIONS
C                  I12= 1 - 21 OR 42 SCREW (K=2N)
C                  I12= 2 - 41 OR 43 SCREW (K=4N)
C     COLS 58-60 I13. NONEXTINCTION INDICATOR FOR (00L) ROW.
C                  I13= 0 - NO CONDITIONS
C                  I13= 1 - 21 OR 42 SCREW (L=2N)
C                  I13= 2 - 31, 32, 62, OR 64 SCREW (L=3N)
C                  I13= 3 - 41 OR 43 SCREW (L=4N)
C                  I13= 4 - 61 OR 65 SCREW (L-6N)
C     COLS 61-63 INDP.
C                  INDP=0 - NOTHINGS HAPPENS.
C                  INDP=1 - WRITE REFLECTIONS ON FILE FOR001
C     COLS 64-66 ICD.
C                  ICD=0 OR 1 - NUCLEAR SCATTERING ONLY
C                  ICD=2 - MAGNETIC SCATTERING ONLY
C                  ICD=3 - NUCLEAR AND MAGNETIC SCATTERING
C
C     CARD 4. SPACE GROUP (A20) [optional]
C
      COMMON/GENL/XLAMDA,DMIN,TITLE(18),NIN,NOUT,NPUNCH,JJ,IA,ISH,ISK,IS
     *L 
      COMMON/CELLS/A,B,C,AL,BE,GA,RCV,RCP(6),VOL,PRCP(6)
      COMMON /DATA/D(3001),IH(3001),IK(3001),IL(3001) 
      COMMON/EXTNS/RECD,LAUE,IEXT(13),NEX,NH,NK,NL,JJJJ 
C--
      CHARACTER*25 FNAM
      CHARACTER*80 SPACEGRP
C--
      DIMENSION BXYZ(6) 
      DATA RAD/57.29578/
C--      NIN=5 
      NIN = 7
      NTERM = 5
      NOUT=6
C--      NPUNCH=1
C---------------------------------------------------------------
!      TYPE 3333
! 3333 FORMAT ($'Enter name of input file: ')
!      ACCEPT 4444,FNAM
! 4444 FORMAT (A25)
!      OPEN (UNIT=NIN,FILE=FNAM,STATUS='OLD')
!      TYPE 5555
! 5555 FORMAT ($'Enter name of output file: ')
!      ACCEPT 4444,FNAM
!      OPEN (UNIT=NOUT,FILE=FNAM,STATUS='UNKNOWN')
      nin = 5
      nout = 6
C----------------------------------------------------------------
      NORD=1
 49   FORMAT(1x,18A4)
C 
C     READ TITLE
C 
  1   READ(NIN,50,END=100) TITLE
  50  FORMAT(18A4)
      WRITE(NOUT,49) TITLE
C 
C     READ CELL PARAMETERS
C 
      READ(NIN,51) RCP
  51  FORMAT(6F8.0) 

C 
C     SET UP RECIPROCAL CELL PARAMETERS 
C 
      CALL CELCON 

      WRITE(NOUT,52) A, B, C, ACOS(AL)*RAD, ACOS(BE)*RAD, ACOS(GA)*RAD
  52  FORMAT('  A= ',F7.4,/,'  B= ',F7.4,/,'  C= ',F7.4,/,
     $     '  ALPHA= ',F6.2,/,'  BETA= ',F6.2,/,'  GAMMA= ',F6.2/)
      WRITE(NOUT,55) AL, BE, GA
  55  FORMAT(' COS ALPHA= ',F8.5,'  COS BETA= ',F8.5,'  COS GAMMA= ',
     $     F8.5/) 
      WRITE(NOUT,56)(RCP(N),N=1,3),(ACOS(RCP(I))*RAD,I=4,6)
  56  FORMAT(' RECIPROCAL CELL CONSTANTS',//,'  A*= ',F7.4,/,'  B*= ',
     $     F7.4,/,'  C*= ',F7.4,/,'  ALPHA*= ',F6.2,/,'  BETA*=  ',F6.2
     $     ,/,'  GAMMA*= ',F6.2,/)
C 
C     READ INPUT PARAMETERS 
C   INDP =1 FOR DATA ON NPUNCH FILE 
C   ICD =2 FOR MAGNETIC INTENSITY ONLY
C       =3 FOR MAGNETIC AND NUCLEAR 
C       =4 FOR K-ALPHA1
C       =5 FOR K-ALPHA2
C 
      READ(NIN,53)XLAMDA,TTHMAX,LAUE,IEXT,INDP,ICD,XLAMD2
 53   FORMAT(2F9.5,16I3,F8.5) 
      DMIN=XLAMDA/(2.*SIN(TTHMAX/(RAD*2.))) 
      DMINORG = DMIN
      IF(XLAMD2.EQ.0.)WRITE(NOUT,54)LAUE,DMIN,IEXT,TTHMAX,XLAMDA
      IF(XLAMD2.GT.0.)WRITE(NOUT,64)LAUE,DMIN,IEXT,TTHMAX,XLAMDA,XLAMD2
  54  FORMAT('  LAUE = ',I4,/,1X,'DMIN =  ',F7.5,/,1X,'EXTN CODE = ',
     $     13I2,/,1X,'TTHMAX =  ',F8.3,/,1X,'WAVE LENGTH = ',F8.5) 
  64  FORMAT('  LAUE = ',I4,/,1X,'DMIN =  ',F7.5,/,1X,'EXTN CODE = ',
     $     13I2,/,1X,'TTHMAX =  ',F8.3,/,1X,'K-ALPHA1 = ',F8.5,5X,
     $     'K-ALPHA2 = ',F8.5) 
C 
C     OUTPUT DEFINING LAUE GROUP AND EXTINCTION CONDITIONS
C 
      CALL NETOUT 
C
C READ AND PROCESS SPACE GROUP
C
      CALL CLRSPG               ! clear the space group
      READ(NIN,'(A20)',END=919) SPACEGRP
      IF (SPACEGRP .NE. ' ') CALL SETSPG(SPACEGRP,NOUT)
C 
C     GENERATE MILLER INDICES FOR THE LAUE GROUP
C 
 919  CALL INDEXREF
C     ARRANGE REFLECTIONS IN ORDER OF DECENDING D-VALUES
C 
      CALL ORDER
      NH=1
      NK=1
      NL=1
C--      IF(INDP.EQ.1) WRITE(NPUNCH,59)JJ,NH,NK,NL 
C-- 59   FORMAT(I8/3I8)
      WRITE(NOUT,57)
!  57  FORMAT(1H1,7H    ICD,8H       H,8H       K,8H       L,8H    MULT/)
  57  FORMAT(/' ICD',7H      H,7H      K,7H      L,6H  MULT)
      IF(ICD.EQ.0) ICD=1
      IF(XLAMD2.GT.0.)ICD=4
      DO 15 N=1,JJ
      CALL MULT1(N,FAC) 
      MULT=FAC
      TH=ASIN(XLAMDA/(2.*D(N))) 
      TH=TH*RAD*2.
      WRITE(NOUT,58)NORD,ICD,IH(N),IK(N),IL(N),MULT,N,TH,D(N)
C--      IF(INDP.EQ.1) WRITE(NPUNCH,48)NORD,ICD,IH(N),IK(N),IL(N),MULT 
      IF(XLAMD2.GT.0.)THEN
      TH=ASIN(XLAMD2/(2.*D(N))) 
      TH=TH*RAD*2.
      ICD=5
      WRITE(NOUT,58)NORD,ICD,IH(N),IK(N),IL(N),MULT,N,TH,D(N)
C--      IF(INDP.EQ.1) WRITE(NPUNCH,48)NORD,ICD,IH(N),IK(N),IL(N),MULT 
      ICD=4
      ENDIF
C--48    FORMAT(I7,I1,4I8) 
!  58  FORMAT(I7,I1,4I8,'   -----  ',I4,2F8.3) 
  58  FORMAT(I3,I1,3I7,i6,' -- ',I4,F9.4,F10.5) 
  15  CONTINUE
      NORD=NORD+1
!      GO TO 1
C-- 100  IF(INDP.EQ.1) END FILE NPUNCH 
 100  IF (DMINORG .NE. DMIN) THEN
         WRITE (*,*) 'Note: Too many reflections were computed'
         WRITE (*,*) '   The d-space limit has been lowered to ',DMIN
      ENDIF
      IF (JJ .eq. 0) THEN
         WRITE (*,*) 'No reflections were computed,',
     $        ' check your 2Theta limit'
      ENDIF
      STOP
      END 
