      INTEGER*4 NPEAKS
      PARAMETER (NPEAKS=5000)
      INTEGER*4 H(NPEAKS),K(NPEAKS),L(NPEAKS)
      INTEGER*4 EXTINCT(NPEAKS)
      INTEGER*4 NPEAK
      LOGICAL FLAG4,FLAG5,FLAG6
      REAL*4    DS(NPEAKS),TT(NPEAKS)
      REAL*4    A,B,C,ALPHA,BETA,GAMMA,WAVE
      REAL*4    RCV,RCP(6),VOL,PRCP(6)
      CHARACTER*25 DNAM

      READ(*,'(A)') DNAM
      READ(*,*) A,B,C,ALPHA,BETA,GAMMA,WAVE
      READ(*,*) YMIN,YMAX,ZERO
      READ(*,*) NPEAK
      READ(*,*) (H(I),I=1,NPEAK)
      READ(*,*) (K(I),I=1,NPEAK)
      READ(*,*) (L(I),I=1,NPEAK)
      READ(*,*,end=999) (EXTINCT(I),I=1,NPEAK)
 999  FLAG4 = .FALSE.
      FLAG5 = .FALSE.
      FLAG6 = .FALSE.

      CALL CELCON(A,B,C,ALPHA,BETA,GAMMA,RCV,RCP,VOL,PRCP)
      IF (PRCP(4) .NE. 0) FLAG4 = .TRUE.
      IF (PRCP(5) .NE. 0) FLAG5 = .TRUE.
      IF (PRCP(6) .NE. 0) FLAG6 = .TRUE.

      DO I=1,NPEAK
         RD = 0.0
         IF (FLAG4) RD = RD + H(I)*K(I)*PRCP(4)
         IF (FLAG5) RD = RD + H(I)*L(I)*PRCP(5)
         IF (FLAG6) RD = RD + K(I)*L(I)*PRCP(6)
         RD = H(I)**2*PRCP(1)+K(I)**2*PRCP(2)+L(I)**2*PRCP(3) + 2*RD
         RD = 2.0*SQRT(RD)
         DS(I) = 1./ RD
         IF (0.5 * WAVE * RD .GT. 1) THEN
            TT(I) = -1
         ELSE
            TT(I) = 360. * ASIN(0.5 * WAVE * RD) / 3.1415926
         ENDIF
      ENDDO
      I = 1
      J = 25
      DO ii = 1, J
         I = II
         IF (DNAM(I:I) .NE. ' ') goto 1
      ENDDO
 1    DO II = I, J
         IF (DNAM(II:II) .EQ. ' ') goto 2
         J = II
      ENDDO
 2    WRITE (*,*) 'set ',dnam(I:J),'(x) {'
      WRITE(*,*) (TT(II),II=1,NPEAK)
      WRITE(*,*) '}'
      WRITE (*,*) 'set ',dnam(I:J),'(dspaces) {'
      WRITE(*,*) (DS(II),II=1,NPEAK)
      WRITE(*,*) '}'
      WRITE (*,*) dnam(I:J),'_x set {'
      DO II=1,NPEAK
         if (TT(II) .GT. 0 .and. EXTINCT(II) .eq. 0)
     $        WRITE(*,*) TT(II)+ZERO,TT(II)+ZERO,TT(II)+ZERO
      ENDDO
      WRITE(*,*) '}'
      WRITE (*,*) dnam(I:J),'_y set {'
      DO II=1,NPEAK
         if (TT(II) .GT. 0 .and. EXTINCT(II) .eq. 0)
     $        WRITE(*,*) YMIN,YMAX,YMIN
      ENDDO
      WRITE(*,*) '}'
      WRITE (*,*) 'xextinct set {'
      DO II=1,NPEAK
         if (TT(II) .GT. 0 .and. EXTINCT(II) .ne. 0)
     $        WRITE(*,*) TT(II)+ZERO,TT(II)+ZERO,TT(II)+ZERO
      ENDDO
      WRITE(*,*) '}'
      WRITE (*,*) 'yextinct set {'
      DO II=1,NPEAK
         if (TT(II) .GT. 0 .and. EXTINCT(II) .ne. 0)
     $        WRITE(*,*) YMIN,YMAX,YMIN
      ENDDO
      WRITE(*,*) '}'
      END
C===========================================================================
      SUBROUTINE CELCON(A,B,C,AL,BE,GA,RCV,RCP,VOL,PRCP)
C     
C     CALCULATE RECIPROCAL CELL CONSTANTS
C     
      REAL A,B,C,AL,BE,GA,RCV,RCP(6),VOL,PRCP(6)
C===========================================================================

	REAL RAD
	PARAMETER (RAD = 3.1415926/180.0)
	REAL COSAL,COSBE,COSGA,SINAL,SINBE,SINGA

      COSAL = COS(AL*RAD)
      COSBE = COS(BE*RAD)
      COSGA = COS(GA*RAD)
      SINAL = SQRT(1.0-COSAL**2)
      SINBE = SQRT(1.0-COSBE**2)
      SINGA = SQRT(1.0-COSGA**2)
      IF (A .GT. 1.0) THEN
C     We have a direct cell
         RCV = A*B*C*SQRT(
     $        1.0-COSAL**2-COSBE**2-COSGA**2+2.0*COSAL*COSBE*COSGA)
         RCP(1) = B*C*SINAL/RCV
         RCP(2) = A*C*SINBE/RCV
         RCP(3) = A*B*SINGA/RCV
         RCP(4) = (COSBE*COSGA-COSAL)/(SINBE*SINGA)
         RCP(5) = (COSAL*COSGA-COSBE)/(SINAL*SINGA)
         RCP(6) = (COSAL*COSBE-COSGA)/(SINAL*SINBE)
         VOL = RCP(1)*RCP(2)*RCP(3)*SQRT(
     $        1.0-RCP(4)**2-RCP(5)**2-RCP(6)**2+
     $        2.0*RCP(4)*RCP(5)*RCP(6))
      ELSE
C     We have a recipcrocal cell
         RCV = A*B*C*SQRT(
     $        1.0-COSAL**2-COSBE**2-COSGA**2+2.0*COSAL*COSBE*COSGA)
         RCP(1) = B*C*SINAL/RCV
         RCP(2) = A*C*SINBE/RCV
         RCP(3) = A*B*SINGA/RCV
         RCP(4) = (COSBE*COSGA-COSAL)/(SINBE*SINGA)
         RCP(5) = (COSAL*COSGA-COSBE)/(SINAL*SINGA)
         RCP(6) = (COSAL*COSBE-COSGA)/(SINAL*SINBE)
         VOL = RCP(1)*RCP(2)*RCP(3)*SQRT(
     $        1.0-RCP(4)**2-RCP(5)**2-RCP(6)**2+
     $        2.0*RCP(4)*RCP(5)*RCP(6))
C     Swap the values
         TMP = RCP(1)
         RCP(1) = A
         A = TMP
         TMP = RCP(2)
         RCP(2) = B
         B = TMP
         TMP = RCP(3)
         RCP(3) = C
         C = TMP

         AL = ACOS(RCP(4))*RAD
         BE = ACOS(RCP(5))*RAD
         GA = ACOS(RCP(6))*RAD

         RCP(4) = COSAL
         RCP(5) = COSBE
         RCP(6) = COSGA

         TMP = VOL
         VOL = RCV
         RCV = TMP
      ENDIF
C     
C     CALCULATE CROSS PRODUCTS OF RECIPROCAL CELL PARAMETERS
C     
      PRCP(1) = RCP(1)**2*0.25
      PRCP(2) = RCP(2)**2*0.25
      PRCP(3) = RCP(3)**2*0.25
      PRCP(4) = RCP(1)*RCP(2)*RCP(6)*0.25
      PRCP(5) = RCP(1)*RCP(3)*RCP(5)*0.25
      PRCP(6) = RCP(2)*RCP(3)*RCP(4)*0.25
      RETURN
      END
