#-----------------------------------------------------------------
# read X'Pert ASCII data file
#------- define a command line option -----------------------------
# command line option 
lappend command(cmdopt) -xpert
# proc to use 
set command(-cpi) readXPertdata
#--------define a dialog box entry
# menu label
lappend command(readtypes) "X'Pert"
# proc for this entry
lappend command(readproc) ReadXPert
# allowed data types
lappend command(filterlist) {udf}
# definitions for these data types
set command(ReadCPI_cpi_type) "X'Pert UDF file"

proc ReadXPert {file} {
    global command
    if {$file == ""} return
    pleasewait "reading file $file"
    set ret [readXPertdata $file]
    donewait
    if {$ret != ""} {return $ret}
    showlastentry $command(read_filelist)
}

proc readXPertdata {filename} {

    #puts "opening X'Pert file $filename"
    global graph

    set lnum 0
    # signal errors by quitting
    if [catch {
	set fp [open $filename r]
	# Initialize the data structure.
	set data [file root [file tail $filename]] 
	# eliminate spaces from the name
	regsub -all " " $data "_" data
	set data [initdata $data]
	global ${data}

	set ${data}(xlabel) "2theta"
	set ${data}(xunits) "2theta"
	set ${data}(ylabel) "counts"
	# No missing points
	set ${data}(skip) 0
	set ptsread 0
	set npts 0

	incr lnum
	set eof [gets $fp line]
	while {$eof >= 0} {
	    set sline [split [string trim $line] ,]
	    set key [lindex $sline 0]
	    switch $key {
		Title2 {
		    set ${data}(title) [lindex $sline 1]
		}
		LabdaAlpha1 {
		    set ${data}(wavelength) [lindex $sline 1]
		}
		DataAngleRange {
		    set min [lindex $sline 1]
		    set max [lindex $sline 2]
		}
		ScanStepSize {
		    set incr [lindex $sline 1]
		}
		RawScan {
		    catch {
			set npts [expr {round(1 + ($max - $min)/$incr)}]
		    }
		    set eof [gets $fp line]
		    incr lnum
		    set sline [split [string trim $line] ,]
		    while {$eof >= 0} {
			foreach num $sline {
			    set num [string trim $num]
			    if {$num == "/"} {
				set eof 1
				break
			    }
			    lappend ${data}(x) [expr {$min + $ptsread*$incr}]
			    lappend ${data}(y) $num
			    lappend ${data}(esd) [expr {sqrt($num)}]
			    incr ptsread
			}
			set eof [gets $fp line]
			incr lnum
			set sline [split [string trim $line] ,]
			if {$lnum > $::command(maxlines)} {
			    return "Read > $::command(maxlines) lines. Something is wrong or change command(maxlines)!"
			}
		    }
		}
	    }
	    incr lnum
	    set eof [gets $fp line]
	}
    } errmsg] {
	# try to process the data we have read
	catch {resetdata $data}
	catch {close $fp}
	return "X'pert file error: $errmsg"
    }
    catch {resetdata $data}
    lappend graph(plotlist) $data
    catch {close $fp}
    if {$ptsread == 0} {
	return "X'pert file error. No RawScan section found."
    }
    #puts "$ptsread valid points read"
    if {$ptsread != $npts} {
	return "$ptsread were read, but expected $npts points!"
    }
    return
    # try to process the data we have read
}
