#-----------------------------------------------------------------
# read live 11BM multidetector data directly from the instrument
#-----------------------------------------------------------------
# This will run only in UNIX and only if  /local/bin/getlive11bm.py
# is accessible and executable
#------------------------------------------------------------------

# test if the command to get the file exists on this computer
if {[file exists  /local/bin/getlive11bm.py] && \
	[file executable  /local/bin/getlive11bm.py]} {

    #--------define a dialog box entry
    lappend command(readbuttons) "Read active scan on 11-BM"
    lappend command(readbuttonproc) "Read11BMactive"

    proc Read11BMactive {} {
	global command
	pleasewait "reading from the VME crate"
	# ignore the error -- always happens
	catch {exec /local/bin/getlive11bm.py > /tmp/11bmlive.tcl} err1
	set error [catch {source /tmp/11bmlive.tcl} errmsg]
	catch {file delete /tmp/11bmlive.tcl}
	if [catch {set errorflag}] {
	    set error 1
	    append errmsg "\ndata transfer incomplete"
	} elseif {$errorflag} {
	    set error 1
	    append errmsg "\ndata transfer incomplete"
	}
	donewait
	showlastentry $command(read_filelist)
	if $error {
	    tk_dialog .err "Read Error" "Read error: $errmsg" error 0 OK
	}
    }
}
