#-----------------------------------------------------------------
# read BTx & xr0 single-detector data from ICP
#------- define a command line option -----------------------------
# command line option 
lappend command(cmdopt) -ICP -icp
# proc to use 
set command(-ICP) readICPdata
set command(-icp) readICPdata
#--------define a dialog box entry
# menu label
lappend command(readtypes) "NIST/ICP single-detector files"
# proc for this entry
lappend command(readproc) ReadICP
# allowed data types
if {$tcl_platform(platform) == "windows"} {
    lappend command(filterlist) {xr0 bt2 bt4 bt7 bt9}
} else {
    lappend command(filterlist) {xr0 bt2 bt4 bt7 bt9 XR0 BT2 BT4 BT7 BT9}
}
# DEFINITIONS for these data types
set command(ReadICP_xr0_type) "NCNR X-ray instrument"
set command(ReadICP_bt2_type) "BT-2/4/9 ICP (untested)"
set command(ReadICP_bt4_type) "BT-2/4/9 ICP (untested)"
set command(ReadICP_bt9_type) "BT-2/4/9 ICP (untested)"
set command(ReadICP_XR0_type) "NCNR X-ray instrument"
set command(ReadICP_BT2_type) "BT-2/4/9 ICP (untested)"
set command(ReadICP_BT4_type) "BT-2/4/9 ICP (untested)"
set command(ReadICP_BT9_type) "BT-2/4/9 ICP (untested)"

set bt1(firstmon) 0

proc ReadICP {file} {
    global command
    if {$file == ""} return
    pleasewait "reading file $file"
    set ret [readICPdata $file]
    donewait
    if {$ret != ""} {return $ret}
    showlastentry $command(read_filelist)
}

#--------------------------------------------------------------------------
# load single detector data from ICP
proc readICPdata {filename} {
    global bt1 graph
    # signal errors by quitting
    if [catch {
	#puts "opening ICP file $filename"
	set fl [open $filename r]
	set lnum 0

	# get a line and turn single quotes into double
	incr lnum
	gets $fl line
	regsub -all {'} $line {"} line;      # balance unmatched " for emacs
 	set data [file root [file tail $filename]]
	# eliminate spaces from the name
	regsub -all " " $data "_" data
	set data [initdata $data]
	global $data

	set ptnum 0
	set ptsread 0
	#==================
	# increment buffer
	#==================
	if {[lindex $line 2] == "I"} {
	    set prefact [expr [lindex $line 3] * [lindex $line 4]]
	    set npts [lindex $line 6]
	    # skip next line
	    incr lnum
	    gets $fl line
	    # get title
	    incr lnum
	    gets $fl line
	    set title [string trim $line]
	    # get wavelength
	    incr lnum
	    gets $fl line
	    regsub -all {'} $line \" line
	    set wave  [lindex $line 7]
	    # skip next line (labels for previous)
	    incr lnum
	    gets $fl line
	    # read list of motors
	    incr lnum
	    gets $fl line
	    while {[lindex $line 0] != "Mot:"} {
		# set scan range from last motor with a range of values
		if {[lindex $line 1] != [lindex $line 3]} {
		    set start [expr [lindex $line 1]]
		    set step  [expr [lindex $line 2]]
		    set axis "Motor [lindex $line 0]"
		}
		incr lnum
		if {[gets $fl line] < 0} {
		    return "end of file on header, line $lnum"
		}
	    }
	    gets $fl line
	    # look for a label "COUNTS" if not found we will simply use the last value
	    set index end
	    for {set i 0} {$i < [llength $line]} {incr i} {
		if {[string toupper [lindex $line $i]] == "COUNTS"} {set index $i}
	    }
	    set ${data}(xlabel) $axis
	    # presumed:
	    set ${data}(xunits) "2theta"
	    set ${data}(ylabel) "counts"

	    while {[gets $fl line] >= 0} {
		incr lnum
		if {$lnum > $::command(maxlines)} {
		    return "Read > $::command(maxlines) lines. Something is wrong or change command(maxlines)!"
		}
		if {[string range $line 0 0] != "$"} {
		    set count [lindex $line $index]
		    if {$count >= 0} {
			lappend ${data}(x) \
			    [expr $start + $step*$ptnum]
			lappend ${data}(y) [expr $count]
			if {$count == 0} {
			    lappend ${data}(esd) 1
			} else {
			    lappend ${data}(esd) [expr sqrt($count)]
			}
			incr ptsread
			incr ptnum
		    }
		}
	    }
	#==================
	# Q buffer
	#==================
	} elseif {[lindex $line 2] == "Q"} {
	    set prefact [expr [lindex $line 3] * [lindex $line 4]]
	    set npts [lindex $line 6]
	    # skip next line
	    incr lnum
	    gets $fl line
	    # get title
	    incr lnum
	    gets $fl line
	    set title [string trim $line]
	    # collimation
	    incr lnum
	    gets $fl line
	    incr lnum
	    gets $fl line
	    # lattice parameters
	    incr lnum
	    gets $fl line
	    incr lnum
	    gets $fl line
	    # q-scan terms
	    incr lnum
	    gets $fl line
	    incr lnum
	    gets $fl line
	    incr lnum
	    gets $fl line
	    incr lnum
	    gets $fl line
	    # header
	    gets $fl line
	    # look for a label "COUNTS" if not found we will simply use the last value
	    set index end
	    for {set i 0} {$i < [llength $line]} {incr i} {
		if {[string toupper [lindex $line $i]] == "COUNTS"} {set index $i}
	    }
	    set ${data}(xlabel) Q
	    # presumed:
	    set ${data}(xunits) "Q"
	    set ${data}(ylabel) "counts"
	
	    while {[gets $fl line] >= 0} {
		incr lnum
		if {$lnum > $::command(maxlines)} {
		    return "Read > $::command(maxlines) lines. Something is wrong or change command(maxlines)!"
		}
		if {[string range $line 0 0] != "$"} {
		    set count [lindex $line $index]
		    if {$count >= 0} {
			lappend ${data}(x) [expr sqrt( \
				[lindex $line 0]*[lindex $line 0] +  \
				[lindex $line 1]*[lindex $line 1] +  \
				[lindex $line 2]*[lindex $line 2])]
			lappend ${data}(y) [expr $count]
			if {$count == 0} {
			    lappend ${data}(esd) 1
			} else {
			    lappend ${data}(esd) [expr sqrt($count)]
			}
			incr ptsread
			incr ptnum
		    }
		}
	    }
	#==================
	# Bragg buffer
	#==================
	} elseif {[lindex $line 2] == "B"} {
	    set prefact [expr [lindex $line 3] * [lindex $line 4]]
	    set npts [lindex $line 6]
	    # skip next line
	    incr lnum
	    gets $fl line
	    # get title
	    incr lnum
	    gets $fl line
	    set title [string trim $line]
	    # collimation
	    incr lnum
	    gets $fl line
	    incr lnum
	    gets $fl line
	    # lattice parameters
	    incr lnum
	    gets $fl line
	    incr lnum
	    gets $fl line
	    # E-scan terms
	    incr lnum
	    gets $fl line
	    incr lnum
	    gets $fl line
	    # q-scan terms
	    incr lnum
	    gets $fl line
	    incr lnum
	    gets $fl line
	    # read list of motors
	    incr lnum
	    gets $fl line
	    while {[lindex $line 0] != "Mot:"} {
		# set scan range from last motor with a range of values
		if {[lindex $line 1] != [lindex $line 3]} {
		    set start [expr [lindex $line 1]]
		    set step  [expr [lindex $line 2]]
		    set axis "Motor [lindex $line 0]"
		}
		incr lnum
		if {[gets $fl line] < 0} {
		    return "end of file on header, line $lnum"
		}
	    }
	    # header
	    gets $fl line
	    # look for a label "COUNTS" if not found we will simply use the last value
	    set index end
	    for {set i 0} {$i < [llength $line]} {incr i} {
		if {[string toupper [lindex $line $i]] == "COUNTS"} {set index $i}
	    }
	    set ${data}(xlabel) $axis
	    # presumed:
	    set ${data}(xunits) "2theta"
	    set ${data}(ylabel) "counts"

	    while {[gets $fl line] >= 0} {
		incr lnum
		if {$lnum > $::command(maxlines)} {
		    return "Read > $::command(maxlines) lines. Something is wrong or change command(maxlines)!"
		}
		if {[string range $line 0 0] != "$"} {
		    set count [lindex $line $index]
		    if {$count >= 0} {
			lappend ${data}(x) \
				[expr $start + $step*$ptnum]
			lappend ${data}(y) [expr $count]
			if {$count == 0} {
			    lappend ${data}(esd) 1
			} else {
			    lappend ${data}(esd) [expr sqrt($count)]
			}
			incr ptsread
			incr ptnum
		    }
		}
	    }
	} else {
	    return "Unsupported buffer type [lindex $line 2]"
	}
	resetdata $data
	lappend graph(plotlist) $data
	set ${data}(title) $title
    } errmsg] {
	# try to process the last data we have read
	catch {resetdata $data}
	return "ReadICPdata error. Error reading line $lnum: $errmsg"
    }
    catch {close $fp} test
    #puts "$ptsread non-zero points read"
    return {}
}
