#-----------------------------------------------------------------
# read DND ASCII data files
#------- define a command line option -----------------------------
# command line option 
lappend command(cmdopt) -dnd
# proc to use 
set command(-dnd) readdnddata
#--------define a dialog box entry
# menu label
lappend command(readtypes) "APS DND File"
# proc for this entry
lappend command(readproc) Readdnd
# allowed data types
if {$tcl_platform(platform) == "windows"} {
    lappend command(filterlist) {dnd}
} else {
    lappend command(filterlist) {dnd DND}
}
# definitions for these data types
set command(Readdnd_dnd_type) "DND data"
set command(Readdnd_DND_type) "DND data"


proc Readdnd {file} {
    global command
    if {$file == ""} return
    pleasewait "reading file $file"
    set ret [readdnddata $file]
    donewait
    if {$ret != ""} {return $ret}
    showlastentry $command(read_filelist)
}

proc readdnddata {filename} {

    #puts "opening DND file $filename"
    global graph

    set lnum 0
    # signal errors by quitting
    if [catch {
	set fp [open $filename r]

	
	# Great!! Now we are positioned to read the data.  We need to normalize
	# the data and calculate esds.  We will use the first datapoint
	# in the file as our reference.   We will normalize everything to
	# the IO of this reading.
	
	# Initialize the data structure.
	set data [file root [file tail $filename]] 
	# eliminate spaces from the name
	regsub -all " " $data "_" data
	set data [initdata $data]
	global ${data}
	set ${data}(xlabel) "2theta"
	set ${data}(xunits) "2theta"
	set ${data}(ylabel) "scaled counts"
	
	# No missing points
	set ${data}(skip) 0
	set ${data}(title) "DND data"
	set ptsread 0

	# Now, read the rest of the file.  Continue reading 
	# until we get to the last data point, an end-of-file or error
	set firstpass 1
	set i 0
	while {[gets $fp line] >= 0} {
	    incr lnum
	    if {$lnum > $::command(maxlines)} {
		return "Read > $::command(maxlines) lines. Something is wrong or change command(maxlines)!"
	    }
	    set angle [lindex $line 0]
	    #	set ctime [lindex $line 7]
	    set count [lindex $line 4]
	    set mon   [lindex $line 3]
	    if $firstpass {
		set firstpass 0
		set firstmon $mon
	    } 
	    # puts $angle
	    lappend ${data}(x) $angle
	    lappend ${data}(y) [expr 1.0*$count*$mon/(1.0*$firstmon)]
	    lappend ${data}(esd) [expr sqrt($count)*$mon/(1.0*$firstmon)]
	    incr ptsread
	}
    } errmsg] {
	# try to process the data we have read
	catch {resetdata $data}
	return "DND error. Error reading line $lnum: $errmsg"
    }
    resetdata $data
    lappend graph(plotlist) $data
    catch {close $fp} test
    #puts "$ptsread valid points read"
    return {}
}
