#-----------------------------------------------------------------
# read COMCAT ASCII data files
#------- define a command line option -----------------------------
# command line option 
lappend command(cmdopt) -COMCAT
# proc to use 
set command(-comcat) readcomcatdata
#--------define a dialog box entry
# menu label
lappend command(readtypes) "COM-CAT Pscan File"
# proc for this entry
lappend command(readproc) Readcomcat
# allowed data types
if {$tcl_platform(platform) == "windows"} {
    lappend command(filterlist) {ccp}
} else {
    lappend command(filterlist) {ccp CCP}
}
# definitions for these data types
set command(Readdnd_comcat_type) "COMCAT data"
set command(Readdnd_COMCAT_type) "COMCAT data"


proc Readcomcat {file} {
    global command
    if {$file == ""} return
    pleasewait "reading file  $file"
    set ret [readcomcatdata $file]
    donewait
    if {$ret != ""} {return $ret}
    showlastentry $command(read_filelist)
}
proc pop_up_zerocorrection { z } {
pack [label .pop_up_zerocorrection -text "Zero "] -side left
pack [entry .pop_up_zerocorrection -variable z] -side left
}
proc readcomcatdata {filename} {

    #puts "opening COMCAT file $filename"
    global graph zerocorrect
    set det 1

	#COMCAT normalization parameters

	set norm_list { null_value \
	1.000 1.025 0.884 0.970 0.871 \
	0.910 0.863 1.247 0.879 1.198 \
	0.797 }

	set zero_list { null_value \
	0.0193 -1.9344 -3.9400 -5.9532 -7.9593 \
	-9.9552 -11.9678 -13.9224 -15.9334 -17.9093 \
	-19.9278 }

	set wavelength_list { null_value \
	0.99999 1.00010 1.00000 1.00009 1.00004 \
        1.00013 1.00011 1.00011 1.00003 1.00010 \
	1.00004 }

        set deadtime_list { null_value \
	2.13 1.92 1.75 1.88 1.85 1.96 1.80 2.04 2.11 2.31 2.04 }

    while { $det <= 11 } {
   
 set lnum 0
 set bank [expr ($det + 5)]
 set deadtime [lindex $deadtime_list $det]
 set std_lambda 1.00000
 set wavelength_ratio [expr ($std_lambda / [lindex $wavelength_list $det])]
    
    # signal errors by quitting
    if [catch {
	set fp [open $filename r]

#first line is header information
	incr lnum
	set eof [gets $fp line]
	if {$eof < 0} {return "early end-of-file"}
	
	# Great!! Now we are positioned to read the data.  We need to normalize
	# the data and calculate esds.  We will use the first datapoint
	# in the file as our reference.   We will normalize everything to
	# the IO of this reading.
	


	# Initialize the data structure.
	set data [file root [file tail $filename]]_$det 
	# eliminate spaces from the name
	regsub -all " " $data "_" data
	set data [initdata $data]
	global ${data}
	set ${data}(xlabel) "2theta"
	set ${data}(xunits) "2theta"
	set ${data}(ylabel) "scaled counts"
	# No missing points
	set ${data}(skip) 0
	set ${data}(title) "COMCAT data"
	set ptsread 0
	set ${data}(zerocorrect) $zerocorrect(value)
        set torad [expr 3.14159 / 360.]
	set totwoth [expr 2.0 / $torad ]

	# Now, read the rest of the file.  Continue reading 
	# until we get to the last data point, an end-of-file or error
	set firstpass 1
	set i 0


	while {[gets $fp line] >= 0} {
	    incr lnum
	    if {$lnum > $::command(maxlines)} {
		return "Read > $::command(maxlines) lines. Something is wrong or change command(maxlines)!"
	    }

	    if {$zerocorrect(value) == 0.0 || $zerocorrect(value) == ""} {
	    set angle [expr ( [lindex $line 0] - [lindex $zero_list $det] )]
	    } else {
	    set angle [expr ( [lindex $line 0] - $zerocorrect(value) \
		- [lindex $zero_list $det] )]
	    }
	    set ctime [lindex $line 3]
	    set count [lindex $line $bank]
	    set cps [expr $count/$ctime]
            set cct [expr $count/(1.0-(0.000001*$deadtime*$cps))]
	    set mon   [lindex $line 5]
	    set ma    [lindex $line 4]

# Monitor is proportional to the count time -- count time is only used to
# correct for deadtime problems.

	    if $firstpass {
		set firstpass 0
		set firstmon $mon
		set firstma $ma
		#puts $firstma
		#puts $firstmon
	    } 
	    # puts $angle
	    #the data is normalized internally by the monitor which also
	    #takes care of differences in counting times.  However, when
	    #running a long series of reaction scans, there is no mechanism
	    #to normalize among the scans so I have added a normalization
	    #factor based on the initial ma reading relative to 100 ma.

	    lappend ${data}(x) [expr $totwoth*asin(sin($torad*0.5*$angle)*\
                 $wavelength_ratio)]

#	    lappend ${data}(x) $angle
#		set ratio [expr $mon/(1.0*$firstmon)]
#		puts $ratio
#	puts "$ptsread $angle $count counts $firstmon $mon $firstma $det $bank"
	    lappend ${data}(y) [expr 1.0*$cct*((1.0*$firstmon)/$mon) \
		*(100.0/$firstma)]
	    lappend ${data}(esd) [expr sqrt($cct)*((1.0*$firstmon)/$mon) \
		*(100.0/$firstma)]
	    incr ptsread
	}
    } errmsg] {
	# try to process the data we have read
	catch {resetdata $data}
	return "COMCAT error. Error reading line $lnum: $errmsg"
    }
    resetdata $data
    lappend graph(plotlist)  $data
    catch {close $fp} test
    #puts "$ptsread valid points read"
 incr det
}

    return {}
}
