#-----------------------------------------------------------------
# read data from SPEC
# $Revision: 421 $ $Date: 2010-09-03 14:58:59 -0500 (Fri, 03 Sep 2010) $
#------- define a command line option -----------------------------
# command line option 
#lappend command(cmdopt) -ICP -icp
# proc to use 
#set command(-ICP) readICPdata
#set command(-icp) readICPdata
#--------define a dialog box entry
# menu label
lappend command(readtypes) "SPEC data files"
# proc for this entry
lappend command(readproc) ReadSPEC
# allowed data types
if {$tcl_platform(platform) == "windows"} {
    lappend command(filterlist) {spec}
} else {
    lappend command(filterlist) {SPEC spec Spec}
}
# DEFINITIONS for these data types
#set command(ReadSPEC_spec_type) "SPEC scan file"
#set command(ReadSPEC_SPEC_type) "SPEC scan file"
#set command(ReadSPEC_Spec_type) "SPEC scan file"

proc ReadSPEC {file} {
    global command
    if {$file == ""} return
#    pleasewait "reading file $file"
    set ret [readSPECdata $file]
#    donewait
    if {$ret != ""} {return $ret}
    showlastentry $command(read_filelist)
}

#--------------------------------------------------------------------------
set command(FirstMonitor) 1
set command(chooseM) (none)
set command(MonitorScale) 1.0
trace variable command(FirstMonitor) w SpecDisableMonitorBoxes
trace variable command(chooseM) w SpecDisableMonitorBoxes
proc SpecDisableMonitorBoxes {args} {
    global command
    if {! [winfo exists .ask]} return
    if {$command(chooseM) == "(none)"} {
	.ask.4a.a config -fg gray
	.ask.4a.b config -state disabled
    } else {
	.ask.4a.a config -fg black
	.ask.4a.b config -state normal
    }
    if {$command(chooseM) == "(none)" || $command(FirstMonitor)} {
	.ask.4a.c.a config -fg gray
	.ask.4a.c.b config -state disabled
    } else {
	.ask.4a.c.a config -fg black
	.ask.4a.c.b config -state normal
    }
}
# load data from SPEC
proc readSPECdata {filename} {
    global graph command
    set command(ReadAll) 0
    # signal errors by quitting
    if [catch {
	#puts "opening SPEC file $filename"
	set fl [open $filename r]
	set lnum 0
	set command(mode) 0
	set scan 0
	set data {}
	# get a line
	while {[gets $fl line] >= 0} {
	    incr lnum
	    # rescue the incompetent
	    if {$lnum > $::command(maxlines)} {
		return "Read > $::command(maxlines) lines. Something is wrong or change command(maxlines)!"
	    }
	    if {[string range $line 0 1] == "#S"} {
		# process the last dataset
		if {$data != ""} {
		    catch {
			if {$ptsread > 0} {
			    resetdata $data
			    lappend graph(plotlist) $data
			    #puts "$data: $ptsread valid points read"
			}
		    }
		}
		set command(mode) 1
		set scan [lindex $line 1]
		set data [file root [file tail $filename]]_$scan
		# eliminate spaces from the name
		regsub -all " " $data "_" data
		set data [initdata $data]
		global $data
		set comment {}
		# don't know if points are consecutive
		set ${data}(skip) 1
		set ptsread 0
	    } elseif {$command(mode) == 1} {
		# reading the header
		if {[string range $line 0 1] == "#C"} {
		    append comment [string trim [string range $line 2 end]]
		    set ${data}(title) $comment
		    append comment " "
		} elseif {[string range $line 0 1] == "#N"} {
		    set cols [lindex $line 1]
		} elseif {[string range $line 0 1] == "#L"} {
		    set line [string range $line 2 end]
		    # two or more spaces is a delimiter on the "L" line
		    set varlist [split [regsub -all "  +" $line ";"] ";"]
		    # make a window to select x & y
		    catch {toplevel .ask}
		    eval destroy [winfo children .ask]
		    pack [label .ask.1 \
			      -text "Choose the entries to read\n for scan $scan"] \
			-side top
		    pack [frame .ask.2] -side top
		    pack [label .ask.2.a -text "X-axis"] -side left
		    eval tk_optionMenu .ask.2.b command(chooseX) $varlist
		    pack .ask.2.b -side left
		    pack [frame .ask.3] -side top
		    pack [label .ask.3.a -text "Y-axis"] -side left
		    eval tk_optionMenu .ask.3.b command(chooseY) $varlist
		    pack .ask.3.b -side left
		    pack [frame .ask.4] -side top
		    pack [label .ask.4.a -text "Monitor"] -side left
		    eval tk_optionMenu .ask.4.b command(chooseM) [concat (none) $varlist]
		    pack .ask.4.b -side left
		    pack [frame .ask.4a] -side top
		    pack [label .ask.4a.a -text "Scale Monitor to:" -anchor w] -side top -anchor w
		    pack [checkbutton .ask.4a.b -text "First monitor value" \
			      -variable command(FirstMonitor)] -side top
		    pack [frame .ask.4a.c] -side top
		    pack [label .ask.4a.c.a -text "(or) value:"] -side left
		    pack [entry .ask.4a.c.b -width 10 -textvariable command(MonitorScale)] -side left
		    SpecDisableMonitorBoxes 

		    # deal with defaults
		    if {$command(chooseY) == $command(chooseX) \
			    && $command(chooseY) == [lindex $varlist 0]} {
			set command(chooseY) [lindex $varlist 1]
			set command(chooseM) "(none)"
		    }
		    if {[lsearch $varlist $command(chooseX)] == -1} {
			set command(ReadAll) 0
			set command(chooseX) ""
		    }
		    if {[lsearch $varlist $command(chooseY)] == -1} {
			set command(ReadAll) 0			
			set command(chooseY) ""
		    }
		    pack [frame .ask.b] -side top
		    pack [frame .ask.c] -side top
		    pack [button .ask.b.c -text "Read scan $scan" \
			      -command "set command(mode) 2; destroy .ask"] -side left
		    pack [button .ask.b.s -text "Skip scan $scan" \
			      -command "set command(mode) 0; destroy .ask"] -side left
		    pack [button .ask.c.c -text "Read all scans" \
			      -command "set command(ReadAll) 1; set command(mode) 2; destroy .ask"] -side left
		    
		    if {$command(ReadAll) == 0} {
			putontop .ask
			tkwait window .ask
			afterputontop
		    } else {
			set command(mode) 2
			destroy .ask
		    }
		    set command(Xcol) [lsearch $varlist $command(chooseX)]
		    set command(Ycol) [lsearch $varlist $command(chooseY)]
		    set command(Mcol) [lsearch $varlist $command(chooseM)]
		    set ${data}(xlabel) $command(chooseX)
		    set ${data}(xunits) $command(chooseX)
		    set ${data}(ylabel) $command(chooseY)
		    set FirstMonitorVal $command(MonitorScale)
		    if {$command(FirstMonitor)} {
			set FirstMonitorVal ""
		    } 
		}
	    } elseif {$command(mode) == 2} {
		# reading the data
		if {[string range $line 0 1] == "#C"} {
		    append comment [string trim [string range $line 2 end]]
		    set ${data}(title) $comment
		    append comment " "
		    continue
		} 
		if {[string range $line 0 7] == "Warning:"} continue
		if {[string range $line 0 0] == "#"} continue
		set x [lindex $line $command(Xcol)] 
		set y [lindex $line $command(Ycol)]
		set mon [lindex $line $command(Mcol)]
		if {$command(chooseM) != "(none)" && \
			$FirstMonitorVal == "" && $mon != ""} {
		    set FirstMonitorVal $mon
		    # save this as the default for subsequent files
		    set command(FirstMonitor) 0
		    set command(MonitorScale) $mon		    
		}
		if {$x != "" && $y != ""} {
		    set esd 0
		    catch {
			expr $x
			expr $y
			set esd 1
			# allow for negative values
			catch {set esd [expr sqrt($y)]}
			if {$command(chooseM) != "(none)"} {
			    catch {
				set scale [expr {(1.0* $FirstMonitorVal) / $mon}]
				set y [expr {$y * $scale}]
				set esd [expr {$esd * $scale}]
			    }
			}
			lappend ${data}(x) $x
			lappend ${data}(y) $y
			lappend ${data}(esd) $esd
			incr ptsread
		    }
		}
	    }
	}
    } errmsg] {
	# try to process the data we have read
	catch {
	    if {$ptsread > 0} {
		resetdata $data
		lappend graph(plotlist) $data
		#puts "$data: $ptsread valid points read"
	    }
	}
	return "SPEC error. Error reading line $lnum: $errmsg"
    }
    if {$ptsread > 0} {
	resetdata $data
	lappend graph(plotlist) $data
	#puts "$data: $ptsread valid points read"
    }
    catch {close $fp} test
    return {}
}
